// Persistence of Vision Ray Tracer Scene Description File
// File: CatHand.pov
// Vers: 3.1
// Desc: A scene file showing two hands throwing a paperwad back and forth
// Date: 9/27/98
// Auth: Steve Sloan II

#include "colors.inc"
#include "textures.inc"
#include "catmacro.inc"

/*********/
/* Units */
/*********/

// Length
#declare inch   = 1;
#declare in     = inch;
#declare inches = inch;
#declare feet   = 12*inch;
#declare foot   = 12*inch;
#declare ft     = 12*inch;
#declare meters = 39.37*inch;

// Time
#declare s         =    1;
#declare sec       =    s;
#declare minute    = 60*s;

// Physical Constants
#declare gravconst =  9.8*meters; // m/s^2
		
sky_sphere { pigment { color SkyBlue } }

/* Lights used for test renderings */
//light_source { < 10*ft, 10*ft,  17*ft> color White }
//light_source { <-10*ft, 10*ft,  -3*ft> color White }

camera {
    /* Side View */
//    location <    0, 16*in,  2*ft>
//    look_at  <    0,     0,  7*ft>
    
    /* Front View */
    location < 5*ft, 16*in,  7*ft>
    look_at  <    0,     0,  7*ft>
}

/* Clock times */
#declare throw_time      =     0.5*s;
#declare catch_time      = 1.14375*s;
#declare flight_time     =     1.5*s;
#declare catch_end_time  =       2*s;
#declare throw2_time     =     2.5*s;
#declare catch2_time     = 3.14375*s;
#declare scene_runtime   =       4*s;
#declare movie_runtime   =       8*s;

#declare CatWatch = 1;
#declare CatMiss  = 2;

/* Convert the clock variable to actual seconds */
#declare movie_clock  = clock;

#if (movie_clock <= 0.5)
    /* First paperwad toss */
    #declare real_clock = 2*scene_runtime*movie_clock;
    #declare cat_action = CatWatch;
#else
    /* Second paperwad toss */
    #declare real_clock = 2*scene_runtime*(movie_clock - 0.5);
    #declare cat_action = CatMiss;
#end

/* Get the clock variables for the cat and the throwing hands */
#declare cat_clock   = real_clock;
#declare throw_clock = real_clock;

union {
    #include "catthrow.inc"
    object { ThrowingHands rotate -90*y }
    
    #include "catjump.inc"
    object { JumpingCat translate 2*ft*z }
    
    rotate 90*y
    translate 7*ft*z
}

/**************/
/* Test Floor */
/**************/

//plane { y, 0 pigment { color White } }

/**************/
/* Room Scene */
/**************/

#include "catscene.inc"

