// Persistence of Vision Ray Tracer Scene Description File
// File: CatMGM.pov
// Vers: 3.1
// Desc: Chloe the Cat pretends to be Leo the MGM lion
// Date: 9/20/98
// Auth: Steve Sloan II

#include "colors.inc"
#include "textures.inc"

#declare inch   = 1;
#declare in     = inch;
#declare inches = inch;
#declare feet   = 12*inch;
#declare foot   = 12*inch;
#declare ft     = 12*inch;
		
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//  (I modified it afterward)

global_settings { assumed_gamma 1.0 ambient_light <1.0,1.0,1.0> }

/*
global_settings {
    adc_bailout 0.003922
    ambient_light <1.0,1.0,1.0>
    assumed_gamma 1.9
    hf_gray_16 off
    irid_wavelength <0.247059,0.176471,0.137255>
    max_intersections 64
    max_trace_level 10
    number_of_waves 10
    radiosity {
        brightness       3.3
        count            100
        distance_maximum 0.0
        error_bound      0.4
        gray_threshold   0.5
        low_error_factor 0.8
        minimum_reuse    0.015
        nearest_count    6
        recursion_limit  1
    }
}
*/

background { color <0, 0, 0> }

camera {
    location  <0, 0, 3.4>
//    location  <0, 0, 34>
    look_at   <0, 0,   0>
}

//
// *******  L I G H T S *******
//

light_source { <     0,      0, 100*ft> color rgb <1, 1, 1> }
//light_source { <100*ft, 100*ft, 100*ft> color rgb <1, 1, 1> }

//
// ********  TEXTURES  *******
//

#declare MGMDecalTexture = 
texture {
    pigment {
        image_map { gif   "C:\Include\srsleo.gif" transmit 127, 1.0 }
        scale 2 translate -1
        scale <-1, 1, 1>
    }
}

#declare RedTexture = texture { pigment { color rgb <1, 0, 0> } }

#declare BlackTexture = texture { pigment { color rgb <0, 0, 0> } }

//
// ********  OBJECTS  *******
//

// TestSphere (The cat will go here)
//sphere { <0,0,0>,1 scale 3.0 translate  <3.0, 0.0, -10.0> texture { RedTexture } }

// MGM Front
#declare MGMFront = 
union {
    // The actual MGM decal
    box { -1, 1 texture { MGMDecalTexture } scale <2.3, 1.2, 0.01> }
    
    // Boxes above and below the decal, to hide the parts of
    // the cat you can't see through the hole in the decal
    box { -1, 1 scale <2.3, 1.2, 0.01> translate  2.4*y texture { BlackTexture } }
    box { -1, 1 scale <2.3, 1.2, 0.01> translate -2.4*y texture { BlackTexture } }
    
    no_shadow
}

object { MGMFront }

/**************/
/* Cat Macros */
/**************/

#include "catmacro.inc"

/**************/
/* Create Cat */
/**************/

#if (clock <= 0.4)
    #declare current_clock = clock/0.4;
#else
    #if (clock < 0.6)
        #declare current_clock = (clock - 0.4)/0.2;
    #else
        #declare current_clock = (clock - 0.6)/0.4;
    #end
#end

#declare sine_clock = SineWaveClock(current_clock);

#if ((clock > 0.4) & (clock < 0.6))
    #declare HeadAngle = -10;
    #declare HeadRoll  = 0;

    /* Jaw */
    #declare JawAngle = 0;

    /* Ears */
    #declare Ear1Rot = 0;
    #declare Ear2Rot = 0;
    #declare Ear1Height = 1;
    #declare Ear2Height = 1;
    
    /* Eyes */
    #declare LEyeOpen = 1 - sine_clock;
    #declare REyeOpen = 1 - sine_clock;
#else
    #declare HeadAngle = -10 + 30*sine_clock;
    #declare HeadRoll  = 30*sine_clock;

    /* Jaw */
    #declare JawAngle = 0.8*sine_clock;

    /* Ears */
    #declare Ear1Rot = sine_clock;
    #declare Ear2Rot = sine_clock;
    #declare Ear1Height = 1 - sine_clock;
    #declare Ear2Height = 1 - sine_clock;
    
    /* Eyes */
    #declare LEyeOpen = 1;
    #declare REyeOpen = 1;
#end

/* Define the control points of the body */
/* The points are: muzzle, head center, shoulder, mid-back, rump, and guide point */
#declare Bodyx =    array[6]{           1,    0,    0, 0,     0,    0 }
#declare Bodyy =    array[6]{ 2.47 -  1.9, 2.47,    0, 0,     0,    0 }
#declare Bodyz =    array[6]{ 4.82 + 2.02, 4.82, 2.69, 0, -5.37,   -9 }

//#declare Bodyx =    array[6]{                     1,    0,    0, 0,     0,    0 }
//#declare Bodyy =    array[6]{ 2.47 - sin(HeadAngle2), 2.47,    0, 0,     0,    0 }
//#declare Bodyz =    array[6]{ 4.82 + cos(HeadAngle2), 4.82, 2.69, 0, -5.37,   -9 }

#declare Bodyxrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }
#declare Bodyyrad = array[6]{ 0.5, 0.5, 2.24, 2,  2.24, 2.24 }

/* Define the control points of the tail */
/* The points are: control point, base of tail, end of tail, */
/*     control point (Only change the last two points) */
/* Tail is about 9 in long */
//#declare Tailx   = array[4]{   0,   0,    0,   -5 }
//#declare Taily   = array[4]{   0,   0,    8,   10 }
//#declare Tailz   = array[4]{   3,   0,   -4,    0 }

#declare Tailx   = array[4]{   0,   0,    5,  15 }
#declare Taily   = array[4]{   0,   0,    7,   5 }
#declare Tailz   = array[4]{   3,   0,    4,  10 }

#declare Tailrad = array[4]{ 0.9, 0.6, 0.45, 0.45 }

/* Left Arm */
#declare LArmAngle = 0;
#declare LForearmAngle = 0;
#declare LFrontPawAngle = 0;

/* Right Arm */
#declare RArmAngle =  0;
#declare RForearmAngle =  0;
#declare RFrontPawAngle = 0;

/* Left Leg */
#declare LThighAngle =  0;
#declare LHeelAngle =  0;
#declare LHindPawAngle = 0;

/* Right Leg */
#declare RThighAngle =  0;
#declare RHeelAngle =  0;
#declare RHindPawAngle = 0;

#include "cat.inc"

object {
    Cat
    rotate -30*x
    translate <0, -5, -20>*in
}
