
//  Billiard.inc  July-August 1998  Neil Alexander

// This file contains object to be used in Poolshrk.pov.

//------------------------ Billiard Balls ---------------------

#declare R1 = seed(0) // random seed for ball rotation

#declare Balls = union {  // balls
  sphere {0,1.25  // (1)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <1,0.8,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    }
  sphere {0,1.25  // (14)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0,0.3,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-1.25,0,2.165>
    }
  sphere {0,1.25  // (15)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0.4,0.1,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <1.25,0,2.165>
    }
  sphere {0,1.25  // (2)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0,0,0.3>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-2.5,0,4.33>
    }
  sphere {0,1.25  // (8)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb 0.1]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <0,0,4.33>
    }
  sphere {0,1.25  // (6)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0,0.3,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <2.5,0,4.33>
    }
  sphere {0,1.25  // (13)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <1,0.5,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-3.75,0,6.495>
    }
  sphere {0,1.25  // (7)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0.4,0.1,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-1.25,0,6.495>
    }
  sphere {0,1.25  // (9)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <1,0.8,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <1.25,0,6.495>
    }
  sphere {0,1.25  // (10)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0,0,0.3>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <3.75,0,6.495>
    }
  sphere {0,1.25  // (3)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0.8,0.1,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-5,0,8.66>
    }
  sphere {0,1.25  // (12)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0.3,0,0.3>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-2.5,0,8.66>
    }
  sphere {0,1.25  // (4)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0.3,0,0.3>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <0,0,8.66>
    }
  sphere {0,1.25  // (11)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0.8,0.1,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <2.5,0,8.66>
    }
  sphere {0,1.25  // (5)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <1,0.5,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <5,0,8.66>
    }
  translate <66,35.25,102> // position on table
  }  // end Balls

#declare Cueball = sphere {0,1.25
  texture {
    pigment { color rgb <1,0.99,0.8>}
    finish { phong 0.8 phong_size 50 }
    }
  } // end Cueball

#declare Cue = union {
  sphere { 0,0.781 // big end
    scale <1,0.5,1>
    texture { pigment { color rgb 0.2 }}
    }
  cylinder { 0,y*6,0.781 // big end
    texture { pigment { color rgb 0.2 }}
    }
  cone { y*6,0.75,y*60,0.25 // shaft
    texture {
      pigment { gradient y
        color_map {  // pigment map - wood
          [0.3 color rgb <0.5,0.3,0.1>]
          [0.3 color rgb <1,0.85,0.6>]
          }
        scale 55
        translate y*6
        }
      finish { phong 1 phong_size 50 }
      }
    }
  cylinder {y*60,y*61,0.281  // tip
    texture { pigment { color rgb 1 }}
    }
  sphere {0,0.25  // tip
    texture { pigment { color rgb <0.5,0.4,1>}}
    scale <1,0.5,1>
    translate y*61
    }
  }  // end Cue

#declare Chalk = box {
  <-0.625,0,-0.625>,<0.625,0.875,0.625>
  texture {
    pigment { gradient y
      color_map {
        [0.156 color rgb <0.5,0.4,1>]
        [0.188 color rgb 1]
        [0.25 color rgb 1]
        [0.281 color rgb <1,0.1,0>]
        }
      scale 1.25
      turbulence 0.2
      }
    }
  } // end Chalk

#declare Glass = texture {
  pigment { color rgbf<1,1,1,0.9> }
  finish {
    phong 1
    phong_size 75
    ambient 0
    diffuse 0
    refraction 1
    reflection 0.1
    ior 1.4
    }
  } // end Glass

#declare Beer = texture {
  pigment { color rgbf<1,0.7,0.2,0.9> }
  finish {
    ambient 0.1
    diffuse 0
    refraction 1
    reflection 0.1
    ior 1.33
    }
  } // end Beer

#declare Foam = texture {
  pigment { color rgb 1 }
  finish { ambient 0.2 }
  }



#declare Pintglass = merge {  // full pint
  cylinder { <0,0,0>,<0,7.5,0>,2 }
  intersection { // handle lower curve
    torus { 2, 0.375 }
    box {<0,-0.4,0>,<2.5,0.4,2.5>}
    rotate x*90
    translate <1.875,3,0>
    }
  intersection { // handle upper curve
    torus { 2, 0.375 }
    box {<0,-0.4,0>,<2.5,0.4,2.5>}
    rotate x*-90
    translate <1.875,4.5,0>
    }
  cylinder {<3.875,3,0>,<3.875,4.5,0>,0.375} // handle

  texture { Glass }
  }  // end Pintglass

#declare Pint1 = union { // full pint
  difference {
    object { Pintglass }
    cylinder { <0,0.75,0>,<0,7.6,0>,1.875
      texture { gradient y
        texture_map {
          [0.625 Beer]
          [0.688 Foam]
          [0.719 Foam]
          [0.719 Glass]
          }
        scale 8
        }
      }
    }
  disc { <0,0,0>, <0,1,0>, 1.875
    texture { Foam }
    translate y*5.75
    }
  } // end Pint1

#declare Pint2 = union { // empty pint
  difference {
    object { Pintglass }
    cylinder { <0,0.75,0>,<0,7.6,0>,1.875
      texture { gradient y
        texture_map {
          [0.25 Beer]
          [0.267 Foam]
          [0.281 Foam]
          [0.281 Glass]
          }
        scale 8
        }
      }
    }
  disc { <0,0,0>, <0,1,0>, 1.875
    texture { Foam }
    translate y*2.248
    }
  } // end Pint2

#declare Star = polygon {
  11
  <0,-0.382>,<0.588,-0.809>,<0.363,-0.118>,
  <0.951,0.309>,<0.225,0.309>,<0,1.000>,
  <-0.255,0.309>,<-0.951,0.309>,<-0.363,-0.118>,
  <-0.588,-0.809>,<0,-0.382>
  no_shadow
  }  // end Star
