
//  Opponent.inc  August 1998  Neil Alexander

// This file contains the object Opponent for use in Poolshrk.pov.

//------------------------- Textures -----------------------

#declare OpShirt = texture {
  pigment { bozo  // shirt color
    color_map {
      [ 0.5 color rgb 0.9]
      [1 color rgb <0.82,0.8,0.66>] // stains
      }
    scale 3
    }
  finish { phong 0 diffuse 0.7 }
  } // end OpShirt

#declare OpSkincol = color rgb <0.9,0.65,0.43>

#declare OpSkin = texture {
  pigment { OpSkincol }
  finish { diffuse 0.6 phong 0.15 phong_size 20 }
  } // end OpSkin


#declare OpEye = sphere {
  0,1
  texture {
    pigment { wood
      color_map {
        [0.3 color rgb 0]
        [0.3 color rgb 1]
        }
      scale 2.1
      }
    }
  }

#declare Opponent = union { // Opponent
  union { // head
    blob {
      threshold 0.5
      cylinder {<0,-4.125,0>,<0,8,0>,8,1}
      sphere { 0, 1, 1 // lower face
        scale <5,3,6>
        translate z*3
        }
      sphere { 0, 1, 1 // lower face
        scale <3,6,4>
        translate <0,2,2.5>
        }
      cylinder {<2.25,6,0.5>,<2.75,0.5,1.75>,2,1} // jaw r
      cylinder {<-2.25,6,0.5>,<-2.75,0.5,1.75>,2,1} // jaw l
      sphere { 0,1,1  // brow r
        scale <2.5,1.5,3>
        rotate z*10
        #if (OpFace >0)
          rotate z*40*(OpFace-0.5)
          #end
        translate <1.75,8.25-(OpFace-0.5)/2,3>
        }
      sphere { 0,1,1  // brow l
        scale <2.5,1.5,3>
        rotate z*-10
        #if (OpFace >0)
          rotate z*-40*(OpFace-0.5)
          #end
        translate <-1.75,8.25-(OpFace-0.5)/2,3>
        }
      sphere { 0,1,1  // lid r
        scale <1.5,0.75,1>
        translate <1.75,7,3.25>
        }
      sphere { 0,1,1  // lid l
        scale <1.5,0.75,1>
        translate <-1.75,7,3.25>
        }
      sphere { 0,1,-1  // eye r
        scale <1,0.375,1>
        translate <1.875,7.25,3.5>
        }
      sphere { 0,1,-1  // eye l
        scale <1,0.375,1>
        translate <-1.875,7.25,3.5>
        }
      sphere { 0,1,1  // cheek r
        scale 2
        translate <2,6,2>
        }
      sphere { 0,1,1  // cheek l
        scale 2
        translate <-2,6,2>
        }
      sphere { 0,1,1  // nose
        scale <1.5,1,1.5>
        translate <0,6.5,5>
        }
      sphere {0,1,1  // right ear
        scale <1.5,2,1>
        rotate y*45
        translate <5,6,-1>
        }
      sphere {0,1,-0.75 // right ear hole
        scale <1,1.5,0.75>
        rotate y*45
        translate <5,5.875,-0.75>
        }
      sphere {0,1,1  // left ear
        scale <1.5,2,1>
        rotate y*-45
        translate <-5,6,-1>
        }
      sphere {0,1,-0.75 // left ear hole
        scale <1,1.5,0.75>
        rotate y*-45
        translate <-5,5.875,-0.75>
        }
      sphere { 0, 1, 1 // lower lip
        scale <3,1,3>
        rotate x*-10
        #if (OpFace >0)
          rotate x*-40*(OpFace-0.5)
          #end
        translate <0,2.25,4>
        }
      #if (OpFace>0)
        sphere { 0,1,-1  // eye l with ball
          scale <1.375,1.375-(OpFace-0.5),1.375>
          translate <-2.25,7,3.75>
          texture { pigment { color rgb <0.5,0,0>}}
          }
          #end  // if

      texture { OpSkin }
      } // end face blob

    object { OpEye  // r
      translate <2,7.25,3.125>
      }
    #if (OpFace < 0.5)
      object { OpEye  // l
        translate <-2,7.25,3.125>
        }
      #end  // if

    union {  // cigarette
      cylinder { <0,0,0>,<0,0,3>,0.156
        texture {
          pigment { gradient z
            pigment_map {
              [0.33 crackle  color_map {
                               [0.5 color rgb <0.8,0.5,0.2>]
                               [0.5 color rgb <1,0.7,0.4>]
                               } scale 0.02 ]
              [0.33 color rgb 1]
              }
            scale 3
            }
          }
        }
      sphere {<0,0,3>,0.156  // heater
        texture {
          pigment { color rgb <1,0.1,0>}
          finish { ambient 1 }
          }
        }
      sphere {0,1  // ash
        scale <0.16,0.16,0.250>
        translate <0,0,3>
        texture {
          pigment { gradient z
            color_map {
              [0 color rgb 0.7]
              [0.7 color rgb 0.1]
              [0.9 color rgbt 1]
              }
            scale 0.1
            turbulence 1.0
            }
          finish { diffuse 0.9 }
          }
        }

      rotate <-10,10,0>
      translate <1.5,3,4.75>
      }  // end cig union

    translate 4*y
    rotate OpHeadrot
    }  // end head union

    cone {<0,0,0>,0,<0,18,0>,0.5  // smoke
        open
        texture {
          pigment { spiral1 2
            color_map {
              [0.4 color rgbt 1]
              [0.5 color rgbt <0.8,0.8,0.8,0.4>]
              [0.6 color rgbt 1]
              }
            rotate x*90
            turbulence 0.4
            scale <1,10,1>
            }
          finish { ambient 0.5 }
          translate Smoketrans
          }
        rotate <10,0,0> // to offset cig rotation
        translate z*3
        rotate <-10,10,0>
        translate <1.5,7,4.75>
        }  // end smoke

    blob {  // body
      threshold 0.5
      cylinder {<0,0,0>,<0,3,0>,7.594,1 } // neck base
      sphere {0,1,1  // shoulderblades
        scale <16,6,8>
        translate <0,-3.5,-3>
        }
      sphere {0,1,1  // shoulderblades
        scale <12,8,8>
        translate <0,-10,-1>
        }
      sphere {0,1,1  // bod r
        scale <10,16,12>
        translate <4,-12,0>
        }
      sphere {0,1,1  // bod l
        scale <10,16,12>
        translate <-4,-12,0>
        }
      sphere {0,1,1  // bod r
        scale <7,10,8>
        translate <2,-20,0>
        }
      sphere {0,1,1  // bod l
        scale <7,10,8>
        translate <-2,-20,0>
        }
      sphere {0,1,2  // chest r
        scale <7,5,3>
        rotate <-20,10,0>
        translate <4.5,-7,5>
        }
      sphere {0,1,2  // chest l
        scale <7,5,3>
        rotate <-20,-10,0>
        translate <-4.5,-7,5>
        }
      sphere {0,1,1  // shldr r
        scale 8
        translate <9,-6,0>
        }
      sphere {0,1,1  // shldr l
        scale 8
        translate <-9,-6,0>
        }

      texture { OpShirt }
      texture {                              // neck hole
        pigment { onion
          color_map {
            [0.1 OpSkincol]
            [0.1 color rgbt 1]
            }
          scale <70,90,90>
          }
        }
      texture {                         // arm r hole
        pigment { onion
          color_map {
            [0.1 OpSkincol]
            [0.1 color rgbt 1]
            }
          scale <40,60,60>
          translate <11,-6,0>
          }
        }
      texture {                         // arm l hole
        pigment { onion
          color_map {
            [0.1 OpSkincol]
            [0.1 color rgbt 1]
            }
          scale <40,60,60>
          translate <-11,-6,0>
          }
        }
      }  // end body

    blob {  // arm R
      threshold 0.5
      sphere {0,1,5 // shoulder
        scale <5,5,6>
        translate y*-1
        }
      sphere {0,1,5 // shoulder
        scale <5,6.5,4>
        translate y*-1.5
        }
      cylinder {0,y*-13,2.5,3 // upper arm
        }
      cylinder {y*-2,y*-12,2.25,3  // forearm
        rotate OpElbowR
        translate y*-13
        }
      sphere {0,1,5 // bicep
        scale <3.5,5.5,4.5>
        rotate x*30
        translate <0,-7,0>
        }
      sphere {0,1,5  // forearm
        scale <3,4.5,3>
        rotate x*-10
        translate <0,-4,-0.25>
        rotate OpElbowR
        translate y*-13
        }
      rotate OpArmRrot
      translate <10,-5,0>
      texture { OpSkin }
      } // end arm R

    blob {  // arm L
      threshold 0.5
      sphere {0,1,5 // shoulder
        scale <5,5,6>
        translate y*-1
        }
      sphere {0,1,5 // shoulder
        scale <5,6.5,4>
        translate y*-1.5
        }
      cylinder {0,y*-13,2.5,3 // upper arm
        }
      cylinder {y*-2,y*-12,2.25,3  // forearm
        rotate OpElbowL
        translate y*-13
        }
      sphere {0,1,5 // bicep
        scale <3.5,5.5,4.5>
        rotate x*30
        translate <0,-7,0>
        }
      sphere {0,1,5  // forearm
        scale <3,4.5,3>
        rotate x*-10
        translate <0,-4,-0.25>
        rotate OpElbowL
        translate y*-13
        }
      rotate OpArmLrot
      translate <-10,-5,0>
      texture { OpSkin }
      } // end arm L

  union {  //      Right Hand
  blob {  // palm
    threshold 0.5
    sphere {0,1,1  // wrist
      scale 2
      }
    sphere {0,1,1
      scale <3.5,3,1.5>
      translate <0,-1.5,0.25>
      }
    sphere {0,1,1  // thumb joint
      scale 1.125
      translate <-1.25,-1,-0.125>
      }
    }  // end palm
  blob {                // thumb
    threshold 0.6
    cylinder {0,x*-1,1,1}
    sphere {0,1,-1
      translate x*-1
      }
    cylinder {0,x*-1,1,1
      rotate y*-90
      translate x*-1
      }
    rotate y*-90
    rotate z*20
    translate <-1.875,-1.25,-0.125>
    }  // end thumb
  blob {                // finger1
    threshold 0.6
    cylinder {0,y*-1.75,1,1}
    sphere {0,1,-1
      translate y*-1.75
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110
      translate y*-1.75
      }
    rotate x*90
    rotate z*-10
    translate <-1,-2.625,0.25>
    }  // end finger1
  blob {                // finger2
    threshold 0.6
    cylinder {0,y*-1.875,1,1}
    sphere {0,1,-1
      translate y*-1.875
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110
      translate y*-1.875
      }
    rotate x*90
    translate <-0.125,-2.75,0.25>
    }  // end finger2
  blob {                // finger3
    threshold 0.6
    cylinder {0,y*-1.625,1,1}
    sphere {0,1,-1
      translate y*-1.625
      }
    cylinder {0,y*-1.375,1,1
      rotate x*110
      translate y*-1.625
      }
    rotate x*90
    rotate z*10
    translate <0.75,-2.5,0.25>
    }  // end finger3
  blob {                // finger4
    threshold 0.6
    cylinder {0,y*-1.5,1,1}
    sphere {0,1,-1
      translate y*-1.5
      }
    cylinder {0,y*-1.25,1,1
      rotate x*110
      translate y*-1.5
      }
    rotate x*90
    rotate z*30
    translate <1.25,-2,0.125>
    }  // end finger4
  texture { OpSkin }
  scale 1.5
  rotate OpHandR
  translate y*-12
  rotate OpElbowR
  translate y*-13
  rotate OpArmRrot
  translate <10,-5,0>
  }  // end HandR

  union {  //      Left Hand
  blob {  // palm
    threshold 0.5
    sphere {0,1,1  // wrist
      scale 2
      }
    sphere {0,1,1
      scale <3.5,3,1.5>
      translate <0,-1.5,0.25>
      }
    sphere {0,1,1  // thumb joint
      scale 1.125
      translate <1.25,-1,-0.125>
      }
    }  // end palm
  blob {                // thumb
    threshold 0.6
    cylinder {0,x*1,1,1}
    sphere {0,1,-1
      translate x*1
      }
    cylinder {0,x*1,1,1
      rotate y*90
      translate x*1
      }
    rotate y*90
    rotate z*-20
    translate <1.875,-1.25,-0.125>
    }  // end thumb
  blob {                // finger1
    threshold 0.6
    cylinder {0,y*-1.75,1,1}
    sphere {0,1,-1
      translate y*-1.75
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110
      translate y*-1.75
      }
    rotate x*90
    rotate z*10
    translate <1,-2.625,0.25>
    }  // end finger1
  blob {                // finger2
    threshold 0.6
    cylinder {0,y*-1.875,1,1}
    sphere {0,1,-1
      translate y*-1.875
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110
      translate y*-1.875
      }
    rotate x*90
    translate <0.125,-2.75,0.25>
    }  // end finger2
  blob {                // finger3
    threshold 0.6
    cylinder {0,y*-1.625,1,1}
    sphere {0,1,-1
      translate y*-1.625
      }
    cylinder {0,y*-1.375,1,1
      rotate x*110
      translate y*-1.625
      }
    rotate x*90
    rotate z*-10
    translate <-0.75,-2.5,0.25>
    }  // end finger3
  blob {                // finger4
    threshold 0.6
    cylinder {0,y*-1.5,1,1}
    sphere {0,1,-1
      translate y*-1.5
      }
    cylinder {0,y*-1.25,1,1
      rotate x*110
      translate y*-1.5
      }
    rotate x*90
    rotate z*-30
    translate <-1.25,-2,0.125>
    }  // end finger4

  texture { OpSkin }
  scale 1.5
  rotate OpHandL
  translate y*-12
  rotate OpElbowL
  translate y*-13
  rotate OpArmLrot
  translate <-10,-5,0>
  }  // end HandL

  blob { // legs
    threshold 0.5
    sphere { 0,1,1
      scale <12,10,9>
      translate <0,-3,1>
      }
    cylinder {<4,0,0>,<6,-18,0>,6,2}
    cylinder {<-4,0,0>,<-6,-18,0>,6,2}
    translate y*-25
    texture { pigment { color rgb <0.2,0.15,0.4>}}
    } // end legs


  translate y*64

  rotate Oprot
  translate Optrans

  } // end Opponent





