
//  Player.inc    July 1998  Neil Alexander

// This file contains the object Player for use in Poolshrk.pov.

//----------------------------- Declarations --------------------------

#declare Skincol = <1,0.8,0.6>
#declare Shirtcol = <0.75,0.85,1>
#declare Pantscol = <0.6,0,0.4>


//---------------------------- Head -------------------------------------

#declare Eye = sphere {
  0,1
  texture {
    pigment { wood
      color_map {
        [Dilate color rgb 0]
        [Dilate color rgb 1]
        }
      scale 2.1
      rotate Eyerot
      }
    }
  texture {
    pigment { gradient y
      color_map {
        [(Lowlid-0.05) color rgb Skincol]
        [Lowlid color rgb Skincol/2]
        [Lowlid color rgbt 1]
        [Uplid color rgbt 1]
        [Uplid color rgb Skincol/2]
        [(Uplid+0.05) color rgb Skincol]
        }
      translate y*-0.5
      scale 2.1
      }
    }
  scale <1.25,2,1.25>
  }  // end Eye

#declare Eyebrow = blob {
  threshold 0.5
  sphere {0,0.5,1
    translate x*0.5
    }
  sphere {0,0.5,1
    translate y*0.125
    }
  sphere {0,0.5,1
    translate x*-0.5
    }
  scale <1,1,0.25>
  texture {
    pigment { color rgb <0.25,0.2,0.125>}
    }
  no_shadow
  }  // end Eyebrow

#declare Head = union {  // head
  difference {  // face minus mouth opening
    blob {  // face
      threshold 0.5
      sphere { 0, 1, 1 // lower face
        scale <(7+2*Faceaspect),(10-2*Faceaspect),8>
        translate z*1
        }
      sphere { 0, 1, 1  // upper face
        scale <6,8,4.5>
        rotate x*20
        translate y*7
        }
      sphere { 0,1,1  // forehead
        scale 4
        translate <0,8,1>
        }
      sphere { 0,1,1  // nose
        scale <2,1.5,3>
        rotate x*-20
        translate <0,3.5,6>
        }
      sphere {0,1,1  // right ear
        scale <1.5,2,1>
        rotate y*45
        translate <4.5,5.5,-1>
        }
      sphere {0,1,-0.75 // right ear hole
        scale <1,1.5,0.75>
        rotate y*45
        translate <4.5,5.375,-0.75>
        }
      sphere {0,1,1  // left ear
        scale <1.5,2,1>
        rotate y*-45
        translate <-4.5,5.5,-1>
        }
      sphere {0,1,-0.75 // left ear hole
        scale <1,1.5,0.75>
        rotate y*-45
        translate <-4.5,5.375,-0.75>
        }
      sphere { 0, 1, 1 // lower lip
        scale <(1.8+Faceaspect/2),0.75,2>
        rotate x*(-30+70*Faceaspect)
        translate <0,(-2+Faceaspect),4>
        #if (Faceaspect<0.51)
          rotate y*(10*Faceaspect*2)
          #end
        texture { pigment { color rgb <1,0,0>}}
        }
      } // end face blob
    intersection {  // mouth opening
      cylinder {<0,0,0>,<0,0,6>,1
        scale <2.75,1.75,1>
        }
      plane {y,0}
      translate y*0.25
      #if (Faceaspect < 1)
        translate z*10
        #end
      }
    texture {
      pigment { color rgb Skincol}
      }
    }  // end face difference
  blob {  // hair
    threshold 0.5
    sphere {0,1,1
      scale <4,9,3.5>
      rotate y*10
      rotate x*30
      translate <1.5,8,-0.5>
      }
    sphere {0,1,1
      scale <4,9,3.5>
      rotate y*-10
      rotate x*30
      translate <-1.5,8,-0.5>
      }
    sphere {0,1,1
      scale <2.5,6,5>
      rotate x*30
      translate <0,7,0>
      }
    cylinder {0,y*-4,1,1  // right sideburn
      scale <0.5,1,1>
      translate <3.375,9,0.5>
      }
    cylinder {0,y*-4,1,1  // right sideburn
      scale <0.5,1,1>
      translate <-3.375,9,0.5>
      }
    texture {  // hair texture base
      pigment { radial
        color_map {
          [0 color rgb <0.5,0.4,0.25>]
          [0.5 color rgb <0.25,0.2,0.125>]
          [1 color rgb <0.5, 0.4, 0.25>]
          }
        turbulence 0.1
        frequency 12
        rotate x*30
        translate y*4
        }
      }
    texture {  // hair texture overlay
      pigment { radial
        color_map {
          [0 color rgbt <1,0.8,0.5,1>]
          [0.5 color rgbt <1,0.8,0.5,0.7>]
          [1 color rgbt <1, 0.8, 0.5,1>]
          }
        turbulence 0.2
        frequency 25
        rotate x*30
        translate y*4
        }
      }
    }  // end hair blob
  object { Eye  // right
    translate <1.5,5.5,2.5>
    }
  object { Eye  // left
    translate <-1.5,5.5,2.5>
    }
  object { Eyebrow  // right
    rotate <0,30,0>
    translate <1.75,(7.75+Brow),3.5>  // 7.75 to 8.75
    }
  object { Eyebrow  // left
    rotate <0,-30,0>
    translate <-1.75,(7.75+Brow),3.5>
    }
  #if (Faceaspect=1)
    sphere {0,1  // Teeth
      texture {
        pigment { radial
          color_map {
            [0 color rgb 0.5]
            [0.125 color rgb 1]
            [0.875 color rgb 1]
            [1 color rgb 0.5]
            }
          frequency 24
          }
        }
      scale <4,4,3>
      translate <0,0,2>
      }
    #end  // teeth
  sphere {0,1  // mustache
    texture {
      pigment { radial
        color_map {
          [0.125 color rgb <0.25,0.2,0.125>]
          [0.25 color rgbt <0.25,0.2,0.125,1>]
          [0.75 color rgbt <0.25,0.2,0.125,1>]
          [0.875 color rgb <0.25,0.2,0.125>]
          }
        frequency 72
        }
      }
    scale <(2.5+Faceaspect),0.5,2.5>
    rotate x*-25
    translate <0,0,3.125>
    }

  rotate Headrot
  }  // end Head


//---------------------------- Head2 -------------------------------------

  #declare Head2 = union {  // head
  difference {  // face minus mouth opening
    blob {  // face
      threshold 0.5
      sphere { 0, 1, 1 // lower face
        scale <9,8,8>
        translate z*1
        }
      sphere {0,1,1 // lump for ball
        scale 2.5
        translate <3.75,-0.718,4.472>
        }
      sphere {0,1,1 // lump for ball
        scale 2.5
        translate <-3.75,-0.718,4.472>
        }
      sphere {0,1,1 // lump for ball
        scale 2.5
        translate <2.5,-3,3.75>
        }
      sphere {0,1,1 // lump for ball
        scale 2.5
        translate <-2.5,-3,3.75>
        }
      sphere {0,1,1 // lump for ball
        scale 2.5
        translate <0,-3,3.75>
        }

      sphere { 0, 1, 1  // upper face
        scale <6,8,4.5>
        rotate x*20
        translate y*7
        }
      sphere { 0,1,1  // forehead
        scale 4
        translate <0,8,1>
        }
      sphere { 0,1,1  // nose
        scale <2,1.5,3>
        rotate x*-20
        translate <0,3.5,6>
        }
      sphere {0,1,1  // right ear
        scale <1.5,2,1>
        rotate y*45
        translate <4.5,5.5,-1>
        }
      sphere {0,1,-0.75 // right ear hole
        scale <1,1.5,0.75>
        rotate y*45
        translate <4.5,5.375,-0.75>
        }
      sphere {0,1,1  // left ear
        scale <1.5,2,1>
        rotate y*-45
        translate <-4.5,5.5,-1>
        }
      sphere {0,1,-0.75 // left ear hole
        scale <1,1.5,0.75>
        rotate y*-45
        translate <-4.5,5.375,-0.75>
        }
      } // end face blob
    cylinder {<0,0,0>,<0,0,8>,1  // mouth opening
      texture { pigment { color rgbt 1}}
      scale <4,2.25,1>
      translate y*-1
      }
    texture {
      pigment { color rgb Skincol}
      }
    }  // end face difference
  blob {  // hair
    threshold 0.5
    sphere {0,1,1
      scale <4,9,3.5>
      rotate y*10
      rotate x*30
      translate <1.5,8,-0.5>
      }
    sphere {0,1,1
      scale <4,9,3.5>
      rotate y*-10
      rotate x*30
      translate <-1.5,8,-0.5>
      }
    sphere {0,1,1
      scale <2.5,6,5>
      rotate x*30
      translate <0,7,0>
      }
    cylinder {0,y*-4,1,1  // right sideburn
      scale <0.5,1,1>
      translate <3.375,9,0.5>
      }
    cylinder {0,y*-4,1,1  // right sideburn
      scale <0.5,1,1>
      translate <-3.375,9,0.5>
      }
    texture {  // hair texture base
      pigment { radial
        color_map {
          [0 color rgb <0.5,0.4,0.25>]
          [0.5 color rgb <0.25,0.2,0.125>]
          [1 color rgb <0.5, 0.4, 0.25>]
          }
        turbulence 0.1
        frequency 12
        rotate x*30
        translate y*4
        }
      }
    texture {  // hair texture overlay
      pigment { radial
        color_map {
          [0 color rgbt <1,0.8,0.5,1>]
          [0.5 color rgbt <1,0.8,0.5,0.7>]
          [1 color rgbt <1, 0.8, 0.5,1>]
          }
        turbulence 0.2
        frequency 25
        rotate x*30
        translate y*4
        }
      }
    }  // end hair blob
  object { Eye  // right
    translate <1.5,5.5,2.5>
    }
  object { Eye  // left
    rotate z*180
    translate <-1.5,5.5,2.5>
    }
  object { Eyebrow  // right
    rotate <0,30,0>
    translate <1.75,(7.75+Brow),3.5>  // 7.75 to 8.75
    }
  object { Eyebrow  // left
    rotate <0,-30,0>
    translate <-1.75,(7.75+Brow),3.5>
    }
  sphere {0,1  // mustache
    texture {
      pigment { radial
        color_map {
          [0.125 color rgb <0.25,0.2,0.125>]
          [0.25 color rgbt <0.25,0.2,0.125,1>]
          [0.75 color rgbt <0.25,0.2,0.125,1>]
          [0.875 color rgb <0.25,0.2,0.125>]
          }
        frequency 72
        }
      }
    scale <3.5,0.5,2.5>
    rotate x*-25
    translate <0,1,3.125>
    }

  rotate Headrot
  }  // end Head2

//---------------------------- Balls2 for Head2 ------------


#declare R1 = seed(0) // random seed for ball rotation

#declare Balls2 = union {  // balls in mouth

  sphere {0,1.25  // (1)    bottom tier
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <1,0.8,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    }
  sphere {0,1.25  // (14)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0,0.3,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-1.25,0,-2.165>
    }
  sphere {0,1.25  // (15)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0.4,0.1,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <1.25,0,-2.165>
    }
  sphere {0,1.25  // (11)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0.8,0.1,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <2.5,0,0>
    }
  sphere {0,1.25  // (5)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <1,0.5,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-2.5,0,0>
    }

  sphere {0,1.25  // (2)     middle tier
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0,0,0.3>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-1.25,2.282,0.722>
    }
  sphere {0,1.25  // (6)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0,0.3,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <1.25,2.282,0.722>
    }
  sphere {0,1.25  // (8)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb 0.1]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <2.5,2.282,-1.443>
    }
  sphere {0,1.25  // (13)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <1,0.5,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <0,2.282,-1.443>
    }
  sphere {0,1.25  // (7)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0.4,0.1,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-2.5,2.282,-1.443>
    }
  sphere {0,1.25  // (9)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <1,0.8,0>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <3.75,2.282,0.722>
    }
  sphere {0,1.25  // (10)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0,0,0.3>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-3.75,2.282,0.722>
    }

  sphere {0,1.25  // (3)    top tier
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0.8,0.1,0>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <1.25,4.564,-0.722>
    }
  sphere {0,1.25  // (12)
    texture { pigment { gradient y
        color_map {
          [0.5 color rgb <0.3,0,0.3>]
          [0.5 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <-1.25,4.564,-0.722>
    }
  sphere {0,1.25  // (4)
    texture { pigment { gradient y
        color_map {
          [0.98 color rgb <0.3,0,0.3>]
          [0.98 color rgb 1]
          } scale 1.25 }
      finish { phong 0.8 phong_size 50 }
      }
    rotate <rand(R1)*360,rand(R1)*360,0>
    translate <0,4.564,-2.887>
    }

  translate <0,-3,3.75>
  rotate Headrot      // position with head

  }  // end Balls2


//---------------------------- Torso -----------------------

#declare Torso = union {
  blob {  // Torso
    threshold 0.5
    sphere {0,1,1  // belly
      scale 14
      }
    sphere {0,1,1  // upper body
      scale <8,8,8>
      translate <0,11,-1>
      }
    sphere {0,1,1  // right shoulder
      scale 2.125
      translate <4,13,0>
      rotate y*Shoulderrot
      }
    sphere {0,1,1  // left shoulder
      scale 2.125
      translate <-4,13,0>
      rotate y*Shoulderrot
      }
    texture {
      pigment { radial
        color_map {
          [0.1 color rgb Pantscol]
          [0.1 color rgb 1]
          [0.9 color rgb 1]
          [0.9 color rgb Pantscol]
          }
        frequency 7
        rotate y*90
        }
      }
    texture {  // pants, shirt
      pigment { gradient y
        color_map {
          [ 0.27 color rgb Pantscol]
          [ 0.27 color rgbt 1]
          [ 0.31 color rgbt 1]
          [ 0.31 color rgb Pantscol]
          [ 0.33 color rgb Pantscol]
          [0.33 color rgb Shirtcol]
          }
        scale 36
        translate y*-10
        }
      }
    }  // end torso blob

  torus {0.67,0.33    // belt buckle
    rotate x*90
    scale <1.5,1.25,0.5>
    translate <0,0.375,7.75>
    texture {
      pigment { color rgb <0.7,0.6,0.2>}
      finish { phong 1 phong_size 50 metallic }
      }
    }

  difference {  // vest
    sphere {0,1
      scale <7.5,15.5,7.5>
      rotate -5*x
      texture {
        pigment { bozo
          color_map {
            [0.5 color rgb <0.8,0.3,0.1>]
            [0.5 color rgb <0.4,0.15,0.05>]
            }
          scale 1
          frequency 4
          }
        }
      }
    cylinder {  // armholes
      <-6,11.5,0>,<6,11.5,0>,2.5
      }
    intersection {  // front opening
      plane { x,0
        rotate 20*y
        }
      plane { x,0
        rotate 160*y
        }
      }
    plane {y,3}
    cylinder {0,y*16,1.5
      scale <1,1,2>
      }
    texture { pigment { color rgbt 1}}
    }  // end vest

  }  // end Torso
#declare Neck = union {
  cylinder {y*3.5,y*6,1.5
    texture { pigment { color rgb Shirtcol }}
    }
  torus {1.25,0.25
    translate y*6
    texture { pigment { color rgb Shirtcol }}
    }
  cylinder {y*3.5,y*12,1
    texture { pigment { color rgb Skincol }}
    }
  }  // end Neck

// ---------------------- Hands ----------------------------

#declare HandR = union {  //      Right Hand
  blob {  // palm
    threshold 0.5
    sphere {0,1,1  // wrist
      scale 2
      }
    sphere {0,1,1
      scale <3.5,3,2>
      translate y*-1.5
      }
    sphere {0,1,1  // thumb joint
      scale 1.125
      translate <-1.25,-1,-0.125>
      }
    }  // end palm
  blob {                // thumb
    threshold 0.6
    cylinder {0,x*-1,1,1}
    sphere {0,1,-1
      translate x*-1
      }
    cylinder {0,x*-1,1,1
      rotate y*-90*FistR
      translate x*-1
      }
    rotate y*-90*FistR
    rotate z*20
    translate <-2,-1.25,0>
    }  // end thumb
  blob {                // finger1
    threshold 0.6
    cylinder {0,y*-1.75,1,1}
    sphere {0,1,-1
      translate y*-1.75
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110*FistR
      translate y*-1.75
      }
    rotate x*90*FistR
    rotate z*-10
    translate <-1,-2.75,0.25>
    }  // end finger1
  blob {                // finger2
    threshold 0.6
    cylinder {0,y*-1.875,1,1}
    sphere {0,1,-1
      translate y*-1.875
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110*FistR
      translate y*-1.875
      }
    rotate x*90*FistR
    translate <-0.125,-2.75,0.25>
    }  // end finger2
  blob {                // finger3
    threshold 0.6
    cylinder {0,y*-1.625,1,1}
    sphere {0,1,-1
      translate y*-1.625
      }
    cylinder {0,y*-1.375,1,1
      rotate x*110*FistR
      translate y*-1.625
      }
    rotate x*90*FistR
    rotate z*10
    translate <0.75,-2.5,0.25>
    }  // end finger3
  blob {                // finger4
    threshold 0.6
    cylinder {0,y*-1.5,1,1}
    sphere {0,1,-1
      translate y*-1.5
      }
    cylinder {0,y*-1.25,1,1
      rotate x*110*FistR
      translate y*-1.5
      }
    rotate x*90*FistR
    rotate z*30
    translate <1.25,-2,0.125>
    }  // end finger4

  texture { pigment { color rgb Skincol }}
  }  // end HandR

#declare HandL = union {  //      Left Hand
  blob {  // palm
    threshold 0.5
    sphere {0,1,1  // wrist
      scale 2
      }
    sphere {0,1,1
      scale <3.5,3,2>
      translate y*-1.5
      }
    sphere {0,1,1  // thumb joint
      scale 1.125
      translate <1.25,-1,-0.125>
      }
    }  // end palm
  blob {                // thumb
    threshold 0.6
    cylinder {0,x*1,1,1}
    sphere {0,1,-1
      translate x*1
      }
    cylinder {0,x*1,1,1
      rotate y*90*FistL
      translate x*1
      }
    rotate y*90*FistL
    rotate z*-20
    translate <2,-1.25,0>
    }  // end thumb
  blob {                // finger1
    threshold 0.6
    cylinder {0,y*-1.75,1,1}
    sphere {0,1,-1
      translate y*-1.75
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110*FistL
      translate y*-1.75
      }
    rotate x*90*FistL
    rotate z*10
    translate <1,-2.75,0.25>
    }  // end finger1
  blob {                // finger2
    threshold 0.6
    cylinder {0,y*-1.875,1,1}
    sphere {0,1,-1
      translate y*-1.875
      }
    cylinder {0,y*-1.5,1,1
      rotate x*110*FistL
      translate y*-1.875
      }
    rotate x*90*FistL
    translate <0.125,-2.75,0.25>
    }  // end finger2
  blob {                // finger3
    threshold 0.6
    cylinder {0,y*-1.625,1,1}
    sphere {0,1,-1
      translate y*-1.625
      }
    cylinder {0,y*-1.375,1,1
      rotate x*110*FistL
      translate y*-1.625
      }
    rotate x*90*FistL
    rotate z*-10
    translate <-0.75,-2.5,0.25>
    }  // end finger3
  blob {                // finger4
    threshold 0.6
    cylinder {0,y*-1.5,1,1}
    sphere {0,1,-1
      translate y*-1.5
      }
    cylinder {0,y*-1.25,1,1
      rotate x*110*FistL
      translate y*-1.5
      }
    rotate x*90*FistL
    rotate z*-30
    translate <-1.25,-2,0.125>
    }  // end finger4

  texture { pigment { color rgb Skincol }}
  }  // end HandL


//----------------------------- Arms -----------------------

#declare ArmR = union {
  cylinder {0,y*-10,1.5}
  sphere {y*-10,1.5}
  union {
    cylinder {0,y*-10,1.5}
    object { HandR
      rotate HandRrot
      translate y*-10
      }
    rotate ForearmRrot
    translate y*-10
    }
  texture { pigment { color rgb Shirtcol }}
  }  // end ArmR

#declare ArmL = union {
  cylinder {0,y*-10,1.5}
  sphere {y*-10,1.5}
  union {
    cylinder {0,y*-10,1.5}
    object { HandL
      rotate HandLrot
      translate y*-10
      }
    rotate ForearmLrot
    translate y*-10
    }
  texture { pigment { color rgb Shirtcol }}
  }  // end ArmL

//----------------------- Legs -----------------------------

#declare LegR = cylinder {
  0,y*-18,2.5
  texture { pigment { color Pantscol }}
  }

#declare LegL = cylinder {
  0,y*-18,2.5
  texture { pigment { color Pantscol }}
  }

//------------------------------ Full Body Assembly -----------------

#declare Player = union {
  union {
    #if (Headalt = 0)  // normal head
      object { Head
        rotate (x*-Headfwd)
        rotate -Hipsbend
        translate <0,11,1>
        }
      #else           // alternate head for shot 9
        object { Head2
          rotate (x*-Headfwd)
          rotate -Hipsbend
          translate <0,11,1>
          }
        object { Balls2
          rotate (x*-Headfwd)
          rotate -Hipsbend
          translate <0,11,1>
          }
      #end

    object { Neck }
    rotate x*Headfwd
    translate <0,11,0>
    }
  object { Torso
    }
  object { ArmR
    rotate ArmRrot
    translate <4,13,0>
    rotate y*Shoulderrot
    }
  object { ArmL
    rotate ArmLrot
    translate <-4,13,0>
    rotate y*Shoulderrot
    }
  object { LegR
    rotate LegRrot
    rotate -Hipsbend
    translate <4,-4,0>
    }
  object { LegL
    rotate LegLrot
    rotate -Hipsbend
    translate <-4,-4,0>
    }

  rotate Hipsbend
  translate y*36

  rotate Bodyrot
  translate Bodytrans
  }

