
//  Poolhall.inc  July - September 1998  Neil Alexander

// This file contains the room definition for the pool hall,
// and is the scene for the animation controlled by Poolshrk.pov.
// Uses image maps:  dboard.gif, chalkbrd.gif, g_poster.gif, guinness.gif
// Uses font Alger.ttf  (comes with Win98, must move font into Pov include folder)

//----------------------- Lights ----------------------------

light_source {
  <0,0,0>
  color rgb 2 // I accidentally discovered you could do this - doubles light intensity.
  spotlight
  point_at <0,-100,0>
  radius 85
  falloff 90
  tightness 1
  scale <1,1,2>
  translate <66,95,90>
  }

light_source {
  <140,90,110>
  color rgb <0.5,0.3,0.05>
  shadowless
  }

//------------------------- Textures ----------------------

#declare Woodcolor = texture {
  pigment { wood
    color_map {
      [0 color rgb <0.7,0.4,0.2>]
      [1 color rgb <0.525,0.3,0.15>]
      }
    frequency 10
    scale 5
    turbulence 0.01
    octaves 4
    omega 0.3
    lambda 1
    rotate x*90
    translate -100
    }
  finish { phong 0.8 phong_size 25 }
  }  // end Woodcolor

#declare Wallcolor = texture {
  pigment { color rgb 1 }
  normal { wrinkles 0.3 scale 0.5 }
  }  // end Wallcolor

//-------------------------- Room -----------------------

#declare Post = union {
  difference {
    box { <-2,0,-3>,<2,96,3>}
    cylinder {<2,-1,-3>,<2,97,-3>,1}
    cylinder {<2,-1,3>,<2,97,3>,1}
    }  // end difference
  box {<-2,0,-3.5>,<2.5,6,3.5>}
  box {<-2,90,-3.5>,<2.5,96,3.5>}
  }  // end Post

#declare Trim = difference {
  box { <0,0,0>,<2,5.5,180>}
  cylinder {<2,5.5,-1>,<2,5.5,181>,1}
  texture { Woodcolor rotate x*90}
  }  // end Trim

#declare Ledge = union {
  box {<0,46,0>,<6,48,180>}
  cylinder {<6,47,0>,<6,47,180>,1}
  texture { Woodcolor rotate x*90}
  }  // end Ledge

#declare C1 = 0

union {  // Posts
  #while (C1<6)
    object { Post
      translate <0,0,36*C1>
      }
    object { Post
      rotate y*180
      translate <144,0,36*C1>
      }
    #declare C1 = C1+1
    #end  // while loop

  #declare C1 = 0
  #while (C1<5)
    object { Post
      rotate y*-90
      translate <36*C1,0,0>
      }
    object { Post
      rotate y*90
      translate <36*C1,0,180>
      }
    #declare C1 = C1+1
    #end  // while loop

  texture { Woodcolor }
  }  // end Posts

object { Trim }
  object { Trim
    rotate y*180
    translate <144,0,180>
    }
  object { Trim
    rotate y*-90
    translate <144,0,0>
    }
  object { Trim
    rotate y*90
    translate <0,0,180>
    }
  object { Trim
    rotate x*180
    translate <0,96,180>
    }
  object { Trim
    rotate z*180
    translate <144,96,0>
    }
  object { Trim
    rotate <0,-90,180>
    translate <0,96,0>
    }
  object { Trim
    rotate <0,90,180>
    translate <144,96,180>
    }
  object { Ledge }
  object { Ledge
    rotate y*180
    translate <144,0,180>
    }
  object { Ledge
    rotate y*-90
    translate <144,0,0>
    }
  object { Ledge
    rotate y*90
    translate <0,0,180>
    }

box {  // Walls
  <0,0,0>,<144,96,180>
  texture { gradient y
    texture_map {
      [0.48 Woodcolor scale 0.01]
      [0.48 Wallcolor scale 0.01]
      }
    scale 100
    }
  inverse
  }  // end Walls

//------------------------- Pool Table --------------------

#declare Corner = union {
  cylinder {<-1,34.5,1.5>,<6,34.5,1.5>,2.122
    clipped_by {
      plane {z,0
        rotate y*-45
        }
      }
    }

  cylinder {<1.5,34.5,-1>,<1.5,34.5,6>,2.122
    clipped_by {
      plane {x,0
        rotate y*45
        }
      }
    }
  sphere {<6,34.5,1.5>,2.122}
  sphere {<1.5,34.5,6>,2.122}
  texture {
    pigment { color rgb 0.2 }
    finish { phong 0.5 phong_size 50 }
    }
  }  // end Corner

union {  // pool table
union {  // wooden frame
  difference {
    box {<0,18,0>,<48,36,96>}
    box {<3,20,3>,<45,37,93>}
    }
  box {<3,0,3>,<9,18,9>}
  box {<39,0,87>,<45,18,93>}
  box {<3,0,87>,<9,18,93>}
  box {<39,0,3>,<45,18,9>}
  texture { Woodcolor }
  }  // end union

difference {  // green felt
  box {<3,20,3>,<45,36,93>}
  box {<6,35,6>,<42,37,90>}
  box {<5.5,34,5.5>,<42.5,35.1,90.5>}
  union {  // pockets
    cylinder {<7.414,20,7.414>,<7.414,37,7.414>,2}
    cylinder {<6.5,20,6.5>,<6.5,37,6.5>,2}
    cylinder {<7.414,20,88.586>,<7.414,37,88.586>,2}
    cylinder {<6.5,20,89.5>,<6.5,37,89.5>,2}
    cylinder {<40.586,20,7.414>,<40.586,37,7.414>,2}
    cylinder {<41.5,20,6.5>,<41.5,37,6.5>,2}
    cylinder {<40.586,20,88.586>,<40.586,37,88.586>,2}
    cylinder {<41.5,20,89.5>,<41.5,37,89.5>,2}
    cylinder {<6,20,48>,<6,37,48>,2}
    cylinder {<42,20,48>,<42,37,48>,2}
    texture {
      pigment { color rgb 0.2 }
      finish { phong 1 phong_size 15 }
      }
    }  // end pockets
  texture { pigment { color rgb <0,0.5,0.2>}}
  }  // end felt

object { Corner }
object { Corner
  rotate y*-90
  translate x*48
  }
object { Corner
  rotate y*90
  translate z*96
  }
object { Corner
  rotate y*180
  translate <48,0,96>
  }

translate <42,0,42>
} // end pool table

//------------------------- Wall Decorations --------------------

#declare Frame = union { // ---------------- Frame for posters
  box {<0,0,-0.25>,<2,34,0>}
  cylinder {<0,0,0>,<0,34,0>,0.5
    scale <1,1,0.5>
    translate <0.5,0,-0.25>
    }
  cylinder {<1.125,0,-0.25>,<1.125,34,-0.25>,0.125
    texture {
      pigment { color rgb <1,0.9,0.4>}
      finish { phong 1 phong_size 50 metallic }
      }
    }
  cylinder {<1.625,0,-0.25>,<1.625,34,-0.25>,0.375}
  texture { Woodcolor }
  }  

#declare PFrame = union {
  difference { // left vertical
    object { Frame}
    plane { y,0
      rotate z*-45
      }
    plane { -x,0
      rotate z*45
      translate<0,34,0>
      }
    }
  difference { // right vertical
    object { Frame}
    plane { y,0
      rotate z*-45
      }
    plane { -x,0
      rotate z*45
      translate<0,34,0>
      }
    rotate 180*z
    translate<24,34,0>
    }
  difference { // top
    object { Frame
      rotate -90*z
      }
    plane { x,0
      rotate 45*z
      }
    plane { y,0
      rotate 45*z
      translate<24,0,0>
      }
    translate<0,34,0>
    }
  difference { // bottom
    object { Frame
      rotate -90*z
      }
    plane { x,0
      rotate 45*z
      }
    plane { y,0
      rotate 45*z
      translate<24,0,0>
      }
    rotate 180*z
    translate<24,0,0>
    }
  translate <-2,0,0>
  }  // end PFrame

union { //-------------------- Guinness poster
  box {
    <0,0,-0.25>,<20,30,0>
    texture {
      pigment {
        image_map {
          gif "g_poster.gif"
          map_type 0
          interpolate 2
          } // image_map
        }
      finish { phong 0.8 phong_size 25 ambient 0.15 }
      scale <20,30,1>
      }
    translate 2*y
    }
  object { PFrame }
  rotate x*-2
  translate <8,52,180>
  }

union { //------------------ other Guinness poster
  box {
    <0,0,-0.25>,<20,30,0>
    texture {
      pigment {
        image_map {
          gif "guinness.gif"
          map_type 0
          interpolate 2
          } // image_map
        }
      finish { phong 0.8 phong_size 25 ambient 0.15 }
      scale <20,30,1>
      }
    translate 2*y
    }
  object { PFrame }
  rotate x*-2
  rotate y*180
  translate <64,52,0>
  }

cylinder { //---------------- Dart Board
  <0,0,0>,<0,0,0.5>,9
  texture {
    pigment {
      image_map {
        gif "dboard.gif"
        map_type 0
        interpolate 2
        } // image_map
      }
    translate <-0.5,-0.5,0>
    scale 20
    }
  translate <126,70,0>
  }
  
union { //------------------ Chalk board
  box {
    <0,0,-0.25>,<12,15,0>
    texture {
      pigment {
        image_map {
          gif "chalkbrd.gif"
          map_type 0
          interpolate 2
          } // image_map
        }
      scale <12,15,1>
      }
    }
  box {<-2,15,0>,<14,17,-0.5>}
  box {<-2,0,0>,<0,14.9,-0.5>}
  box {<12,0,0>,<14,14.9,-0.5>}
  difference {
    box {<-2,-2,0>,<14,0,-2>}
    cylinder {<-3,0.25,-1.25>,<15,0.25,-1.25>,0.5}
    }
  cylinder {<9,0,-1.25>,<11,0,-1.25>,0.25
    texture { pigment { color rgb 1}}
    }
  texture { pigment { color rgb <1,0.8,0.5>}}
  rotate y*-90
  translate <0,54,155>
  }
  
union { //------------------- Toilets sign
  box {<0,0,0>,<24,11,0.5>
    texture { Woodcolor rotate z*90}
    }
  text { ttf "alger.ttf" "< TOILETS" 0.125, 0
    texture {
      pigment { color rgb <1,0.95,0.6>}
      finish { ambient 0.2 }
      }
    scale <5,8,1>
    translate <0.875,2,0>
    }
  rotate y*180
  translate <120,82,2.5>
  }
