
//  Poolshrk.pov  August-September 1998  Neil Alexander

#include "billiard.inc"
#include "poolhall.inc"

#declare Shot = 1 // 1-9, Shot to be rendered

// This file contains all the camera and object position declarations
// and motion control variables for the animation Poolshark.
// Objects are declared in Player.inc, Opponent.inc, Billiard.inc,
// and Poolhall.inc.
// Uses font Broadw.ttf  (comes with Win98, must move font into Pov include folder)

// The scenes are as follows:

// Shot 1 - Frames 1-100
//          Opening titles, Player and Opponent at pool table,
//          Player reaches for chalk

// Shot 2 - Frames 101-160
//          Close-up of Player chalking cue

// Shot 3 - Frames 161-200
//          Close-up of Opponent

// Shot 4 - Frames 201-320
//          Player setting up shot, eyeing cue ball; focus shift
//          from ball to Player

// Shot 5 - Frames 321-365
//          Cue hitting ball, ball leaving table

// Shot 6 - Frames 366-455
//          Ball hits Opponent in eye,
//          falls in drink, Oppent gets angry

// Shot 7 - Frames 456-500
//          Similar view to Shot 4, Player realizes what he has done;
//          perspective shift/camera closes

// Shot 8 - Frames 501-530
//          Stars fly

// Shot 9 - Frames 531-620
//          Player with mouth full of balls


//-------- Motion Control Variables - Player defaults -----------------

    #declare Headalt = 0  // =1 for alternate head (shot 9)
    #declare Uplid = 0.55  //0.55, up to 0.95
    #declare Lowlid = 0.25  //0.25, down to 0.05
    #declare Dilate = 0.3   // 0.3
    #declare Eyerot = <0,30,0>    // 0 = straight
    #declare Headrot = <0,0,0>
    #declare Headfwd = 10
    #declare Faceaspect = 1  // 1 = normal, 0 = long
    #declare Brow = 0  // 0 to 1 for rise
    #declare Shoulderrot = 0
    #declare Bodyrot = <0,105,0>
    #declare Bodytrans = <24,0,96>

    #declare HandRrot = <0,-55,-30>
    #declare FistR = 1  // 0=open, 1=closed
    #declare ArmRrot = <0,0,78>
    #declare ForearmRrot = <-20,0,-110>

    #declare HandLrot = <0,-120,0>
    #declare FistL = 1  // 0=open, 1=closed
    #declare ArmLrot = <10,0,-30>
    #declare ForearmLrot = <-90,0,0>

    #declare LegRrot = <-10,60,0>
    #declare LegLrot = <-10,-60,0>
    #declare Hipsbend = <0,0,0>

//-------- Motion Control Variables - Opponent defaults -----------------

    #declare Oprot = <0,180,0>
    #declare Optrans = <60,0,169>
    #declare OpFace = 0  // 0 = normal, 0.5 = ball in eye, 1 = angry
    #declare OpHeadrot = <0,0,0> // x*-10 for recoil
    #declare Smoketrans = y*clock*6 // 6" per second
    #declare OpArmRrot = <-20,0,30>
    #declare OpElbowR = <-60,0,0>
    #declare OpHandR = <0,120,0>
    #declare OpArmLrot = <20,0,-40>
    #declare OpElbowL = <-120,20,0>
    #declare OpHandL = <0,-122,0>



#switch (Shot)

  #case (1) //--------------- Shot 1 ------------------------------

  // Frames 1 - 100 (3.3 sec.), clock from 0 to 1
  // Titles on screen for 55 frames, fade out over 10 frames,
  // 15 frame pause, Player reaches for chalk over 20 frames.

    camera {
      location  <104, 60, 16>
      angle 45
      look_at   <56, 50, 100>
      }

    #declare F = clock*10-5.5
    #if (F<0)
      #declare F = 0
      #end  // end if
    #if (F>1)
      #declare F = 1
      #end  // end if

    #declare K = clock*5 - 4 // normalized value for K
    #if (K<0)
      #declare K = 0
      #end  // end if

    #declare K1 = (cos(pi*(K+1))+1)/2  // pendulum motion
    #declare K2 = K*K                  // accelerating motion

    // Titles - Note: Font Broadw.ttf must be copied into Pov Include directory.
    //          This font comes with Windows 98.

    #declare Titletext = union {
      text { ttf "broadw.ttf" "the" 0.25, 0
        translate <-1,10,0>
        }
      text { ttf "broadw.ttf" "POOL" 0.25, 0
        scale <3,3,1>
        translate <-4.375,7.5,0>
        }
      text { ttf "broadw.ttf" "SHARK" 0.25, 0
        scale <3,3,1>
        translate <-5.25,5,0>
        }
      text { ttf "timrom.ttf" "by Neil Alexander  1998" 0.25, 0
        translate <-5.5,-0.75,0>
        }
      }

    #declare Titles = union {
      object { Titletext
        texture {
          pigment { bozo
            pigment_map {
              [F color rgbt 1]
              [F gradient y
                color_map {
                  [0.4 color rgb <1,0.1,0>]
                  [1 color rgb <1,0.7,0>]
                }
                scale 11]
              }
            }
          finish { ambient 2 }
          }
        }
      object { Titletext
        texture {
          pigment { bozo
            pigment_map {
              [F color rgbt 1]
              [F color rgbt 0]
              }
            }
          }
        translate <0.125,-0.125,0.25>
        }
      no_shadow
      } // end Titles

    #if (F<1)
      object { Titles
        rotate y*-90
        rotate z*5.9
        translate x*-25
        rotate y*60.255
        translate <104,50.5,16>
        }
      #end  // end if

    // Player motion variables

    #declare ArmRrot = <0-50*K1,0,80-65*K1>
    #declare ForearmRrot = <-105+90*K2,-75+60*K1,0>
    #declare HandRrot = <-60+30*K1,20+10*K1,-30+30*K1>
    #declare FistR = 1-0.75*K2  // 0=open, 1=closed

    // Opponent motion variables

    #declare Smoketrans = y*clock*20 // 6" per second


    #include "player.inc"
    #include "opponent.inc"
    object { Player }
    object { Opponent }
    object { Chalk
      rotate y*60
      translate <43.75,36,84.5>
      }
    object { Balls }
    object { Pint2
      rotate y*-30
      translate <4.5,48,92>
      }
    object { Cueball
      translate <66, 35.25,75>
      }
    object { Cue // player's
      rotate -90*z
      translate <-42,-2,-0.5>
      rotate HandLrot
      translate y*-10
      rotate ForearmLrot
      translate y*-10
      rotate ArmLrot
      translate <-4,13,0>
      rotate Hipsbend
      translate y*36
      rotate  Bodyrot
      translate Bodytrans
      }
    object { Cue // opponent's
      rotate 90*z
      translate <48,-3,-0.75>
      rotate OpHandR
      translate y*-12
      rotate OpElbowR
      translate y*-13
      rotate OpArmRrot
      translate <10,-5,0>
      translate y*64
      rotate  Oprot
      translate Optrans
      }
    object { Pint1 // opponent's
      rotate y*-60
      translate <70.5,45.375,155.75>
      }



  #break  //  end Shot 1

  #case (2) //--------------- Shot 2 ------------------------------

  // Frames 101 - 160 (2 sec.), clock from 0 to 1
  // Hand with chalk raises to position and cue swings over 15 frames,
  // hand twists chalk back and forth 8 times over 45 frames,
  // brows rise and fall twice in frames 131 to 145.

    camera {
      location  <70, 60, 50>
      angle 40
      look_at   <24, 54, 100>
      }

    // Player variables

    #declare K = clock*4
    #if (K>1)               // stage 1 - hands move to position
      #declare K = 1
      #end

    #declare K1 = sqrt(K)              // decelerating motion
    #declare K2 = K*K                  // accelerating motion

    #declare H = clock*5.333-1.333  // stage 2 - hand back and forth
    #if (H<0)
      #declare H = 0
      #end
    #declare H1 = sin(pi*H)
    #if (H1<0)
      #declare H1 = H1*-1
      #end

    #declare B = clock*8-4  // stage 3 - eyebrows
    #if (B<0)
      #declare B = 0
      #end
    #if (B>2)
      #declare B = 2
      #end
    #declare B1 = sin(pi*B)
    #if (B1<0)
      #declare B1 = B1*-1
      #end

    #declare ArmRrot = <-50-15*K1,-12*K1,-15+15*K1>
    #declare ForearmRrot = <-15-77*K1,-15+15*K1-2*H1,0>
    #declare HandRrot = <-30+48*K1+2*H1,30-5*K1-5*H1,-10*K1+15*H1>
    #declare FistR = 0.5  // 0=open, 1=closed

    #declare HandLrot = <0,-120+10*K2,0>
    #declare ArmLrot = <10-10*K2,0,-30>
    #declare ForearmLrot = <-90+10*K,20*K2,0>

    #declare Brow = B1  // 0 to 1 for rise


    #include "player.inc"
    object { Player }
    object { Pint2
      rotate y*-30
      translate <4.5,48,92>
      }
    object { Cue // player's
      rotate -90*z
      translate <-42,-2,-0.5>
      rotate HandLrot
      translate y*-10
      rotate ForearmLrot
      translate y*-10
      rotate ArmLrot
      translate <-4,13,0>
      rotate Hipsbend
      translate y*36
      rotate  Bodyrot
      translate Bodytrans
      }
    object { Chalk
      rotate 150*x
      translate <0,-3,-3>
      rotate HandRrot
      translate y*-10
      rotate ForearmRrot
      translate y*-10
      rotate ArmRrot
      translate <4,13,0>
      rotate Hipsbend
      translate y*36
      rotate  Bodyrot
      translate Bodytrans
      }


  #break  //  end Shot 2

  #case (3) //--------------- Shot 3 ------------------------------

  // Frames 161 - 200 (1.3 sec.), clock from 0 to 1
  // Opponent close-up, smoke animation

    camera {
      location  <104, 72, 90> // 104,72,90
      angle 20
      look_at   <60, 70, 160>
      }

    #declare Smoketrans = y*clock*8 // 6" per second

    #include "opponent.inc"
    object { Opponent }

  #break  //  end Shot 3

  #case (4) //--------------- Shot 4 ------------------------------

  // Frames 201 - 320 (4 sec.), clock from 0 to 1
  // Focus on cue ball for first 15 frames, focus shift to Player
  // over 45 frames.
  // Player does 2 practice strokes over first 2 seconds, then bobs head over
  // third second, and does one more practice stroke in fourth second.
  // Player blinks during frames 275 to 281 at top of head bob.


    #declare F = clock*2.667 - 0.333 // focus shift
    #if (F<0)
      #declare F = 0
      #end  // end if
    #if (F>1)
      #declare F = 1
      #end  // end if

    #declare F1 = F*F
    #declare F2 = sqrt(F)

    camera {
      location  <66, 41, 79+3*F2>
      angle 90
      look_at   <66, 38*F2, 30>
      aperture 2
      blur_samples 20
      focal_point <66,(35.25+19.75*F1),(75-33*F1)> // ball to player
      }

    #declare K = sin(pi*clock*4) // cue stroke
    #if (K<0)
      #declare K = K*-1
      #end

    #declare B = 0
    #if ((clock>0.5) & (clock<0.75)) // 3rd second
      #declare B = K                 // bob 3rd second
      #declare K = 0                 // no stroke
      #end

    #declare E = clock*32 - 20 // blink
    #if ((E<0)|(E>1))
      #declare E = 0
      #end

    #declare E1 = sin(pi*E)

    #declare Uplid = 0.45-0.1*E1  //0.55, up to 0.95
    #declare Lowlid = 0.25+0.1*E1  //0.25, down to 0.05
    #declare Eyerot = <10,0,0>    // 0 = straight
    #declare Headrot = <10,-30,0>
    #declare Headfwd = 20-B*10
    #declare Faceaspect = 0.5  // 1 = normal, 0 = long
    #declare Shoulderrot = 0
    #declare Bodyrot = <0,30,0>
    #declare Bodytrans = <58,0,30>
    #declare FistR = 1  // 0=open, 1=closed
    #declare ArmRrot = <45,0,90>
    #declare HandLrot = <-33,-23,-40>
    #declare FistL = 0.25  // 0=open, 1=closed
    #declare ArmLrot = <-96,-15,0>
    #declare ForearmLrot = <0,0,20>
    #declare LegRrot = <-10,60,0>
    #declare LegLrot = <-10,-60,0>
    #declare Hipsbend = <40,0,0>
    #declare HandRrot = <0,(17-11.5*K),(-22+26.25*K)>
    #declare ForearmRrot = <-25,0,(-90-30*K)>


    #include "player.inc"
    object { Player }
    object { Cueball
      translate <66, 35.25,75>
      }
    object { Cue // player's
      rotate 90*z
      translate <15,-2,-0.5>
      rotate HandRrot
      translate y*-10
      rotate ForearmRrot
      translate y*-10
      rotate ArmRrot
      translate <4,13,0>
      rotate Hipsbend
      translate y*36
      rotate  Bodyrot
      translate Bodytrans
      }

  #break  //  end Shot 4

  #case (5) //--------------- Shot 5 ------------------------------

  // Frames 321 - 365 (1.5 sec.), clock from 0 to 1
  // practice stroke over first second, 8 frame pause,
  // then cue goes over 3 frames, hits ball, ball travels from table
  // to opponent's eye over 4 frames


    camera {
      location  <90, 50, 50>
      angle 60
      look_at   <10, 30, 180>
      }

    #declare K1 = sin(pi*clock*1.5) // cue stroke
    #if (clock>0.6667)
      #declare K1 = 0
      #end

    #declare K2 = clock*15-12.6667 // cue stroke
    #if (K2<0)
      #declare K2 = 0
      #end
    #if (K2>1)
      #declare K2 = 1
      #end

    #declare B = clock*9-8.2  // ball travel
    #if (B<0)
      #declare B = 0
      #end

    #declare Smoketrans = y*clock*9 // 6" per second


    #include "opponent.inc"
    object { Opponent }
    object { Chalk
      rotate y*60
      translate <43.75,36,84.5>
      }
    object { Balls }
    object { Cue // opponent's
      rotate 90*z
      translate <48,-3,-0.75>
      rotate OpHandR
      translate y*-12
      rotate OpElbowR
      translate y*-13
      rotate OpArmRrot
      translate <10,-5,0>
      translate y*64
      rotate  Oprot
      translate Optrans
      }
    object { Pint1 // opponent's
      rotate y*-60
      translate <70.5,45.375,155.75>
      }
    object { Cueball
      translate <66-3.75*B, 35.25+39.875*B,75+90.5*B>
      }
    object { Cue // player's
      translate y*-61
      rotate 95*x
      translate <66,34.5,67+6*K1+7*K2>
      }


  #break  //  end Shot 5

  #case (6) //--------------- Shot 6 ------------------------------

  // Frames 366 - 455 (3 sec.), clock from 0 to 1
  // Head recoil over first 4 frames.  Pause for 40 frames, then
  // ball falls from eye to drink surface over 11 frames.  Drink
  // splashes and foams over 12 frames, and face turns angry over
  // frames 75 to 90.

    camera {
      location  <104, 75, 90>
      angle 35
      look_at   <60, 62, 160>
      }

    #declare K = clock*22  // head recoil
    #if (K>1)
      #declare K = 1
      #end
    #declare K1= sin(pi*K)

    #declare B = clock*8.182 - 4 //  ball falling
    #if (B<0)
      #declare B = 0
      #end
    #if (B>1)
      #declare B = 1
      #end

    #declare B2 = clock*7.5 - 4.583 // ball sinking after splash
    #if (B2<0)
      #declare B2 = 0
      #end
    #if (B2>1)
      #declare B2 = 1
      #end

    #declare F = clock*6 - 5 // face change
    #if (F<0)
      #declare F = 0
      #end
    #if (F>1)
      #declare F = 1
      #end

    #declare T = clock*3-1.833 // time function for splash

    #declare OpFace = 0.5 + 0.5*F  // 0 = normal, 0.5 = ball in eye, 1 = angry
    #declare OpHeadrot = <K1*-6,0,0> // x*-10 for recoil
    #declare Smoketrans = y*clock*18+1 // 6" per second

    #include "opponent.inc"
    object { Opponent }
    object { Cue // opponent's
      rotate 90*z
      translate <48,-3,-0.75>
      rotate OpHandR
      translate y*-12
      rotate OpElbowR
      translate y*-13
      rotate OpArmRrot
      translate <10,-5,0>
      translate y*64
      rotate  Oprot
      translate Optrans
      }
    object { Pint1 // opponent's
      rotate y*-60
      translate <70.5,45.375,155.75>
      }
    #if (B2>0) // rising head, splash
      superellipsoid {
        <1,0.1>
        rotate 90*x
        texture {
          pigment { color rgb 1}
          finish { ambient 0.3 }
          }
        scale <1.874,0.125+1.375*sqrt(T),1.874>
        translate <70.5,51.001,155.75>
        }
      #declare R2 = seed(0)
      #declare C1 = 0
      #while (C1<40)
        #declare VX = rand(R2)*20
        #declare VY = (rand(R2)+1)*50
        #declare RY = rand(R2)*360
        sphere {0,0.250
          texture {
            pigment { color rgb 1 }
            finish { ambient 0.15 }
            }
          translate <VX*T,VY*T-192*T*T,0>
          translate <-1.562,0,0>
          rotate y*RY
          translate <70.5,51.125,155.75>
          }
        #declare C1 = C1 + 1
        #end  // end while loop

      #end // end if B2>0

    object { Cueball
      translate <-2.25-8.25*B,11.125-24*B*B-4*B2,3.5+9.75*B>
      rotate OpHeadrot
      translate y*64
      rotate  Oprot
      translate Optrans
      }


  #break  //  end Shot 6

  #case (7) //--------------- Shot 7 ------------------------------

  // Frames 456 - 500 (1.5 sec.), clock from 0 to 1
  // Player looks shocked, camera moves in and zooms out.

    #declare F = clock*1.5 // camera shift over first second
    #if (F>1)
      #declare F = 1 + (clock-0.6667)
      #end

    #declare F2 = 0
      #if (F>1)
      #declare F2 = (clock-0.6667)*3
      #end

    #declare F1 = F*0.875 + 0.125
    #if (F1>1)
      #declare F1 = 1
      #end

    camera {
      location  <66, 45+F2*10, 160-75*F>
      angle 30+50*F1*F1
      look_at   <66, 45+F2*10, 30>
      }


    #declare K = (1-cos(pi*clock))/2  // 0 to 1

    #declare Faceaspect = 0.5*(1-K)  // 0.5 to 0
    #declare Brow = K*0.75
    #declare Dilate = 0.3-0.15*K // 0.3 to 0.15
    #declare Uplid = 0.95  //0.55, up to 0.95
    #declare Lowlid = 0.05  //0.25, down to 0.05
    #declare Eyerot = <0,0,0>    // 0 = straight
    #declare Headrot = <10,-30,0>
    #declare Headfwd = 20-K*20
    #declare Shoulderrot = 0
    #declare Bodyrot = <0,30,0>
    #declare Bodytrans = <58,0,30>
    #declare FistR = 1  // 0=open, 1=closed
    #declare ArmRrot = <-50,120,0>
    #declare HandLrot = <-33,-23,-40>
    #declare FistL = 0.25  // 0=open, 1=closed
    #declare ArmLrot = <-96,-15,0>
    #declare ForearmLrot = <0,0,20>
    #declare LegRrot = <-10,60,0>
    #declare LegLrot = <-10,-60,0>
    #declare Hipsbend = <40,0,0>
    #declare HandRrot = <0,0,50>
    #declare ForearmRrot = <10,0,-125>


    #include "player.inc"
    object { Player }
    object { Cue // player's
      rotate 90*z
      translate <15,-2,-0.5>
      rotate HandRrot
      translate y*-10
      rotate ForearmRrot
      translate y*-10
      rotate ArmRrot
      translate <4,13,0>
      rotate Hipsbend
      translate y*36
      rotate  Bodyrot
      translate Bodytrans
      }

  #break  //  end Shot 7

  #case (8) //--------------- Shot 8 ------------------------------

  // Frames 501 - 530 (1.0 sec.), clock from 0 to 1
  // stars flying

    camera {
      location  <0, -200, -12>
      angle 90
      look_at   <0, -200, 0>
      }

    #declare F = clock*10-8 // fade for background
    #if (F<0)
      #declare F = 0
      #end
    #if (F>1)
      #declare F = 1
      #end

    plane { z,0 // background
      texture {
        pigment { wood
          color_map {
            [0 color rgb <1,1,0>]
            [0.25*(1-F) color rgb <1,0,0>]
            [0.5*(1-F) color rgb 0]
            }
          scale 40
          }
        finish { ambient 1 }
        }
      translate y*-200
      }

    #declare C1 = 0
    #declare R1 = seed(2)
    #while (C1<200)
      #declare X1 = rand(R1)*12-6  // -6 to +6
      #if ((X1<0.1)&(X1>-0.1))  // not too close to centre
        #declare X1 = X1 * 10
        #end  // end if
      #declare Y1 = rand(R1)*9-4.5  // -4.5 to +4.5
      #if ((Y1<0.1)&(Y1>-0.1))  // not too close to centre
        #declare Y1 = Y1 * 10
        #end  // end if
      #declare Z1 = rand(R1)*25-12  // -12 to +13
      #declare Z1 = Z1 - clock*24 // move twd cam

      object { Star
        texture {
          pigment { color rgb <rand(R1),rand(R1),rand(R1)>}
          finish { ambient 1 }
          }
        rotate z*X1*clock*360
        translate <X1,-200+Y1,Z1>
        }
      #declare C1 = C1 + 1
      #end  // end while loop


  #break  //  end Shot 8

  #case (9) //--------------- Shot 9 ------------------------------

  // Frames 531 - 620 (3.0 sec.), clock from 0 to 1
  // start with black screen, open to player with balls in mouth.
  // Player weaves, eyes rolling, arms pinwheeling, and falls.
  // Screen closes down to black.

    camera {
      location  <104, 60, 90>
      angle 40
      look_at   <60, 55, 30>
      }

    #declare K = 2*pi*clock
    #declare X1 = sin(K)  // rotation
    #declare Y1 = cos(K)  // functions
    #declare X2 = sin(2*K)
    #declare Y2 = cos(2*K)
    #declare X3 = sin(3*K)
    #declare Y3 = cos(3*K)
    #declare F = clock*2 - 1 // fall
    #if (F<0)
      #declare F = 0
      #end
    #declare F1 = F*F
    #declare B = sin(clock*pi*1.1)  // black fade
    #if (B<0)
      #declare B = 0
      #end

    #declare Headalt = 1
    #declare Uplid = 0.95  //0.55, up to 0.95
    #declare Lowlid = 0.05  //0.25, down to 0.05
    #declare Dilate = 0.2   // 0.3
    #declare Eyerot = <20*X3,20*Y3,0>    // 0 = straight
    #declare Headrot = <-10*X1,0,-10*Y1>
    #declare Headfwd = 10
    #declare Brow = 0.75  // 0 to 1 for rise
    #declare Bodyrot = <-70*F1,30+60*F1,0>
    #declare Bodytrans = <58,-36*F1,30>

    #declare HandRrot = <-10,30,0>
    #declare FistR = 0.25  // 0=open, 1=closed
    #declare ArmRrot = <-70+X2*20,30+Y2*30,0>
    #declare ForearmRrot = <-20+X2*30,Y2*30,0>

    #declare HandLrot = <-20,-40,0>
    #declare FistL = 0.25  // 0=open, 1=closed
    #declare ArmLrot = <-80+X2*20,-50-Y2*30,0>
    #declare ForearmLrot = <-40+X2*30,-Y2*30,0>

    #declare LegRrot = <-10,60,0>
    #declare LegLrot = <-10,-60,0>
    #declare Hipsbend = <10*X1,0,10*Y1>

    #include "player.inc"
    object { Player }

    union {  // Stars
      #declare C1 = 0
      #while (C1<360)
        object { Star
          translate z*8
          rotate -y*(clock*540+C1)
          }
        #declare C1 = C1 + 40
        #end  // while
      texture {
        pigment { color rgb <1,1,0>}
        finish { ambient 1 }
        }
      translate y*10  // position with head
      rotate Headrot
      rotate (x*-Headfwd)
      rotate -Hipsbend
      translate <0,11,1>
      rotate x*Headfwd  // position with neck
      translate <0,11,0>
      rotate Hipsbend   // position with body
      translate y*36
      rotate Bodyrot
      translate Bodytrans
      }  // end Stars

    plane {z,0
      texture {
        pigment { wood
          color_map {
            [(B*0.5) color rgbt <0,0,0,1>]
            [(B*0.55) color rgbt 0]
            }
          scale 60
          }
        }
      translate -z*8
      rotate <-3.8,36.3,0>
      translate <104,60,90>
      }


  #break  //  end Shot 9

  #end
