#include "colors.inc"

  #declare LandArea = texture {
      pigment {
        agate
        turbulence 1
        lambda 1.5
        omega.8
        octaves 8
        color_map {
          [0.00 color rgb <.5,.25,.15>]
          [0.33 color rgb <.1,.5,.4>]
          [0.86 color rgb <.6,.3,.1>]
          [1.00 color rgb <.5,.25,.15>]
        }
      }
    }

  #declare OceanArea = texture {
    pigment {
      bozo
        turbulence.5
        lambda 2
        color_map {
          [0.00, 0.33 color rgb <0, 0, 1>
                      color rgb <0, 0, 1>]
          [0.33, 0.66 color rgbf <1, 1, 1, 1>
                      color rgbf <1, 1, 1, 1>]
          [0.66, 1.00 color rgb <0, 0, 1>
                      color rgb <0, 0, 1>]
        }
      }
    }

  #declare Clouds1 = pigment {
      bozo
      turbulence 1
      color_map {
        [0.0 color White filter 1]
        [0.5 color White]
        [1.0 color White filter 1]
      }
    }
  #declare Clouds2 = pigment {
    agate
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
      }
    }

  #declare Clouds3 = pigment {
    marble
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
    }
  }
  #declare Clouds4 = pigment {
    granite
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
    }
  }

  #declare CloudArea = texture {
    pigment {
      gradient y
      pigment_map {
        [0.00 Clouds1]
        [0.25 Clouds2]
        [0.50 Clouds3]
        [0.75 Clouds4]
        [1.00 Clouds1]
      }
    }
  }

//camera { location <0.167203, 0.275097, -.00005> look_at <0.167203, 0.275097, 0> }
camera { location <0.167203, 0.275097, -1.65 -.0001 + 1.65*(cos(clock*pi + pi) + 1)/2>
	look_at <0.167203, 0.275097, 0> }

light_source { <-100, 100, -100> color White }

/*
0.167203
0.275097
*/
background { color White*0.05 }

#declare UnitSide = 1
#declare LongSide = UnitSide/2 + sqrt((UnitSide/2)*(UnitSide/2) + UnitSide*UnitSide)
#declare OddBit = LongSide - UnitSide
#declare Angle = 1080

#declare MasterLoop = 0
#while (MasterLoop < Angle)   // 360 - 720 - 1080
	#declare RotLoop = 0
	#declare StartPoint = <-UnitSide, 0, 0>

	#declare Point = vaxis_rotate(StartPoint, z*-1, mod(MasterLoop, 90))
		#declare InnerLoop = 0
		#while ( InnerLoop < int(MasterLoop/90) )
			#declare Temp = Point.x
			#declare Temp = Temp - OddBit
			#declare Point = <Temp*(OddBit/UnitSide),
					Point.y*(OddBit/UnitSide),
					Point.z*(OddBit/UnitSide)>
			#declare Point = vaxis_rotate(Point, z*-1, 90)
		#declare InnerLoop = InnerLoop + 1
		#end
/*
	#debug concat( str(Point.x, 0, 6), "\n")
	#debug concat( str(Point.y, 0, 6), "\n")
*/

	sphere { 0, 0.01*(1 - MasterLoop/Angle)
	    texture { LandArea scale 0.01*(1-MasterLoop/Angle)}
	    texture { OceanArea scale 0.01*(1-MasterLoop/Angle)}
	    texture { CloudArea scale 0.01*(1-MasterLoop/Angle)}
	    finish { ambient 0.8 }
	    translate Point
		}

#declare MasterLoop = MasterLoop + 5
#end
