#include "colors.inc"

camera { location <0, 0, -3> look_at 0 }

light_source { <-100, 100, -100> color White }

background { color White*0.05 }

#declare UnitSide = 1
#declare LongSide = UnitSide/2 + sqrt((UnitSide/2)*(UnitSide/2) + UnitSide*UnitSide)
#declare OddBit = LongSide - UnitSide

#declare Clock1 = 0

#declare Square = union {
cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2 + UnitSide, UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 
cylinder { <-LongSide/2, -UnitSide/2, 0>, <-LongSide/2 + UnitSide, -UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 
cylinder { <-LongSide/2 + UnitSide, UnitSide/2, 0>, <-LongSide/2 + UnitSide, -UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 
cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2, -UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 


#if (clock > 0.15)
cylinder { <-LongSide/2 + UnitSide/2, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Green transmit 0.8*Clock1 } finish { ambient 0.5 } } }
#end

#if (clock > 0.3)
cylinder { <-LongSide/2 + UnitSide, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.65 } } }
#end

#if (clock > 0.6)
cylinder { <LongSide/2, -UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.011
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.65 } } }
#end

#if (clock > 0.45)
#declare Clock4 = min((clock - 0.45)/.15, 1)
#declare Loop3 = 30
#while (Loop3 < 30 + 60*Clock4)
sphere { y*sqrt(1.25), 0.011 rotate -z*Loop3
		translate <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.5 } } }
#declare Loop3 = Loop3 + 5
#end
#end

#if (clock > 0.75)
cylinder { <LongSide/2, -UnitSide/2, 0>, <-LongSide/2 + UnitSide, -UnitSide/2, 0>, 0.012
	texture { pigment { color White transmit 0.8*Clock1 } finish { ambient 0.5 } } }
#end

        translate x*((OddBit)/2 - UnitSide/2)
        translate y*(UnitSide/2)
}

#declare BBox = union
{
cylinder { <-LongSide/2, UnitSide/2, 0>, <LongSide/2, UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2, -UnitSide/2, 0>, <LongSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <LongSide/2, UnitSide/2, 0>, <LongSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2, -UnitSide/2, 0>, 0.01
	translate x*UnitSide
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2 + UnitSide/2, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Green transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2 + UnitSide, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.65 } } }

	translate x*((OddBit)/2 - UnitSide/2)
	translate y*(UnitSide/2)
}

#declare Spiral = union
{
	#declare Loop = 0
	#while (Loop < 30)
		sphere { 0, 0.033 - 0.0190983/3*(Loop/30)
		    translate x*(-UnitSide) rotate z*-(3*Loop)
			texture { pigment { color rgb <0.4, 0.4, 1> }
				  finish { ambient 0.65 } }
			}
	#declare Loop = Loop + 1
	#end
}

//object { BBox translate y*-(1 - OddBit/UnitSide) translate x*-0.75}
object { Square translate y*-(1 - OddBit/UnitSide) translate x*-0.75}

/*
union {
	object { Spiral }
	#declare S2 = object { Spiral translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	object { S2 }
	#declare S3 = object { S2 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	object { S3 }
	#declare S4 = object { S3 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	object { S4 }
	object { S4 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	#declare S5 = object { S4 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	object { S5 }
	object { S5 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	#declare S6 = object { S5 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	object { S6 }
	object { S6 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }

translate y*-(1 - OddBit/UnitSide) translate x*-0.75
}
*/

#if(clock > 0.75)
union {
text { ttf "crystal.ttf", "1" 0.1, 0
	translate <1 + 2, 0.75, 0>
	pigment { color Green }
	finish { ambient 0.6 }
	}

box { <1, 0.3, 0>, <5, 0.45, 0.1>
	pigment { color Red } finish { ambient 0.6 }
	}

text { ttf "crystal.ttf", str(OddBit, 1, -1) 0.1, 0
	translate <1, -0.5, 0>
	pigment { color White }
	finish { ambient 0.6 }
}

text { ttf "crystal.ttf", "= O" 0.1, 0
	rotate y*25
	translate <6, 0, 0>
	pigment { color rgb <0.4, 0.4, 1> }
	finish { ambient 0.65 }
	}

text { ttf "crystal.ttf", "  |" 0.1, 0
	scale <1, 1.3, 1>
	translate y*-0.1
	rotate y*25
	translate <5.95, 0, 0>
	pigment { color rgb <0.4, 0.4, 1> }
	finish { ambient 0.65 }
	}

scale 0.25
translate x*-0.1
}
#end
