#include "colors.inc" 

camera { location <0, 10, 0> look_at 0 }

light_source { <-100, 100, -100> color White }

background { color White*0.25 }

#declare Tex = texture { pigment { color Red } finish { ambient 0.6 } }
#declare Tex1 = texture { pigment { color Blue } finish { ambient 0.6 } }
#declare Tex2 = texture { pigment { color Green } finish { ambient 0.6 } }

#declare NumNodes = 11
#declare MinorRadius = 1
#declare MagicRadius = 1/sin(pi*2*MinorRadius/(NumNodes*2))
#declare MajorRadius = MagicRadius - MinorRadius

#declare Spin = clock*180

#declare Level0 = union
{
	cylinder { y*-0.1, y*0.1, MajorRadius texture { Tex1 }}

	#declare Loop = 0
	#while(Loop < NumNodes)
		cylinder { y*-0.1, y*0.1, MinorRadius
			texture { Tex }
			rotate y*Spin
			translate x*MagicRadius
			rotate y*((360/NumNodes)*Loop)
		}
		#declare Loop = Loop + 1
	#end

	rotate y*Spin
}

#declare Level1 = union
{
	#declare Scale = (MajorRadius / (MagicRadius + 1))
	#declare Scale1 = 1/(MagicRadius + 1)
        object { Level0 scale <Scale, 1, Scale>
		}

        #declare Loop = 0
        #while(Loop < NumNodes)
		object { Level0 scale <Scale1, 1, Scale1>
			rotate y*-(Spin*MagicRadius)
                        translate x*MagicRadius
                        rotate y*((360/NumNodes)*Loop + Spin/MagicRadius)
                        texture { Tex1 }
                }
                #declare Loop = Loop + 1
        #end
	texture { Tex1 }
}

#declare Level2 = union
{
        #declare Scale = (MajorRadius / (MagicRadius + 1))
        #declare Scale1 = 1/(MagicRadius + 1)
        object { Level0 scale <Scale, 1, Scale>
                texture { Tex2 }
                }

        #declare Loop = 0
        #while(Loop < NumNodes)
                object { Level1 scale <Scale1, 1, Scale1>
			rotate y*-(Spin*2*MagicRadius)
                        translate x*MagicRadius
                        rotate y*((360/NumNodes)*Loop)
                        texture { Tex2 }
                }
                #declare Loop = Loop + 1
        #end
	rotate y*Spin
}

object { Level2 }
