// Empty *******************************************************
                                                             //*
                                                             //*
//                                                             *

//                                                             *
                                                             //*
                                                             //*
// *************************************************** Empty ***

#version 3.1;

// Programmparameter
#declare dim=10;             
#declare initprob=.5;         
#declare createmin=3;
#declare createmax=3;
#declare livemin=2;
#declare livemax=3;
#declare dateistring="conway.dat"
#declare conwayframes=5;
#declare bloboff=.3;
#declare copy=" 1999 Ulf Schreiber"

// Switches
//#declare debug_output=1;

// Globals
#declare world=array [dim][dim]
#declare newworld=array [dim][dim]

// Multiple Use
#declare backf=0;
#declare backv=<0,0,0>;

// Uhr *********************************************************
                                                             //*
                                                             //*
//                                                             *

#macro uhr()
	#declare frame=clock/clock_delta;
	#declare fase=frame/conwayframes;
	#declare fase=fase-floor(fase);
	#declare fase_delta=1/conwayframes;                   
	#declare runde=floor(frame/conwayframes)+1;
	#declare frameseed=seed(runde);
#end

//                                                             *
                                                             //*
                                                             //*
// ***************************************************** Uhr ***


// Conway macros ***********************************************
                                                             //*
                                                             //*
//                                                             *

#macro initializearray (ia_rand)                           
	#local ia_seed=seed(ia_rand);                              
	#local ia_xi=0;                                           
	#while (ia_xi<dim)                                          
		#local ia_yi=0; 
		#while (ia_yi<dim)                                       
			#if (rand(ia_seed)<initprob)                        
				#declare newworld[ia_xi][ia_yi]=1;                  
			#else 	                                           
				#declare newworld[ia_xi][ia_yi]=0;                  
			#end	                                              
		 #local ia_yi=ia_yi+1;                                 
		#end
	 #local ia_xi=ia_xi+1; 
	#end
#end                                              
                                    
#macro getpoint(gp_arr,gp_x,gp_y)
	#if (gp_x=-1)		#local gp_x=dim-1;	#end
	#if (gp_x=dim)		#local gp_x=0;			#end	
	#if (gp_y=-1)		#local gp_y=dim-1;	#end
	#if (gp_y=dim)		#local gp_y=0;			#end	
	#declare backf=gp_arr[gp_x][gp_y];
#end
                                                                
#macro conway()
	#local cw_xi=0;                                           
	#while (cw_xi<dim)                                          
		#local cw_yi=0; 
		#while (cw_yi<dim)            
			#local cw_neighbours=0;
			getpoint(world,cw_yi-1	,cw_xi-1	)
			#local cw_neighbours=cw_neighbours+backf;
			getpoint(world,cw_yi		,cw_xi-1	)
			#local cw_neighbours=cw_neighbours+backf;
			getpoint(world,cw_yi+1	,cw_xi-1	)
			#local cw_neighbours=cw_neighbours+backf;
			getpoint(world,cw_yi-1	,cw_xi	)
			#local cw_neighbours=cw_neighbours+backf;
			getpoint(world,cw_yi+1	,cw_xi	)
			#local cw_neighbours=cw_neighbours+backf;
			getpoint(world,cw_yi-1	,cw_xi+1	)
			#local cw_neighbours=cw_neighbours+backf;
			getpoint(world,cw_yi		,cw_xi+1	)
			#local cw_neighbours=cw_neighbours+backf;
			getpoint(world,cw_yi+1	,cw_xi+1	)
			#local cw_neighbours=cw_neighbours+backf;
			
			getpoint(world,cw_yi,cw_xi)
			#if (backf>0)
				//dead                                 
				#declare newworld[cw_yi][cw_xi]=0;				
				#if (cw_neighbours<=createmax)
					#if (cw_neighbours>=createmin)
						#declare newworld[cw_yi][cw_xi]=1;
					#end
				#end
			#else    
				//alive                                
				#declare newworld[cw_yi][cw_xi]=1;				
				#if (cw_neighbours<livemin)
					#declare newworld[cw_yi][cw_xi]=0;					
				#end
				#if (cw_neighbours>livemax)
					#declare newworld[cw_yi][cw_xi]=0;					
				#end
			#end
		 #local cw_yi=cw_yi+1;                                 
		#end
	 #local cw_xi=cw_xi+1; 
	#end
#end             

#macro conwayuhr()
	conway()
	#if (fase=0)	
		#declare world=newworld
		schreib()
		conway()
	#end
	#local ia_xi=0;                                           
	#while (ia_xi<dim)                                          
		#local ia_yi=0; 
		#while (ia_yi<dim)                                       
			#if (world[ia_xi][ia_yi]<newworld[ia_xi][ia_yi]) 
				#declare newworld[ia_xi][ia_yi]=-((world[ia_xi][ia_yi]*(1-fase))+(newworld[ia_xi][ia_yi]*fase));
			#else
				#declare newworld[ia_xi][ia_yi]=(world[ia_xi][ia_yi]*(1-fase))+(newworld[ia_xi][ia_yi]*fase);
			#end
		 #local ia_yi=ia_yi+1;                                 
		#end
	 #local ia_xi=ia_xi+1; 
	#end  
	#if (fase+fase_delta=1)
		schreib()
	#end
#end

//                                                             *
                                                             //*
                                                             //*
// ******************************************* Conway macros ***

// Schreib *****************************************************
                                                             //*
                                                             //*
//                                                             *

#macro schreib()
	#fopen datei dateistring write 
	#debug "\n"
	#local o_ix=dim;
	#while (o_ix>0)
	 #local o_ix=o_ix-1;
		#local o_iy=dim;
		#while (o_iy>0)
		 #local o_iy=o_iy-1;
			#if (world[o_ix][o_iy]=1) 
				#write (datei, 1 )
			#else 
				#write (datei, 0 )
			#end   
			#write (datei,",")
		#end
	#end
	#fclose datei
	#debug "Datei \""
	#debug dateistring
	#debug "\" geschrieben.\n"
#end                                                      

//                                                             *
                                                             //*
                                                             //*
// ************************************************* Schreib ***

// Lese ********************************************************
                                                             //*
                                                             //*
//                                                             *

#macro lese()
	#fopen datei dateistring read 
	#debug "\n"
	#local o_ix=dim;
	#while (o_ix>0)
	 #local o_ix=o_ix-1;
		#local o_iy=dim;
		#while (o_iy>0)
		 #local o_iy=o_iy-1;
			#read (datei, puffer)
			#declare world[o_ix][o_iy]=puffer;
		#end
	#end
	#fclose datei
	#debug "Datei \""
	#debug dateistring
	#debug "\" gelesen.\n"
#end                                                      

//                                                             *
                                                             //*
                                                             //*
// *************************************************** Lese ****


// Output ******************************************************
                                                             //*
                                                             //*
//                                                             *

#macro output()
	#ifdef (debug_output)
		#debug "\n\n"
		#local o_ix=dim;
		#while (o_ix>0)
		 #local o_ix=o_ix-1;
			#local o_iy=dim;
			#while (o_iy>0)
			 #local o_iy=o_iy-1;
				#if (world[o_ix][o_iy]=1) 
					#debug "X" 
				#else 
					#debug " " 
				#end
			#end
			#debug "\n"
		#end
	#end
#end                                                      
                                                      
//                                                             *
                                                             //*
                                                             //*
// ************************************************** Output ***

// Zeitlisten **************************************************
                                                             //*
                                                             //*
//                                                             *

#macro zeitraum(_1,_2,_3,_4)
	#declare backf=0;
	#if (clock>_1) 
	 	#if (clock <_4)
	 		#if (clock<_2)
	 			#declare backf=(clock-_1)/(_2-_1);
	 		#else
		 		#if (clock<_3)
					#declare backf=1;		 		
				#else
		 			#declare backf=(_4-clock)/(_4-_3);
				#end 			
	 		#end
		#end	
	#end	   
	#if (backf>0)
		#if (backf<1)
			#declare backf=((cos(pi*(1-backf))+1)*.5);
		#end
	#end
#end

#macro _PRIMITIV(_1,_2,_3,_4)    
	#if (clock>=_1)
		#if (clock<=_4)
			zeitraum(_1,_2,_3,_4)
			#declare PRIMITIV=backf; 			
		#end
	#end		
#end   
                       
#macro _P2KREUZ(_1,_2,_3,_4)
	zeitraum(_1,_2,_3,_4)
	#declare P2KREUZ=backf;
#end                          

#macro _RLIGHT(_1,_2,_3,_4)
	zeitraum(_1,_2,_3,_4)
	#declare RLIGHT=backf;
#end                          

#macro _BLOBB(_1,_2,_3,_4)
	zeitraum(_1,_2,_3,_4)
	#declare BLOBB=backf;
#end                  
#macro _BLOBD(_1,_2,_3,_4)
	zeitraum(_1,_2,_3,_4)
	#declare BLOBD=backf;
#end                  
        

//                                                             *
                                                             //*
                                                             //*
// ********************************************** Zeitlisten ***

// Zeit ********************************************************
                                                             //*
                                                             //*
//                                                             *

#macro zeitplan()                         
	#declare PRIMITIV=0; 			

	_PRIMITIV(-1,0,.07,.3)
	_P2KREUZ(.12,.3,.41,.44)
	_PRIMITIV(.394,.435,.5,.55)
	_BLOBB (.5,.55,.85,.88)
	_BLOBD (.54,.79,.791,.863)
	_PRIMITIV(.82,.88,.92,1)
	_RLIGHT (.03,.19,.89,1)

	#debug "\n CLOCK = "
	#debug str(clock,3,3)
	#debug "\n rlight="
	#debug str(RLIGHT,3,3)
	#debug "\n primitiv="
	#debug str(PRIMITIV,3,3)
	#debug "\n p2kreuz="
	#debug str(P2KREUZ,3,3)
	#debug "\n blobb="
	#debug str(BLOBB,3,3)
	#debug "\n blobd="
	#debug str(BLOBD,3,3)
	#debug "\n"
#end                                                  
                                                  
//                                                             *
                                                             //*
                                                             //*
// **************************************************** Zeit ***

// Ding ********************************************************
                                                             //*
                                                             //*
//                                                             *

#macro ding(dx,dy)
	#if (blobflag=1)	//blobflag
		#if (BLOBB>0)
			#local dox=dx-(dim/2);
			#local doz=dy-(dim/2);
			#local doy=0;
			sphere {
				<dox,doy,doz>,2*.4*(BLOBD+BLOBD+1),
				strength (1+BLOBD)*a_val*((aktuell-bloboff)/abs(aktuell-bloboff))
				pigment {color rgbt <(1-aktuell)*(1-BLOBD)/*>*/+BLOBD*(aktuell-1),0+BLOBD*10*(aktuell-bloboff),aktuell*(1-BLOBD)/*>*/+BLOBD*(aktuell-1),1-BLOBB>}	
				finish {
					ambient 1-RLIGHT*.8 
					phong 1.2 phong_size 40
				}
				normal {
					granite .3*RLIGHT
					turbulence 0.5
				   lambda 1.5
					omega 0.75
	    			octaves 3
	    			scale 2
	    		}	
			}  
		#end	
	#else	//blobflag
		#if (PRIMITIV>0)
			#local dox=dx-(dim/2);
			#local doz=dy-(dim/2);
			#local doy=0;
			sphere {
				<dox,doy,doz>,.4*a_val
				pigment {color rgbt <(1-aktuell),0,aktuell,1-PRIMITIV>}	
				finish {
					ambient 1-RLIGHT*.8 
					phong 1.2 phong_size 40
				}
				normal {
					granite .3*RLIGHT
					turbulence 0.5
				   lambda 1.5
					omega 0.75
	    			octaves 3
	    			scale 2
	    		}	
			}  
		#end	      
		#if (P2KREUZ>0)
			#local dox=dx-(dim/2);
			#local doz=dy-(dim/2);
			#local doy=0;
			sphere {
				0,.2*(1-pow((1-a_val),3))
				scale <(1+2*pow(a_val,2)),1,1>
				pigment {color rgbt <(1-aktuell)*.3,(1-aktuell)*.7,aktuell,1-P2KREUZ>}	
				finish {
					ambient 1-RLIGHT*.8 
					phong 1.2 phong_size 40
				}
				normal {
					granite .3*RLIGHT
					turbulence 0.5
				   lambda 1.5
					omega 0.75
	    			octaves 3
	    			scale 2
		    		translate <dox,doy,doz>
	    		}	
	    		rotate y*45
	    		translate <dox,doy,doz>
			}  
			sphere {
				0,.2*(1-pow((1-a_val),3))//.8*(.5-abs(aktuell/2))
				scale <1,1,(1+2*pow(a_val,2))>
				pigment {color rgbt <(1-aktuell)*.3,(1-aktuell)*.7,aktuell,1-P2KREUZ>}	
				finish {
					ambient 1-RLIGHT*.8 
					phong 1.2 phong_size 40
				}
				normal {
					granite .3*RLIGHT
					turbulence 0.5
				   lambda 1.5
					omega 0.75
	    			octaves 3
	    			scale 2
		    		translate <dox,doy,doz>
	    		}	
	    		rotate y*45
	    		translate <dox,doy,doz>
			}  
		#end	
	#end 	//blobflag	
#end

//                                                             *
                                                             //*
                                                             //*
// **************************************************** Ding ***
// Keinding ****************************************************
                                                             //*
                                                             //*
//                                                             *

#macro keinding(dx,dy)
   #if (blobflag=1)
		#if (BLOBB>0)
			#local dox=dx-(dim/2);
			#local doz=dy-(dim/2);
			#local doy=0;
			sphere {
				<dox,doy,doz>,2*.4*(BLOBB+BLOBD+1),
				strength -(1+BLOBD)
				pigment {color rgbt <(1-aktuell)*(1-BLOBD)/*>*/+BLOBD*(aktuell-1),0+BLOBD*5*(aktuell-bloboff),aktuell*(1-BLOBD)/*>*/+BLOBD*(aktuell-1),1-BLOBB>}	
				finish {
					ambient 1-RLIGHT*.8 
					phong 1.2 phong_size 40
				}
				normal {
					granite .3*RLIGHT
					turbulence 0.5
				   lambda 1.5
					omega 0.75
   	 			octaves 3
   	 			scale 2
   	 		}	
			}  
		#end
	#end	


#end

//                                                             *
                                                             //*
                                                             //*
// ************************************************ Keinding ***

// Kamera ******************************************************
                                                             //*
                                                             //*
//  																				*
   
#macro zeichen(charnum,chrd)
	text{
		ttf "c:\windows\fonts\ocraext.ttf"
		substr(copy,charnum,1)
		.2,0 
		translate <-.2,0,-.1>
		rotate -y*fase*360*chrd
		translate <.7*charnum,0,0>
	}
#end           
#macro sig()                
   union {
		#local k_i=0;     
		#if (clock<.5)
			#local dch=runde-floor(runde/strlen(copy));
		#else	
			#local dch=runde-floor(runde/strlen(copy))*strlen(copy);
		#end
		#while (k_i<strlen(copy))
		 #local k_i=k_i+1;
		 	#if (k_i=dch) 		#local dcc=1;			#else 	#local dcc=0;		#end
		 	zeichen(k_i,dcc)
		#end   
		 
		pigment{rgbf <.4,.8,.2,.3>}
		finish{ambient .8}
		
		scale .02
		rotate x*90
		rotate 90*y
		translate <-.1,7+BLOBD*2,0>
		translate <-.163,-.35,.06>
		
	}
#end
#macro kamera()
	camera{location <-.1,7+BLOBD*2,0> look_at 0} 
	sig()
#end

//                                                             *
                                                             //*
                                                             //*
// ************************************************** Kamera ***

// Darstellung Dinger ******************************************
                                                             //*
                                                             //*
//  																				*

#macro darstellung_dinger()         
	#local blobflag=0;
#debug "  [Setze Elemente] \n"
	#local o_ix=dim;
	#while (o_ix>0)
	 #local o_ix=o_ix-1;
		#local o_iy=dim;
		#while (o_iy>0)
		 #local o_iy=o_iy-1;                      
			#declare aseed=seed(rand(frameseed));		 

			#if (world[o_ix][o_iy]=0)
#debug "[ ]"
				#declare aktuell=0;
				keinding(o_ix,o_iy)
			#else	
#debug "[x]"                                     
				#if (world[o_ix][o_iy]=1)  //lebend
					#declare aktuell= .5;
					#declare a_val=1;
				#else
					#if (world[o_ix][o_iy]<0) 	//wachsend
						#declare aktuell= -world[o_ix][o_iy]/2;
						#declare a_val=1-abs(2*(aktuell-.5));
					#else								//sterbend
						#declare aktuell= 1-world[o_ix][o_iy]/2;
						#declare a_val=1-(2*(aktuell-.5));
					#end 
				#end
				ding(o_ix,o_iy) 
         #end
		#end                   
		#debug "\n"
	#end
#end

//                                                             *
                                                             //*
                                                             //*
// ************************************** Darstellung Dinger ***
// Darstellung BlobDinger **************************************
                                                             //*
                                                             //*
//  																				*

#macro darstellung_blobdinger()         
blob{ 			                                           
	
	#local blobflag=1;                                         
	
	#local o_ix=dim;
	#while (o_ix>0)
	 #local o_ix=o_ix-1;
		#local o_iy=dim;
		#while (o_iy>0)
		 #local o_iy=o_iy-1;                      
			#if (world[o_ix][o_iy]=0)
				#declare aktuell=0;
				keinding(o_ix,o_iy)
			#else	
				#if (world[o_ix][o_iy]=1)  //lebend
					#declare aktuell= .5;
					#declare a_val=1;
				#else
					#if (world[o_ix][o_iy]<0) 	//wachsend
						#declare aktuell= -world[o_ix][o_iy]/2;
						#declare a_val=1-abs(2*(aktuell-.5));
					#else								//sterbend
						#declare aktuell= 1-world[o_ix][o_iy]/2;
						#declare a_val=1-(2*(aktuell-.5));
					#end 
				#end
				ding(o_ix,o_iy) 
         #end
		#end                   
	#end
	#debug "Blob setzte \n"
threshold .5 } 				
		
	
#end

//                                                             *
                                                             //*
                                                             //*
// ********************************** Darstellung BlobDinger ***

// Darstellung *************************************************
                                                             //*
                                                             //*
//  																				*

#macro darstellung ()
	union {
		plane {y,.01
			pigment {color rgb <.7,.6,.8>}
			finish {ambient .2 * RLIGHT}
		}                               
		darstellung_dinger()
		#if (BLOBB>0) darstellung_blobdinger ()				#end
	
		light_source {<10,10,-10>,rgb RLIGHT* 1 rotate y*100*clock}

		rotate y*360*clock    
		rotate x* 10 * sin(clock * 8.4* RLIGHT)
		rotate -z * 60 * ((cos(pi*(1-clock))+1)*.5)* RLIGHT
	}                             
#end

//                                                             *
                                                             //*
                                                             //*
// ********************************************* Darstellung ***
        
// Main ********************************************************
                                                             //*
                                                             //*
//                                                             *
         
//Clock                                               
uhr()         
//Conway 
#if (clock=0)
	initializearray(42)
	#declare world=newworld
	schreib()
#end
lese()
conwayuhr()  
#declare world=newworld
output() 
             
//Drehbuch
zeitplan()
             
//Darstellung
kamera()
darstellung()

//                                                             *
                                                             //*
                                                             //*
// **************************************************** Main ***


/*
The Rules:

The Game of Life was invented by John Conway (as you might have gathered). The game is played on a field of cells, each of which has eight neighbors (adjacent cells). A cell is either occupied (by an organism) or not. The rules for deriving a generation from the
previous one are these: 
 Death
        If an occupied cell has 0, 1, 4, 5, 6, 7, or 8 occupied neighbors, the organism dies
        (0, 1 neighbors: of loneliness; 4 thru 8: of overcrowding).
 Survival
        If an occupied cell has two or three neighbors, the organism survives to the next generation.
 Birth
        If an unoccupied cell has three occupied neighbors, it becomes occupied. 
*/        /* quoted from some url I seem to have forgotten, sorry. */