
#declare groutDepth = .05;

//create the walls for the hallway
//Note: The bricks are actually only 2 dimensional since it is a surface texture being used.
//      Fortunately, a shallow grout and shadows hide this problem.
difference{
  box { < 0,0, 0> <25,10,82.5> } //<90,40,70> }
  union {
    box { <7.4, 0, 37.5> <25.1  , 8, 40> }
    box { <5  , 0, 10>   <7.5 , 8, 40> }
  }
  texture {EJG_HallWall scale 5}
}
//create the grout used between the bricks
difference{
  box { < 0,-10, 0> <24.99,7,82.5> } //<90,40,70> }
  union {
    box { <5-groutDepth, 0-groutDepth, 10-groutDepth>     <7.5+groutDepth , 8+groutDepth, 40+groutDepth> }
    box { <5+groutDepth, 0-groutDepth, 37.5-groutDepth> <25.1  , 8+groutDepth, 40+groutDepth> }
  }
  texture { Rust scale .05}  
}

//create stuff on the floor of the hallway
box { <7.4, 0.001, 37.5> <25  , -.2, 40.1> 
  texture {EJG_HallFloor scale 5 }
  
}

//create ceiling in the hallway
box { <0, 7.9, 0> <24.8  , 8.5, 45> 
  texture {EJG_HallCeiling scale 5 }
  
}

//create columns at doorway with grate
cylinder { <25,-.1,40> <25,8.1,40> .2 texture {T_Stone6 finish {reflection .1 phong .2 }} }
cylinder { <25,-.1,37.5> <25,8.1,37.5> .2 texture {T_Stone6 finish {reflection .1 phong .2 }} }
cylinder { <25,8,40> <25,8,37.5> .2 texture {T_Stone6 finish {reflection .1 phong .2 }} }
        
#if(moveGate=1)        
  #if (clock2<.3) //only create if visible
  object {IronGate
      //texture {T_Chrome_1A finish {reflection .1 phong .2 }} translate -26.5*clock2*y
      texture {T_Chrome_1A } translate <25,-26.5*clock2,37>
    }
  #end
#else
  object {IronGate texture {T_Chrome_1A } translate <25,0,37> }
#end


//create chamber
difference{
  box { < 25,-20, 0> <80,35,77.5> } 
  union {
    box { <7.5, 0, 37.5> <25  , 8, 40> }
    box { <25 , 0,  7.5> <77.5,30, 70> } 
    //cylinder { <55 , 0.1, 37.5> <55 ,-10, 37.5> 5} 
  } 
  texture {T_Stone33 scale 5} //14
}

