#include "rusty_l.inc"

#macro SeeBit(Field,Bit)
  #local tF=floor(Field/Bit);
  (tF-2*floor(tF/2))
#end

#local PR=5.625*sqrt(2+sqrt(3));
#local WR=2.8125*(2+sqrt(3));
#local TH=.3125;
#local LE=3.125;
#local WI=6.25;

#local ER= 3.75;
#local BB=27.5+ER;
#local BT=90-ER;
#local RB=21.25;
#local RT=15;

#local OT=sqrt( (RT-RB)*(RT-RB) + (BT-BB)*(BT-BB) );
#local OU=(BT-BB)/OT*ER;
#local OV=(RB-RT)/OT*ER;

union {//The Robot

union { //robot body
  torus { RB,ER translate y*BB }
  torus { RT,ER translate y*BT }
  difference {
    cylinder { y*BT,y*(BT+ER),RT }
    cylinder { <0,85,11.25>,<0,91,11.25>,3.5 }
  }
  difference {
    torus { 3.5,.625 }
    cylinder { -y,y,3.5 }
    translate <0,90,11.25> }
  cylinder { y*(BB-ER),y*BB,RB }
  cone {y*(BB+OV),RB+OU,y*(BT+OV),RT+OU }

  cone {<-6.25,60.0,16.25>,2.5,<-6.25,60,23.75>,1.25 }
  cone {< 6.25,60.0,16.25>,2.5,< 6.25,60,23.75>,1.25 }
  cone {<-6.25,75.0,16.25>,2.5,<-6.25,75,23.75>,1.25 }
  cone {< 6.25,75.0,16.25>,2.5,< 6.25,75,23.75>,1.25 }

  box { -1,1 matrix <6.25,0,0, 0,.625,0, 0,-.625,3.75,    0, 76.25,20> }
  box { -1,1 matrix <6.25,0,0, 0,.625,0, 0, .625,3.75,    0, 58.75,20> }
  box { -1,1 matrix <.625,0,0, 0, 7.5,0, -.625,0,3.75,  7.5, 67.50,20> }
  box { -1,1 matrix <.625,0,0, 0, 7.5,0,  .625,0,3.75, -7.5, 67.50,20> }

  difference {
    cylinder{ <0,82.5,-16>,<0,82.5,-20>,3.75 }
    cylinder{ <0,82.5,-15>,<0,82.5,-21>,3.25 } }
  difference {
    cylinder{ <0,82.5,-16>,<0,82.5,-20>,3.75 }
    cylinder{ <0,82.5,-15>,<0,82.5,-21>,3.25 } rotate y*120 }
  difference {
    cylinder{ <0,82.5,-16>,<0,82.5,-20>,3.75 }
    cylinder{ <0,82.5,-15>,<0,82.5,-21>,3.25 } rotate y*240 }

  torus { 3.5,.25 matrix <1,0,0, 0,0,1, 0,1,0, 0,82.5,-20> }
  torus { 3.5,.25 matrix <1,0,0, 0,0,1, 0,1,0, 0,82.5,-20> rotate y*120 }
  torus { 3.5,.25 matrix <1,0,0, 0,0,1, 0,1,0, 0,82.5,-20> rotate y*240 }

  texture { RustyGold }
}

intersection {
  plane { z, 24.25
    texture {
      pigment { rgbft <.5,.5,.5,1,0> }
      finish { reflection .15 ambient .1 diffuse .1 } } }
  plane {-z,-23.76
    texture {
      pigment { rgbft <.5,.5,.5,1,0> }
      finish { ambient .1 diffuse .1 } } }
  merge {
    RoundedBar(<-7.25,23.75,59>,<7.25,24.26,76>,1)
    matrix <1,0,0, 0,0,1, 0,1,0, 0,0,0>
    texture {
      pigment { rgbft <.5,.5,.5,1,0> }
      finish { ambient .1 diffuse .1 } } }
  bounded_by { box { <-7.25,59,23.76>,<7.25,76,24.25> } }
}

union {
  intersection {
    sphere { 0,1 }
    plane { -z,-.6 }
    box { <-1.1,-.1,.75>,<1.1,.1,1.1> rotate z*40 inverse }
    bounded_by { sphere { 0,1 } }
    translate <-6.25,60,23.65> }
  intersection {
    sphere { 0,1 }
    plane { -z,-.6 }
    box { <-1.1,-.1,.75>,<1.1,.1,1.1> rotate z*85 inverse }
    bounded_by { sphere { 0,1 } }
    translate <-6.25,75,23.65> }
  intersection {
    sphere { 0,1 }
    plane { -z,-.6 }
    box { <-1.1,-.1,.75>,<1.1,.1,1.1> rotate z*130 inverse }
    bounded_by { sphere { 0,1 } }
    translate < 6.25,60,23.65> }
  intersection {
    sphere { 0,1 }
    plane { -z,-.6 }
    box { <-1.1,-.1,.75>,<1.1,.1,1.1> rotate z*175 inverse }
    bounded_by { sphere { 0,1 } }
    translate < 6.25,75,23.65> }

  cylinder { <-6.25,60,23.5>,<-6.25,60,24.25>,.6 }
  cylinder { <-6.25,75,23.5>,<-6.25,75,24.25>,.6 }
  cylinder { < 6.25,60,23.5>,< 6.25,60,24.25>,.6 }
  cylinder { < 6.25,75,23.5>,< 6.25,75,24.25>,.6 }

  texture { pigment { rgb 1 }
    finish { diffuse .15 ambient .1 specular 1 roughness .01 } }
}    

box { <-6.25,60,22.725>,<6.25,75,22.75> pigment { rgb 0 } }

#declare LED=sphere { 0,1 hollow
  texture { pigment { rgbt 1 } }
  interior { media { emission rgb <10,0,0> density { spherical } } }
  scale .625 }

#if (SeeBit(LEDRow0,16)) object { LED translate < 2.50, 71.25,23.125> } #end
#if (SeeBit(LEDRow0, 8)) object { LED translate < 1.25, 71.25,23.125> } #end
#if (SeeBit(LEDRow0, 4)) object { LED translate <    0, 71.25,23.125> } #end
#if (SeeBit(LEDRow0, 2)) object { LED translate <-1.25, 71.25,23.125> } #end
#if (SeeBit(LEDRow0, 1)) object { LED translate <-2.50, 71.25,23.125> } #end

#if (SeeBit(LEDRow1,16)) object { LED translate < 2.50, 70.00,23.125> } #end
#if (SeeBit(LEDRow1, 8)) object { LED translate < 1.25, 70.00,23.125> } #end
#if (SeeBit(LEDRow1, 4)) object { LED translate <    0, 70.00,23.125> } #end
#if (SeeBit(LEDRow1, 2)) object { LED translate <-1.25, 70.00,23.125> } #end
#if (SeeBit(LEDRow1, 1)) object { LED translate <-2.50, 70.00,23.125> } #end

#if (SeeBit(LEDRow2,16)) object { LED translate < 2.50, 68.75,23.125> } #end
#if (SeeBit(LEDRow2, 8)) object { LED translate < 1.25, 68.75,23.125> } #end
#if (SeeBit(LEDRow2, 4)) object { LED translate <    0, 68.75,23.125> } #end
#if (SeeBit(LEDRow2, 2)) object { LED translate <-1.25, 68.75,23.125> } #end
#if (SeeBit(LEDRow2, 1)) object { LED translate <-2.50, 68.75,23.125> } #end

#if (SeeBit(LEDRow3,16)) object { LED translate < 2.50, 67.50,23.125> } #end
#if (SeeBit(LEDRow3, 8)) object { LED translate < 1.25, 67.50,23.125> } #end
#if (SeeBit(LEDRow3, 4)) object { LED translate <    0, 67.50,23.125> } #end
#if (SeeBit(LEDRow3, 2)) object { LED translate <-1.25, 67.50,23.125> } #end
#if (SeeBit(LEDRow3, 1)) object { LED translate <-2.50, 67.50,23.125> } #end

#if (SeeBit(LEDRow4,16)) object { LED translate < 2.50, 66.25,23.125> } #end
#if (SeeBit(LEDRow4, 8)) object { LED translate < 1.25, 66.25,23.125> } #end
#if (SeeBit(LEDRow4, 4)) object { LED translate <    0, 66.25,23.125> } #end
#if (SeeBit(LEDRow4, 2)) object { LED translate <-1.25, 66.25,23.125> } #end
#if (SeeBit(LEDRow4, 1)) object { LED translate <-2.50, 66.25,23.125> } #end

#if (SeeBit(LEDRow5,16)) object { LED translate < 2.50, 65.00,23.125> } #end
#if (SeeBit(LEDRow5, 8)) object { LED translate < 1.25, 65.00,23.125> } #end
#if (SeeBit(LEDRow5, 4)) object { LED translate <    0, 65.00,23.125> } #end
#if (SeeBit(LEDRow5, 2)) object { LED translate <-1.25, 65.00,23.125> } #end
#if (SeeBit(LEDRow5, 1)) object { LED translate <-2.50, 65.00,23.125> } #end

#if (SeeBit(LEDRow6,16)) object { LED translate < 2.50, 63.75,23.125> } #end
#if (SeeBit(LEDRow6, 8)) object { LED translate < 1.25, 63.75,23.125> } #end
#if (SeeBit(LEDRow6, 4)) object { LED translate <    0, 63.75,23.125> } #end
#if (SeeBit(LEDRow6, 2)) object { LED translate <-1.25, 63.75,23.125> } #end
#if (SeeBit(LEDRow6, 1)) object { LED translate <-2.50, 63.75,23.125> } #end

#include "tread.inc" // object { Piece } defined

#local Tread=0;
#while (Tread<56)

#local RL=RotLT+Tread*30;
#local TD=-22.5*x;
#if (Tread>27) #local RL=RotRT+(Tread-28)*30; #local TD=22.5*x; #end

#local RL=RL-840*floor(RL/840);

//figure out where front and back edges should be

#local EF=y*(PR+TH)+vrotate(y*PR,x*RL)+z*120*7.5/40;
#if (RL>180)
#local EF=y*TH-z*(RL-300)*7.5/40;
#end
#if (RL>420)
#local EF=y*(PR+TH)+vrotate(y*PR,x*(RL-240))-z*7.5*120/40;
#end
#if (RL>600)
#local EF=y*(PR+PR+TH)+z*7.5*(RL-720)/40;
#end

#local RT=RL-30;
#local RT=RT-840*floor(RT/840);

#local ET=y*(PR+TH)+vrotate(y*PR,x*RT)+z*7.5*(120)/40;
#if (RT>180)
#local ET=y*TH-z*7.5*(RT-300)/40;
#end
#if (RT>420)
#local ET=y*(PR+TH)+vrotate(y*PR,x*(RT-240))-z*7.5*(120)/40;
#end
#if (RT>600)
#local ET=y*(PR+PR+TH)+z*7.5*(RT-720)/40;
#end

#local VX=x;
#local VZ=vnormalize(EF-ET);
#local VY=vnormalize(vcross(VZ,VX));
#local VT=(ET+EF)/2+TD;

object { Piece
  texture { BangUp translate Tread }
  matrix <VX.x,VX.y,VX.z,VY.x,VY.y,VY.z,VZ.x,VZ.y,VZ.z,VT.x,VT.y,VT.z>
}

#local Tread=Tread+1;
#end

union {
  cylinder { < -18.75,PR+TH, 22.5>,<-26.25,PR+TH, 22.5>,1.25 }
  cylinder { <  18.75,PR+TH, 22.5>,< 26.25,PR+TH, 22.5>,1.25 }
  cylinder { < -18.75,PR+TH,-22.5>,<-26.25,PR+TH,-22.5>,1.25 }
  cylinder { <  18.75,PR+TH,-22.5>,< 26.25,PR+TH,-22.5>,1.25 }
  pigment { rgb 1 }
  finish { diffuse .5 specular 1 roughness .01 metallic on } }

#local A=1.875;
#local C=WR-TH-.5-A;
#local D=3.75;

#local qA=1;
#local qB=A*A + D*D - C*C;
#local qC=A*A*D*D;

#local qP=-qB/2/qA+sqrt(qB*qB-4*qA*qC)/2/qA;
#local qM=-qB/2/qA-sqrt(qB*qB-4*qA*qC)/2/qA;

#local B=sqrt(max(qP,qM));

#local tX=(B*B*C)/(A*A+B*B);

#local CutOut=merge {
  intersection {
    quadric { <0,1,-1>,<0,0,0>,<0,0,0>,D*D }
    box { <-1.26,-B,-tX>,<1.26,B,tX> }
    bounded_by { box { <-1.26,-B,-tX>,<1.26,B,tX> } }
  }
  cylinder { -x*1.26,x*1.26,1 scale <1,B,A> translate  z*C }
  cylinder { -x*1.26,x*1.26,1 scale <1,B,A> translate -z*C }
  scale <1,sqrt(1/3),1> }

#declare Wheel= intersection {
  box { <-1.26,TH-WR,TH-WR>,<1.26,WR-TH,WR-TH> rotate x*15 }
  box { <-1.25,TH-WR,TH-WR>,<1.25,WR-TH,WR-TH> rotate x*45 }
  box { <-1.26,TH-WR,TH-WR>,<1.26,WR-TH,WR-TH> rotate x*75 }
  #local I=15; #while (I<359)
    box { <-TH*2,WR-TH-1.25,-TH*2>,<TH*2,WR,TH*2> rotate x*I inverse }
  #local I=I+30; #end
  object { CutOut inverse }
  object { CutOut inverse rotate x*60 }
  object { CutOut inverse rotate x*120 }
  sphere { 0,1 scale <1.875,WR-TH-.5,WR-TH-.5> translate  x*1.25 inverse }
  bounded_by { cylinder { -x*1.26,x*1.26,WR+TH } }
}

object { Wheel pigment { rgb .75 } scale <-1,1,1>
  rotate x*RotLT translate <-26.25,PR+TH, 22.5> }
object { Wheel pigment { rgb .75 }
  rotate x*RotLT translate <-18.75,PR+TH, 22.5> }
object { Wheel pigment { rgb .75 } scale <-1,1,1>
  rotate x*RotLT translate <-26.25,PR+TH,-22.5> }
object { Wheel pigment { rgb .75 }
  rotate x*RotLT translate <-18.75,PR+TH,-22.5> }

object { Wheel pigment { rgb .75 }
  rotate x*RotRT translate < 26.25,PR+TH, 22.5> }
object { Wheel pigment { rgb .75 } scale <-1,1,1>
  rotate x*RotRT translate < 18.75,PR+TH, 22.5> }
object { Wheel pigment { rgb .75 }
  rotate x*RotRT translate < 26.25,PR+TH,-22.5> }
object { Wheel pigment { rgb .75 } scale <-1,1,1>
  rotate x*RotRT translate < 18.75,PR+TH,-22.5> }

//the undercarriage
union {
  union { RoundedBar(<-1.875,-20,-2.5>,  <1.875,20,2.5>,.625)
    matrix <1,0,0, 0,0,1, 0,1,0,  22.5,0,0> }
  union { RoundedBar(<-1.875,-20,-2.5>,  <1.875,20,2.5>,.625)
    matrix <1,0,0, 0,0,1, 0,1,0, -22.5,0,0> }
  union { RoundedBar(<-2.5,-21.25,-2.5>, <2.5,21.25,2.5>,.625)
    matrix <0,1,0, 1,0,0, 0,0,1, 0,0, 7.5> }
  union { RoundedBar(<-2.5,-21.25,-2.5>, <2.5,21.25,2.5>,.625)
    matrix <0,1,0, 1,0,0, 0,0,1, 0,0,-7.5> }

  union { RoundedBar(<-3.75,26.875-PR-TH,-3.75>,<3.75,27.5-PR-TH,3.75>,.625)
    translate <-13.125,0,-7.5> }
  union { RoundedBar(<-3.75,26.875-PR-TH,-3.75>,<3.75,27.5-PR-TH,3.75>,.625)
    translate < 13.125,0,-7.5> }
  union { RoundedBar(<-3.75,26.875-PR-TH,-3.75>,<3.75,27.5-PR-TH,3.75>,.625)
    translate <-13.125,0, 7.5> }
  union { RoundedBar(<-3.75,26.875-PR-TH,-3.75>,<3.75,27.5-PR-TH,3.75>,.625)
    translate < 13.125,0, 7.5> }

  union { RoundedBar(<-2.5,1.875,-2.5>,<2.5,27.375-PR-TH,2.5>,.625)
    translate <-13.125,0,-7.5> }
  union { RoundedBar(<-2.5,1.875,-2.5>,<2.5,27.375-PR-TH,2.5>,.625)
    translate < 13.125,0,-7.5> }
  union { RoundedBar(<-2.5,1.875,-2.5>,<2.5,27.375-PR-TH,2.5>,.625)
    translate <-13.125,0, 7.5> }
  union { RoundedBar(<-2.5,1.875,-2.5>,<2.5,27.375-PR-TH,2.5>,.625)
    translate < 13.125,0, 7.5> }

  lathe { 9,
    < 1.25 , 1.25>,< 1.875, 1.875>,<4.375, 1.875>,
    < 5, 1.25>,< 5,-1.25>,<4.375,-1.875>,
    < 1.875,-1.875>,< 1.25 ,-1.25>,< 1.25 , 1.25>
    matrix <0,1,0, 1,0,0, 0,0,1, -22.5,0,-22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1, -21.25,0,-22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1, -23.75,0,-22.5> }

  lathe { 9,
    < 1.25 , 1.25>,< 1.875, 1.875>,<4.375, 1.875>,
    < 5, 1.25>,< 5,-1.25>,<4.375,-1.875>,
    < 1.875,-1.875>,< 1.25 ,-1.25>,< 1.25 , 1.25>
    matrix <0,1,0, 1,0,0, 0,0,1,  22.5,0,-22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1,  21.25,0,-22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1,  23.75,0,-22.5> }

  lathe { 9,
    < 1.25 , 1.25>,< 1.875, 1.875>,<4.375, 1.875>,
    < 5, 1.25>,< 5,-1.25>,<4.375,-1.875>,
    < 1.875,-1.875>,< 1.25 ,-1.25>,< 1.25 , 1.25>
    matrix <0,1,0, 1,0,0, 0,0,1, -22.5,0, 22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1, -21.25,0, 22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1, -23.75,0, 22.5> }

  lathe { 9,
    < 1.25 , 1.25>,< 1.875, 1.875>,<4.375, 1.875>,
    < 5, 1.25>,< 5,-1.25>,<4.375,-1.875>,
    < 1.875,-1.875>,< 1.25 ,-1.25>,< 1.25 , 1.25>
    matrix <0,1,0, 1,0,0, 0,0,1,  22.5,0, 22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1,  21.25,0, 22.5> }
  torus { 4.375,.625 matrix <0,1,0, 1,0,0, 0,0,1,  23.75,0, 22.5> }

  pigment { rgb <.5,0,0> }
  translate y*(PR+TH) }

// *******************  CAMERAS **********************

#local dX=sqrt(3.5*3.5-3*3);

#local Count=0;
#while (Count<3)

#switch (Count)
  #case (0) #local CamLft=-CamLft1; #local CamSwp=CamSwp1; #break
  #case (1) #local CamLft=-CamLft2; #local CamSwp=CamSwp2; #break
  #case (2) #local CamLft=-CamLft3; #local CamSwp=CamSwp3; #break
#end

union { // the camera and all mounting objects
  union { // the mount
    torus { 3.5,.25 matrix <1,0,0, 0,0,1, 0,1,0, 0,0,0> }
    difference {
      cylinder { -z*.25,z*.25,3.5 }
      cylinder { <-2.5,0,-.26>,<-2.5,0,.26>,.2 }
      cylinder { <-1.9,0,-.26>,<-1.9,0,.26>,.2 }
      cylinder { < 2.5,0,-.26>,< 2.5,0,.26>,.2 }
      cylinder { < 1.9,0,-.26>,< 1.9,0,.26>,.2 }
      box { <-2.5,-.2,-.26>,<-1.9,.2,.26> }
      box { < 1.9,-.2,-.26>,< 2.5,.2,.26> }
      bounded_by { cylinder { -z*.25,z*.25,3.5 } }
    }
    cylinder { <-dX,-3,0>,<0,-3,-3.125>,.25 }
    cylinder { < dX,-3,0>,<0,-3,-3.125>,.25 }
    cylinder { <-dX, 3,0>,<0, 3,-3.125>,.25 }
    cylinder { < dX, 3,0>,<0, 3,-3.125>,.25 }
    sphere { <0, 3,-3.125>,.25 }
    sphere { <0,-3,-3.125>,.25 }
    pigment { rgb .8 }
  }
  union { // the camera
    union { // the camera housing
      difference {
        cylinder { <-5,0,-2.5>,<4.375,0,-2.5>,2.625 }
        cylinder { <-5.1,0,-2.5>,<4.4,0,-2.5>,2.375 } }
      cylinder { <4.875,0,-2.5>,<5.125,0,-2.5>,1.875 }
      difference {                 
        cylinder { <-3.875,0,-2.5>,<-3.625,0,-2.5>,2.5 }
        cylinder { <-3.9,0,-2.5>,<-3.6,0,-2.5>,1.875 } }
      torus { 1.875,.75 matrix <0,1,0, 1,0,0, 0,0,1,4.375,0,-2.5> }
      torus { 2.5,.125 matrix <0,1,0, 1,0,0, 0,0,1,-5,0,-2.5> }

#local tX=3.75+.375/2*sqrt(13);
      prism { -2.625,-2.375,5,
        < .75/sqrt(13),1.125/sqrt(13)>,
        < tX,-2.5>,<-tX,-2.5>,
        <-.75/sqrt(13),1.125/sqrt(13)>,
        < .75/sqrt(13),1.125/sqrt(13)>
      }
      prism { 2.375,2.625,5,
        < .75/sqrt(13),1.125/sqrt(13)>,
        < tX,-2.5>,<-tX,-2.5>,
        <-.75/sqrt(13),1.125/sqrt(13)>,
        < .75/sqrt(13),1.125/sqrt(13)>
      }
      cylinder { <-.75/sqrt(13),-2.5,1.125/sqrt(13)>,<-tX,-2.5,-2.5>,.125 }
      cylinder { <-.75/sqrt(13), 2.5,1.125/sqrt(13)>,<-tX, 2.5,-2.5>,.125 }
      cylinder { < .75/sqrt(13),-2.5,1.125/sqrt(13)>,< tX,-2.5,-2.5>,.125 }
      cylinder { < .75/sqrt(13), 2.5,1.125/sqrt(13)>,< tX, 2.5,-2.5>,.125 }
      cylinder { -y*2.625,-y*2.375,.375 }
      cylinder {  y*2.375, y*2.625,.375 }
      torus { .375,.125 translate -y*2.5 }
      torus { .375,.125 translate  y*2.5 }
      torus { .25,.125 translate <-2.5,0,.25> }
      torus { .25,.125 translate < 2.5,0,.25> }
      pigment { rgb .8 }
    }
// The lens mount
    difference {
      cylinder {<-4.375,0,-2.5>,<-1.75,0,-2.5>,2.25 }
      cylinder {<-4.4,0,-2.5>,<-1.7,0,-2.5>,1.75 }
      pigment { rgb .15 }
    }
// The lens
    intersection {
      sphere {<-8.375,0,-2.5>,4.875 }
      sphere {<.625,0,-2.5>,4.875 }
      pigment { rgbt 1 }
      finish { diffuse .05 ambient .05 specular 1 roughness .001 reflection .25 }
      interior { ior 1.8 }
      bounded_by { cylinder { <-4.25,0,-2.5>,<-3.5,0,-2.5>,1.875 } }
    }
    cylinder { <0,-3.375,0>,<0,3.375,0>,.125
      pigment { rgb 1 }
      finish { diffuse .4 reflection .3 specular .5 roughness .01 }
    }
    rotate y*CamLft
    translate -z*3.125
  }

  union { // rods that turn the camera
    torus { .25,.125
      matrix <0,1,0, 1,0,0, 0,0,1, 0,0,.25>
      translate vrotate(<-2.5,0,.25>,y*CamLft)
    }
    torus { .25,.125
      matrix <0,1,0, 1,0,0, 0,0,1, 0,0,.25>
      translate vrotate(< 2.5,0,.25>,y*CamLft)
    }
    cylinder { z*.5,z*7.5,.125
      translate vrotate(<-2.5,0,.25>,y*CamLft)
    }
    cylinder { z*.5,z*7.5,.125
      translate vrotate(< 2.5,0,.25>,y*CamLft)
    }
    pigment { rgb .7 }
    finish { diffuse .7 specular .5 roughness .1 ambient .1 }
    translate -z*3.125
  }

  rotate z*CamSwp
  translate <0,82.5,-20.5>
  rotate y*120*Count
}

#local Count=Count+1;
#end

// ******** The ARM ********

#local VF=-BotHandZ; // intial values for claw placement
#local VV= BotHandY;
#local VU=-BotHandX;

#declare ArmPoints=array[4]
{ BotHandL,-BotHandZ,<0,90,11.25>,-y }

//#declare ArmPoints[1]=BotHandL; // the wrist (may move)
//#declare ArmPoints[3]=<0,90,  11.25>; //Mounting point on robot

/*
  #local t_P0=<0,90,11.25>;
  #local t_P1=BotHandL;
  #local t_V0=y;
  #local t_V1=vnormalize(BotHandZ);

  #local t_A=(t_P1-t_P0)*3/2;
  #local t_B=(t_V0+t_V1)/4;
  #local t_C=vdot(t_A,t_A);
  #local t_D=vdot(t_A,t_B);
  #local t_E=vdot(t_B,t_B)-1;
  #local t_T=(t_D-sqrt(t_D*t_D-t_C*t_E))/t_E;
*/
//#declare ArmPoints[2]=t_P0/2 + t_P1/2 + t_V0*t_T/4 - t_V1 * t_T/4;

//#declare ArmPoints[4]=ArmPoints[2]-y*35; // always below point #2
//#declare ArmPoints[0]=ArmPoints[2]-VF*35; // to Aim the arm & claw

#local ClawPiece=union { // one of Rusty's fingers
  cylinder { -x*.625,-x*.5,.375 texture { Alum } }    
  cylinder {  x*.625, x*.5,.375 texture { Alum } }    
  intersection {
    lathe { 11,<2.5,.625>,<3.125,.625>,<3.25,.5>,
    <3.25,-.5>,<3.125,-.625>,<2.5,-.625>,<2.5,-.5>,
    <3.125,-.5>,<3.125,.5>,<2.5,.5>,<2.5,.625>
      matrix <0,1,0, 1,0,0, 0,0,1, 0,0,0> }
    box { <-.63,-3.28,.125>,<.63,-.125,3.28> }
    texture { Alum }
    translate -z*2.8125 }
  intersection {
    torus { 3.125,.125 matrix <0,1,0, 1,0,0, 0,0,1, -.5,0,0> }
    box { <-.63,-3.28,.125>,<-.37,-.125,3.28> }
    texture { Alum }
    translate -z*2.8125 }
  intersection {
    torus { 3.125,.125 matrix <0,1,0, 1,0,0, 0,0,1,  .5,0,0> }
    box { < .37,-3.28,.125>,< .63,-.125,3.28> }
    texture { Alum }
    translate -z*2.8125 }
  cylinder { <-.625,-2.75,-2.8125>,<-.5,-2.75,-2.8125>,.375 texture { Alum } }    
  cylinder { < .625,-2.75,-2.8125>,< .5,-2.75,-2.8125>,.375 texture { Alum } }    
  cylinder { <-.475,-2.75,-2.8125>,<.475,-2.75,-2.8125>,.425 texture { Rubber } }    
} // end of one of Rusty's fingers

union { // Rusty's hand
  prism { -1,-.375,11,
    <-0.500, 1.500>,
    <-0.500, 1.875>,
    < 0.500, 1.875>,
    < 0.500, 1.500>,
    < 1.500,-1.375>,
    < 1.875,-1.375>,
    < 1.875,-2.375>,
    <-1.875,-2.375>,
    <-1.875,-1.375>,
    <-1.500,-1.375>,
    <-0.500, 1.500>
    pigment { rgb <0,.5,1> }
  }
  cylinder { <-0.500,-.6875, 1.875>,< 0.500,-.6875, 1.875>,.3125 pigment { rgb <0,.5,1> } }
  cylinder { <-1.875,-.6875,-1.375>,<-1.875,-.6875,-2.375>,.3125 pigment { rgb <0,.5,1> } }
  cylinder { < 1.875,-.6875,-1.375>,< 1.875,-.6875,-2.375>,.3125 pigment { rgb <0,.5,1> } }

  object { ClawPiece rotate <-FingerOpen-40,0,0> translate <0,-.6875,1.875> }
  object { ClawPiece rotate <-ClawOpen-40, 90,0> translate < 1.875,-.6875,-1.875> }
  object { ClawPiece rotate <-ClawOpen-40,270,0> translate <-1.875,-.6875,-1.875> }
  Matrix(VU,VF,VV,BotHandL)
} // end of Rusty's hand

#declare RingC=array[2][5]

//PrepConSpline(ArmPoints,RingC)
PrepFullSpline(ArmPoints,RingC)

#local RR=2.5;
#local RC=ArmPoints[1];

union {

#local Index=2.625;
#while (Index<vdot(RingC[0][4],<1,1,0>))
  #local RC2=SplineLoc(RingC,Index);
  #local VF2=SplineVel(RingC,Index);
  #local VV2=vnormalize(vcross(VU,VF));
  #local VU2=vnormalize(vcross(VF,VV));
  #local RR2=5.625-RR;

  sphere { 0,3.125 translate RC2 }

  #local RC=RC2;
  #local VF=VF2;
  #local VV=VV2;
  #local VU=VU2;
  #local RR=RR2;

#local Index=Index+2;
#end

  pigment { rgb .5 }
}
  Matrix(RobotX,RobotY,RobotZ,RobotL)

#ifdef(RustyClip) clipped_by { object { RustyClip } } #end
} // end of the robot
