// the area lights below are both five by five arrays, but for some frames this
// still produced a multiplicity of sharp shadows, instead of one smooth one,
// and when the happened the lights were promoted to 10x10 or 15x15.

light_source { <0,250,-150> rgb .05+.45*Indoors
#if(Test=0)
  area_light x*15,z*15,5,5 adaptive 1
#end
}
light_source { <0,250,150> rgb .05+.45*Indoors
#if(Test=0)
  area_light x*15,z*15,5,5 adaptive 1
#end
}

#declare TvX=vnormalize(< 1,0,1>);
#declare TvY=y;
#declare TvZ=vnormalize(<-1,0,1>);
#declare TvL=<250,10,-250>;
#include "tv.inc"

// the foundation
box { <-310,  0,-310>,<310,9.8,310> texture { Cement } }

box { <-300,9.8,-300>,<300, 10,300>
  texture {
    pigment { checker
      pigment { bumps 
        color_map {
          [ 0 rgb <.5,.45,.4>]
          [.1 rgb <1,.9,.8>]
          [.9 rgb <1,.9,.8>]
          [ 1 rgb <.5,.45,.4>]
        }
        scale <10,1,1>/30
      }
      pigment { bumps 
        color_map {
          [ 0 rgb <.5,.45,.4>]
          [.1 rgb <1,.9,.8>]
          [.9 rgb <1,.9,.8>]
          [ 1 rgb <.5,.45,.4>]
        }
        scale <1,1,10>/30
      }
      scale 30
    }
  }
}

#local Brick=texture {
  pigment { bumps scale 10
    color_map { [0 rgb <.45,.15,0>][1 rgb <.3,.1,0>] }
    warp { repeat y*3 offset x*50 }
  }
  normal { bumps scale .05 }
}

#local Mortar=texture { 
  pigment { bumps scale .1
    color_map { [0 rgb .45][1 rgb .55] }
  }
  normal { bump_map { gif "brick.gif" interpolate 2} scale <8,6,1> }
}  

#local BrickWall=texture { brick 
  texture { Mortar }, texture { Brick }
  turbulence .01 octaves 6 lambda 3 omega .5
  translate y*9.8
}

#local Basic=pigment { granite scale 2
  color_map {
    [.50 rgb <1,.9,.8>]
    [.50 rgb <.3,.4,.5>]
    [.55 rgb <.3,.4,.5>]
    [.55 rgb <1,.9,.8>]
    [1 rgb <.5,.3,.4>]
  }
}   

#local WallPaper=texture {
  pigment { gradient y
    pigment_map {
      [0 gradient x
        pigment_map {
          [0 Basic]
          [1 Basic translate x]
        }
      ]
      [1 gradient x translate y
        pigment_map {
          [0 Basic]
          [1 Basic translate x]
        }
      ]
    }    
    warp { repeat x }
    warp { repeat y }
  }
  translate -x*100
  matrix <1,-1,0, 1,1,0, 0,0,1, 0,0,0>
  scale <35,70,1>*sqrt(.5)
}

#local Oak=texture {
  pigment { wood
    frequency 4 turbulence .1 scale <1,1,10> ramp_wave
    color_map { [.25 rgb <.6,.3,.2>][1 rgb <.5,.2,.1>] }
    warp { repeat z*50 offset y*20 }
  }
}

// three of the four walls      
#local iI=0; #while (iI<3)

#switch(iI)
#case(0)
  #local Slap=transform { matrix <1,0, 0, 0,1,0,  0,0,1, 0,0,0> }
#break
#case(1)
  #local Slap=transform { matrix <0,0, 1, 0,1,0, -1,0,0, 0,0,0> }
#break
#case(2)
  #local Slap=transform { matrix <0,0,-1, 0,1,0,  1,0,0, 0,0,0> }
#break
#end

polygon { 5,<-300.1,9.8,0>,<300.1,9.8,0>,<300.1,300,0>,<-300.1,300,0>,<-300.1,9.8,0>
  texture { WallPaper }
  translate -z*300
  transform Slap
}
polygon { 5,<-310,9.8,0>,<310,9.8,0>,<310,300,0>,<-310,300,0>,<-310,9.8,0>
  texture { BrickWall }
  translate -z*310
  transform Slap
}

union {
  box { <-300,10,-300>,< 300,16,-299> }
  cylinder { <-300,16,-300>,< 300,16,-300>,1 }
  texture { Oak transform FlipXZ }
  transform Slap
}

#local iI=iI+1; #end

// and the front wall
polygon { 9,<-300.1,  9.8,0>,<-41,     9.8,0>,<- 41,  210.8,0>,
            <    41,210.8,0>,< 41,     9.8,0>,< 300.1,  9.8,0>,
            < 300.1,300,  0>,<-300.1,300,  0>,<-300.1,  9.8,0>
  texture { WallPaper }
  translate -z*300
  matrix  <-1,0,0, 0,1,0, 0,0,-1, 0,0,0>
}

union {
  box { <-300,10,-300>,<-47,16,-299> }
  cylinder { <-300,16,-300>,<-47,16,-300>,1 }
  texture { Oak transform FlipXZ }
  matrix  <-1,0,0, 0,1,0, 0,0,-1, 0,0,0>
}
union {
  box { <47,10,-300>,<300,16,-299> }
  cylinder { <47,16,-300>,<300,16,-300>,1 }
  texture { Oak transform FlipXZ }
  matrix  <-1,0,0, 0,1,0, 0,0,-1, 0,0,0>
}

intersection {
  cylinder { 0,y*207,1 scale <7,1,1> }
  box { <0,0,-1>,<7,207,0> }
  plane { <1,1,0>,0 translate <7,200,0> }
  bounded_by { box { <0,0,-1>,<7,207,0> } }
  texture { Oak transform FlipYZ }
  translate <-47,9.8,300>
}

box { <-46.5,  9.8,300>,<-39.5,209.3,310>
  texture { Oak transform FlipYZ }
}
box { < 39.5,  9.8,300>,< 46.5,209.3,310>
  texture { Oak transform FlipYZ }
}
box { <-46.5,209.3,300>,< 46.5,210.3,310>
  texture { Oak transform FlipXZ }
}

box { <-46.5,  9.8,303.5>,<-38.5,208.3,306.5>
  texture { Oak transform FlipYZ }
}
box { < 38.5,  9.8,303.5>,< 46.5,208.3,306.5>
  texture { Oak transform FlipYZ }
}
box { <-46.5,208.3,303.5>,< 46.5,210.3,306.5>
  texture { Oak transform FlipXZ }
}

// the door
union {
box { <-39,10.3,300>,<39,208.7,303.5>
  texture { Oak transform FlipYZ }
}
union { // the brass
#local iI=0; #while(iI<3)
#switch(iI)
#case(0) #local sY=10.3+(208.7-10.3)*5/6; #break
#case(1) #local sY=10.3+(208.7-10.3)*1/2; #break
#case(2) #local sY=10.3+(208.7-10.3)*1/6; #break
#end

cylinder { <39.25,sY-5.00,0>,<39.25,sY-2.55,0>,.5 }
cylinder { <39.25,sY-2.45,0>,<39.25,sY+2.45,0>,.5 }
cylinder { <39.25,sY+2.55,0>,<39.25,sY+4.95,0>,.5 }
cylinder { <39.25,sY-4.00,0>,<39.25,sY+5.10,0>,.4 }

intersection { sphere { 0,.5 } plane { -y,0 } translate <39.25,sY+5.05,0> }

#local iI=iI+1; #end
  translate z*299.6
  texture { Gold }
}// end of the brass
#ifdef(DoorOpen)
  translate <-39.25,0,-299.6>
  rotate -y*DoorOpen
  translate < 39.25,0, 299.6>
#end
}


intersection {
  cylinder { 0,y*207,1 scale <7,1,1> }
  box { <-7,0,-1>,<0,207,0> }
  plane { <-1,1,0>,0 translate <-7,200,0> }
  bounded_by { box { <-7,0,-1>,<0,207,0> } }
  texture { Oak transform FlipYZ }
  translate <47,9.8,300>
}

intersection {
  cylinder { -47*x,47*x,1 scale <1,7,1> }
  box { <-47,-7,-1>,<47,0,0> }
  plane { <-1,-1,>,0 translate -x*47}
  plane { < 1,-1,>,0 translate  x*47}
  bounded_by { box { <-47,-7,-1>,<47,0,0> } }
  texture { Oak transform FlipXZ }
  translate <0,216.8,300>  
}

// The ceiling
#local iJ=-300;  #while (iJ<300)
#local iI=-300;  #while (iI<300)
  box { <iI+1,300,iJ+1>,<iI+49,302,iJ+49> texture { pigment { rgb .85 } } }
#local iI=iI+50; #end
#local iJ=iJ+50; #end

box { <-300,301,-300>,<300,302,300> pigment { rgb .60 } }

#local sC=20/sqrt(401);
#local sS=1/sqrt(401);

box { <-35,-1,0>,<35,0,200> texture { RibbedSteel}
  matrix <1,0,0, 0,sC,sS, 0,-sS,sC, 0,10,310> }

#declare TableX=x;
#declare TableY=y;
#declare TableZ=z;
#declare TableL=<-100,10,-258>;
#include "table1.inc"

#declare PicX=vnormalize(<4,0,-3>);
#declare PicY=y;
#declare PicZ=vnormalize(<3,0,4>);
#declare PicL=<-100,85.5,-258>;
#include "rosiepic.inc"

union { // the cap from the spray can
  intersection {
    torus { 2.5,.5 }
    cylinder { -y*.5,0,3 }
    torus { 2.5,.4 inverse }
    translate y*.5
  }
  difference {
    cylinder { y*.5,y*5,3 }
    cylinder { y*.4,y*5.1,2.9 }
  }
  cylinder { 0,y*.1,2.5 }  
  difference {
    cylinder { y*.1,y*3.5,1.05 }
    cylinder { 0,y*3.6,.95 }
  }
  texture { Gold }
  translate <-85,85.5,-264>
}

#declare MirrorX=x;
#declare MirrorY=y;
#declare MirrorZ=z;
#declare MirrorL=<0,10,-300>;
#include "mirror.inc"

#declare PicX=-z;
#declare PicY= y;
#declare PicZ= x;
#declare PicL=<-299.9,150,0>;
#declare PicW=100;
#declare PicH=75;
#declare PicFrameCross=array[4]
  { <0,0>,<4,0>,<2,1>,<0,0> }
#declare PicFrameText= texture {
  pigment { agate color_map { [0 rgb 0][1 rgb <.5,.25,0> ] } }
}  

#declare PicPigment= pigment {
  mandel 1000 frequency 10
  color_map {
    [0/6 rgb <0,0,0>]
    [1/6 rgb <1,0,0>] 
    [2/6 rgb <1,1,0>]
    [3/6 rgb <1,1,1>] 
    [4/6 rgb <0,1,1>]
    [5/6 rgb <0,0,1>] 
    [6/6 rgb <0,0,0>]
  }

  translate x*1.5
  translate <255.5-306,162-191.5,0>/384
  scale 10
  translate <255.5-427,181-191.5,0>/384
  scale 10
  translate <255.5-264,243-191.5,0>/384
  scale 10

// center in picture
  scale <.75,1,1>
  translate <.5,.5,0>
}
#include "pic.inc"

#declare TableX=-x;
#declare TableY=y;
#declare TableZ=-z;
#declare TableL=<-200,10,300>;
#include "table2.inc"


#declare SprayY=y;
#declare SprayCapOn=true;
#local S0=seed(0);

#local iI=0; #while(iI<8)
  #declare SprayX=vrotate(x,iI*y*130);
  #declare SprayZ=vrotate(z,iI*y*130);
  #declare SprayL=<-250+iI*10,80,250+30*rand(S0)-30*rand(S0)>;
#switch(iI)
  #case(0) #declare SprayCapTexture=texture { pigment { rgb <.5,.75,1> } } #break
  #case(1) #declare SprayCapTexture=texture { pigment { rgb <0,.5,0> } } #break
  #case(2) #declare SprayCapTexture=texture { pigment { rgb <.5,0,.5> } } #break
  #case(3) #declare SprayCapTexture=texture { pigment { rgb <1,1,0> } } #break
  #case(4) #declare SprayCapTexture=texture { pigment { rgb <.5,.25,0> } } #break
  #case(5) #declare SprayCapTexture=texture { pigment { rgb <1,1,1> } } #break
  #case(6) #declare SprayCapTexture=texture { pigment { rgb <0,0,1> } } #break
  #case(7) #declare SprayCapTexture=texture { pigment { rgb <0,0,0> } } #break
#end
#include "spray.inc"
#local iI=iI+1; #end

#declare OddClockX=z;
#declare OddClockY=y;
#declare OddClockZ=-x;
#declare OddClockL=<300,200,-250>;
#switch (clock)
#range(13.999,18.999)
#declare OddClockSeconds=4*3600+24*60+37+Timer;
#break
#range(18.999,99.999)
#declare OddClockSeconds=4*3600+51*60+15+Timer;
#break
#end
#include "oddclock.inc"

#declare TableX=vrotate(x,y*67.5);
#declare TableY=y;
#declare TableZ=vrotate(z,y*67.5);
#declare TableL=<-225,10,0>;
#include "table3.inc"

#declare VaseX=x;
#declare VaseY=y;
#declare VaseZ=z;
#declare VaseL=<-210,85.5,10>;
#include "vase.inc"

// the detector for the automatic door


