#declare Test=1;
#include "macs.inc"
#include "spline.inc"
#include "rosetext.inc"

#declare Frame=floor(clock*24+.5);
#declare Clock=Frame/24;

#declare CamZ=2.5;
#declare CamS=y;

#switch(Clock)
  #range(-.001,6.999)
    #declare Timer=Clock;
    #include "rose_s01.inc"
  #break
  #range(6.999,10.499)
    #declare Timer=Clock-7;
    #include "rose_s02.inc"
  #break
  #range(10.499,13.999)
    #declare Timer=Clock-10.5;
    #include "rose_s03.inc"
  #break
  #range(13.999,19.999)
    #declare Timer=Clock-14;
    #include "rose_s04.inc"
  #break
  #range(19.999,25.999)
    #declare Timer=Clock-20;
    #include "rose_s05.inc"
  #break
  #range(25.999,28.999)
    #declare Timer=Clock-26;
    #include "rose_s06.inc"
  #break
  #range(28.999,31.999)
    #declare Timer=Clock-29;
    #include "rose_s07.inc"
  #break
  #range(31.999,34.999)
    #declare Timer=Clock-32;
    #include "rose_s08.inc"
  #break
  #range(34.999,36.999)
    #declare Timer=Clock-35;
    #include "rose_s09.inc"
  #break
  #range(36.999,39.999)
    #declare Timer=Clock-37;
    #include "rose_s10.inc"
  #break
  #range(39.999,43.999)
    #declare Timer=Clock-40;
    #include "rose_s11.inc"
  #break
  #range(43.999,99.999)
    #declare Timer=Clock-44;
    #include "rose_s12.inc"
  #break
#end

#declare CamD=vnormalize(CamE-CamL);
#declare CamR=vnormalize(vcross(CamS,CamD));
#declare CamU=vnormalize(vcross(CamD,CamR));

camera {
  up CamU
  right CamR*4/3
  direction CamD*CamZ
  location CamL
}

// titling goes here
#switch(Clock)
  #range(5.999,7.999)
    #declare Timer=Clock-6;
    #include "rose_t01.inc"
  #break
  #range(31.999,34.999)
    #declare Timer=Clock-32;
    #include "rose_t02.inc"
  #break
  #range(38.999,39.999)
    #declare Timer=Clock-39;
    #include "rose_t03.inc"
  #break
  #range(39.999,41.249)
    #declare Timer=Clock-40;
    #include "rose_t04.inc"
  #break
  #range(49.999,50.999)
    #declare Timer=Clock-50;
    #include "rose_t05.inc"
  #break
#end

#ifdef(Stars)
  #include "stars.inc"
#end