// Opening shot showing picture from Rosie
#debug "Shot three is being parsed.\n"

#declare Indoors=on;
#include "chezrust.inc"
//#include "valley.inc"

#local i_I=0;

#declare RobotY=y;
#declare RobotZ=vnormalize(<-1,0,0>);
#declare RobotX=vnormalize(< 0,0,1>);
#declare RobotL=<0,10,-198>;
#declare RotLT=i_I*180/pi/5.625/sqrt(2+sqrt(3));
#declare RotRT=i_I*180/pi/5.625/sqrt(2+sqrt(3));
#declare CamLft1=0;
#declare CamSwp1=0;
#declare CamLft2=15;
#declare CamSwp2=0;
#declare CamLft3=Transition(15,-25,0,Timer);
#declare CamSwp3=Transition(180,105,0,Timer);

#declare BotHandX=vnormalize(< 13,0,-16>);
#declare BotHandY=-y;
#declare BotHandZ=vnormalize(<-16,0,-13>);

#declare CanStart=<0,95.5,0>+74.8*vnormalize(<16,0,13>);
#declare CanEnd=<0,75.5,0>+34.8*vnormalize(<16,0,13>);

#declare BotHandL=Transition(CanStart,CanEnd,-5*y,(Timer+.5)/2);

#declare FingerOpen=35; //proper angle for pressing the spray can nozzle
// when the can is located at <0,-9.5,4.3> from BotHandL
#declare ClawOpen=Transition(35,28.9,0,(Timer-1.75)*4);
// proper angle for holding item 6 units wide = 28.9
// item should be placed 4.3 units forward of BotHandL
#include "rusty.inc"

// transform can for location of hand
#declare SprayX=vmatrix(x,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayY=vmatrix(y,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayZ=vmatrix(z,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare SprayL=vmatrix(<0,-9.5,4.3>,BotHandX,BotHandY,BotHandZ,BotHandL);

// and then transform it for location of the robot 
#declare SprayX=vmatrix(SprayX,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayY=vmatrix(SprayY,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayZ=vmatrix(SprayZ,RobotX,RobotY,RobotZ,<0,0,0>);
#declare SprayL=vmatrix(SprayL,RobotX,RobotY,RobotZ,RobotL);
#declare SprayOn=off;
#if (Timer>1.499) #declare SprayOn=on; #end
#if (Timer>2.999) #declare SprayOn=off; #end
#include "spray.inc"

#declare CamE=<0,82.5,-198>+20.5*vnormalize(<-13,0,16>);
#declare CamL=CamE+vnormalize(<.1,0,6>)*(75-5*Timer);
#declare CamZ=2.5;

// the first patch

#local ER= 3.75;
#local BB=27.5+ER;
#local BT=90-ER;
#local RB=21.26;
#local RT=15.01;

#local OT=sqrt( (RT-RB)*(RT-RB) + (BT-BB)*(BT-BB) );
#local OU=(BT-BB)/OT*ER;
#local OV=(RB-RT)/OT*ER;

#local sC=min(max((Timer-1.625)/1.25,0),1);

#declare HalfRust = texture {
  pigment { rgb lin(<.20,.13,0>,<1,.9,0>,sC) }
  finish { diffuse lin(1,.4,sC) specular lin(0,.8,sC) roughness .03 ambient .1 }
  normal { granite .3 scale .02 }
}

#declare HalfGold = texture {
  granite 
  texture_map { [.8 BlisterGold] [.8 HalfRust] }
  scale 50
}

cone {
  y*(BB+OV),RB+OU,y*(BT+OV),RT+OU
  texture { HalfGold }
  clipped_by { sphere { y*72.5+20.5*vnormalize(<16,0,13>),2 } }
//  bounded_by {clipped_by }
  Matrix(RobotX,RobotY,RobotZ,RobotL)
}
 