// Opening shot showing picture from Rosie
#debug "Shot four is being parsed.\n"

#declare Indoors=on;
#declare DoorOpen=Transition(0,105,0,(Timer-2)/1.5);
#declare DoorOpen=Transition(DoorOpen,0,0,(Timer-6)/1.5);
#include "chezrust.inc"
#include "darkvale.inc"

#declare Trail=array[2][5]

#declare CamLft1=0;
#declare CamSwp1=0;
#declare CamLft2=20;
#declare CamSwp2=0;
#declare CamLft3=15;
#declare CamSwp3=180;

#switch(Timer)
#range(-.001,2.499)
  #declare Path=array[4] {
    <   0,10, 25>,-x,
    <-150,10,175>,z
  }
  PrepFullSpline(Path,Trail)
  #local iI=Transition(vdot(Trail[0][4],x+y),0,0,(Timer-.75)/1.5);
  #declare RobotY=y;
  #declare RobotZ=vnormalize(SplineVel(Trail,iI));
  #declare RobotX=vnormalize(vcross(RobotY,RobotZ));
  #declare RobotL=SplineLoc(Trail,iI);
  #declare RotLT=iI*180/pi/5.625/sqrt(2+sqrt(3));
  #declare RotRT=iI*180/pi/5.625/sqrt(2+sqrt(3));
  #declare CamLft2=Transition(20,-30,0,Timer);
  #declare CamSwp2=Transition(0,180,0,Timer);
  #declare CamLft3=Transition(15,-30,0,Timer);
  #declare CamSwp3=Transition(180,0,0,Timer);
#break
#range(2.499,3.749)
  #local iI=Transition(0,90,0,Timer-2.5);
  #declare RobotX=vrotate( z,y*iI);
  #declare RobotY=y;
  #declare RobotZ=vrotate(-x,y*iI);
  #declare RobotL=<0,10,25>;
// wheel rotation for movement = distance*180/pi/5.625/sqrt(2+sqrt(3));
// wheel rotation for turning  = degrees *4/sqrt(2+sqrt(3))
  #declare RotLT= iI*4/sqrt(2+sqrt(3));
  #declare RotRT=-iI*4/sqrt(2+sqrt(3));
  #declare CamLft2=Transition(-30,20,0,Timer-2.5);
  #declare CamSwp2=Transition(180,0,0,Timer-2.5);
  #declare CamLft3=Transition(-30,30,0,Timer-2.5);
  #declare CamSwp3=Transition(0,180,0,Timer-2.5);
#break
#range(3.749,99)
  #local sPR=5.625*sqrt(2+sqrt(3))+.3125;
  #local sA=degrees(atan2(1,20));
  #local sW=45;
  #local iI=150*(Timer-3.75)*(Timer-3.75);
  #if(Timer>4.749) #local iI=150+300*(Timer-4.75); #end
  #declare RobotX=x;

#switch(iI)
#range(-1,285)
  #declare RobotY=y;
  #declare RobotZ=z;
  #declare RobotL=<0,10,25+iI>;
#break
#range(285,285+sW/2)
  #declare aX=sA*(iI-285)/(sW/2);
  #declare RobotY=vrotate(y,x*aX);
  #declare RobotZ=vrotate(z,x*aX);
  #declare RobotL=RobotZ*(iI-285)+<0,10,310>;
#break
#range (285+sW/2,285+sqrt(40100)-sW/2-sPR/20)
  #declare RobotY=vnormalize(<0,20, 1>);
  #declare RobotZ=vnormalize(<0,-1,20>);
  #declare RobotL=RobotZ*(iI-285)+<0,10,310>;
#break
#range (285+sqrt(40100)-sW/2-sPR/20,285+sqrt(40100)+sW/2-sPR/20)
  #local vF=vnormalize(<0,-1,20>);
  #local pCB=vF*(iI-285-sW/2)+<0,10,310>+vnormalize(<0,20,1>)*sPR;
  #local sZ=sqrt(45*45-(pCB.y-sPR)*(pCB.y-sPR));
  #local pCF=<0,sPR,sZ+pCB.z>;
  #declare RobotZ=vnormalize(pCF-pCB);
  #declare RobotY=vnormalize(vcross(RobotZ,x));
  #declare RobotL=(pCB+pCF)/2-RobotY*sPR;
#break
#range (285+sqrt(40100)+sW/2-sPR/20,1e4)
  #declare RobotY=y;
  #declare RobotZ=z;
  #declare RobotL=<0,0,310+200+sPR/20+sW/2+iI-285-sqrt(40100)-sW/2+sPR/20>;
#break
#end

// wheel rotation for movement = distance*180/pi/5.625/sqrt(2+sqrt(3));
// wheel rotation for turning  = degrees *4/sqrt(2+sqrt(3))
  #declare RotLT=(iI*180/pi/5.625+360)/sqrt(2+sqrt(3));
  #declare RotRT=(iI*180/pi/5.625-360)/sqrt(2+sqrt(3));
  #declare CamLft2=20;
  #declare CamSwp2=0;
  #declare CamLft3=30;
  #declare CamSwp3=180;
#break
#end

#declare BotHandL=Transition(<0,77.3,75>,<0,100,35>,y*10,Timer);

#local aR=Transition(-180,0,0,Timer-.25);
#local aP=Transition(110, 0,0,Timer);
#declare ClawOpen=-12;
#declare FingerOpen=45;

#declare vX=vrotate(vrotate(x,z*aR),x*aP);
#declare vY=vrotate(vrotate(y,z*aR),x*aP);
#declare vZ=vrotate(z,x*aP);

#declare vRZ=vnormalize((BotHandL-z*11.25)*<1,0,1>);
#declare vRX=vcross(y,vRZ);

#declare BotHandX=vmatrix(vX,vRX,y,vRZ,<0,0,0>);
#declare BotHandY=vmatrix(vY,vRX,y,vRZ,<0,0,0>);
#declare BotHandZ=vmatrix(vZ,vRX,y,vRZ,<0,0,0>);

#declare RustyGold = texture { Gold
  normal { granite
    normal_map {
      [.6 bumps .001]
      [.8 granite .1 scale.1 ]
      [.8 granite .3 scale .02]
    }
  }
  scale 50
}

#include "rusty.inc"

#declare SprayX=vnormalize(<73.75,0,-30>);
#declare SprayY=y;
#declare SprayZ=vnormalize(<30,0,73.75>);
#declare SprayL=<-140,80,230>;
#declare SprayOn=off;
#declare SprayCapOn=off;
#include "spray.inc"

// the one by the mirror; probably off-screen at the moment
#declare SprayX=vnormalize(<-29,0,69.75>);
#declare SprayY=y;
#declare SprayZ=vnormalize(<-69.75,0,-29>);
#declare SprayL=<-80,85.5,-252>;
#declare SprayOn=off;
#declare SprayCapOn=off;
#include "spray.inc"

#declare CamE=<-100,80,201>+Timer*<50/6,0,99/6>;
#declare CamL=<100,119.5,-200>;

#declare CamZ=2.5;

//
#declare vHSX=vrotate(-x,x*110);
#declare vHSY=vrotate(-y,x*110);
#declare vHSZ=vrotate( z,x*110);
#local vHSL=<0,77.3,75>+<-150,10,175>;

#declare FlowerX=vm_invert(x,vHSX,vHSY,vHSZ,<0,0,0>);
#declare FlowerY=vm_invert(vrotate( z,-x*5)*<-1,1,-1>,vHSX,vHSY,vHSZ,<0,0,0>);
#declare FlowerZ=vm_invert(vrotate( y,-x*5)*<-1,1,-1>,vHSX,vHSY,vHSZ,<0,0,0>);
#declare FlowerL=vm_invert(<0,-3.6,30>+<-150,80,250>,vHSX,vHSY,vHSZ,vHSL);

#declare FlowerX=vmatrix(FlowerX,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare FlowerY=vmatrix(FlowerY,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare FlowerZ=vmatrix(FlowerZ,BotHandX,BotHandY,BotHandZ,<0,0,0>);
#declare FlowerL=vmatrix(FlowerL,BotHandX,BotHandY,BotHandZ,BotHandL);

#declare FlowerX=vmatrix(FlowerX,RobotX,RobotY,RobotZ,<0,0,0>);
#declare FlowerY=vmatrix(FlowerY,RobotX,RobotY,RobotZ,<0,0,0>);
#declare FlowerZ=vmatrix(FlowerZ,RobotX,RobotY,RobotZ,<0,0,0>);
#declare FlowerL=vmatrix(FlowerL,RobotX,RobotY,RobotZ,RobotL);

#declare PetalPig=pigment { rgb <1,0,0> }

#include "flower.inc"

#local Trans=array[256] {
  255,  0,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,127,114, 195, 53,187, 33,
  179, 21,170,162, 154,138, 98,146,  81, 90, 73,130,  65, 57, 37,  5,
  251,150,203, 77, 227,183,106, 41, 243,215,199, 94, 166,134, 61, 13,
  247,235,191,102, 118,223,239,175, 158, 45,211,142,  85, 25,  5, 69

}
#local pC=<.5,.5,0>;
polygon { 5,0,x,x+y,y,0
  texture {
    material_map {
      gif "smear.gif" once
#local iI=0; #while(iI<255)
  texture { pigment { rgbt <1,0,0,Trans[iI]/255> } finish { ambient 0 diffuse 1 } }
#local iI=iI+1; #end      

    }
  }  
    translate <-.5,-.5,0>
    matrix <0,0,-160/3, -40,0,0, 0,1,0,-150,80+.002,250+7.5>
  no_shadow
}

polygon {5,0,x,x+z,z,0 pigment { rgb <1,.99,.98> }
  translate <-.5,0,-.5>
  scale <50,1,70>
  rotate y*25
  translate <-150,80.001,255>
}

union { // the cap from the spray can
  intersection {
    torus { 2.5,.5 }
    cylinder { -y*.5,0,3 }
    torus { 2.5,.4 inverse }
    translate y*.5
  }
  difference {
    cylinder { y*.5,y*5,3 }
    cylinder { y*.4,y*5.1,2.9 }
  }
  cylinder { 0,y*.1,2.5 }  
  difference {
    cylinder { y*.1,y*3.5,1.05 }
    cylinder { 0,y*3.6,.95 }
  }
  pigment { rgb <1,0,0> }
  translate <-130,80,275>
}
   