#default { pigment { rgb .75 } finish { ambient .1 diffuse 1 } }

#declare BugIron=texture {
  pigment {rgb .75}
  finish {ambient .1 diffuse .6 specular .25 roughness .1 }
}

#declare BugBrass=texture {
  pigment { rgb <.75,.65,.55>}
  finish {ambient .1 diffuse .6  specular .25 roughness .1 }
}

#declare BugLapis=texture {
  pigment { rgb <.1,.4,.7> }
  finish {ambient .1 diffuse .6  specular .25 roughness .08 }
}

#declare BugEye=texture {
  pigment { rgbf <1,0,0,.5> }
  finish { ambient .5 diffuse .5 } }

#declare Ruby=material {
  texture {
    pigment { rgbf <.5,0,0,1> }
    finish { ambient .1 diffuse .1 reflection .25 }
  }
  interior { ior 2 }
}
#declare BugSpark=texture {
  pigment { rgbt <.6,.8,1,(clock*6-floor(clock*6))/2+.5> }
  finish { ambient 1 diffuse 0 } }

#declare Gold=texture {
  pigment { rgb <1,1,0> }
  finish { ambient .1 diffuse .1 specular 1 roughness .01
    reflection .5 brilliance 4 metallic on }
}

#declare Plastic=texture {
  pigment { rgb .75 }
}

#declare Cement=texture {
  pigment { rgb .75 }
  normal { granite .1 }
}

#declare Rubber=texture {
  pigment { rgb .125 }
  normal { bumps .317 }
}

#declare Chrome=texture {
  pigment { rgb <.95,.98,1> }
  finish { ambient .1 diffuse .1 specular 1 roughness .01
    reflection .5 brilliance 4 metallic on }
}

#declare Steel=texture {
  pigment { rgb .75 }
  finish { ambient .1 diffuse .55 specular 1 roughness .1
    brilliance 2 metallic on }
}

#declare BangUp=texture {
  Steel
  normal { dents .1 triangle_wave }
}

#declare Alum=texture {
  pigment { rgb .85 }
  finish { ambient .1 diffuse .85 specular .7 roughness .316
    brilliance 1.5 metallic on }
}

#declare RibbedSteel=texture { Steel
    normal { bump_map { gif "metal.gif" use_color bump_size .55 interpolate 2 }
      matrix <5,0,0, 0,0,5, 0,1,0, -2.5,0,-2.5> }
}

#declare Glass=material {
  texture {
    pigment { rgbt 1 }
    finish { diffuse .05 ambient .05 specular 1 roughness .001 reflection .25 }
  }
  interior { ior 1.8 }
}

#declare YellowStripe= texture {
  pigment {
    image_map { gif "stripe.gif" interpolate 2 map_type 2 }
    scale <1,2*pi,1>
  }
}

#declare Obsidian = texture {
  pigment { rgb 0 }
  finish { reflection .25 specular 1 roughness .01 }
}

#declare BakedMud = texture {
  pigment { granite color_map { [0 rgb .5][1 rgb <.6,.5,.4>] } }
  normal  { granite
    normal_map { [.25 granite .317] [.5 granite -.1] }
  }
  scale 25
}

#declare Sandstone = texture {
  pigment { agate frequency 10 pigment_map {
      [ 0 rgb <.6,.5,.4> ]
      [.1 rgb <.65,.6,.55> ]
      [.9 rgb <.65,.6,.55> ]
      [1  rgb <.7,.6,.5> ]
  }
  scale <200,10,200>
  }
  normal { granite scale 10 }
}

#declare Sandstone2 = texture {
  pigment { agate pigment_map {
      [ 0 rgb <.6,.5,.4> ]
      [.1 rgb <.65,.6,.55> ]
      [.9 rgb <.65,.6,.55> ]
      [1  rgb <.7,.6,.5> ]
  }
  transform FlipYZ
  scale <200,1,200>
  }
  normal { granite scale 10 }
}

#declare Sandstone3 = texture {
  pigment { rgb <.65,.6,.55> }
  normal { average
    normal_map {
      [1 granite 2 scale 10 ]
      [1 agate transform FlipYZ scale 100 ]
    }
  }
}

#declare Wood=texture {
  pigment { rgb <.7,.4,.1> }
  normal { crackle scale <1,10,1> }
}

#declare Neon= texture {
  pigment { rgb <1,0,0> }
  finish { ambient 1 diffuse 0 }
}

#declare Laser=material {
  texture { pigment { rgbt 1 } }
  interior {
    media { emission <1,0,0> }
    media { absorption <0,.1,.1> }
  }
}

#declare Rust = texture {
#if (Test=0)
  pigment { rgb <.20,.13,0> }
  finish { diffuse 1 ambient .1 }
  normal { granite .3 scale .02 }
#else
  pigment { rgb 1 }
  finish { ambient 1 diffuse 0}
#end
}

#declare Gold=texture {
  pigment { rgb <1,.9,0> }
  finish { diffuse .4 specular .8 roughness .03 ambient .1
#if(Test=0) reflection .25 #end brilliance 4 }
}

#declare BlisterGold = texture { Gold
  normal { granite normal_map { [.6 bumps .001] [.8 granite .1 scale.1 ] } }
}

#declare RustyGold = texture {
  granite 
  texture_map { [.8 BlisterGold] [.8 Rust] }
  scale 50
}

#declare RosieGold = texture {
  pigment { rgb <1,.5,.5> }
  finish { diffuse .4 specular .8 roughness .03 ambient .1
#if(Test=0) reflection .5 #end brilliance 4 }
}

#declare BluePlastic=texture { pigment { rgb <.4,.7,1> } }

#declare Divit=pigment { average
  pigment_map { 
    [1 bumps translate  y color_map {[.5 rgb 0][.5 rgb <1.5,1,.5>] }] 
    [1 bumps              color_map {[.5 rgb 0][.5 rgb .75 ]}]
    [1 bumps translate -y color_map {[.5 rgb 0][.5 rgb <1.125,.875,.625>] }]
  }
}

#declare Granite=texture {
//  pigment { rgb .75 }
//}


  pigment { average
    pigment_map {
      [1 Divit scale 1.28 ]
      [1 Divit scale 0.64 ]
      [1 Divit scale 0.32 ]
    }
  }
}


#declare Brass = texture {
  pigment { rgb <1,.8,.2> }
  finish { diffuse .4 specular .8 roughness .1 ambient .1 brilliance 3 }
}

   