#include "colors.inc"

light_source {
<-250,300,-50>*10000
color rgb 4
//area_light 25,25,10,10
//adaptive 0
}
light_source {
< 250, 0, -250 >*10000
color rgb <.5,.5,1>/2
//area_light 25,25,10,10
//adaptive 0
}


background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
} 

#macro FFTest(Loc,Rot,ERot) 
#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end 

//#declare RotZ = ((Rot.z/clock)*clock_delta)/2
//#declare RotX = ((Rot.x/clock)*clock_delta)/2
 
#declare EngRot1 = ((RotZ)/2)+((-RotX)/2)+ERot
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)+ERot

union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate 15*y }  

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate -37.5*x rotate <EngRot2,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <-37.5,0,50> rotate <EngRot2,0,0>} 

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate 37.5*x rotate <EngRot1,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <37.5,0,50> rotate <EngRot1,0,0>}

scale .75 
rotate Rot 
translate Loc
}
#end



#declare Start = 0;
#declare End = .5; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end 

#declare Flipc1 = pow(keyclock,.5)  

#declare Start = .25;
#declare End = .5; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end 

#declare Flipc2 = pow(keyclock,2)
        

#declare Start = .4;
#declare End = .6; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end  

#declare Barrelc2 = pow(keyclock,.5)  

#declare Start = .8;
#declare End = 1.001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end  

#declare Barrelc2 = pow(keyclock,.5)

                   
#declare Start = .5;
#declare End = 1.0001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare Barrelc1 = sin((keyclock-.5)*pi)/2+.5 
#declare Barrelc3 = pow(keyclock,.5)

#declare Speedc1 = pow(keyclock,2)

//#declare mclock2 = sin((keyclock-.5)*pi)/2+.5
#declare Rclock = sin(clock*2*pi)            

#declare BarrelRoll = 360*Barrelc1-360
#declare Flip = 90+90*Flipc1 

#declare Rclock2 = sin(keyclock*2*pi) 
#declare BarrelRoll2 = -40*Rclock2
#declare Flip2 = 75+115*Flipc1 
 
#include "COM Fighter.inc"  
TiltFighter(<-60,50*Flipc1,(210*Flipc2)+(1080*Speedc1+(210*clock))>,<Flip,0,BarrelRoll>,(45*Barrelc2),false,1)
TiltFighter(<50,20+60*Flipc1,(200*Flipc2)+(1000*Speedc1+(200*clock))>,<Flip2,0,BarrelRoll2>,((115/2)*Barrelc2),false,2)

//FFTest(<-60,50*Flipc1,(210*Flipc2)+(1080*Speedc1+(210*clock))>,<Flip,0,BarrelRoll>,(45*Barrelc2))
//FFTest(<50,20+60*Flipc1,(200*Flipc2)+(1000*Speedc1+(200*clock))>,<Flip2,0,BarrelRoll2>,((115/2)*Barrelc2))
//FFTest(<0,0,0>,<90,0,0>,0)


#macro BellyCam(Loc,Rot)  

#declare Start = .5;
#declare End = .75; 
#if (clock > Start)
#if (clock < End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

camera 
{
location  <10,25,-120>
direction (1+(2*keyclock))*z
look_at <10,26,15>
      
rotate Rot
translate Loc
} 
#end


//#if (clock >.25)
#include "Pirate Fighter.inc" 
FixedFighter(<10,100+45*clock,(3000+(7000*clock))/4>,<0,180,(25*Rclock)+(60*clock)+12.5>,1) 
//FixedFighter(<-110,0,(-7580+(13500*clock))/4>,<0,180,-15*Rclock>,2) 

BellyCam(<10,100+45*clock,(3000+(7000*clock))/4>,<0,180,(25*Rclock)+(60*clock)+12.5>)

                           
                              