#include "colors.inc"
//+sf102
#macro CM(S,E)
#if (clock > S)
#if (clock < E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
#end 
CM(.833,1)
#declare Rate0 = sin((keyclock-.5)*pi)/2+.5


//#if (clock < .1)  
#declare cam_loc = <-70,-30,-2000>; 
#declare sky_vect = y;
#declare lookat = <0,0,-1000+(-500*clock)>;
camera 
{
location  cam_loc
direction 1.5*z
look_at lookat 
}



light_source {
<-250,120,50>*10000
color rgb 2
//area_light 25,25,10,10
//adaptive 0
}
/*#declare flare_size = <1,1,1>;
#declare flare_brightness = 1.5;   
#declare light_loc = <-250,80,60>*10000
#include "35mm.flr"   
#include "nkflare.inc"*/



light_source {
< 250, 0, -250 >*10000
color rgb <.5,.5,1>/2
//area_light 25,25,10,10
//adaptive 0
}
background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
}

#macro Flare(Size,RotTimes,Length,Loc,R,S,E)  
#local flrclock = mod((clock-S)/(E-S),1) 
#if (clock < E)
#if (clock >= S)
#local FlrSze = rand(seed(R+clock))*.5
#local flare_brightness = <1,.75,.25>*2
#local flare_size = (FlrSze+.5)*(1-flrclock)*Size
#local light_loc = vrotate(Length*flrclock*x,(360*RotTimes*clock)*z)+Loc;
#include "sports.flr" 
#include "nkflare.inc"  
light_source {light_loc rgb <1,.75,.25>*2 fade_distance 200*(FlrSze+.5)*(1-flrclock) fade_power 2}
#end
#end 
#end 

#macro Exp(R,B,S,E,Size) 
#declare Rand = rand(seed(R)) 

#if (clock > S)
#if (clock < E)
#local keyclock = mod((clock-S)/(E-S),1) 
#local Rate = pow(keyclock,.375)
 
#local Scale = 1*Rate  
#local Fader = -1.5*keyclock+1.5

sphere {0,1 no_shadow hollow on
pigment {transmit 1}
interior {
media { 
intervals 35
/*samples 1,1
confidence .9999
variance .0001*/
emission <1,.5,.2>/Size/Scale*Fader*B//*3.5
//absorption .5 
density {spherical
color_map {
[0 rgb 0]
[.2 rgb <1,.375,0>] 
[.2 rgb 5]
[.2125 rgb 5]  
[.25 rgb 2]
}
translate -2.5*Rate+Rand*z 
warp {turbulence .5 omega 0} 
translate 2.5*Rate-Rand*z  


scale 4
translate 6*Rate-Rand
rotate 20*Rate
warp {turbulence 1*(Rate/2+1/2) omega .125}
rotate -20*Rate
translate -6*Rate+Rand
scale 1/(4)
rotate (Rand*360)

scale 10
translate -6*Rate+Rand
rotate 20*Rate
warp {turbulence .75*(Rate/2+1/2) omega .125}
rotate -20*Rate
translate 6*Rate-Rand
scale 1/(10)
rotate (Rand*36)
 
scale .8  
}
#if (keyclock < .5)
#else
density { bozo
color_map{
[1.5*keyclock-(1.5/2) rgb 0]
[2*keyclock-1 rgb <1,.375,0>*2]
[2*keyclock-1 rgb 1]
[1.0 rgb 1]
}
scale 1/3
translate 2.5*Rate+Rand
warp {turbulence .5 }
translate -2.5*Rate+Rand  

scale 6
translate 2*clock+Rand+Rand
rotate 20*clock
warp {turbulence .2 omega 0}
rotate -20*clock
translate -2*clock-Rand+Rand
scale 1/6

rotate 323456*Rand+567567
}
#end


}
}
scale Scale 
scale Size
}
#end
#end

#end


#macro Streamer(Rand,S,E)
#declare S = rand(seed(Rand+Rand))*.06125+S  
#declare E = E-(.35*rand(seed(Rand*Rand)))   

#local SC = mod((clock-S)/(E-S),1)
#if (clock < S) 
#local SC = 0
#end
#if (clock > E) 
#local SC = 1
#end  

#local SC = pow(SC,.5) 

#if (clock < E)
#declare C=0
#while (C<20)
#declare Max = 2.25
#declare Dist = (Max*rand(seed(C*C+Rand)))+Max/2
#declare Rot = ((10-5*SC)*rand(seed(C+Rand)))-(5-2.5*SC)  
#declare Rot2 = (-20*rand(seed(C*C*Rand))) 



disc {0,z,1 hollow on no_shadow
#declare Emis = ((<.5,.25,0>+(<1,.675,.675>*Dist/Max))-(<0,.5,.9>*SC))
#if (Emis.x < 0)
#declare EX = 0 
#else           
#declare EX = Emis.x 
#end
 
#if (Emis.y < 0)
#declare EY = 0
#else           
#declare EY = Emis.y
#end 

#if (Emis.z < 0)
#declare EZ = 0 
#else           
#declare EZ = Emis.z
#end
 
#declare Color =  <EX,EY,EZ>

pigment { onion
color_map {
[.5+.5*SC rgb (Color*2.5)*(rand(seed(C+Rand)))+(Color*2.5)/4 transmit 1*SC]
[1 transmit 1]
}
}
scale .5
scale (.125/2)*SC+.125  
scale <1+(1*rand(seed(Rand*C))),1+(.25*rand(seed(C+Rand*C))),1>
rotate 9000*(rand(seed(Rand+C)))*z
rotate 900*SC*(rand(seed(Rand*C)))*z

translate Dist*SC rotate Rot*z
scale .5*rand(seed(Rand))+.75 
rotate 4576567*Rand*z
rotate (-1767*rand(seed(Rand)))*z   
rotate (8767*rand(seed(Rand*Rand)))*z 
translate (.2*rand(seed(C*C*Rand))-.1)*z  
translate -(.2*rand(seed(C*Rand*Rand))-.1)*z 
translate -(.4*rand(seed(C))-.2)*z
} 

#declare C=C+1
#end           
#end                   

#end

  

#macro Missile(S,E,SLoc,SRot,Dist,Scale,TotalNum,MisEnd)
#declare M_Tex1 =
texture {
pigment {rgb 1}
finish {ambient .15 diffuse .875 phong 1}
}
#declare M_Tex2 =
texture {
pigment {rgb <0,0,.75>}
finish {ambient .15 diffuse .875 phong 1}
}
#declare M_Tex3 =
texture {
pigment {rgb .125}
finish {ambient .15 diffuse .875 phong 1}
}
#local MisClock = mod((clock-S)/(E-S), 1) 
#local AccelClock = clock 
#if (clock < E)
#local SmokeTrans = <0,100*AccelClock*(Dist/100)+.001,0>
#else                                                   
#local SmokeTrans = <0,100*E*(Dist/100)+.001,0>
#end

union {

difference {
cylinder {0,SmokeTrans,2 hollow on
pigment {transmit 1}
interior {
media{
emission 2/3/Scale/5
absorption (1/3/Scale)*10/5
intervals 15
density { cylindrical
color_map{
[0 rgb 0]
[1 rgb 1]
}
scale <2,1,2>
} 
density { bozo
color_map{
[.5 rgb 0]
[.5 rgb 1]
}
rotate -25*MisClock*y
warp {turbulence .25}
rotate 25*MisClock*y
scale .175*Scale
}
density { spherical
color_map{
[0 rgb 0]
[.5 rgb .25]
[1 rgb 1]
}
scale <10,250,10>
translate (100*clock*(Dist/100)+.001)*y
} 
}
}
rotate -90*x
} 
plane {-z,0  pigment {transmit 1}
translate (100*clock*(Dist/100)+.001)+250*z
}
           
}

#if (clock < MisEnd)
cylinder {0,3*y,1
pigment {transmit 1}
hollow
interior {
media {
emission <.675,.5,1>/2/3/Scale
//intervals 25
#declare C=0;
#while (C <360)
density {
cylindrical
color_map {
[0 rgb 0]  
[.25 rgb 1]
}       
rotate 15*z     
rotate C*y
}        
#declare C=C+60;
#end
density {
gradient y
color_map {
[0 rgb 0] 
[.125 rgb .25]
[.25 rgb .5]  
[.5 rgb 1.75]
[.75 rgb 7.5]
[1 rgb 10]
}       
scale 4
} 
}
}
scale 3 
translate -3*y
rotate -90*x 
translate <0,0,-100*AccelClock>*(Dist/100)+<0,0,6>
}

// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

               scale < 0.75, 6.5, 0.75 >
               rotate < 90, 0, 0 >
               translate < 0, 1.522e-22, -7.5 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               scale < 0.75, 1, 0.75 >
               rotate < 90, 0, 0 >
               translate < 0, 0, -1 >

               texture
               {
                  M_Tex3
                  scale < 0.75, 1, 0.75 >
                  rotate < 90, 0, 0 >
                  translate < 0, 0, -1 >
               }
            }
                // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < .75, 1, .75 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -1 >
                     pigment {rgb <1,.75,0>}
                     finish {ambient 1}
                  }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5 }

               scale < 0.75, 2.5, 0.75 >
               rotate < -90, 0, 0 >
               translate < 0, 0, -7.5 >

               texture
               {
                  M_Tex2
                  scale < 0.75, 2.5, 0.75 >
                  rotate < -90, 0, 0 >
                  translate < 0, -3.3087e-24, -7.5 >
               }
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 0.375, 0.375, 0.75 >
               translate < 0, 0, -10 >
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, 0 >
                     translate < 0, 1.25, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, 90 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, 90 >
                     translate < -1.25, -5.4639e-08, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, -90 >
                     translate < 6.6613e-16, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, -90 >
                     translate < 1.25, -5.4639e-08, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, -180 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, -180 >
                     translate < 1.0928e-07, -1.25, -2.5 >
                  }
               }
            }
         }

         texture
         {
            M_Tex1
            translate < 0, 0, -2.5 >
         }
      }
   }
   scale .5
#if ( MisClock > 0 )
translate <0,0,-Dist*AccelClock>
#end
}
#end

#if ( MisClock > 0 )
light_source {
<0,0,-Dist*AccelClock+2>
color rgb <.6,.5,1>*1.5
fade_distance 60*Scale
fade_power 2
}
#end
scale Scale 
rotate SRot
translate SLoc
}
#end 


#macro FFTest(Loc,Rot,ERot) 
#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end 

//#declare RotZ = ((Rot.z/clock)*clock_delta)/2
//#declare RotX = ((Rot.x/clock)*clock_delta)/2
 
#declare EngRot1 = ((RotZ)/2)+((-RotX)/2)+ERot
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)+ERot

union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate 15*y }  

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate -37.5*x rotate <EngRot2,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <-37.5,0,50> rotate <EngRot2,0,0>} 

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate 37.5*x rotate <EngRot1,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <37.5,0,50> rotate <EngRot1,0,0>}

scale .75 
rotate Rot 
translate Loc
}
#end
 
 
CM(0,1)
#declare Rclock = sin(sin((keyclock-.5)*pi)/2+.5*2*pi) 
 
#include "COM Fighter.inc" 
TiltFighter(<0,-45*clock+15,-3200*clock+3000>,<0,0,(-30*Rclock)>,0,false,2) 
//FFTest(<0,-45*clock+15,-2200*clock+2000>,<0,0,(-30*Rclock)>,0) 
 
 
//Missile(S,E,SLoc,SRot,Dist,Scale)
Missile(-.55,1.01,<-25,0,1000>,<0,0,5>,4500/5,5,6,1)
Missile(-.65,.6,<25,0,1000>,<0,0,5>,4450/5,5,6,.6)

//Flare(RotTimes,Length,Loc,R,S,E)
CM(.3,.7)
Flare(.5,2.25,34,<0,0,-200*keyclock-1050>,18,.3,.7)
CM(.35,.75)
Flare(.625,-1.5,84,<0,0,-400*keyclock-1225>,3,.35,.75) 
CM(.4,.8)
Flare(.75,1,44,<0,0,-200*keyclock-1400>,6,.4,.8)
CM(.5,.601)
Flare(1,-3,25,<0,0,80*keyclock-1750>,9,.5,.8)  


union {


#declare RandomNumber = 459;

//Exp(R,B,S,E,Size) 
Exp(RandomNumber,1.25,.5875,.825,60)
union {
#declare B=0
#while (B<25)
Streamer(RandomNumber*B,.5875,.825) 
#declare B=B+1
#end   
scale 1/5*60
}
rotate -180*y
translate <25,0,-1670>
}



#macro EFTest(Loc,Rot) 
union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate -30*z }  
scale .75 
rotate Rot 
translate Loc
}
#end 
CM(.35,.7)
#declare Clock3 = sin((keyclock-.5)*pi)/2+.5



//#include "Pirate Fighter.inc"
//EFTest(<0,0,-3500*clock>,<0,0,(-20*Rclock)+(90*clock)-(90*Clock3)-(100*clock)>) 
//FixedFighter(<0,0,-3500*clock>,<0,0,(-20*Rclock)+(90*clock)-(90*Clock3)-(100*clock)>,2,2,2) 


#macro Debris(RNum,Num,Loc,Clock)
#declare C=0;
#while (C < Num)
#declare Seed = seed(C+RNum)
#declare Rand = rand(Seed)  
#declare Seed2 = seed(C*C+RNum*RNum)
#declare Rand2 = rand(Seed2)
intersection {
difference {
sphere {0,1}
sphere {0,.95}   
sphere {2*z,2
}
}
sphere {0,.875 scale <.5+Rand*.5,1+Rand2*2,4>} 
scale <1,1,.1+Rand2*.75>*1.5

texture {   
pigment { gradient y triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}
turbulence -.25*Rand-.25   
scale .2+.15*Rand2          
translate Rand2*y
}
}
texture {   
pigment { gradient x triangle_wave
color_map {
[0 rgb .5-<0,.15,.3>*Rand]
[.05 rgb .25-<0,.075,.15>*Rand2]
[.1 rgb .5 transmit 1]
}  
turbulence .5*Rand2+.125
scale .2+.15*Rand2          
translate Rand2*x
}
}
texture {   
pigment { bozo
color_map {
[0 rgb .5-(<0,.15,.3>/2)*Rand]
[.3+.4*Rand2 rgb .25-<0,.075,.15>*Rand2]
[.425+.4*Rand2 rgb .5 transmit 1]
}   
turbulence 1
scale .35+.35*Rand2          
translate Rand2*y
}
}

scale 2
rotate Rand*720
rotate 480*Rand2*clock
translate (Rand*80*Clock)*x
translate (-Rand*35*Clock+5)*y
translate (Rand*60*Clock+10)*z
rotate C*360*Rand
//translate <Rand2*8*clock,Rand*-8*clock,Rand2*8*clock> 
rotate -C*180*Rand2 
scale 2
translate Loc 

}
#declare C=C+1;
#end  
#end 

#declare Start = .5875
#declare End = 1; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock2 = pow(keyclock,.5)

#if (clock > Start)
Debris(8988,10,<25,0,-1670>,10*mclock2)
#end




global_settings {max_trace_level 100000}  

