#include "colors.inc"
#declare sky_vect = y;
#declare cam_loc = <20,10,-30>;
#declare lookat = 0;
camera { 
  location  cam_loc
  direction 1.5*z
  look_at   lookat
}

#declare keyclock = pow(clock,.5/2)

light_source {<10, 10, -20> rgb 1}
/*background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
}*/


sor {8,
<20,-15>, 
<15,0>,
<6,5>,
<1.5,5.25+4.75*keyclock>,
<.5,5.5+7*keyclock>,
<.25,5.75+9*keyclock>,
<.125,6+10*keyclock>,
<0,6.25+11*keyclock>
open
rotate 90*x

//interior {ior 1.2}
texture {
finish {ambient 1.5}
pigment {
cylindrical
pigment_map { 
[.25 transmit 1]
[.875 
radial sine_wave frequency 12
//onion triangle_wave
color_map{
[0 rgb <.5,.5,.5> transmit 1]
[1 rgb <.5,.5,.75>*1.5 transmit .5]
}
scale 3
translate -20*z*keyclock
warp {turbulence 1 omega 0}
translate 20*z*keyclock     
scale 1/3

warp {turbulence .75 omega 0 lambda 1
}

scale 1/8
scale <1,100000,1>
]             
[.8 rgb 3]

}
scale 20
rotate 90*x 
rotate (9000*keyclock)*z
}
}               

texture {
finish {ambient 2}
pigment {
cylindrical
pigment_map { 
[.25 transmit 1]
[.925 onion triangle_wave
color_map{
[0 rgb <.5,.5,.75> transmit .125]
[1 rgb <.5,.5,1>*1.25]
}
scale 6
translate -2*z*keyclock
warp {turbulence 2}
translate 2*z*keyclock     
scale 1/6


phase 4*clock
warp {turbulence .5
}
scale 1/10
scale <1,100000,1>
]             
[.8 rgb 3]

}
scale 20 
rotate 90*x
}
}                      
translate -16*z   
rotate -90*z*clock
scale <1*keyclock+.0001,1*keyclock+.0001,1*keyclock+.0001> 
translate 16*z*keyclock 
}



#declare flare_size = <1,1,1>*clock+.5;
#declare flare_brightness = <.5,.5,1>;   
#declare light_loc = <0,0,5>
#include "CAMCORDR.flr"   
#include "nkflare.inc"
global_settings {max_trace_level 100000}  
