#include "colors.inc"
#include "woods.inc"
#include "c:\windows\desktop\robot.pov"

sky_sphere
{
  pigment
  {
    bozo turbulence 1
    color_map { 
    [0.0 color rgb <0,0,.5>] 
    [0.25 color rgb <0,0,.5>]
    [1.0 color rgb<1,1,1>]}
   rotate <0,0,1*clock>} scale <1, 0.25, 1>
}

light_source {<-100, 500, -1000> color rgb<1,1,1>}

//test camera
camera { location <20-(17*(clock-1)),1+(25*(clock-1)),-100-(5*clock)> look_at <15,2+(6*clock-1),-80+(100*(clock-1))>
//   translate <0,10.53+(5*clock),-80-(20*clock)>
   }

//main camera
//camera {location <0,-1.5+(.5*clock),-11-(14*clock)> look_at  <0,.5,4-(2.5*clock)>


height_field {gif "c:\packfo~1\graphics\grassmap.gif" scale <50,150,25> 
  pigment {rgb<0,1,.5>} finish {ambient .25} rotate <0,270,0> translate <12.5,-3,-40>}

height_field {gif "c:\packfo~1\graphics\grassmap.gif" scale <50,150,25> 
  pigment {rgb<0,1,.5>} finish {ambient .25} rotate <0,270,0> translate <50,-3,40>}

height_field {gif "c:\packfo~1\graphics\grassmap.gif" scale <50,150,25> 
  pigment {rgb<0,1,.5>} finish {ambient .25} rotate <0,270,0> translate <50,-3,-40>}
  
height_field {gif "c:\packfo~1\graphics\grassmap.gif" scale <50,150,25> 
  pigment {rgb<0,1,.5>} finish {ambient .25} rotate <0,270,0> translate <75,-3,-40>}  
  
height_field {gif "c:\packfo~1\graphics\grassmap.gif" scale <50,150,25> 
  pigment {rgb<0,1,.5>} finish {ambient .25} rotate <0,270,0> translate <75,-3,40>}

height_field {gif "c:\packfo~1\graphics\grassmap.gif" scale <50,150,25> 
  pigment {rgb<0,1,.5>} finish {ambient .25} rotate <0,270,0> translate <75,-3,140>}
    
plane {y,-2 pigment { bozo 
    pigment_map { 
    [0.0 color rgb <0,1,0>] 
    [0.5 color rgb <.25,.75,.5>]
    [1.0 color rgb <0,1,0>]}} }

#declare anteater=union {
sphere {<0,0,0>,1 pigment {rgb<.5, .5, .5>}}
sphere {<-.7,.25,-.5>,.25 pigment {rgb<0,0,0>} finish {phong 1}}
sphere {<.7,.25,-.5>,.25 pigment {rgb<0,0,0>} finish {phong 1}}


#declare numtor=1
                                                                            
#while (numtor<100)

torus {.5-.5*(numtor/100), .4-.4*(numtor/100) rotate<90,0,0> translate <0,-numtor/500,0-numtor/35.> pigment {rgb<.5, .5, .5>}}
torus {.5-.5*(numtor/100), .4-.4*(numtor/100) rotate<90,0,0> translate <0,-numtor/200,0-numtor/37.5> pigment {rgb<.5, .5, .5>}}

torus {.5-.5*(numtor/100), .4-.4*(numtor/100) rotate<90,0,0> translate <clock*(sin(pi*numtor/100)),-numtor/200,8+numtor/10> pigment {rgb<.5, .5, .5>}}

#declare numtor=numtor+1

#end

sphere {<0,-.18,-2.85>,.175 pigment {rgb<0,0,0>} finish {phong 1}}

cylinder {<0,0,0><0,0,1>,.9 pigment {rgb<.5,.5,.5>}}

blob{
threshold .65
sphere{<-.75,0,1.5>,1.5,1}
sphere{<.75,0,1.5>,1.5,1}
sphere{<0,.5,3>,4,1}
sphere{<0,1,4.5>,3,1}
sphere{<-1.5,.5,5>,2,1}
sphere{<1.5,.5,5>,2,1}
sphere{<0,.25,7>,3,1}
sphere{<0,0,8.25>,1,1}
pigment {rgb<.5,.5,.5>}

}

//legs

union{

//leg1

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 
//rotate <0,0,(5*sin(4*clock))-5> 
translate <0,-3,0>}
//rotate <0,0,15*sin(clock*4)> 
translate <-.75,0,1.5>
}

//leg2

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 
//rotate <0,0,(5*sin(4*clock))-5> 
translate <0,-3,0>}
//rotate <0,0,15*sin(-clock*4)> 
translate <0,6, -.5> }    

rotate <0,270,0> scale <.25, .20, .25> translate <.75,0,1.5> 
}

//front legs

union{

//leg1

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 
//rotate <0,0,(5*sin(4*clock))-5> 
translate <0,-3,0>}
//rotate <0,0,15*sin(clock*4)> 
translate <0,6, .5>
}

//leg2

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 
//rotate <0,0,(5*sin(4*clock))-5> 
translate <0,-3,0>}
//rotate <0,0,15*sin(-clock*4)> 
translate <0,6, -.5> }    

pigment {rgb<.5, .5, .5>} scale <1.5,.25,1.5> rotate <0,270,0> translate <0,-2,2>
}

//hind legs

union{

//leg1

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 
//rotate <0,0,(5*sin(4*clock))-5> 
translate <0,-3,0>}
//rotate <0,0,15*sin(clock*4)> 
translate <0,6, .5>
}

//leg2

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 
//rotate <0,0,(5*sin(4*clock))-5> 
translate <0,-3,0>}
//rotate <0,0,15*sin(-clock*4)> 
translate <0,6, -.5> }    

pigment {rgb<.5, .5, .5>} scale <2,.25,2> rotate <0,270,0> translate <0,-2,6>}

//tongue

sphere {<0,-2,-2.5>, 1 scale <.125,.05,1> pigment {rgb<1,.25,.25>} 
  finish {phong 1} rotate <-5,0,0> translate <0,0,0>}

difference{  
cylinder {<0,0,0> <0,-.5,-11.5>, .125 scale <1,.05,1> rotate <-5,0,0>pigment {rgb<1,.25,.25>} finish {phong 1} }
box {<-100,-100,0-(40*clock)><100,100,-100>}  
}  
finish {ambient .5} 
translate <0,-.25,-8.5> 
}

//ant

#declare ant=union{
union{
blob{
  threshold .65
  sphere {<0,.1,.05>, .5, 1}
  sphere {<0,0,.15>,.25, 1}
}
cylinder{<.15,.1,.05><.15,.5,.05>,.01}
cylinder{<.15,.5,.05><.25,.65,.5>,.01}
cylinder{<-.15,.1,.05><-.15,.5,.05>,.01}
cylinder{<-.15,.5,.05><-.25,.65,.5>,.01}
rotate <0,-90*clock,0>}
cylinder {<0,.1,0><0,-.5,0>, .05}
sphere {<0,-.45,0>, .2}
cylinder {<0,-.5,0><0,-1, -.5>,.05}
sphere { <0,0,0>,.5 scale <.5,.5,1> rotate <-45,0,0>  translate <0,-1, -.5>}


cylinder {<0,-.45,0><-.35, -.75, -.35>,.05}
cylinder {<-.35, -.75, -.35><-.25,-1,.3>,.05}

cylinder {<0,-.45,0><.35, -.75, -.35>,.05}
cylinder {<.35, -.75, -.35><.25,-1,.3>,.05}

cylinder {<0,-.45,0><-.35, -.45, -.35>,.05}
cylinder {<-.35, -.45, -.35><-.25,-.55,.3>,.05}

cylinder {<0,-.45,0><.35, -.45, -.35>,.05}
cylinder {<.35, -.45, -.35><.25,-.55,.3>,.05}

//legs

union{

//leg1

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 rotate <0,0,(5*sin(clock))-5> translate <0,-3,0>}
rotate <0,0,15*sin(clock)> translate <0,6, .5>
}

//leg2

union{

//thigh

cylinder {<0,0,0><0,-3,0>, .2 }
sphere {<0,-3,0>, .25}                          

//calf

cylinder {<0,0,0><0,-3,0>, .2 rotate <0,0,(5*sin(clock))-5> translate <0,-3,0>}
rotate <0,0,15*sin(-clock)> translate <0,6, -.5> }    

rotate <0,270,0> scale <.25, .20, .25> translate <0,-1.8,0>
pigment{rgb<0,0,0>} finish {phong 1}
}
}

//#object {ant rotate<0,90,0> translate <0,0,-20> finish {phong 1 reflection .25}}

//Sandbox

//union{
difference{
box{<0,.25,0><1,.5,1>}
box{<.025,1.25,.025><.975,-1.25,.975>}
texture {T_Wood1 scale 1 } finish {ambient .33  phong .25} 
}
height_field {tga "c:\mydocu~1\animat~1\celseq~1\images\stel.tga" pigment {rgb<1,.9,.8>}
   normal {bozo } smooth finish {ambient .53} }
//#object {ant scale .0125 rotate <0,90-(90*clock),0> translate <.985,.52,.975> finish {phong 1}}  
//scale 100 translate <-100,-35,-200>}                         


//anthill
height_field {tga "c:\mydocu~1\animat~1\celseq~1\images\anthill.tga" scale <50,25,50> translate<15,-7,-100>
   pigment {rgb<.7,.6,.5>} smooth finish {ambient .53} }
#declare r1=seed(0)
#declare r2=seed(1)
#declare numant=0
#while (numant<50)
union{
#object{ant translate<0,0,25+25*rand(r1)> rotate <0,360*rand(r2),0>}
#object{ant translate<0,0,25+25*rand(r2)> rotate <0,360*rand(r1),0>}
translate <0,1.8,-80> finish {phong 1}}
#declare numant=numant+1
#end

object {robot rotate <0,180,0> translate <10,17,-95>}

object {anteater rotate<15*clock,84*clock,20*clock> translate <15,2+(6*clock),-80+(300*(clock-1))>}

//bomb
union {
light_source{<0,1.2,0> rgbt<20*(clock-1),20*(clock-1),20*(clock-1)>}
sphere {<0,0,0>, 2.5 pigment {bozo pigment_map {
   [0 rgbt<1,1,1,1>]
   [.45 rgbt<0,.5,0,.5>]
   [.5 rgbt<0,1,0,.25>]
   [.65 rgbt<0,.5,0,.5>]
   [1 rgbt<1,1,1,1>]
   }
   rotate<360*clock, 600*clock,-360*clock>}
   finish {ambient 1} }
sphere {<0,0,0>, 1.25 pigment {bozo pigment_map {
   [0 rgbt<1,1,1,1>]
   [.45 rgbt<1,0,0,.5>]
   [.5 rgbt<1,1,0,.25>]
   [.65 rgbt<1,0,0,.5>]
   [1 rgbt<1,1,1,1>]
   }
   rotate<-360*clock, 360*clock,0>}
   finish {ambient 1} }
scale 6*clock translate <15,2+(6*clock),-80+(300*(clock-1))>}

//ray beam

cylinder{<11,15,-95><15,2+(6*clock),-80+(300*clock)>,.9
 pigment {bozo pigment_map {
   [0 rgbt<1,1,1,1>]
   [.45 rgbt<1,1,0,.5>]
   [.5 rgbt<1,0,0,.25>]
   [.65 rgbt<1,1,0,.5>]
   [1 rgbt<1,1,1,1>]
   }
   rotate<-360*clock, 360*clock,0>}
   finish {ambient 1} no_shadow}


