
#declare b_length = 300;
#declare b_num_tress = 20;
#declare b_depth = 10;
#declare b_width = 38;
#declare b_plank_number = 65;
#declare b_plank_gap = 1;

       
#declare b_tress = union {       
#declare i =0;
#while (i < b_num_tress)  

   #declare b_start = -b_length/2 + i     * b_length / b_num_tress;
   #declare b_end   = -b_length/2 + (i+1) * b_length / b_num_tress;
   #if (mod(i,2) = 1)
       cylinder {<b_start,0,-b_depth>, <b_end,0,0>, 0.8}
   #else
       cylinder {<b_start,0,0>, <b_end,0,-b_depth>, 0.8}
   #end
   #declare i = i + 1;
#end
box { -0.8, 0.8
    scale b_length * x * .625
    }
    
box { -0.8, 0.8
    scale b_length * x  *.625
    translate -b_depth * z
    }


}

object {
   union {
      union {b_tress translate -y*b_width/2}
      union {b_tress translate y*b_width/2}
                    
   #declare i = 0;            
   #declare b_plank_width = b_length / b_plank_number - b_plank_gap;
   #while (i < b_plank_number)
       #declare box_start = i*(b_plank_width+b_plank_gap) -b_length/2;   
       box { <box_start, -b_width/2, -.25>,
             <box_start + b_plank_width, b_width/2, 0.25> }  
      #declare i = i +1;
   #end
   }
   translate z* -.25    
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <0.25, 0.2, 0.2>
            //color rgb 1
            
         }      
         normal
         {
            wrinkles , 0.5
         }      
         finish
         {
            ambient 0.3
            phong 0.5
            phong_size 10.0
            roughness 0.9
         }
      }
   }   
   translate 20*z 
}