#declare cam_start   = <0, -80, 50>;     
#declare cam_start_a = cam_start + < 0, -450, 0>;               
#declare cam_end     = cam_start_a + <0, -1500, 0>;

#switch (clock)
   #range(0,0.5)
      #declare cam_location = cam_start;
      #break    
   #range (0.5, 0.75)         
      #declare temp_radians = radians((clock-0.5)/0.25*180 -90);
      #declare cam_location = cam_start - 450 * (sin(temp_radians)+1)/2 * y;     
      #break
   #range (0.75, 0.9)
      #declare temp_radians = radians((clock-0.75)/0.15*180 -90);
      #declare cam_location = cam_start_a - 1500 * (sin(temp_radians)+1)/2 * y;     
      #break
   #else
      #declare cam_location = cam_end;        
#end                                 
//#debug concat("pos_cam = ", str(cam_location.x,2,2), " " , str(cam_location.y,2,2), " ", str(cam_location.z,2,2), "\n")
                                      

#declare look_start   = <-30, 0, 30>;   
#declare look_start_a = look_start + <80, 0, 0>;                              
#declare look_start_b = look_start_a + <-50, 0, 0>;   
#declare look_end     = look_start_b + <0, 0, -100>;                           

#switch(clock)
   #range (0, 0.2)
      #declare look_location = look_start;
      #break      
   #range (0.2, 0.3)
      #declare temp_radians = radians((clock-0.2)/0.1*180 -90);
      #declare look_location = look_start + 80 * (sin(temp_radians)+1)/2 * x;
      #break         
   #range(0.3, 0.5)
      #declare look_location = look_start_a;
      #break
   #range(0.5,0.6)        
      #declare temp_radians = radians((clock-0.5)/0.1*180 -90);
      #declare look_location = look_start_a -50 * (sin(temp_radians)+1)/2 * x;
      #break  
   #range(0.6,0.75)
      #declare look_location = look_start_b;
      #break                                   
   #range (0.75, 0.9)
      #declare temp_radians = radians((clock-0.75)/0.15*180 -90);
      #declare look_location = look_start_b -100 * (sin(temp_radians)+1)/2*z;
      #break        
   #else
      #declare look_location = look_end;
#end                        
//#debug concat("pos_look = ", str(look_location.x,2,2), " " , str(look_location.y,2,2), " ", str(look_location.z,2,2), "\n")
