/* ##############################################################
   #              GEAR INCLUDE FILE (POVRAY 3.02)               #
   #                                                            #
   # Author  : Marc Schimmler (schimmler@ica.uni-stuttgart.de)  #
   # Date    : Oct 1998                                         #
   # copyleft: GNU Public License                               #
   # Version : 0.1b                                             #
   #                                                            #
   ############################################################## */

//
//	 CHECK IF GEAR VARIABLES ARE DECLARED -- IF NOT USE DEFAULT VALUES
//   -----------------------------------------------------------------

#ifndef (gear_z)                                // NO# OF GEAR TEETH
 #declare gear_z = 20
#end

#ifndef (gear_m)                                // MODUL OF GEAR
 #declare gear_m =  3
#end

#ifndef (gear_flank)                            // HEIGHT OF FLANK
 #declare gear_flank = 10
#end

#ifndef (gear_alpha)                             // WORKING ANGLE
 #declare gear_alpha = 20.0
#end

//
//   CALCULATE THE DERIVED GEAR VARIABLES
//   ------------------------------------

#declare gear_c = 0.25 * gear_m                 // HEADROOM OF GEAR
#declare gear_p = gear_m * pi                   // ARC OF TOOTH + GAP
#declare gear_rt = gear_z * gear_m / 2          // NOMINAL RADIUS
#declare gear_hf = gear_m + gear_c              // HEIGHT OF THE TOOTHFOOT
#declare gear_rk = gear_rt + gear_m             // UPPER RADIUS OF GEAR
#declare gear_rf = gear_rt - gear_hf            // LOWER RADIUS OF GEAR
#declare gear_rg = gear_rt * cos(radians(gear_alpha))  // GROUND RADIUS OF GEAR

//
//  CALCULATE ADDITIONAL NEEDED VALUES
//  ----------------------------------

#declare gear_lo = -gear_flank / 2              // UNDERSIDE OF GEAR
#declare gear_hi =  gear_flank / 2              // UPPERSIDE OF GEAR
#declare gear_th =  gear_rk - gear_rg           // REAL TOOTH HEIGHT

//
//  DEFINE GEAR GEOMETRY
//  --------------------

#declare GEAR_OBJ = object{ 
 
 union {                                            // GEAR = TEETH + BASE

  cylinder {<0,gear_lo,0>,<0,gear_hi,0>,gear_rf}    // BASE CYLINDER OF GEAR 

  #declare _g_count = 0                             // COUNTING VARIABLE

 #declare _g_tooth = object {                       // DECLARE TOOTH GEOMETRY
  union{ 
   #while (_g_count < 10)
     #declare g_inv_a = tan(radians(20)) - radians(20)      // INVOLUT ALPHA
     #declare gear_ry0 = gear_rk - (gear_th/10 * _g_count)  // LOWER PRISM SIDE
     #declare gear_ay0 = acos(gear_rg / gear_ry0)           // LOWER ALPHA_Y
     #declare g_inv_y0 = tan(gear_ay0) - gear_ay0           // LOWER INVOLUT
     #declare gear_sy0 = 2*gear_ry0*((pi/2/gear_z)          // LOWER TOOTHARC
                         - g_inv_y0 + g_inv_a)
     #declare gear_ry1 = gear_rk                            // HIGHER PRISM
                         - (gear_th/10 * (_g_count + 1))    // SIDE
     #declare gear_ay1 = acos(gear_rg / gear_ry1)           // HIGHER ALPHA_Y
     #declare g_inv_y1 = tan(gear_ay1) - gear_ay1           // HIGHER INVOLUT
     #declare gear_sy1 = 2*gear_ry1*((pi/2/gear_z)          // HIGHER TOOTHARC
                         - g_inv_y1 + g_inv_a)
              
     #declare g_p_1x   =  gear_ry0 * sin(gear_sy0 / 2 / gear_ry0) // PRISM
     #declare g_p_1y   =  gear_ry0 * cos(gear_sy0 / 2 / gear_ry0) // VERTICES
     #declare g_p_2x   = -gear_ry0 * sin(gear_sy0 / 2 / gear_ry0) // FROM
     #declare g_p_2y   =  gear_ry0 * cos(gear_sy0 / 2 / gear_ry0) // 1 TO 4
     #declare g_p_3x   = -gear_ry1 * sin(gear_sy1 / 2 / gear_ry1)
     #declare g_p_3y   =  gear_ry1 * cos(gear_sy1 / 2 / gear_ry1)
     #declare g_p_4x   =  gear_ry1 * sin(gear_sy1 / 2 / gear_ry1)
     #declare g_p_4y   =  gear_ry1 * cos(gear_sy1 / 2 / gear_ry1)

     #if (_g_count = 0)                                     // IF UPPERMOST
      difference {                                          // PRISM THEN
       cylinder {<0,gear_lo,0>,<0,gear_hi,0>,gear_rk}       // CREATE
       #declare g_rk_al = degrees(gear_sy0 / 2 / gear_rk)   // CYLINDRICAL CAP
       plane { x,0 rotate <0,-1.0 * g_rk_al,0> }
       plane {-x,0 rotate <0,       g_rk_al,0> } }
     #end

     prism {                                                  // CREATE TOOTH
           linear_sweep                                       // BY UNION
           linear_spline                                      // OF 10
           gear_lo,                                           // PRISMS
           gear_hi,
           5,
           <g_p_1x,g_p_1y>, <g_p_2x,g_p_2y>, <g_p_3x,g_p_3y>, 
           <g_p_4x,g_p_4y>, <g_p_1x,g_p_1y> }


  #declare _g_count = _g_count + 1                             
 #end

 #declare g_foot_m = (g_p_1y - g_p_4y) / (g_p_1x - g_p_4x)        // CONTINUE
 #declare g_p_5x = (0.75 * gear_rf - g_p_4y)/ g_foot_m  + g_p_4x  // TOOTH
 #declare g_p_5y =  0.75 * gear_rf                                // INTO
 #declare g_p_6x = -1.0 * g_p_5x                                  // BASE
 #declare g_p_6y =        g_p_5y                                  // WITH 
   prism {                                                        // AN
           linear_sweep                                           // ADDITIONAL
           linear_spline                                          // PRISM
           gear_lo,
           gear_hi,
           5,
           <g_p_4x,g_p_4y>, <g_p_5x,g_p_5y>, <g_p_6x,g_p_6y>, 
           <g_p_3x,g_p_3y>, <g_p_4x,g_p_4y> }

  }
 }

 #declare _g_count = 0

 #while (_g_count != gear_z)                       // COPY AND ROTATE TOOTH
                                                   // UNTIL ALL TEETH ARE 
  #declare _g_ang = 360 / gear_z                   // CREATED
  object { _g_tooth rotate <0,_g_count*_g_ang,0>}  
  #declare _g_count = _g_count + 1
 #end
  }
 }
