//
// ********  REFERENCED OBJECTS  *******
//

#declare R2EyeLidCSG = difference {
  sphere { // R2EyeLid1
    <0,0,0>,1
    scale 0.3
    translate  <-0.45, -1.18436, 6.45>
  }
  sphere { // R2EyeLidCut
    <0,0,0>,1
    material {
      Brass_Metal
    }
    scale <0.3, 0.24, 0.3>
    translate  <-0.45, -1.267973, 6.45>
  }
  material {
    Brass_Metal
  }
}
#declare R2Eye1 = object {
  sphere { // R2Eye1
    <0,0,0>,1
    material {
      EyeColor
    }
    scale 0.15
    translate  <-0.45, -1.247032, 6.45>
  }
}




//
// ********  OBJECTS  *******
//
//Treads      
#declare Right_Tread = union {

#declare wheel = 1.1;
#declare apart = 4;
#declare separ = 0.075;
#declare number = 25;
#declare length = 2* pi * wheel + 2 * apart;
#declare wide = (length/number) - separ;              

//Right Tread
#declare rtreadoff = R2Degree/360*6.5*pi*2;        
#declare rwheelrot = rtreadoff/(2*1*pi)*360;

#declare a = 0;       
#while (a < number)                
   // create a box that extends between the 2 specified points
   box { < -0.5, -wide/2, -wheel - 0.05> <0.5, wide/2, -wheel + 0.05  > 
   #declare d = mod(a * (wide + separ) + rtreadoff, length) ; 
   #switch (d)
      #range (0,apart)
         translate d*y
         #break
      #range (apart, apart + pi*wheel)
         rotate (d-apart)/pi/wheel *180 * x
         translate apart * y
         #break
      #range (apart + pi*wheel, 2*apart + pi*wheel)
         translate<0,2* apart + pi * wheel - d, 2 * wheel>
         #break
      #range (2*apart + pi*wheel, length)
         rotate (d - (2 *apart + 2 * pi * wheel))/ pi / wheel * 180 * x
   #end          
   translate <-2.0, -2, wheel>    
     material {
       Brass_Metal
     }
   }
   #declare a = a + 1;
#end
                              
}                              
#declare ltreadoff = R2Degree/360*2.5*pi*2;        
#declare lwheelrot = ltreadoff/(2*1*pi)*360;

#declare Left_Tread = union {

#declare wheel = 1.1;
#declare apart = 4;
#declare separ = 0.075;
#declare number = 25;
#declare length = 2* pi * wheel + 2 * apart;
#declare wide = (length/number) - separ;

//Right Tread
#declare a = 0;       
#while (a < number)                
   // create a box that extends between the 2 specified points
   box { < -0.5, -wide/2, -wheel - 0.05> <0.5, wide/2, -wheel + 0.05  >  
   #declare d = mod(a * (wide + separ) + ltreadoff, length); 
   #switch (d)
      #range (0,apart)
         translate d*y
         #break
      #range (apart, apart + pi*wheel)
         rotate (d-apart)/pi/wheel *180 * x
         translate apart * y
         #break
      #range (apart + pi*wheel, 2*apart + pi*wheel)
         translate<0,2* apart + pi * wheel - d, 2 * wheel>
         #break
      #range (2*apart + pi*wheel, length)
         rotate (d - (2 *apart + 2 * pi * wheel))/ pi / wheel * 180 * x
   #end          
   translate <2.0, -2, wheel>    
     material {
       Brass_Metal
     }
   }
   #declare a = a + 1;
#end
                              
}                              

#declare R2Hand2 = difference {
  box { // R2RightHandMain1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Brass_Metal
    }
    scale 0.4
    rotate -45.0*x
    translate  <-1.7, -1.836302, 3.95>
  }
  cylinder { // R2RightHandCut1
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 1.0>
    rotate -90.0*y
    translate  <-1.2, -2.2, 3.95>
  }
  material {
    Brass_Metal
  }
  translate  3.4*x
}
#declare R2Hand1 = difference {
  box { // R2RightHandMain
    <-1, -1, -1>, <1, 1, 1>
    material {
      Brass_Metal
    }
    scale 0.4
    rotate -45.0*x
    translate  <-1.7, -1.836302, 3.95>
  }
  cylinder { // R2RightHandCut
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 1.0>
    rotate -90.0*y
    translate  <-1.2, -2.2, 3.95>
  }
  material {
    Brass_Metal
  }
}


#declare WheelDetailBase = difference {
  sphere { // WheelDetailOutside
    <0,0,0>,1
    scale <0.8, 1.0, 1.0>
    translate  -2.5*x
  }
  sphere { // WheelDetailInside
    <0,0,0>,1
    scale <0.4, 1.0, 1.0>
    translate  -2.5*x
  }
}
#declare WheelDetailBoxes = union {
  box { // WheelDetail2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <-90.0, 0.0, 0.0>
    translate  -1.5*x
  }
  box { // WheelDetail1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    translate  -1.5*x
  }               
}

#declare WheelDetailCSG = intersection {
  object { WheelDetailBase }
  object { WheelDetailBoxes }
  material {
    Brass_Metal
  }               
}                      

#declare WheelCSG4 = difference {
  cylinder { // R2Wheel4
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    rotate -90.0*y
    translate  <-1.5, 2.0, 1.2>
  }
  sphere { // WheelCut4
    <0,0,0>,1
    scale <0.7, 1.0, 1.0>
    translate  <-2.5, 2.0, 1.2>
  }
  material {
    Aluminum
  }
  rotate 180.0*z
  translate  4.0*y
}
#declare WheelCSG3 = difference {
  cylinder { // R2Wheel3
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    rotate -90.0*y
    translate  <-1.5, 2.0, 1.2>
  }
  sphere { // WheelCut3
    <0,0,0>,1
    scale <0.7, 1.0, 1.0>
    translate  <-2.5, 2.0, 1.2>
  }
  material {
    Aluminum
  }
  rotate 180.0*z
}
#declare WheelCSG2 = difference {
  cylinder { // R2Wheel2
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    rotate -90.0*y
    translate  <-1.5, 2.0, 1.2>
  }
  sphere { // WheelCut2
    <0,0,0>,1
    scale <0.7, 1.0, 1.0>
    translate  <-2.5, 2.0, 1.2>
  }
  material {
    Aluminum
  }
  translate  -4.0*y
}
#declare WheelCSG1 = difference {
  cylinder { // R2Wheel1
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    rotate -90.0*y
    translate  <-1.5, 2.0, 1.2>
  }
  sphere { // WheelCut1
    <0,0,0>,1
    scale <0.7, 1.0, 1.0>
    translate  <-2.5, 2.0, 1.2>
  }
  material {
    Aluminum
  }
}
#declare R2RadarCSG = difference {
  cylinder { // R2RadarMain
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 0.5, 0.5>
    translate  7.5*z
  }
  cylinder { // R2RadarCut
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 0.5, 0.7>
    translate  <0.0, -0.2, 7.4>
  }
  material {
    Brass_Metal
  }
  translate  -0.4*y
}
#declare R2Radar = union {
  sphere { // R2RadarSpot
    <0,0,0>,1
    scale 0.1
    translate  <0.0, -0.5475, 7.75>
  }
  cone { // R2RadarSpike
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.05, 0.05, 0.5>
    rotate -90.0*x
    translate  <0.0, -0.57598, 7.75>
  }
  cylinder { // R2RadarPost
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  6.7*z
  }
  object { R2RadarCSG }
  material {
    Brass_Metal
  }       
  rotate R2Degree * 2 * z
}
#declare MainArm = difference {
  cylinder { // ArmOuter
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 1.0, 1.0>
    rotate -90.0*x
    translate  <0.0, -0.5, 4.25>
  }
  cylinder { // ArmInner
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 0.7, 1.2>
    rotate -90.0*x
    translate  <0.0, -0.6, 4.25>
  }
  box { // ArmCut
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    translate  3.25*z
  }
  material {
    Aluminum
  }
}        
        




#declare Robot2 = union { // Robot2
  object { Right_Tread }
  object { Left_Tread }
  object { R2Hand2 }
  object { R2Hand1 }
  object { WheelDetailCSG             
           rotate rwheelrot * x
           translate  <0.0, 2.0, 1.2>
         }
  object { WheelDetailCSG      
           rotate rwheelrot * x
           translate  <0.0, -2.0, 1.2>
         }
  object { WheelDetailCSG      
           rotate -lwheelrot * x
           rotate 180 * z
           translate  <0.0, 2.0, 1.2>
         }
  object { WheelDetailCSG      
           rotate -lwheelrot * x
           rotate 180 * z
           translate  <0.0, -2.0, 1.2>
         }
  object { WheelCSG4 }
  object { WheelCSG3 }
  object { WheelCSG2 }
  object { WheelCSG1 }
  object { R2Radar }
  object { R2EyeLidCSG }
  object { // R2EyeLidCSG1->R2EyeLidCSG
    R2EyeLidCSG
    translate  0.9*x
  }
  object { R2Eye1 }
  object { // R2Eye2->R2Eye1
    R2Eye1
    rotate <0.0, 0.0, 0.0>
    translate  <0.9, 0.0, 0.0>
  }
  box { // R2Arm1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.3, 1.0, 0.3>
    translate  <-1.7, -0.5, 3.95>
  }
  box { // R2Arm2
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.3, 1.0, 0.3>
    translate  <1.7, -0.5, 3.95>
  }
  object { MainArm }
  box { // MainTorso
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.5, 1.0, 1.5>
    translate  <0.0, 0.0, 3.7>
  }
  box { // HeadFront
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.75, 0.53, 0.53>
    rotate -45.0*x
    translate  <0.0, -0.75, 6.0>
  }
  box { // HeadBack
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale 0.75
    translate  6.0*z
  }
  cylinder { // BodyFront
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.9>
    rotate -90.0*y
    translate  <1.45, -3.0, 1.2>
  }
  box { // Base
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <1.45, 3.0, 1.0>
    translate  1.2*z
  }                       
  scale <2.0, 2.0, 2.0> 
  translate <-8,4.4,0>
  rotate R2Degree * z
}






