// Persistence of Vision Ray Tracer Scene Description File
// File: factory.pov
// Vers: 3.1
// Desc: Included scene description file for the factory part of "Robot Factory" animation.
// Date: 01/14/00
//
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
// Copyright (c) Dan Lauer, 2000                               
//
// mailto:dlauer@optonline.net
//
// This is the Included scene description file for the factory part my "Robot Factory" Animation.
// It was created specifically for entry into the January 15, 2000 round of the
// Internet Ray Tracing Competition.  See http://www.irtc.org/.
//
// The code in this and the accompanying files may be used freely for non-commercial
// purposes without permission.  However, I would love to here from anyone with questions
// or comments.  Commercial uses other than those described in the STANDARD RAYTRACING
// COMPETITION COPYRIGHT require permission from the author.  Please contact me via e-mail.
//

#include "FedExBox.inc"

default { texture { pigment { rgb <1,0,0> } }}

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

//
// *******  Macros *********
//

#macro Bolts( p1, p2, scl)
  #local length = sqrt(pow((p1.x)-(p2.x),2)+pow((p1.y)-(p2.y),2)+pow((p1.z)-(p2.z),2));
  #local rivet_cnt = int(length/0.5);
  #local cnt = 0;
  #while (cnt <= rivet_cnt)
    sphere {
      <0, 0, 0>
      1.0       // radius of sphere
      scale scl
      translate Interpolate(cnt, 0, rivet_cnt, p1, p2)
    }
    #local cnt = cnt+1;
  #end  
#end

#macro Elevator (Width2, Depth2, Height2, Lift)
  #declare Width  = Width2 /2;
  #declare Depth  = Depth2 /2;
  #declare Height = Height2/2;
union { 
  union {
    difference { //Outer Box
      box { <Width - 0.1 , Depth - 0.1 , Height    >, <-Width + 0.1 , -Depth + 0.1 , -Height      > }
      box { <Width - 0.15, Depth - 0.15, Height+0.1>, <-Width + 0.15, -Depth + 0.15, -Height - 0.1> }
      material { Brushed_Aluminum }
    }
    difference { //Inner Box
      box { <Width - 0.15, Depth - 0.15, Height    >, <-Width + 0.15, -Depth + 0.15, -Height      > }
      box { <Width - 0.2 , Depth - 0.2 , Height+0.1>, <-Width + 0.2 , -Depth + 0.2 , -Height - 0.1> }
      material { ChromeTexture }
    }
    union { // Box Frame
      box { < Width        , Depth       , Height + 0.05>, <-Width       , Depth - 0.02, Height - 0.2 > }
      box { < Width        , Depth       ,-Height       >, <-Width       , Depth - 0.02,-Height + 0.2 > }
      box { < Width        , Depth       , Height + 0.05>, < Width - 0.2 , Depth - 0.02,-Height       > }
      box { <-Width        , Depth       , Height + 0.05>, <-Width + 0.2 , Depth - 0.02,-Height       > }
      Bolts(< Width-0.1, Depth, Height-0.1>, <-Width+0.1, Depth, Height-0.1>, <0.1, 0.05, 0.1>)
      Bolts(< Width-0.1, Depth,-Height+0.1>, <-Width+0.1, Depth,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(< Width-0.1, Depth, Height-0.1>, < Width-0.1, Depth,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(<-Width+0.1, Depth, Height-0.1>, <-Width+0.1, Depth,-Height+0.1>, <0.1, 0.05, 0.1>)
  
      box { < Width        ,-Depth       , Height + 0.05>, <-Width       ,-Depth + 0.02, Height - 0.2 > }
      box { < Width        ,-Depth       ,-Height       >, <-Width       ,-Depth + 0.02,-Height + 0.2 > }
      box { < Width        ,-Depth       , Height + 0.05>, < Width - 0.2 ,-Depth + 0.02,-Height       > }
      box { <-Width        ,-Depth       , Height + 0.05>, <-Width + 0.2 ,-Depth + 0.02,-Height       > }
      Bolts(< Width-0.1,-Depth, Height-0.1>, <-Width+0.1,-Depth, Height-0.1>, <0.1, 0.05, 0.1>)
      Bolts(< Width-0.1,-Depth,-Height+0.1>, <-Width+0.1,-Depth,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(< Width-0.1,-Depth, Height-0.1>, < Width-0.1,-Depth,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(<-Width+0.1,-Depth, Height-0.1>, <-Width+0.1,-Depth,-Height+0.1>, <0.1, 0.05, 0.1>)
  
      box { < Width        , Depth       , Height + 0.05>, < Width - 0.02,-Depth       , Height - 0.2 > }
      box { < Width        , Depth       ,-Height       >, < Width - 0.02,-Depth       ,-Height + 0.2 > }
      box { < Width        , Depth       , Height + 0.05>, < Width - 0.02, Depth - 0.2 ,-Height       > }
      box { < Width        ,-Depth       , Height + 0.05>, < Width - 0.02,-Depth + 0.2 ,-Height       > }
      Bolts(< Width, Depth-0.1, Height-0.1>, < Width, -Depth+0.1, Height-0.1>, <0.1, 0.05, 0.1>)
      Bolts(< Width, Depth-0.1,-Height+0.1>, < Width, -Depth+0.1,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(< Width, Depth-0.1, Height-0.1>, < Width,  Depth-0.1,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(< Width,-Depth+0.1, Height-0.1>, < Width, -Depth+0.1,-Height+0.1>, <0.1, 0.05, 0.1>)
  
      box { <-Width        , Depth       , Height + 0.05>, <-Width + 0.02,-Depth       , Height - 0.2 > }
      box { <-Width        , Depth       ,-Height       >, <-Width + 0.02,-Depth       ,-Height + 0.2 > }
      box { <-Width        , Depth       , Height + 0.05>, <-Width + 0.02, Depth - 0.2 ,-Height       > }
      box { <-Width        ,-Depth       , Height + 0.05>, <-Width + 0.02,-Depth + 0.2 ,-Height       > }
      Bolts(<-Width, Depth-0.1, Height-0.1>, <-Width, -Depth+0.1, Height-0.1>, <0.1, 0.05, 0.1>)
      Bolts(<-Width, Depth-0.1,-Height+0.1>, <-Width, -Depth+0.1,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(<-Width, Depth-0.1, Height-0.1>, <-Width,  Depth-0.1,-Height+0.1>, <0.1, 0.05, 0.1>)
      Bolts(<-Width,-Depth+0.1, Height-0.1>, <-Width, -Depth+0.1,-Height+0.1>, <0.1, 0.05, 0.1>)
  
      material { Steel }
    }
    translate z*Height
  }
  box { <Width - 0.2 , Depth - 0.2 , 0.0>, <-Width + 0.2 , -Depth + 0.2 , -0.1> // Elevator 
    material { RubberMat }
    translate  Height2*Lift*z
  }
}
#end



//
// *******  L I G H T S *******
//

#if (use_full_lights != yes)
  light_source {   // Light1
    <6.700, 5.200, 20.100>
    color rgb <1.000, 1.000, 1.000>
  }
#end

#if (use_full_lights)
// create a point "spotlight" (conical directed) light source 
#declare fl_bright = 0.6;
#macro factory_light(loc) 
  light_source {
    loc                     // light's position 
    color rgb <fl_bright, fl_bright, fl_bright>       // light's color
  //  spotlight               // this kind of light source
  //  point_at <loc.x, loc.y, 0>      // direction of spotlight
  //  radius 84               // hotspot (inner, in degrees)
  //  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  //  falloff 89               // intensity falloff radius (outer, in degrees)
    fade_distance 8
    fade_power 2
  }      
  cone {
  loc + 0.5*z,  0.0,
  loc - 0.19*z, 0.5
  open   
  pigment { Green }
}

#end

factory_light(< 10, 40, 16>)
factory_light(<  6, 35, 16>)
factory_light(< 10, 30, 16>)
factory_light(<  6, 25, 16>)
factory_light(< 10, 20, 16>)
factory_light(<  6, 15, 16>)
factory_light(< 10, 10, 16>)
factory_light(<  6,  5, 16>)
                     
#end                     
//
// ********  MATERIALS  *******
//

#include "factory.inc"

//
// ********  OBJECTS  *******
//
#declare ConveyerRail = union { // ConveyerRail
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 1.0, 0.2>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.07, 1.0, 0.02>
    translate  <0.05, 0.0, 0.2>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 1.0, 0.1>
    translate -1.2*z
  }
  material {
    YellowMetal
  }
}


#declare ConveyerLeg = union { 
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.2, 1.35>
    translate  -0.025*x
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.02, 1.35>
    translate  -0.2*y
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.22, 0.02>
    translate  -1.325*z
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.02, 1.35>
    translate  0.2*y
  }
  material {
    YellowMetal
  }
}

object {
  ConveyerRail
  scale <1.0, 15.75, 1.0>
  translate  <belt_center + 1.075, 27.5, 2.5>
}
object {
  ConveyerRail
  rotate z*180
  scale <1.0, 15.75, 1.0>
  translate  <belt_center - 1.075, 27.5, 2.5>
}

union { // The main conveyer Belt
  box { <belt_center-0.9, 12, 2.9>, <belt_center+0.9, 43, 3> }
  difference {
    cylinder { <belt_center-0.9, 12, 3-0.5>, <belt_center+0.9, 12, 3-0.5>, 0.5 }
    box {<belt_center-1.0, 12, 2.9>, <belt_center+1.0, 13, 2.0> }
  }
  difference {
    cylinder { <belt_center-0.9, 43, 3-0.5>, <belt_center+0.9, 43, 3-0.5>, 0.5 }
    box {<belt_center-1.0, 43, 2.9>, <belt_center+1.0, 42, 2.0> }
  }
  material {
    Belt_Mat
    translate  <0, (-(belt_cycle_count+belt_clock)*station_dist), 0>
  }
}
box { //underside of belt
  <belt_center-0.9, 12, 2.1>, <belt_center+0.9, 43, 2>
  material {
    Belt_Mat
    translate  <0, ((belt_cycle_count+belt_clock)*station_dist), 0>
  }
}
#declare cnt = 0;
#while (cnt <=10) //This is all of the chrome cylinders of the conveyer belt
  cylinder { <belt_center+1.05, 0, 0>, <belt_center-1.05, 0, 0>, 0.45
    material {
      SmearedChrome
      rotate x*(belt_cycle_count+belt_clock)*station_dist*360/(pi*0.9)
    }
    translate <0, Interpolate(cnt, 0, 10, 12, 43), 2.5>
  }                             
  object {
    ConveyerLeg
    translate  <belt_center+1.15, Interpolate(cnt, 0, 10, 12, 43), 1.35>
  }
  object {
    ConveyerLeg
    rotate z*180
    translate  <belt_center-1.15, Interpolate(cnt, 0, 10, 12, 43), 1.35>
  }
  cylinder { <belt_center+1.1, 0, 0>, <belt_center-1.1, 0, 0>, 0.1
    material {
      YellowMetal
    }
    translate <0, Interpolate(cnt, 0, 10, 12, 43), 1.2>
  }                             

  #declare cnt = cnt+1;
#end

#render concat("Belt at ",str((-(belt_cycle_count+belt_clock)*station_dist),0,4),"\n")


box { // RightSideWall
  <16, 12, -0.1>, <16.5, 57, 20>
  material {
    BlueCinderBlock
    rotate 90*x
  }
}
box { // RightSideWall Set back
  <20.5, -10, -0.1>, <20.8, 18, 20>
  material {
    BlueCinderBlock
    rotate 90*x
  }
}
box { // RightSideWall Set back
  <16, 14, -0.1>, <22.1, 14.1, 20>
  material {
    BlueCinderBlock
    rotate 90*x
  }
}

box {  // RearWall
   <-0.1, 56, -0.1>, <16.1, 57, 20>
  material {
    BlueCinderBlock
    rotate -90.0*x
  }
}

box {  // Front Wall
   <-0.1, -1, -0.1>, <21.1, 0, 20>
  material {
    BlueCinderBlock
    rotate -90.0*x
  }
}

box { // LeftSideWall
  <-0.1, -0.1, -0.1>, <0.0, 56.1, 20>
  material {
    BlueCinderBlock
    rotate 90*x
  }
}

plane { // Floor
  z,0
  material {
    T_Stone1
  }
}

box { 
  <16.2, 9.1, 0 >, <16.3 , 12 , 9>
  material { Brushed_Aluminum }
}
box { 
  <16.2, 9.1, 9 >, <24, 12 , 9.1>
  material { Brushed_Aluminum }
}
union {
  box { <16.1, 9.2, 0>, <16.4, 11.8, 0.2 > }
  box { <16.1, 9.2, 2.9>, <16.4, 11.8, 3.1 > }
  box { <16.1, 9.2, 5.9>, <16.4, 11.8, 6.1 > }
  box { <16.1, 9.2, 8.8>, <16.4, 11.8, 9.0 > }
  Bolts(<16.1, 9.3, 0.1>, <16.1,  11.7, 0.1>, <0.1, 0.05, 0.1>)
  Bolts(<16.1, 9.3, 3.0>, <16.1,  11.7, 3.0>, <0.1, 0.05, 0.1>)
  Bolts(<16.1, 9.3, 6.0>, <16.1,  11.7, 6.0>, <0.1, 0.05, 0.1>)
  Bolts(<16.1, 9.3, 8.9>, <16.1,  11.7, 8.9>, <0.1, 0.05, 0.1>)

  box { <16.1, 9.0, 0>, <16.4, 9.2, 9.0 > }
  box { <16.1, 11.8, 0>, <16.4, 12, 9.0 > }
  Bolts(<16.1, 9.1, 0.1>, <16.1,  9.1, 8.9>, <0.1, 0.05, 0.1>)
  Bolts(<16.1, 11.9, 0.1>, <16.1,  11.9, 8.9>, <0.1, 0.05, 0.1>)

  material { Steel }
}


// The chrome wall where the Fedex boxes come and go.
box { 
  <17.2, 0, 0 >, <17.3 , 2.9 , 9>
  material { Brushed_Aluminum }
}
box { 
  <17.2, 0, 9 >, <24 , 2.9 , 9.1>
  material { Brushed_Aluminum }
}
union {
  box { <17.1, 0.2, 0>, <17.4, 2.8, 0.2 > }
  box { <17.1, 0.2, 2.9>, <17.4, 2.8, 3.1 > }
  box { <17.1, 0.2, 5.9>, <17.4, 2.8, 6.1 > }
  box { <17.1, 0.2, 8.8>, <17.4, 2.8, 9.0 > }
  Bolts(<17.1, 0.3, 0.1>, <17.1,  2.7, 0.1>, <0.1, 0.05, 0.1>)
  Bolts(<17.1, 0.3, 3.0>, <17.1,  2.7, 3.0>, <0.1, 0.05, 0.1>)
  Bolts(<17.1, 0.3, 6.0>, <17.1,  2.7, 6.0>, <0.1, 0.05, 0.1>)
  Bolts(<17.1, 0.3, 8.9>, <17.1,  2.7, 8.9>, <0.1, 0.05, 0.1>)

  box { <17.1, 0.0, 0>, <17.4, 0.2, 9.0 > }
  box { <17.1, 2.8, 0>, <17.4, 3.0, 9.0 > }
  Bolts(<17.1, 0.1, 0.1>, <17.1,  0.1, 8.9>, <0.1, 0.05, 0.1>)

  material { Steel }
}


box { // The Fedex box conveyer Belt 
  <18, -10, 0>, <20, 25, 0.023>
  material {
    Belt_Mat
    translate  y*-5*(A_cycle_count+sin(Interpolate(max(0.31,max(0.7,A_clock)), 0.31, 0.7, -pi/2, pi/2)/2))
  }
}

