#include "colors.inc"
#include "metals.inc"
#include "woods.inc"

//#declare calidad=false;

#include "rbox.inc"
#include "robot.inc"


#declare cielo   = true;
#declare colinas = true;
#declare sol     = true;
#declare suelo   = true;
#declare niebla  = false;

#declare long_muslo       = 1.25;
#declare long_pantorrilla = 1.25;






//     #declare i=(clock-12)/2;
//     #declare camera_location = <98.5,0.5,i*7-4>;
//     #declare camera_look_at  = <100,0.5,i*7-4>;
     #declare camera_location= <-4,0.5,-5>
     #declare camera_look_at = <0,0,0>

     camera{
        location camera_location
        look_at  camera_look_at
     }
     
   #declare expl1=object{diana_1 translate <0,0,-3>}
   #if(clock<.1)
      object{expl1}
      #else
      #declare explode_object=object{expl1}
         
      #declare explode_start = .12;
   #declare time_scale = 1;
   #declare object_corner1 = min_extent(expl1);
   #declare object_corner2 = max_extent(expl1);
   #declare object_hollow = false;
   #declare particle_texture=T_Wood7
   #declare particle_res = <3, 4, 7>;
   #declare exp_location = <-3, 0, -3>;
   #declare exp_strength = 3;
   #declare exp_gravity = 10;
   #declare exp_spin = 1.2;
   #declare exp_seed = 87632;
   #declare ground_plane = true;
   #declare ground_reflection = .8;
   #declare max_bounces = 6;
   #declare exp_turb = 1;
   #declare scale_turb = 1;
   #declare rotate_turb = 1;
   #declare vel_turb = .3;
   #declare dir_turb = .1;
   #declare spin_turb = .5;
   #include "explode.inc"
   #end
   
   #declare expl2=object{diana_2}
   #if(clock <.3)
     object{expl2}
     #else
     #declare explode_object=object{expl2}
     #declare exp_location=<-3,0,0>
     #declare explode_start=.32;
     #declare object_corner1=min_extent(expl2)
     #declare object_corner2=max_extent(expl2)
     #declare exp_seed=1231;
     #include "explode.inc"
   #end
   #declare expl3=object{diana_3 translate <0,0,3>}
   #if(clock <.6)
     object{expl3}
     #else
     #declare explode_object=object{expl3}
     #declare exp_location=<-3,0,3>
     #declare explode_start=.62;
     #declare object_corner1=min_extent(expl3)
     #declare object_corner2=max_extent(expl3)
     #declare exp_seed=42342;
     #include "explode.inc"
  #end
   
     
     /*translate <100,0,-3>}
     object{diana_2 
     //rotate -90*z 
     translate <100,0,0>}
     object{diana_3 
     //rotate -90*(1-i)*z 
     translate <100,0,3>}*/
       






#declare effect_type       = "Sun"
#declare effect_location   = <5000,2200,0>;
#declare effect_brightness = 1.5 ;
  
#if (sol & calidad)
   #declare options_only      = true;
   #include "lens.inc"
   #undef effect_type
   #declare glow_type         = 2;
   #declare options_only      = false;
   #include "lnsefcts.inc"
#end   

#if (cielo & calidad)
   sky_sphere {
   pigment {
      gradient y
      pigment_map {
         [0 rgb <.957,0.497,0>*1.5]         
         [0.8 rgb <.4, .6, .8>]
      }
   }
   }
   
   object{cloud1}
   object{cloud2}
   object{cloud3}
   #else
   background{color rgb .5}
              
#end

#if (!calidad)
#declare gradiente_x=texture{
        pigment{gradient x 

                color_map {
                [0 rgbt <0,1,0,0>]
                [0.1 rgbt <0,1,0,0>]
                [0.1 rgbt<0,0,0,0>]
                [1 rgbt <0,0,0,0>]
                }
            }
        finish{ambient 0.7}
}
#declare gradiente_z=texture{
        pigment{gradient z

                color_map {
                [0 rgbt <0,1,0,0>]
                [0.1 rgbt <0,1,0,0>]
                [0.1 rgbt<0,0,0,1>]
                [1 rgbt <0,0,0,1>]
                }
            }
        finish{ambient 0.7}
        }    
 
#end
   
#if (colinas)        
   height_field { 
   tga "test2.tga"
   #if (calidad)   smooth #end
   translate <-.15,-.5,-.15>
   
   rotate <0,180,0>
     
//   water_level 16/256
   scale <12000,1000,12000> 
   #if (calidad)
      texture{ 
         pigment {color <.88, .74, .65>}
         normal {crackle 1 turbulence .8}
      }
   finish{ambient .3}
      
   #else
      texture{gradiente_x}
      texture{gradiente_z}
   #end
  
   translate <-200, 0 ,-200>
   translate <-90,0,-180 >
   rotate <0,-90,0>
   }
#end  
  
#if (niebla & calidad)   
  
   fog {
      fog_type 2
      color rgbt <0.7,0.7, 0.7, 0.25>
      distance 5
      fog_offset 0
      fog_alt 1
      turbulence 0.25
      omega .2
      lambda .9
      octaves 3
   }
#end

#if (suelo)   
   
   plane { y,0 
      #if (calidad)
          texture{
        pigment {color <.85, .7, .6>
        }
        finish{ ambient .5}
        normal{
        crackle 1
        turbulence 0.8
        //scale <1,0.1,1>
        }
      }        
   #else
      texture{gradiente_x}
      texture{gradiente_z}
   #end

    translate <-200,0,-200>}
#end

#declare semilla=seed(1231*clock)
#declare max_bullets=rand(semilla)*16;
#declare i=0
#while (i<max_bullets)
   object{trazadora translate <rand(semilla)*12-3,0.1+rand(semilla)/2, -2.5 +6*clock+rand(semilla)>}
   #declare i=i+1;
#end   


#declare light_color = <0.8, 0.5, 0.5>;

light_source { effect_location colour light_color }             //Luz principal. La que va con el sol
//light_source { effect_location colour light_color/3 shadowless} //Luces de relleno, para que se note un poco
//light_source { camera_location colour White/10 shadowless}      //las normales del terreno
           