// Macros para construir un robot caminante
// Unica opcin: valor entre 0 y 1 

#ifndef (calidad)
   #declare calidad=true;
#end   

#declare textura_clara=
   texture{
  pigment {color rgb <0.363, 0.600, 0.347>}
  finish { ambient 0.7
           diffuse 0.8
           specular 0.2
           roughness 0.1
           metallic
  }
}

   


#declare textura_oscura=

   texture{
  pigment {color rgb <0.263, 0.400, 0.247>}
  finish { ambient 0.7
           diffuse 0.8
           specular 0.2
           roughness 0.1
           metallic
  }
}



#macro angulo(a,b,c) //TEOREMA DEL COSENO
  degrees(acos( (pow(c,2) -pow(a,2) - pow(b,2)) / (-2*a*b)))
#end  

#macro cilindro_alambre( longitud, radio, radio_alambre, segmentos)
   #local i=0;
   #local previo=<0,radio,0>;
   #while (i<360)
      cylinder{<0,radio,0>,<longitud,radio,0>,radio_alambre rotate i*x}
      #local i=i+(360/segmentos);
      #local previo2=vrotate(previo,(360/segmentos)*x);
      #local parcial=cylinder{previo,previo2,radio_alambre}
      object{parcial}
      object{parcial translate longitud*x}
      #declare previo=previo2;
   #end 
#end

#declare trazadora =

#if (calidad)
union {
   intersection{
      union{
      sphere{0,.5 pigment{color rgbt <1,1,1,.5>} finish{ambient 1} scale <4,.02,.02>}
      sphere{0,1 pigment{color rgbt <1,1,1,.8>} finish{ambient 1} scale <4,.02,.02>}
      }
      box{<-4,-.02,-.02>,<0,.02,.02>}
   }
   sphere{0,.02 pigment{color rgb 1} finish{ambient 1} scale <2,1,1>}
}

#else
cylinder{<-4,0,0>,0,0.02 pigment {color rgb 1} finish{ambient 1}}
#end



#declare rastro_cohete=

#if(calidad)
intersection{
   union{
      sphere{0,1 pigment{gradient y color_map {
            [0.1 color rgb 1]
            [0.2 color rgbt <1,1,1,0.6>]
            [0.6 color rgbt <1,1,0,0.8>]
            [0.8 color rgbt <1,0,0,0.85>]
            [1   color rgbt <1,1,1,0.95>]
            }}
            finish{ambient 1}
            scale <8,.04,.04>
            }  
      
      light_source{<-.2,0,0> colour rgb <1,1,0> fade_distance 2 fade_power 4}
      }        
   box{<-8,-.1,-.1>,<0,.1,.1>}
}
#else
   cylinder{<-8,0,0>,0,0.04 pigment{color rgb 1 } finish{ambient 1}}
#end   

#declare cohete =
#if(calidad)
union {
   cylinder{<0,0,0>,<1,0,0>,0.035}
   sphere{0,0.035 scale <2,1,1> translate <1,0,0>}
   texture{textura_oscura}
   }
#else
cylinder{0,<1,0,0>,0.035 pigment{color rgb <1,0,0>} finish{ambient 1}}
#end

#declare multiguns=
#if(calidad)  

difference {
   union{
   #local i=0;
   #while (i<360) //Tubos de can
      cylinder{<0.45,0,0>,<1.3,0,0>,0.035 translate <0,0.07,0> rotate i*x texture{T_Chrome_2A} finish{ambient .4}}
      #local i=i+60;
   #end
   cylinder{<.8,0,0>,<.83,0,0>,.12 texture{textura_clara}}      //Abrazaderas
   cylinder{<1,0,0>,<1.03,0,0>,.12 texture{textura_clara}}
   }
   
   #local i=0;
   #while (i<360) //Huecos de can
      cylinder{<0.3,0,0>,<2,0,0>,0.025 texture{T_Chrome_1A} finish{ambient .5} translate <0,0.07,0> rotate i*x}
   #local i=i+60;
   #end
   bounded_by{cylinder{<0.45,0,0>,<1.3,0,0>, .12}}
   }
#else
   cylinder{<0.4,0,0>,<1.3,0,0>,.105}
#end


#declare mgun=
#if(calidad)
union
{
   box{<-.31,-.2,-.2>,<.2,.2,.2>}
      
   cylinder{<.4,0,0>,<-.3,0,0>,.15 }
   cone{<.4,0,0>,.15,<.45,0,0>,.1 }
/*   difference {
      box{<-.05,-0.01,0>,<.05,.05,0.38>}
      box{<-0.04,0,0>,<0.04,0.04,0.4> texture{T_Chrome_1A}}
      rotate <40,0,0>}*/
      
   motion_blur{
      multiguns
      rotate 2.5*360*clock*x
   }                        
}   
#else
union{
   cylinder{<-.3,0,0>,<0,0,0>,0.15}
   object{multiguns}
}
#end         

   
#declare cannon=
#if(calidad)
union{
   difference{
      rbox(-1,-.4, -.2, .3, .3, .2, .05)
      #local i=2;
      #while (i<10) //Rejillas
      box{<-.01,0,-2>,<.01,.3,1> rotate <0,0,-30> translate <i*-.1,.1,1> pigment{color rgb 0} finish{ambient 1}}
      #local i=i+1;
      #end
   }
   box{<-.9,-.3,-.15>,<.2, .25, .15> pigment{color rgb .2} finish{ambient .6}}//Interior en las rejillas
   
   cone{<0,0,.15>,.2,<0,0,.25>,0.15}    //Cilindro externo
   rbox(-.5,.07,-.1,  0.5,.27,.1,0.03)
   box{<-.5,.1,-.05>,<.51,.2,.05> pigment{color rgb 0}}
   box{<0,-.2,.2>,<-.5,-.35,.22> }
   cylinder{<0,0,-.2>,<0,0,-.5>,0.2 texture{T_Chrome_2B} finish{ambient .6}}    //Unin con robot
   difference{
      union{
      cylinder{<.3,0,0>,<2,0,0>,.05 }   //Can
      cylinder{<1.9,0,0>,<2.2,0,0>,0.07}
      }
      cylinder{<0,0,0>,<3,0,0>,.035 texture{T_Chrome_1A}}   //Hueco
   }
   translate <0,0,.5>
   
   texture{textura_oscura}
   
     texture{
     pigment{
        image_map{
           png "\proyecto\kerberos\bandera.png" once interpolate 2
           transmit 0, 1
        }
     scale <-1,.5,.5>
     translate <.2,-.35,-.5>
    }
    finish {
       ambient 0.7
       diffuse 0.8
       specular 0.2
       roughness 0.1
       metallic
   }
  }    
  

   
}

#else
union{
 box{<-1,-.4,-.2>,<.3,.3,.2>}
 cylinder{<.3,0,0>,<2,0,0>,0.05}
 pigment{color rgb <0,1,1>}
 finish{ambient .7}
 }
#end 

   
#declare lanzacohetes=
#if(calidad)
union{  //Lanzacohetes derecho
    cylinder{<0,0,.25>,<0,0,.5>,.2 }
    
    difference{
    rbox( -.75, -.5,-.25, .75, .5,.25,.1)
    
    #declare i=-.35;
    #while (i<.4)
        #declare j=-.15;
        #while (j<.2) //Huecos de los cohetes
           cylinder{<-1,i,j>,<1,i,j>,.04 texture{T_Chrome_1A}}
           #declare j=j+.1;
        #end
        #declare i=i+.1;
    #end
    bounded_by{box{<-.75,-.5,-.25>,<.75,.5,.25>}}
    }
//    pigment{color rgb <1,0,0>}
//    finish{ambient .5}
    translate <0,0,-.5>
  texture{textura_oscura}
  texture{
     pigment{
        image_map{
           png "\proyecto\kerberos\bandera.png" once interpolate 2
           transmit 0, 1
        }
     scale <1,.5,.5>
     translate <-.5,-.25,-.5>
    }
    finish {
       ambient 0.7
       diffuse 0.8
       specular 0.2
       roughness 0.1
       metallic
   }
  }    
}     
#else
box{<-.75,-.5,-.25>,<.75, .5, .25> pigment{color rgb <0,1,1>} finish{ambient .7}}

#end
  
#macro robotwlk(robot_step)
   #local step_number=1 ;
   #local step_advance=1/15;
   #local i=0 ;
   #declare long_muslo=1.25;
   #declare long_pantorrilla=1.25;

   #declare robot_max_length = sqrt( pow( long_paso/2, 2) + pow( alt_eje, 2) ) ;
   #declare angle_width      = degrees( acos( alt_eje / robot_max_length)) * 2;
   #declare clock_preview    = true;
   #declare mclock           = robot_step;
   #declare clock_repeat     = 2;            
   #debug concat(str(robot_step,4,4),"\n")
   #switch (robot_step)
      #range (0,.499)
         #declare clock_type         = "J"                               
         #include "clockmod.inc" 
         #declare robot_eje_pos      = <long_paso/4 + long_paso*robot_step,alt_eje + mclock*0.2,0>;
         #declare robot_pie_izq_pos  = <long_paso*robot_step*2,mclock*alt_max_pie,0>;
         #declare robot_pie_dcho_pos = <long_paso/2,0,0>;
         #declare longitud_izq       = vlength (robot_pie_izq_pos - robot_eje_pos);
         #declare longitud_dcha      = vlength (robot_pie_dcho_pos - robot_eje_pos);
      #break
      #else
         #declare clock_type         = "J"
         #include "clockmod.inc"                                               
         #declare robot_eje_pos      = <long_paso/4 + long_paso * robot_step, alt_eje+ mclock*0.2,0>;
         #declare robot_pie_izq_pos  = <long_paso,0,0>;
         #declare robot_pie_dcho_pos = <long_paso/2 + long_paso * (robot_step-.5)*2,mclock*alt_max_pie,0>;
         #declare longitud_izq       = vlength (robot_pie_izq_pos - robot_eje_pos);
         #declare longitud_dcha      = vlength (robot_pie_dcho_pos - robot_eje_pos);
      #break
   #end
   #declare angulo_cm_dcha         = angulo(long_muslo,longitud_dcha,long_pantorrilla); 
   #declare angulo_cm_izq          = angulo(long_muslo,longitud_izq,long_pantorrilla);                                                    
   #declare vector_cadera_pie_dcho = robot_eje_pos-robot_pie_dcho_pos;
   #declare angulo_vert_pie_dcho   = (degrees(acos( vector_cadera_pie_dcho.y / vlength(vector_cadera_pie_dcho))) * vector_cadera_pie_dcho.x ) / abs(vector_cadera_pie_dcho.x);
   #declare pos_rodilla_dcha       = vrotate(-long_muslo*y, -(angulo_cm_dcha+angulo_vert_pie_dcho)*z) + robot_eje_pos;
   #declare vector_pie_rodilla_dcha= robot_pie_dcho_pos-pos_rodilla_dcha;
   #declare grados_dcha            = degrees(asin(vector_pie_rodilla_dcha.x/long_pantorrilla));      
   #declare vector_cadera_pie_izq  = robot_eje_pos-robot_pie_izq_pos;
   #declare angulo_vert_pie_izq    = (degrees(acos( vector_cadera_pie_izq.y  / vlength(vector_cadera_pie_izq)))  * vector_cadera_pie_izq.x) / abs(vector_cadera_pie_izq.x);
   #declare pos_rodilla_izq        = vrotate(-long_muslo*y, -(angulo_cm_izq+angulo_vert_pie_izq)*z) + robot_eje_pos;
   #declare vector_pie_rodilla_izq = robot_pie_izq_pos-pos_rodilla_izq;
   #declare grados_izq             = degrees(asin(vector_pie_rodilla_izq.x/long_pantorrilla));
#end

#if(calidad)
#declare cubierta_pantorrilla=
   difference { //Cubierta
      prism {                 
         cubic_spline
         conic_sweep
         -1.15,-0.5, 15
         <-.1,-1>,
         <-2,-1>, <-1.25,-1.25>, <-1,-2>,
         < 1,-2>, < 1.25,-1.25>, < 2,-1>,
         < 2, 1>, < 1.25, 1.25>, < 1, 2>
         <-1, 2>, <-1.25, 1.25>, <-2, 1>,
         <-2,-1>,<.1,.1>
         translate <0,1,0>
         scale <0.2,2.2,.2>
         }
         
      prism { //Hueco de la cubierta                 
         cubic_spline
         conic_sweep
         -2,-0.5, 15
         <-.1,-1>,
         <-2,-1>, <-1.25,-1.25>, <-1,-2>,
         < 1,-2>, < 1.25,-1.25>, < 2,-1>,
         < 2, 1>, < 1.25, 1.25>, < 1, 2>
         <-1, 2>, <-1.25, 1.25>, <-2, 1>,
         <-2,-1>,<.1,.1>
         
         translate <0,1,0>
         scale <0.2,2.2,.2>*.9
         }
         
      intersection { //Para practicar el espacio trasero para que pueda hacer el giro
         plane{y, 0 rotate -30*z}
         plane{x,0}
      }
      
      intersection { //Huecos laterales
         plane{y,-.1 rotate  20*x}
         plane{z ,-.25}
      }
   
      intersection {
         plane{y,-.1 rotate -20*x}
         plane{-z, -.25}
      }
      
      box{<-2,0,-.1>,<0,.4,.1> }
      translate <0,-1.5,0>    
   }      
#end   
   

#declare dedo=
#if(calidad)
union {
   cylinder {
      <.25,.1,-.15>,<.25,.1,.15>,.05
      }
   
   prism {
      linear_spline
      -.15,.15,9
      <.25,.1>, <.25,.05>,
      <.30, 0>, <.65, 0>,
      <.66,.06>,
      <.5, .15>,
      <.4, .2>,
      <.25 , .15>,
      <.25,.10>
      rotate -90*x
      }
      
   translate <-.25,0,0>
   texture{T_Chrome_2A }      
}
#else
cylinder{<.25,.1,0>,<.66,.1,0>,.1 pigment{color rgb <0,1,0>} finish{ambient .7}}
#end
      

#macro pie(grados)
#if(calidad)
   prism {
      linear_spline
      .1, .2, 8,
      <-.25,-.15>,<-.15,-.25>,
      < .15,-.25>,< .25,-.15>,
      < .25, .15>,< .15, .25>,
      <-.15, .25>,<-.25, .15>
      texture{T_Chrome_1A}
   }
         
   box {
      <-.1,.2,.15>,<.1,.5,-.15> 
      texture{T_Chrome_1A}
   }
   
   cylinder {
      <0,.5,.14>,<0,.5,-.14>,0.1
      texture{T_Chrome_3A}
   }
#else
   cylinder{<0,0,0>,<0,0.5,0>,.15 pigment{color rgb <0,1,0>} finish{ambient .7}}
#end      
   
   
   #local punto_giro = vrotate (<.15,.2,0>, -grados*z) +.25*x;
   #local i=0;
   #while (i<360)
      object {dedo rotate -grados*z translate +.25*x rotate i*y}
      #if(calidad)
      cylinder {
         <.4,.2,-.1>,<.4, .2, -.08>, 0.05 
         translate -.25*x 
         rotate -grados*z 
         translate +.25*x 
         rotate i*y 
         texture{T_Chrome_4A}
      }
      
      cylinder {
         <.4,.2,-.02>,<.4, .2, .02>, 0.05 
         translate -.25*x 
         rotate -grados*z 
         translate +.25*x 
         rotate i*y 
         texture{T_Chrome_4A}
      }
      
      cylinder {
         <.4,.2,.08>,<.4, .2, .1>, 0.05
         translate -.25*x 
         rotate -grados*z 
         translate +.25*x 
         rotate i*y 
         texture{T_Chrome_4A}
      }
      
      cylinder {
         <.4,.2,-.08>,<.4,.2,-.02>, 0.05 
         translate -.25*x 
         rotate -grados*z 
         translate +.25*x 
         rotate i*y 
         texture{T_Chrome_5A} 
      }
      
      cylinder {
         <.4,.2, .08>,<.4,.2, .02>, 0.05 
         translate -.25*x 
         rotate -grados*z 
         translate +.25*x 
         rotate i*y 
         texture{T_Chrome_5A} 
      }

      cylinder {
         <.1,.4,.05>,  punto_giro+.05*z,.03 
         texture {T_Chrome_5A}
         rotate i*y
      }
      
      cylinder {
         <.1,.4,-.05>, punto_giro-.05*z,.03 
         texture{T_Chrome_5A} 
         rotate i*y
      }
      
      #end
      #local i=i+90;
   #end
#end


#declare muslo = 
#if(calidad)

difference{
   union {
     difference {
        cylinder{<0,0,-.1>,<0,0,.1>,0.15 }
        cylinder{<0,0,-.2>,<0,0,-.09>,0.12 }
        cylinder{<0,0,.2>,<0,0,.09>,0.12 }
        }
     difference {
        cylinder{<0,-1.25,-.1>,<0,-1.25,0.1>,.15 }
        cylinder{<0,-1.25,-.2>,<0,-1.25,-.09>,.12 }
        cylinder{<0,-1.25,.2>,<0,1.25,.09>,.12 }
        }     
        
     union {
        #local i=0;
        #while (i<360)
           cylinder{<0,.1,-.09>,<0,.1,.09>,0.02 rotate <0,0,i> texture{T_Chrome_1A}}
           cylinder{<0,.1,-.09>,<0,.1,.09>,0.02 rotate <0,0,i> texture{T_Chrome_1A} translate -1.25*y}
           #local i=i+30;
        #end
     }
                
     difference {
        union{
           box{<-.14,0,-.089>,<.14,-1.25,0.089> texture{pigment{image_map{png "c:\proyecto\kerberos\parrilla.png" interpolate 2}}
           scale .5}
           finish{ambient .7}
           
           }
           
           box{<.15,0,-.1>,<.12,-1.25,.1> }
           box{<-.15,0,-.1>,<-.12,-1.25,.1> }
        }
     }
  }
  
  cylinder{<0,-1.25,-.05>,<0,-1.25,0.05>, 0.27}

//  texture{T_Chrome_5A}
}

#else

cylinder{0,<0,-1.25,0>,.1 pigment{color rgb <0,1,0>} finish{ambient .7}}
#end

#declare pantorrilla = 
#if(calidad)

union {
   object{cubierta_pantorrilla}      
   box{<-.15,0,-.089>,<.15,-0.75,.089>}
   box{<-.1,-.74,-.1>,<.1,-1.25,.1>}
//   texture{T_Chrome_3A}
   }
#else
cylinder{0, <0,-1.25,0>,0.1 pigment{color rgb <0,1,0>} finish{ambient .7}}
#end   

#if(calidad)
#declare cabina_delantera=
union{
   sphere{0,1 scale <1.25,.5,.5>
      bounded_by{box{<0,0,-1>,<2,.5,1>}}
   }   
   sphere{0,1.001 scale <1.25,.5,.5>
      texture{pigment{color rgb .1}   
         finish { ambient 0.2 diffuse 0.0 reflection 0.12 specular 15.0 roughness 0.001 }
      }
      clipped_by{box{<0,0.15,-1>,<2,.37,1>}}   
    }
   torus{1, .025 scale <1.25,1,.5> texture{textura_clara}}    
   cone{0,1,<0,-.1,0>,.9 scale <1.25,1,.5>}
   torus{.9, .025 scale <1.25,1,.5> translate <0,-.1,0> texture{textura_clara}}    
//   texture{T_Chrome_5A 
//   finish{ambient .5}
//   }
   bounded_by{box{<0,-1,-.5>,<2,1,.5>}}
}

#macro gun_turret(rotation, disparo)
  union{
     cone{<0,.62,0>,0.4,<0,0.35,0>,0.25}
     box{<-.1,0.35,.2>,<.1,0,.23> }
     box{<-.1,0.35,-.2>,<.1,0,-.23>}
     cylinder{<0,0,-.23>,<0,0,.23>,0.1}
     cone{<0,0,.23>,.1,<0,0,.25>,.08 }
     cylinder{<0,0,.23>,<0,0.35,.23>,0.03 }
     sphere{<0,0,.23>,0.03 }

     cone{<0,0,-.23>,.1,<0,0,-.25>,.08}
     cylinder{<0,0,-.23>,<0,0.35,-.23>,0.03 }
     sphere{<0,0,-.23>,0.03 }     
     
     
     
     object{mgun 
     //translate <.4,0,0> 
      rotate rotation.z*z 
      //texture{T_Chrome_3A} 
      //finish{ambient .6}
      }
      
     #if( disparo)
     sphere{
        0, 2
        hollow
        texture{pigment{rgbt 1}}
        interior{
        media{
        emission 1
        ////scattering {1 ,<.5,.5,0>} 
        intervals 2
        samples 1,2
        confidence 0.9999
        variance 1/1000
        density{
        spherical
        #local turbulencia = seed(clock);
 
        turbulence <rand(turbulencia), rand(turbulencia), rand(turbulencia)>
        color_map {
        [0 color rgbt <0,0,0,1>]
        [.25 color rgb <1,1,.5>]
        [.5 color rgb <1,.2,.1>]
        [.75 color rgbf <1,1,.8,.1>]
        [1 color rgbt <0,0,0,.1>]
 
        }
        }
        }
        }
        scale <1,.3,.3> *((rand(turbulencia)/2)+0.5)
        translate <1.4,0,0>
        rotate rotation.z*z
        }
     light_source{<1.4,0,0> rgb <1,1,0> fade_distance 0.5 fade_power 2 media_interaction off rotate rotation.z*z}
     #end
     
      
      
     rotate rotation.y*y
     }
#end



#declare cabina_motor=
union{
   cone{<0,0,-.2>,.25,<0,0,-.65>,.2}
   cone{<0,0,0.2>,.25,<0,0,0.65>,.2}
   cylinder{<0,0,.2>,<0,0,-.2>,0.25}
   
   cylinder{<0,-.5,-.25>,<0,-.5,.25>,.1}
   
   torus{1,0.025 scale <1.25,1..5> texture{textura_clara}}
   cylinder{0,<0,-.1,0>,1 scale <1.25,1,.5>}
   torus{1,0.025 scale <1.25,1,.5> translate <0,-.1,0> texture{textura_clara}}
//   torus{1,0.075 scale <1.25,1,.5> translate <0,0.2,0> clipped_by{box{<0,0.1,-1>,<-2,0.3,1>}}}
   cylinder{0,<0,0.1,0>,1 scale <1.25,1,.5> clipped_by{plane{x,0}}}
   sphere{0,1 scale <1.25,.5,.5> clipped_by{box{<0,0.1,-.5>,<-2,1,.5>}}}


   union{
     difference{union{ rbox(-1.25,.2,.2,0,.3,.4,0.02)}
                box{<-2,.22,.22>,<-1,.28,.38> pigment{color rgb 0}}
                
     texture{textura_clara}}
                
     union{rbox(-1,0,.15,-.75,.35,.45,0.05)           texture{textura_oscura}}
                
     box{<-0.001,-.02,-0.08>,<0.001,0.02,0.08> rotate <0,0,60> translate <-1.25,.23,.3> 
     texture{textura_oscura}
     
     }
     box{<-0.001,-.02,-0.08>,<0.001,0.02,0.08> rotate <0,0,60> translate <-1.25,.27,.3> 
     texture{textura_oscura}
     }
   }
//

   union{
     difference{union{ rbox(-1.25,.2,-.4,0,.3,-.2,0.02)}
                box{<-2,.22,-.22>,<-1,.28,-.38> pigment{color rgb 0}}
                texture{textura_clara}
                }
     union{rbox(-1,0,-.45,-.75,.35,-.15,0.05) texture{textura_oscura}}           
                
     box{<-0.001,-.02,-0.08>,<0.001,0.02,0.08> rotate <0,0,60> translate <-1.25,.23,-.3>
     texture{textura_oscura}
     }
     box{<-0.001,-.02,-0.08>,<0.001,0.02,0.08> rotate <0,0,60> translate <-1.25,.27,-.3>
     texture{textura_oscura}
     }
                
   }
   
   cylinder{<-1,0,-.15>,<-.5,-.25,-.2>,0.1 texture{T_Chrome_1A}}
   cylinder{<-1,0,-.15>,< 0, -.5, -.25>,0.075 texture{T_Chrome_3A finish{ambient .5}}}
   cylinder{<-1,0, .15>,<-.5,-.25, .2>,0.1 texture{T_Chrome_1A}}
   cylinder{<-1,0, .15>,< 0, -.5,  .25>,0.075 texture{T_Chrome_3A finish{ambient .5}}}
   
   cylinder{<0,-.5,-.5>,<0,-.5,.5>,0.14 pigment{color rgb 1} finish{ambient .6}}
   cylinder{<0,-.5,-.15>,<0,-.5,-.35>,0.17 texture{T_Chrome_3A finish{ambient .5}}}
   cylinder{<0,-.5, .15>,<0,-.5, .35>,0.17 texture{T_Chrome_3A finish{ambient .5}}}
   
   
   

   difference{  //Radiadores
   
   prism{
      0,.31,10
      <0,-.5>,<.3,-.5>,<0.25,-0.6>,<0,-0.6>,<-.8,-.3>,
      <-.8,.3>,<0,0.6>,<0.25,0.6>,<.3,.5>,<0,.5>
      
   texture{textura_clara}

   }
   
   #local i=0.01;
   #while (i<0.3)
   box{<.05,i,-.59>,<0.5,i+0.005,-.51> pigment{color rgb 0} finish{ambient 1}}
   box{<.05,i,0.59>,<0.5,i+0.005,0.51> pigment{color rgb 0} finish{ambient 1}}
   #local i=i+0.01;
   #end
   } 
   
   prism{
   -.15,0.15,6
   <0,0>,<0,-.5>,
   <-.2,-.5>,<-.3,-.4>,
   
   <-.5,-.25>,<-1,0>
   rotate <-90,0,0>
   }
  
      
   
 
//   texture{T_Chrome_5A}  
}      

#end

#declare cabina=
#if(calidad)
union{
   object{cabina_delantera translate <0,.5,0>}
   object{cabina_motor translate <0,.5,0>}


//   object{cannon translate <0,.5,.5> }
//   object{lanzacohetes translate <0,0.5,-.5> }
   
}

#else
   union {
   sphere{0,.5 scale <2,1,1> translate .5*y pigment{color rgb <1,0,0>} finish{ambient .7}}
   object{lanzacohetes}
   object{cannon}
   }   

#end


#macro robot(robot_step, gun_rot, cannon_rot, lanza_rot ,disparo)
   robotwlk(robot_step)
   union {
   object { muslo rotate -(angulo_cm_dcha+angulo_vert_pie_dcho)*z translate robot_eje_pos - 0.5*z translate .5*y}
   object { pantorrilla rotate grados_dcha*z translate pos_rodilla_dcha - 0.5*z translate .5*y}
   object { muslo rotate -(angulo_cm_izq+angulo_vert_pie_izq)*z translate robot_eje_pos+0.5*z translate .5*y}
   object { pantorrilla rotate grados_izq*z translate pos_rodilla_izq + 0.5*z translate .5*y} 
   #if (robot_step <=.5)
       union{pie(0) translate robot_pie_dcho_pos-.5*z}
       union{pie(robot_pie_izq_pos.y*30) translate robot_pie_izq_pos+.5*z}
   #else
       union{pie(robot_pie_dcho_pos.y*30) translate robot_pie_dcho_pos-.5*z}
       union{pie(0) translate robot_pie_izq_pos+.5*z}
   #end
   object{cabina translate robot_eje_pos + .5*y}
   
   object{cannon rotate cannon_rot.z*z translate <0,0.5,0.5> translate robot_eje_pos + .5*y}
   object{lanzacohetes rotate lanza_rot.z*z translate <0,0.5,-.5> translate robot_eje_pos + .5*y}
//   object{gun_turret(gun_rot) translate <.7, -.12,0>translate robot_eje_pos + .5*y}

#if(calidad)
   object{gun_turret(gun_rot, disparo) translate <.7,-.12,0> translate robot_eje_pos + .5*y}
#end   

   translate -robot_step*2*x
   
   texture{textura_oscura}
   }
     
#end

#declare diana_1 = 
   box { 
      <0,0,-.7>,<0.05,.37,.7>
      texture {
         pigment {
            image_map {
               png "\proyecto\kerberos\diana_1.png"  interpolate 2
            } 
            translate <-.5,0.01,0> scale <1.4,.37,1>
         } 
         rotate <0,90,0>
         finish{
            ambient .8
            metallic
         }
      }
   }
                              
#declare diana_2 = 
   box {
      <0,0,-.59>,<0.05,.43,.59>
      texture {
         pigment {
            image_map {
               png "\proyecto\kerberos\diana_2.png"  interpolate 2
            } 
            translate <-.5,0.01,0> 
            scale <1.17,.43,1>
         } 
         rotate <0,90,0>
         finish {
            ambient .8
            metallic
         }
      }
   }        
                      
#declare diana_3 = 
   box {
      <0,0,-.77>,<0.05,.42,.78>
      texture {
         pigment {
            image_map {
               png "\proyecto\kerberos\diana_3.png"  
               interpolate 2
            } 
            translate <-.5,0.01,0> 
            scale <1.55,.42,1>
         } 
         rotate <0,90,0>
         finish {
            ambient .8
         }
      }
   }        
                      

/*#declare cloud_layer = 

pigment { 

wrinkles 

turbulence .5 

octaves 6 

lambda 6 //3 to 6 

omega 0.6 //0.2 to 0.6 

color_map { 

[0 color rgbt <1, 1, 1, 1>] 

[0.5 color rgbt <0.98, 0.99, 0.99, .8>] 

[1 color rgbt <1, 1, 1, 1>] 

} 

scale <.8, .1, .8> 

} */

//cloud plane 1 

#declare cloud1=
plane {y, 900 
texture { 
pigment {bozo 
turbulence .4 
lambda 6 
octaves 3 
omega .7 
color_map { 
[0 color rgbt <1,1,1, 1>] 
[.4 color rgbt <1,1,1, 1>] 
[.5 color rgbt <1, .98, .9, .1>] 
[.7 color rgbt <1,1,1, 1>] 
[1 color rgbt <1,1,1, 1>] 
} 
} 
finish {ambient .7 diffuse .5} 
scale 2000 
translate <-500,900,-10000> 
} 
hollow 
}



#declare cloud2=
plane {y,1200 

texture { 

pigment { 

bozo 

turbulence .7 

omega .7 

color_map { 

[0 color rgbt <.8, .8, .8, 1>] 

[.5 color rgbft <1,.85, .79, .5, .6>] 

[1 color rgbt <1,.85,.79, 1>]}} 

finish {ambient 1 diffuse .5} 

scale 2000 

//translate <1500,900,-2000>
} 

hollow 

} 
#declare cloud3=
plane { y, 300.0 

hollow on 

pigment { 

bozo 

omega .5 

lambda 5 

octaves 6 

turbulence 0.5 

color_map { 

[0.0 0.6 color rgbf <1, 1, 1, .5> 

color rgbf <1, 1, 1, 1>] 

[0.6 0.8 color rgbf <1, 1, 1, 1> 

color rgb <1, .9, .8>] 

[0.8 1.001 color rgb <1, .9, .8> 

color rgb <1, 1, .9>] 

} 

//quick_color rgb <.8, .4, .2> 

scale <1000.0, 200.0, 800.0> 

} 

finish { 

ambient 1 

diffuse 0.0 

} 

translate -450*x 

rotate 6*y 

} 
