/* nano0.pov - before nano1.pov, where the camera zooms in on the eyepiece
               of a microscope
Created:     11/5/1999 (1999.11.05.18.35)
Last edited: 2000.01.13.12.40
By:          William de Beaumont
*/
#include "colors.inc"

#declare fade=1;
#if (clock<.1)
 #declare fade=clock*10;
#end
#if (clock>.9)
 #declare fade=(1-clock)*10;
#end

camera
{
 location <-10,0,0> //overall view
 look_at <0,0,0>
 translate x*8*clock*clock //curve like this:  |
                                            // _/
 #declare clock2 = 1-((1-clock)*(1-clock)) //curve like this: /-
 rotate z*-60*clock2                                      // |
 rotate y*270*clock2
 /*location <-5,-2,0> //close up of lenses
 look_at <0,-2,0>*/
 /*location <0,10,0> //top view
 look_at <0,0,0>*/
}
light_source {<-10,10,0> color rgb <fade,fade,fade>}

//microscope barrel
union
{
 cylinder {<0,-2,0>,<0,2,0>,.5}
 cylinder {<0,2,0>,<0,3,0>,.2}
 rotate x*-30
 texture
 {
  finish 
  {
    phong .25
    phong_size 75
    reflection .2
  }
  pigment {color Gray20}
 }
} 
//microscope stand
union 
{
 difference
 {
  cylinder {<-.1,0,0>,<.1,0,0>,2}
  cylinder {<-1,0,2>,<1,0,2>,3}
  scale y*1.5
  translate y*-2
 }
 box {<-1,-3,-2>,<1,-4,2>}
 texture
 {
  finish 
  {
    phong .25
    phong_size 75
    reflection .2
  }
  pigment {color Gray20}
 }
}
//silver trim
union
{
 torus {.5,.05 translate <0,-2,0>}
 torus {.5,.05 translate <0,2,0>}
 torus {.2,.05 translate <0,3,0>}
 //lenses
 union
 {
  sphere {<0,-.5,0>,.5 scale y*.5}
  cone {<0,-.25,0>,.2,<0,-1,0>,.15 rotate x*30}
  cone {<0,-.25,0>,.2,<0,-1,0>,.15 rotate <30,120,0>}
  cone {<0,-.25,0>,.2,<0,-1,0>,.15 rotate <30,-120,0>}
  translate y*-1.75
 }
 rotate x*-30
 texture
 {
  finish 
  {
    phong .25
    phong_size 25
    reflection .8
  }
  pigment {color White}
 }
} 

//eyepiece
sphere
{<0,0,0>,.2
 scale y*.2
 translate y*3
 rotate x*-30
 interior {ior .2}
 texture
 {
  finish {reflection .3 ambient .2*fade phong 1}
  pigment {color rgbt <1,1,1,1>}
 }
}

//slide
box
{ <-.5,-3,.8>,<.5,-2.95,1.2>
 interior {ior .2}
 texture
 {
  finish {reflection .3 ambient .2*fade phong 1}
  pigment {color rgbt <1,1,1,1>}
 }
}
box {<-.1,-2.94,.9>,<.1,-2.95,1.1> finish {ambient fade} pigment {color White}}
box {<-.1,-2.99,.9>,<.1,-3,1.1> finish {ambient fade} pigment {color White}}

//table
union
{
 box {<-5,-5,-5>,<5,-4,5>}
 cylinder {<-5,-4.5,-5>,<5,-4.5,-5>,.5}
 cylinder {<5,-4.5,-5>,<5,-4.5,5>,.5}
 cylinder {<5,-4.5,5>,<-5,-4.5,5>,.5}
 cylinder {<-5,-4.5,5>,<-5,-4.5,-5>,.5}
 sphere {<-5,-4.5,-5>,.5}
 sphere {<5,-4.5,-5>,.5}
 sphere {<5,-4.5,5>,.5}
 sphere {<-5,-4.5,5>,.5}
 texture
 {
  pigment
  {
   marble
   turbulence 1
   color_map
   {
    [0.0 rgb <0,0,0>]
    [0.1 rgb <.5,.5,.5>]
    [0.3 rgb <.7,.7,.7>]
    [0.5 rgb <.9,.9,.9>]
    [1.0 rgb <1,1,1>]
   }
  scale 3
  }
  finish
  {
   reflection .3
  }
 } 
}
//papers on the table
box 
{<0,0,0>,<8.5,-.01,11> 
 pigment
 {
  gradient z
  color_map
  {
   [0.0 White]
   [0.9 White]
   [1.0 Blue]
  }
  scale .8
 }
 scale .3 
 translate <-2,-3.99,0> 
 rotate y*-30
}
 
box 
{<0,0,0>,<8.5,-.01,11> 
 pigment
 {
  gradient z
  color_map
  {
   [0.0 White]
   [0.9 White]
   [1.0 Blue]
  }
  scale .8
 }
 scale .3 
 translate <-2,-3.99,-6> 
 rotate y*30
}
 
//background
box {<-40,-40,-40>,<40,40,40> inverse pigment {color Gray75}}
