/* nano1.pov - nano-robot for IRTC 
Created:     11/4/1999 (1999.11.04.17.30)
Last edited: 2000.01.15.15.15
By:          William de Beaumont
*/
#include "colors.inc"

#declare fade=1;
#if (clock<.1)
 #declare fade=clock*10;
#end
#if (clock>.9)
 #declare fade=(1-clock)*10;
#end

#declare PI=3.141592654;
#declare Walk=2.4;
//body position
 #if (clock >.7)
   #declare Headturn=-30;
   #declare Headnod=20;
 #else 
  #if (clock >.6)
   #declare Headturn=-30* (clock-.6)*10;
   #declare Headnod=20* (clock-.6)*10;
  #else
   #declare Walk=4*clock;
   #declare Headturn=0;//-30;
   #declare Headnod=0;//20;
  #end
 #end
 #declare Lshoulderrot=<-10+sin(Walk*2*PI)*10,0,-20>;
 #declare Lelbowrot=<30,0,0>;
 #declare Rshoulderrot=<-10-sin(Walk*2*PI)*10,0,20>;
 #declare Relbowrot=<30,0,0>;
 #declare Lhiprot=<10-sin(Walk*2*PI)*20,0,-10>;//<20,0,-10>;
 #declare Lkneerot=<-20+sin(Walk*2*PI+0.785398163)*20,0,0>;//<-30,0,0>;
 #declare Rhiprot=<10+sin(Walk*2*PI)*20,0,10>;
 #declare Rkneerot=<-20-sin(Walk*2*PI+0.785398163)*20,0,0>;

camera
{
 #if (clock <.6)
  location <20,20,-40>
  look_at <-20,-8,-10>
 #else
  //this curve looks like:   /-
  //                        |
  //                      _/
  #if (clock<.7)
   #declare smoothzoom=(clock-.6)*(clock-.6)*500;
  #else
   #if (clock<.8)
    #declare smoothzoom=(1-(1-(clock-.7)*10)*(1-(clock-.7)*10))*5+5;
   #else
    #declare smoothzoom=10;
   #end
  #end
  location <20-smoothzoom,20-smoothzoom,-40+smoothzoom*2>
  look_at <-20+smoothzoom*2,-8,-10+smoothzoom>
 #end
 translate z*Walk*-10 
}
light_source {<-100,100,0> color rgb <.5*fade,.5*fade,.5*fade>}

background {color rgb <.5*fade,.5*fade,.5*fade>}

#declare metal =
 texture
 {
  finish {reflection .5 specular .5}
  pigment {color Gray50}
 }

/*plane
{ <0,1,0>,-20
  texture
  {
   pigment {checker color White, color Black scale 10}
   finish {reflection .2}
  }
}*/
difference  
{
  height_field {
    tga "height.tga"
    smooth
    translate <-.5, -.5, -.5>
    scale <400, 5, 400>
    translate y*-19.3
  }
  union
  {
   #declare footsteps=-2;
   #while (footsteps<=Walk)
    cylinder {<4.5,-15,footsteps*-10-16>,<4.5,-20,footsteps*-10-16>,.6}
    cylinder {<-4.5,-15,footsteps*-10-21>,<-4.5,-20,footsteps*-10-21>,.6}
    cylinder {<-15.5,-15,footsteps*-10-16>,<-15.5,-20,footsteps*-10-16>,.6}
    cylinder {<-24.5,-15,footsteps*-10-21>,<-24.5,-20,footsteps*-10-21>,.6}
    cylinder {<-35.5,-15,footsteps*-10-16>,<-35.5,-20,footsteps*-10-16>,.6}
    cylinder {<-44.5,-15,footsteps*-10-21>,<-44.5,-20,footsteps*-10-21>,.6}
    #declare footsteps=footsteps+1;
   #end
  }
  texture
  {
   finish {reflection .2 ambient .25*fade}
   pigment { White }
  }
}
//slide from nano0 enlarged
box
{ <-.5,-.025,-.2>,<.5,.025,.2>
 scale 2000
 translate y*-75
 interior {ior .2}
 texture
 {
  finish {reflection .3 ambient .2*fade phong 1}
  pigment {color rgbt <1,1,1,1>}
 }
}
//microscope base
plane
{ <0,1,0>,-125
 texture
 {
  finish 
  {
    phong .25
    phong_size 75
    reflection .2
  }
  pigment {color Gray20}
 }
}
//last robot in first line
//giganto-
union
{
 //head
 union
 {
  difference
  {
   sphere {<0,0,0>,2 scale <1,1.5,1>}
   box {<-.5,-2.5,-3>,<.5,-4,3>}
  }
  //eyes
  sphere 
  { <-.7,.5,-2>,.12
    texture
    {finish
     {
      ambient fade
      specular 1
     }
     pigment {color Red}
    }
  }
  sphere 
  { <.7,.5,-2>,.12
    texture
    {finish
     {
      ambient fade
      specular 1
     }
     pigment {color Red}
    }
  }
  translate y*2.5
  rotate x*Headnod
  rotate y*Headturn
  translate y*-2.5
 }
 //torso
 cylinder {<0,-2.5,0>,<0,-10,0>,.5}
 //shoudlers
 cylinder {<-4,-4,0>,<4,-4,0>,.5}
 sphere {<-4,-4,0>,.8}
 sphere {<4,-4,0>,.8}
 //arms
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Lshoulderrot translate <-4,-4,0>}
 sphere {<0,-4,0>,.6 rotate Lshoulderrot translate <-4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Lelbowrot translate <0,-4,0> rotate Lshoulderrot translate <-4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Rshoulderrot translate <4,-4,0>}
 sphere {<0,-4,0>,.6 rotate Rshoulderrot translate <4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Relbowrot translate <0,-4,0> rotate Rshoulderrot translate <4,-4,0>}
 //hips
 cylinder {<-3,-10,0>,<3,-10,0>,.7}
 sphere {<-3,-10,0>,.9}
 sphere {<3,-10,0>,.9}
 //legs
 cylinder {<0,0,0>,<0,-5,0>,.7 rotate Lhiprot translate <-3,-10,0>}
 sphere {<0,-5,0>,.8 rotate Lhiprot translate <-3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.6 rotate Lkneerot translate <0,-5,0> rotate Lhiprot translate <-3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.7 rotate Rhiprot translate <3,-10,0>}
 sphere {<0,-5,0>,.8 rotate Rhiprot translate <3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.6 rotate Rkneerot translate <0,-5,0> rotate Rhiprot translate <3,-10,0>}
 
 translate z*Walk*-10
 texture {metal}
}


//no head turning for the other robots 
#declare Headturn=0;
#declare Headnod=0;
#declare Walk=4*clock;
 #declare Lshoulderrot=<-10+sin(Walk*2*PI)*10,0,-20>;
 #declare Lelbowrot=<30,0,0>;
 #declare Rshoulderrot=<-10-sin(Walk*2*PI)*10,0,20>;
 #declare Relbowrot=<30,0,0>;
 #declare Lhiprot=<10-sin(Walk*2*PI)*20,0,-10>;//<20,0,-10>;
 #declare Lkneerot=<-20+sin(Walk*2*PI+0.785398163)*20,0,0>;//<-30,0,0>;
 #declare Rhiprot=<10+sin(Walk*2*PI)*20,0,10>;
 #declare Rkneerot=<-20-sin(Walk*2*PI+0.785398163)*20,0,0>;
#declare Robot=
//giganto-
union
{
 //head
 union
 {
  difference
  {
   sphere {<0,0,0>,2 scale <1,1.5,1>}
   box {<-.5,-2.5,-3>,<.5,-4,3>}
  }
  //eyes
  sphere 
  { <-.7,.5,-2>,.12
    texture
    {finish
     {
      ambient fade
      specular 1
     }
     pigment {color Red}
    }
  }
  sphere 
  { <.7,.5,-2>,.12
    texture
    {finish
     {
      ambient fade
      specular 1
     }
     pigment {color Red}
    }
  }
  translate y*2.5
  rotate x*Headnod
  rotate y*Headturn
  translate y*-2.5
 }
 //torso
 cylinder {<0,-2.5,0>,<0,-10,0>,.5}
 //shoudlers
 cylinder {<-4,-4,0>,<4,-4,0>,.5}
 sphere {<-4,-4,0>,.8}
 sphere {<4,-4,0>,.8}
 //arms
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Lshoulderrot translate <-4,-4,0>}
 sphere {<0,-4,0>,.6 rotate Lshoulderrot translate <-4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Lelbowrot translate <0,-4,0> rotate Lshoulderrot translate <-4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Rshoulderrot translate <4,-4,0>}
 sphere {<0,-4,0>,.6 rotate Rshoulderrot translate <4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Relbowrot translate <0,-4,0> rotate Rshoulderrot translate <4,-4,0>}
 //hips
 cylinder {<-3,-10,0>,<3,-10,0>,.7}
 sphere {<-3,-10,0>,.9}
 sphere {<3,-10,0>,.9}
 //legs
 cylinder {<0,0,0>,<0,-5,0>,.7 rotate Lhiprot translate <-3,-10,0>}
 sphere {<0,-5,0>,.8 rotate Lhiprot translate <-3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.6 rotate Lkneerot translate <0,-5,0> rotate Lhiprot translate <-3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.7 rotate Rhiprot translate <3,-10,0>}
 sphere {<0,-5,0>,.8 rotate Rhiprot translate <3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.6 rotate Rkneerot translate <0,-5,0> rotate Rhiprot translate <3,-10,0>}
 
 translate z*Walk*-10
 texture {metal}
}
//first line
object {Robot translate z*-10}
object {Robot translate z*-20}
//second line
object {Robot translate <-20,0,0>}
object {Robot translate <-20,0,-10>}
object {Robot translate <-20,0,-20>}
//third line
object {Robot translate <-40,0,0>}
object {Robot translate <-40,0,-10>}
object {Robot translate <-40,0,-20>}
