/* nano2.pov - nano-robot for IRTC 
Created:     2000.01.13.17.25
Last edited: 2000.01.15.15.25
By:          William de Beaumont
*/

#include "colors.inc"

#declare fade=1;
#if (clock<.05)
 #declare fade=clock*20;
#end
#if (clock>.95)
 #declare fade=(1-clock)*20;
#end

camera
{
 location <0,2.7,-1.6>
 translate x*clock*-30
 look_at <0,2.6,-1.5>
}
light_source {<-10,10,0> color rgb <fade,fade,fade>}

#if (fade<1)  
  text 
  { ttf "cyrvetic.ttf" "'Nano' by William de Beaumont" .1,0 
    //scale .45
    scale .25
    rotate y*90 
    //translate <-25,4,1.5>
    translate <5+clock*-30,.5,1.5>
    texture
    {
     finish {ambient 1-fade}
     pigment {color rgbt <1,1,1,fade>}
    }
  }
#end
//---------------microscope------------------

//microscope barrel
union
{
 cylinder {<0,-2,0>,<0,2,0>,.5}
 cylinder {<0,2,0>,<0,3,0>,.2}
 rotate x*-30
 texture
 {
  finish 
  {
    phong .25
    phong_size 75
    reflection .2
  }
  pigment {color Gray20}
 }
} 
//microscope stand
union 
{
 //difference
 //{
//  box {<-.1,-4,0>,<.1,0,-1>}
 difference
 {
  cylinder {<-.1,0,0>,<.1,0,0>,2}
  cylinder {<-1,0,2>,<1,0,2>,3}
  scale y*1.5
  translate y*-2
 }
 box {<-1,-3,-2>,<1,-4,2>}
 texture
 {
  finish 
  {
    phong .25
    phong_size 75
    reflection .2
  }
  pigment {color Gray20}
 }
}
//silver trim
union
{
 torus {.5,.05 translate <0,-2,0>}
 torus {.5,.05 translate <0,2,0>}
 torus {.2,.05 translate <0,3,0>}
 //lenses
 union
 {
  sphere {<0,-.5,0>,.5 scale y*.5}
  cone {<0,-.25,0>,.2,<0,-1,0>,.15 rotate x*30}
  cone {<0,-.25,0>,.2,<0,-1,0>,.15 rotate <30,120,0>}
  cone {<0,-.25,0>,.2,<0,-1,0>,.15 rotate <30,-120,0>}
  translate y*-1.75
 }
 rotate x*-30
 texture
 {
  finish 
  {
    phong .25
    phong_size 25
    reflection .8
  }
  pigment {color White}
 }
} 

//eyepiece
sphere
{<0,0,0>,.2
 scale y*.2
 translate y*3
 rotate x*-30
 interior {ior .2}
 texture
 {
  finish {reflection .3 ambient .2*fade phong 1}
  pigment {color rgbt <1,1,1,1>}
 }
}

//slide
box
{ <-.5,-3,.8>,<.5,-2.95,1.2>
 interior {ior .2}
 texture
 {
  finish {reflection .3 ambient .2*fade phong 1}
  pigment {color rgbt <1,1,1,1>}
 }
}
box {<-.1,-2.94,.9>,<.1,-2.95,1.1> finish {ambient fade} pigment {color White}}
box {<-.1,-2.99,.9>,<.1,-3,1.1> finish {ambient fade} pigment {color White}}

//table
union
{
 box {<-5,-5,-5>,<5,-4,5>}
 cylinder {<-5,-4.5,-5>,<5,-4.5,-5>,.5}
 cylinder {<5,-4.5,-5>,<5,-4.5,5>,.5}
 cylinder {<5,-4.5,5>,<-5,-4.5,5>,.5}
 cylinder {<-5,-4.5,5>,<-5,-4.5,-5>,.5}
 sphere {<-5,-4.5,-5>,.5}
 sphere {<5,-4.5,-5>,.5}
 sphere {<5,-4.5,5>,.5}
 sphere {<-5,-4.5,5>,.5}
 texture
 {
  pigment
  {
   marble
   turbulence 1
   color_map
   {
    [0.0 rgb <0,0,0>]
    [0.1 rgb <.5,.5,.5>]
    [0.3 rgb <.7,.7,.7>]
    [0.5 rgb <.9,.9,.9>]
    [1.0 rgb <1,1,1>]
   }
  scale 3
  }
  finish
  {
   reflection .3
  }
 } 
}
//table leg 
cylinder
{ <0,-5,0>,<0,-40,0>,1
 texture
 {
  finish 
  {
    phong .25
    phong_size 25
    reflection .8
  }
  pigment {color White}
 }
}

//papers on the table
box 
{<0,0,0>,<8.5,-.01,11> 
 pigment
 {
  gradient z
  color_map
  {
   [0.0 White]
   [0.9 White]
   [1.0 Blue]
  }
  scale .8
 }
 scale .3 
 translate <-2,-3.99,0> 
 rotate y*-30
}
 
box 
{<0,0,0>,<8.5,-.01,11> 
 pigment
 {
  gradient z
  color_map
  {
   [0.0 White]
   [0.9 White]
   [1.0 Blue]
  }
  scale .8
 }
 scale .3 
 translate <-2,-3.99,-6> 
 rotate y*30
}
 
//background
box {<-40,-40,-40>,<40,40,40> inverse pigment {color Gray75}}

//----------------robot----------------------

#declare PI=3.141592654;
#declare Walk=3.2;
//body position
 #if (clock>.3)
  #if (clock<.4)
   #declare Headturn=-15-(1-(clock-.3)*5)*(clock-.3)*20*120;
  #else
   #if (clock<.5)
    #declare Headturn=-135;
   #else
    #if (clock<.59)
     #declare Headturn=-15-(1-(clock-.4)*5)*(clock-.4)*20*120;
    #else
     #if (clock<.7)
      #declare Headturn=-37.8;
     #else
      #declare Headturn=-37.8-sin((clock-.5)*72)*20;
     #end
    #end
   #end
  #end
 #else
  #declare Headturn=-15;
 #end
 #if (clock <.2)
  #declare Headnod=-10;
 #else 
  #if (clock>.7)
   #declare Headnod=-(clock-.7)*30
  #else
   #declare Headnod=0;
  #end
 #end
 #declare Lshoulderrot=<-10,0,-20>;
 #declare Lelbowrot=<115,0,0>;
 #declare Rshoulderrot=<-10,0,20>;
 #declare Relbowrot=<115,0,0>;
 #declare Lhiprot=<50,0,-10>;
 #declare Lkneerot=<-40,0,0>;
 #declare Rhiprot=<50,0,10>;
 #declare Rkneerot=<-40,0,0>;


#declare metal =
 texture
 {
  finish {reflection .5 specular .5}
  pigment {color Gray50}
 }

//giganto-
union
{
 //head
 union
 {
  difference
  {
   sphere {<0,0,0>,2 scale <1,1.5,1>}
   box {<-.5,-2.5,-3>,<.5,-4,3>}
  }
  //eyes
  sphere 
  { <-.7,.5,-2>,.12
    texture
    {finish
     {
      ambient fade
      specular 1
     }
     pigment {color Red}
    }
  }
  sphere 
  { <.7,.5,-2>,.12
    texture
    {finish
     {
      ambient fade
      specular 1
     }
     pigment {color Red}
    }
  }
  translate y*2.5
  rotate x*Headnod
  rotate y*Headturn
  translate y*-2.5
 }
 //torso
 cylinder {<0,-2.5,0>,<0,-10,0>,.5}
 //shoudlers
 cylinder {<-4,-4,0>,<4,-4,0>,.5}
 sphere {<-4,-4,0>,.8}
 sphere {<4,-4,0>,.8}
 //arms
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Lshoulderrot translate <-4,-4,0>}
 sphere {<0,-4,0>,.6 rotate Lshoulderrot translate <-4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Lelbowrot translate <0,-4,0> rotate Lshoulderrot translate <-4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Rshoulderrot translate <4,-4,0>}
 sphere {<0,-4,0>,.6 rotate Rshoulderrot translate <4,-4,0>}
 cylinder {<0,0,0>,<0,-4,0>,.4 rotate Relbowrot translate <0,-4,0> rotate Rshoulderrot translate <4,-4,0>}
 //hips
 cylinder {<-3,-10,0>,<3,-10,0>,.7}
 sphere {<-3,-10,0>,.9}
 sphere {<3,-10,0>,.9}
 //legs
 cylinder {<0,0,0>,<0,-5,0>,.7 rotate Lhiprot translate <-3,-10,0>}
 sphere {<0,-5,0>,.8 rotate Lhiprot translate <-3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.6 rotate Lkneerot translate <0,-5,0> rotate Lhiprot translate <-3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.7 rotate Rhiprot translate <3,-10,0>}
 sphere {<0,-5,0>,.8 rotate Rhiprot translate <3,-10,0>}
 cylinder {<0,0,0>,<0,-5,0>,.6 rotate Rkneerot translate <0,-5,0> rotate Rhiprot translate <3,-10,0>}

 rotate <-30,180,0>
 translate <0,4,-4>

 texture {metal}
}


