#include "colors.inc"
#include "textures.inc"

#declare EClock = clock;             //Different clock variable, for testing
#declare Angle = EClock;             //Angle of Ball's Rotation
#declare RAngle = radians(Angle);    //Angle, in Radians (to save Space)

//Ball Constants
#declare Bounces = 5;                //The Number of Times The Ball Bounces
#declare BallSize = 1;               //The Radius of the Ball
#declare BallHeight = 5;             //The Height to which the ball bounces
#declare BallDist = 7;               //The X/Z plane Distance of the ball's center from the origin
#declare BallCenter = <BallDist* cos(RAngle), abs(BallHeight* cos(RAngle*Bounces)), BallDist* sin(RAngle)>;
#declare BallCenter2 = <BallDist* cos(RAngle-pi), abs(BallHeight* cos(RAngle*Bounces)), BallDist* sin(RAngle-pi)>;

//Platform Constants
#declare PlatformHeight = 10;        //The Y Height of the Cylinder

background {White}

camera
{
  location <0,10,-20>
  look_at <0,0,0>         
}

//Makes 4 Lights, at 0,90,180,270 degrees around cylinder
#declare FourLightColor = White * .75;
#declare LightPos = 0;
#while (LightPos < 360)
  light_source
  {
    <BallDist * cos(radians(LightPos))*2, BallHeight , BallDist * sin(radians(LightPos))*2>
    color FourLightColor  
  }
  #declare LightPos = LightPos + 90;
#end

cylinder
{
  <0,-BallSize,0>,
  <0,-(BallSize + PlatformHeight),0>,
  (BallDist + BallSize*3)
  texture { pigment {Sapphire_Agate } scale 3 }  //prev. pigment { Blue }
}

sphere
{
  BallCenter,
  BallSize
  texture { pigment { Blue_Sky2 } }  //used to be pigment { Red }
}

sphere
{
  BallCenter2,
  BallSize
  texture { Chrome_Metal }
  texture { Lightening2 }
}


merge       //Center support for the Ball-Arm
{
  cylinder
  {
    <0, -(BallSize + 1), 0>,
    <0, BallSize, 0>, 1
  }
  sphere
  {
    <0, BallSize, 0>, 1
  }
  texture { Silver_Metal }
}

cylinder    //The Ball-Arm
{
  <0, BallSize, 0>,
  BallCenter,
  0.2
  texture { Silver_Metal }
}

cone        //The Holo-Cone
{
  <0, BallSize, 0>, 0
  BallCenter2, BallSize / 1.5
  texture
  {
    Lightening2 
  }
}