/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/
default {
  texture {
    pigment { rgb <1,0,0> }
  }
}
/* // Scene Comment
This scene was created with Moray For Windows.
*/ // End Scene Comment
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}
background { color <0.549,0.573,0.882> }
camera {  //  Camera StdCam
  location  <     11.000,      68.000,      37.500>
  direction <        0.0,         0.0,      1.6501> // Aperture is 0.59 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       2.000,      26.000>
}
light_source {   // Light001
  <-72.800, -60.000, 430.850>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  1.0
  fade_power 0.5
}
light_source {   // Light002
  <-72.800, 60.000, 430.850>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  fade_distance  1.0
  fade_power 0.5
}
light_source {   // Light003
  <47.200, -60.000, 430.850>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  fade_distance  1.0
  fade_power 0.5
}
light_source {   // Light004
  <47.200, 60.000, 430.850>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  fade_distance  1.0
  fade_power 0.5
}
#include "ani276.inc"
#declare Cube1729 = object {
  box { // Cube1729
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.3, 1.3>
    rotate 90.0*z
    translate  <0.0, -1.68437, -0.05>
  }
}
#declare Cube1736 = object {
  box { // Cube1736
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus035 = object {
  torus { // Torus035
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube1748 = object {
  box { // Cube1748
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube1753 = object {
  box { // Cube1753
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube1758 = object {
  box { // Cube1758
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube1759 = object {
  box { // Cube1759
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube1760 = object {
  box { // Cube1760
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube1773 = object {
  box { // Cube1773
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube1774 = object {
  box { // Cube1774
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube1775 = object {
  box { // Cube1775
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube1776 = object {
  box { // Cube1776
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare Engine44 = difference {
  superellipsoid { // SuperQ101
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube1736 }
  object { // Cube1737->Cube1736
    Cube1736
    rotate -15.0*z
  }
  object { // Cube1738->Cube1736
    Cube1736
    rotate -30.0*z
  }
  object { // Cube1739->Cube1736
    Cube1736
    rotate -45.0*z
  }
  object { // Cube1740->Cube1736
    Cube1736
    rotate -60.0*z
  }
  object { // Cube1741->Cube1736
    Cube1736
    rotate -75.0*z
  }
  object { // Cube1742->Cube1736
    Cube1736
    rotate -90.0*z
  }
  object { // Cube1743->Cube1736
    Cube1736
    rotate -105.0*z
  }
  object { // Cube1744->Cube1736
    Cube1736
    rotate -120.0*z
  }
  object { // Cube1745->Cube1736
    Cube1736
    rotate -135.0*z
  }
  object { // Cube1746->Cube1736
    Cube1736
    rotate -150.0*z
  }
  object { // Cube1747->Cube1736
    Cube1736
    rotate -165.0*z
  }
  object { Torus035 }
  object { // Torus036->Torus035
    Torus035
    translate  -2.4*z
  }
  object { Cube1748 }
  object { // Cube1749->Cube1748
    Cube1748
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube1750->Cube1748
    Cube1748
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube1751->Cube1748
    Cube1748
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube1752->Cube1748
    Cube1748
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube1753 }
  object { // Cube1754->Cube1753
    Cube1753
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube1755->Cube1753
    Cube1753
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube1756->Cube1753
    Cube1753
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube1757->Cube1753
    Cube1753
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube1758 }
  object { Cube1759 }
  object { Cube1760 }
  object { // Cube1761->Cube1760
    Cube1760
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube1762->Cube1760
    Cube1760
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube1763->Cube1760
    Cube1760
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube1764->Cube1760
    Cube1760
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube1765->Cube1758
    Cube1758
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube1766->Cube1758
    Cube1758
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube1767->Cube1758
    Cube1758
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube1768->Cube1758
    Cube1758
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube1769->Cube1759
    Cube1759
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube1770->Cube1759
    Cube1759
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube1771->Cube1759
    Cube1759
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube1772->Cube1759
    Cube1759
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube1773 }
  object { Cube1774 }
  object { Cube1775 }
  object { Cube1776 }
  object { // Cube1777->Cube1773
    Cube1773
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube1778->Cube1773
    Cube1773
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube1779->Cube1774
    Cube1774
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube1780->Cube1774
    Cube1774
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube1781->Cube1775
    Cube1775
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube1782->Cube1775
    Cube1775
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube1783->Cube1776
    Cube1776
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube1784->Cube1776
    Cube1776
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine45 = union {
  cone { // Cone143
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine44 }
  material {
    Brushed_Aluminum
  }
  scale 0.7
  rotate 90.0*y
  translate  <-4.3, 2.2, 3.5>
}
#declare CSG253 = union {
  box { // Cube1785
    <-1, -1, -1>, <1, 1, 1>
    scale <0.087, 0.087, 0.6>
    rotate -45.0*z
    translate  <-0.507, 0.02, 0.5>
  }
  box { // Cube1786
    <-1, -1, -1>, <1, 1, 1>
    scale <0.087, 0.087, 0.6>
    rotate -45.0*z
    translate  <-0.507, -0.02, 0.5>
  }
  box { // Cube1787
    <-1, -1, -1>, <1, 1, 1>
    scale <0.123037, 0.02, 0.6>
    translate  <-0.507, 0.0, 0.5>
  }
  scale <1.0, 1.0, 0.83>
  translate  0.085*z
}
#declare plus_part_zahnrad_klein4 = union {
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    scale <0.53, 0.53, 1.0>
  }
  object { CSG253 }
  object { // CSG254->CSG253
    CSG253
    rotate -40.0*z
  }
  object { // CSG255->CSG253
    CSG253
    rotate -80.0*z
  }
  object { // CSG256->CSG253
    CSG253
    rotate -120.0*z
  }
  object { // CSG257->CSG253
    CSG253
    rotate -160.0*z
  }
  object { // CSG258->CSG253
    CSG253
    rotate 160.0*z
  }
  object { // CSG259->CSG253
    CSG253
    rotate 120.0*z
  }
  object { // CSG260->CSG253
    CSG253
    rotate 80.0*z
  }
  object { // CSG261->CSG253
    CSG253
    rotate 40.0*z
  }
  superellipsoid { // SuperQ102
    <1.0, 0.1>
    scale <0.2, 0.2, 3.2>
    rotate -10.0*z
    translate  2.7*z
  }
}
#declare Zahnrad_Schraee20 = difference {
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone144
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.5>
    translate  -0.05*z
  }
  scale <0.65, 0.65, 2.0>
  translate  0.92*z
}
#declare Zahnrad_Schraee21 = difference {
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone145
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <0.65, 0.65, 2.0>
  rotate -180.0*y
  translate  0.08*z
}
#declare Zahnrad_klein4 = difference {
  object { plus_part_zahnrad_klein4 }
  object { Zahnrad_Schraee20 }
  object { Zahnrad_Schraee21 }
  scale <1.0, 1.0, 0.5>
  rotate 90.0*y
  translate  <-6.5, 2.2, 3.5>
}
#declare Motor_befestigung_schulter2 = union {
  superellipsoid { // SuperQ103
    <0.1, 0.1>
    scale <0.8, 0.7, 0.33>
  }
  superellipsoid { // SuperQ104
    <0.1, 0.1>
    scale <0.8, 0.7, 0.33>
    translate  1.8*z
  }
  translate  <-4.35, 1.8, 2.6>
}
#declare Motor_etc4 = union {
  object { Engine45 }
  object { Zahnrad_klein4 }
  object { Motor_befestigung_schulter2 }
  translate  1.9*x
}
#declare CSG262 = union {
  box { // Cube1788
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.06, 0.6>
    rotate -44.0*z
    translate  <-1.009846, -0.017627, 0.5>
  }
  box { // Cube1789
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.06, 0.6>
    rotate -46.0*z
    translate  <-1.009846, 0.017627, 0.5>
  }
  box { // Cube1790
    <-1, -1, -1>, <1, 1, 1>
    scale <0.084994, 0.016146, 0.6>
    translate  <-1.01, 0.0, 0.5>
  }
}
#declare Cube1791 = object {
  box { // Cube1791
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.3, 1.3>
    rotate 90.0*z
    translate  <0.0, -1.68437, -0.05>
  }
}
#declare Cube1798 = object {
  box { // Cube1798
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.55, 1.55>
    rotate 90.0*z
    translate  -1.01*y
  }
}
#declare Cube1804 = object {
  box { // Cube1804
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11875, 1.12, 1.12>
    translate  <-0.7275, 0.0, -5.7>
  }
}
#declare Cube1809 = object {
  box { // Cube1809
    <-1, -1, -1>, <1, 1, 1>
    scale <0.125, 1.12, 1.12>
    translate  -0.975*x
  }
}
#declare minus_something12 = union {
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.2>
    rotate -90.0*x
    translate  <0.0, -1.1, 1.8>
  }
  box { // Cube1817
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.1, 1.8>
  }
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.2>
    rotate -90.0*x
    translate  <0.0, -1.1, -1.8>
  }
  translate  -5.2*z
}
#declare Cylndr449 = object {
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.2>
    rotate -0.0*x
    translate  <0.0, -0.4, -7.3>
  }
}
#declare ader144 = union {
  sphere { // Sphere089
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere090
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube1819 = object {
  box { // Cube1819
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube1820 = object {
  box { // Cube1820
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader148 = union {
  sphere { // Sphere091
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere092
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube1829 = object {
  box { // Cube1829
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube1830 = object {
  box { // Cube1830
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader152 = union {
  sphere { // Sphere093
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.45, 0.3>
  }
  sphere { // Sphere094
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 1.0>
    rotate -90.0*x
    translate  <-0.2, -1.45, 0.3>
  }
  // All transformations fixed
}
#declare Cube1839 = object {
  box { // Cube1839
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare Cube1845 = object {
  box { // Cube1845
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-1.15, -0.7, 0.0>
  }
}
#declare Cube1856 = object {
  box { // Cube1856
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.55, -0.7, 0.0>
  }
}
#declare Cube1855 = object {
  box { // Cube1855
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -0.7, 0.0>
  }
}
#declare ader160 = union {
  sphere { // Sphere097
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere098
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube1870 = object {
  box { // Cube1870
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube1871 = object {
  box { // Cube1871
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader164 = union {
  sphere { // Sphere099
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.45, 0.3>
  }
  sphere { // Sphere100
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 1.0>
    rotate -90.0*x
    translate  <-0.2, -1.45, 0.3>
  }
  // All transformations fixed
}
#declare Cube1880 = object {
  box { // Cube1880
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader172 = union {
  sphere { // Sphere103
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere104
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube1894 = object {
  box { // Cube1894
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube1895 = object {
  box { // Cube1895
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader176 = union {
  sphere { // Sphere105
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.45, 0.3>
  }
  sphere { // Sphere106
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 1.0>
    rotate -90.0*x
    translate  <-0.2, -1.45, 0.3>
  }
  // All transformations fixed
}
#declare Cube1904 = object {
  box { // Cube1904
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare CSG292 = union {
  box { // Cube1909
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.06, 0.6>
    rotate -44.0*z
    translate  <-1.009846, -0.017627, 0.5>
  }
  box { // Cube1910
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.06, 0.6>
    rotate -46.0*z
    translate  <-1.009846, 0.017627, 0.5>
  }
  box { // Cube1911
    <-1, -1, -1>, <1, 1, 1>
    scale <0.084994, 0.016146, 0.6>
    translate  <-1.01, 0.0, 0.5>
  }
}
#declare Cube1912 = object {
  box { // Cube1912
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.3, 1.3>
    rotate 90.0*z
    translate  <0.0, -1.68437, -0.05>
  }
}
#declare Cube1919 = object {
  box { // Cube1919
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.55, 1.55>
    rotate 90.0*z
    translate  -1.01*y
  }
}
#declare Cube1925 = object {
  box { // Cube1925
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11875, 1.12, 1.12>
    translate  <-0.7275, 0.0, -5.7>
  }
}
#declare Cube1930 = object {
  box { // Cube1930
    <-1, -1, -1>, <1, 1, 1>
    scale <0.125, 1.12, 1.12>
    translate  -0.975*x
  }
}
#declare minus_something15 = union {
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.2>
    rotate -90.0*x
    translate  <0.0, -1.1, 1.8>
  }
  box { // Cube1938
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.1, 1.8>
  }
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.2>
    rotate -90.0*x
    translate  <0.0, -1.1, -1.8>
  }
  translate  -5.2*z
}
#declare Cylndr496 = object {
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.2>
    rotate -0.0*x
    translate  <0.0, -0.4, -7.3>
  }
}
#declare ader180 = union {
  sphere { // Sphere108
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere109
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube1940 = object {
  box { // Cube1940
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube1941 = object {
  box { // Cube1941
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader184 = union {
  sphere { // Sphere110
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere111
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube1950 = object {
  box { // Cube1950
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube1951 = object {
  box { // Cube1951
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader188 = union {
  sphere { // Sphere112
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.45, 0.3>
  }
  sphere { // Sphere113
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 1.0>
    rotate -90.0*x
    translate  <-0.2, -1.45, 0.3>
  }
  // All transformations fixed
}
#declare Cube1960 = object {
  box { // Cube1960
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare Cube1966 = object {
  box { // Cube1966
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-1.15, -0.7, 0.0>
  }
}
#declare Cube1977 = object {
  box { // Cube1977
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.55, -0.7, 0.0>
  }
}
#declare Cube1976 = object {
  box { // Cube1976
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -0.7, 0.0>
  }
}
#declare ader196 = union {
  sphere { // Sphere116
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere117
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube1991 = object {
  box { // Cube1991
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube1992 = object {
  box { // Cube1992
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader200 = union {
  sphere { // Sphere118
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.45, 0.3>
  }
  sphere { // Sphere119
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 1.0>
    rotate -90.0*x
    translate  <-0.2, -1.45, 0.3>
  }
  // All transformations fixed
}
#declare Cube2001 = object {
  box { // Cube2001
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader208 = union {
  sphere { // Sphere122
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere123
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare Cube2015 = object {
  box { // Cube2015
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
}
#declare Cube2016 = object {
  box { // Cube2016
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare ader212 = union {
  sphere { // Sphere124
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.45, 0.3>
  }
  sphere { // Sphere125
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 1.0>
    rotate -90.0*x
    translate  <-0.2, -1.45, 0.3>
  }
  // All transformations fixed
}
#declare Cube2025 = object {
  box { // Cube2025
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
}
#declare Cube2031 = object {
  box { // Cube2031
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.1, 0.75, 0.75>
    translate  -0.4*x
  }
}
#declare head_line4 = union {
  sphere { // Sphere127
    <0,0,0>,1
    // All transformations fixed
    scale 0.2
    translate  <-1.0, -1.0, 1.0>
  }
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.2, 0.2, 2.0>
    rotate -90.0*x
    translate  <-1.0, -1.0, 1.0>
  }
  sphere { // Sphere128
    <0,0,0>,1
    // All transformations fixed
    scale 0.2
    translate  <-1.0, 1.0, 1.0>
  }
  // All transformations fixed
}
#declare Cube2036 = object {
  box { // Cube2036
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.1, 0.75, 0.75>
    translate  -0.6*x
  }
}
#declare Cylndr535 = object {
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 3.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.5, 0.0, 4.5>
  }
}
#declare Cube2043 = object {
  box { // Cube2043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.01, 0.358333>
  }
}
#declare Cube2047 = object {
  box { // Cube2047
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <-0.0, -1.684375, 0.358333>
  }
}
#declare Cube2054 = object {
  box { // Cube2054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus037 = object {
  torus { // Torus037
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube2066 = object {
  box { // Cube2066
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube2071 = object {
  box { // Cube2071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube2076 = object {
  box { // Cube2076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube2077 = object {
  box { // Cube2077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube2078 = object {
  box { // Cube2078
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube2091 = object {
  box { // Cube2091
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube2092 = object {
  box { // Cube2092
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube2093 = object {
  box { // Cube2093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube2094 = object {
  box { // Cube2094
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare Engine46 = difference {
  superellipsoid { // SuperQ119
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube2054 }
  object { // Cube2055->Cube2054
    Cube2054
    rotate -15.0*z
  }
  object { // Cube2056->Cube2054
    Cube2054
    rotate -30.0*z
  }
  object { // Cube2057->Cube2054
    Cube2054
    rotate -45.0*z
  }
  object { // Cube2058->Cube2054
    Cube2054
    rotate -60.0*z
  }
  object { // Cube2059->Cube2054
    Cube2054
    rotate -75.0*z
  }
  object { // Cube2060->Cube2054
    Cube2054
    rotate -90.0*z
  }
  object { // Cube2061->Cube2054
    Cube2054
    rotate -105.0*z
  }
  object { // Cube2062->Cube2054
    Cube2054
    rotate -120.0*z
  }
  object { // Cube2063->Cube2054
    Cube2054
    rotate -135.0*z
  }
  object { // Cube2064->Cube2054
    Cube2054
    rotate -150.0*z
  }
  object { // Cube2065->Cube2054
    Cube2054
    rotate -165.0*z
  }
  object { Torus037 }
  object { // Torus038->Torus037
    Torus037
    translate  -2.4*z
  }
  object { Cube2066 }
  object { // Cube2067->Cube2066
    Cube2066
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2068->Cube2066
    Cube2066
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2069->Cube2066
    Cube2066
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2070->Cube2066
    Cube2066
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2071 }
  object { // Cube2072->Cube2071
    Cube2071
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2073->Cube2071
    Cube2071
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2074->Cube2071
    Cube2071
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2075->Cube2071
    Cube2071
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2076 }
  object { Cube2077 }
  object { Cube2078 }
  object { // Cube2079->Cube2078
    Cube2078
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2080->Cube2078
    Cube2078
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2081->Cube2078
    Cube2078
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2082->Cube2078
    Cube2078
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2083->Cube2076
    Cube2076
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2084->Cube2076
    Cube2076
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2085->Cube2076
    Cube2076
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2086->Cube2076
    Cube2076
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2087->Cube2077
    Cube2077
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2088->Cube2077
    Cube2077
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2089->Cube2077
    Cube2077
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2090->Cube2077
    Cube2077
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2091 }
  object { Cube2092 }
  object { Cube2093 }
  object { Cube2094 }
  object { // Cube2095->Cube2091
    Cube2091
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2096->Cube2091
    Cube2091
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2097->Cube2092
    Cube2092
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube2098->Cube2092
    Cube2092
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube2099->Cube2093
    Cube2093
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2100->Cube2093
    Cube2093
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2101->Cube2094
    Cube2094
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube2102->Cube2094
    Cube2094
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine47 = union {
  cone { // Cone199
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine46 }
  material {
    Brushed_Aluminum
  }
  scale 0.7
  rotate <90.0, 0.0, -90.0>
  translate  <-2.65, 0.0, 4.0>
}
#declare SuperQ120 = object {
  superellipsoid { // SuperQ120
    <0.1, 0.1>
    scale <0.8, 0.37, 0.3>
    translate  <-2.2, 0.0, 4.0>
  }
}
#declare Cube2103 = object {
  box { // Cube2103
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.6>
    translate  <-2.0, 0.2, 3.2>
  }
}
#declare Cube2107 = object {
  box { // Cube2107
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.35>
    translate  <-2.04, 0.0, 5.6>
  }
}
#declare Cylndr538 = object {
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    scale <0.73, 0.73, 1.8>
    rotate -90.0*y
    translate  <-1.3, 0.0, 4.5>
  }
}
#declare Cylndr540 = object {
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.6>
    rotate -90.0*x
    translate  <-2.59, -0.3, 2.61>
  }
}
#declare Cylndr542 = object {
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    scale <1.15, 0.65, 0.6>
    rotate -90.0*x
    translate  <-2.649, -0.3, 5.94>
  }
}
#declare Cube2110 = object {
  box { // Cube2110
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.01, 0.358333>
  }
}
#declare Cylndr547 = object {
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.2>
    translate  <0.0, 2.2, 0.5>
  }
}
#declare SuperQ124 = object {
  superellipsoid { // SuperQ124
    <0.1, 0.1>
    scale <0.8, 0.37, 0.3>
    translate  <-2.2, 0.0, 4.0>
  }
}
#declare Cube2114 = object {
  box { // Cube2114
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.6>
    translate  <-2.0, 0.2, 3.2>
  }
}
#declare Cube2118 = object {
  box { // Cube2118
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.35>
    translate  <-2.04, 0.0, 5.6>
  }
}
#declare Cylndr548 = object {
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    scale <0.73, 0.73, 1.8>
    rotate -90.0*y
    translate  <-1.3, 0.0, 4.5>
  }
}
#declare Cylndr550 = object {
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.6>
    rotate -90.0*x
    translate  <-2.59, -0.3, 2.61>
  }
}
#declare Cylndr552 = object {
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    scale <1.15, 0.65, 0.6>
    rotate -90.0*x
    translate  <-2.649, -0.3, 5.94>
  }
}
#declare Cube2132 = object {
  box { // Cube2132
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus039 = object {
  torus { // Torus039
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube2144 = object {
  box { // Cube2144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube2149 = object {
  box { // Cube2149
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube2154 = object {
  box { // Cube2154
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube2155 = object {
  box { // Cube2155
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube2156 = object {
  box { // Cube2156
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube2169 = object {
  box { // Cube2169
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube2170 = object {
  box { // Cube2170
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube2171 = object {
  box { // Cube2171
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube2172 = object {
  box { // Cube2172
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare Engine51 = difference {
  superellipsoid { // SuperQ129
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube2132 }
  object { // Cube2133->Cube2132
    Cube2132
    rotate -15.0*z
  }
  object { // Cube2134->Cube2132
    Cube2132
    rotate -30.0*z
  }
  object { // Cube2135->Cube2132
    Cube2132
    rotate -45.0*z
  }
  object { // Cube2136->Cube2132
    Cube2132
    rotate -60.0*z
  }
  object { // Cube2137->Cube2132
    Cube2132
    rotate -75.0*z
  }
  object { // Cube2138->Cube2132
    Cube2132
    rotate -90.0*z
  }
  object { // Cube2139->Cube2132
    Cube2132
    rotate -105.0*z
  }
  object { // Cube2140->Cube2132
    Cube2132
    rotate -120.0*z
  }
  object { // Cube2141->Cube2132
    Cube2132
    rotate -135.0*z
  }
  object { // Cube2142->Cube2132
    Cube2132
    rotate -150.0*z
  }
  object { // Cube2143->Cube2132
    Cube2132
    rotate -165.0*z
  }
  object { Torus039 }
  object { // Torus040->Torus039
    Torus039
    translate  -2.4*z
  }
  object { Cube2144 }
  object { // Cube2145->Cube2144
    Cube2144
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2146->Cube2144
    Cube2144
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2147->Cube2144
    Cube2144
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2148->Cube2144
    Cube2144
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2149 }
  object { // Cube2150->Cube2149
    Cube2149
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2151->Cube2149
    Cube2149
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2152->Cube2149
    Cube2149
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2153->Cube2149
    Cube2149
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2154 }
  object { Cube2155 }
  object { Cube2156 }
  object { // Cube2157->Cube2156
    Cube2156
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2158->Cube2156
    Cube2156
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2159->Cube2156
    Cube2156
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2160->Cube2156
    Cube2156
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2161->Cube2154
    Cube2154
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2162->Cube2154
    Cube2154
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2163->Cube2154
    Cube2154
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2164->Cube2154
    Cube2154
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2165->Cube2155
    Cube2155
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2166->Cube2155
    Cube2155
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2167->Cube2155
    Cube2155
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2168->Cube2155
    Cube2155
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2169 }
  object { Cube2170 }
  object { Cube2171 }
  object { Cube2172 }
  object { // Cube2173->Cube2169
    Cube2169
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2174->Cube2169
    Cube2169
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2175->Cube2170
    Cube2170
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube2176->Cube2170
    Cube2170
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube2177->Cube2171
    Cube2171
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2178->Cube2171
    Cube2171
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2179->Cube2172
    Cube2172
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube2180->Cube2172
    Cube2172
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine52 = union {
  cone { // Cone204
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine51 }
  material {
    Brushed_Aluminum
  }
  scale 0.7
  rotate -0.0*z
  translate  <0.0, 2.2, 1.7>
}
#declare CSG324 = difference {
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
  }
  cone { // Cone201
    <0,0,0>, 0.9, <0,0,1>, 0.7
    scale <1.0, 1.0, 0.2>
    translate  0.45*z
  }
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 0.45>
  }
}
#declare Cube2121 = object {
  box { // Cube2121
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.5, 0.3>
    translate  0.4*z
  }
}
#declare Schraube__minus_solid_part_12 = union {
  object { CSG324 }
  object { Cube2121 }
  object { // Cube2122->Cube2121
    Cube2121
    rotate -120.0*z
  }
  object { // Cube2123->Cube2121
    Cube2121
    rotate 120.0*z
  }
  scale 0.15
  rotate <-90.0, -90.0, 0.0>
  translate  <0.0, 3.012, 2.2>
}
#declare Cube2124 = object {
  box { // Cube2124
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    scale <0.22, 0.1, 0.07>
    rotate -45.0*x
    translate  <0.0, 3.06, 2.81>
  }
}
#declare Cube2127 = object {
  box { // Cube2127
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.355, 0.1>
    translate  <0.0, 1.55, 0.6>
  }
}
#declare Cube2181 = object {
  box { // Cube2181
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 1.1, 0.1>
    translate  <0.0, 1.1, 0.6>
  }
}
#declare CSG325 = union {
  box { // Cube2129
    <-1, -1, -1>, <1, 1, 1>
    scale <0.087, 0.087, 0.6>
    rotate -45.0*z
    translate  <-0.507, 0.02, 0.5>
  }
  box { // Cube2130
    <-1, -1, -1>, <1, 1, 1>
    scale <0.087, 0.087, 0.6>
    rotate -45.0*z
    translate  <-0.507, -0.02, 0.5>
  }
  box { // Cube2131
    <-1, -1, -1>, <1, 1, 1>
    scale <0.123037, 0.02, 0.6>
    translate  <-0.507, 0.0, 0.5>
  }
  scale <1.0, 1.0, 0.83>
  translate  0.085*z
}
#declare Cube2183 = object {
  box { // Cube2183
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.684375, 0.0>
  }
}
#declare Cube2190 = object {
  box { // Cube2190
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.5, 1.25>
    rotate 90.0*z
    translate  <0.0, 1.5, -0.075>
  }
}
#declare Cylndr564 = object {
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.8, 2.6>
    rotate -90.0*x
    translate  <-2.2, -1.3, 4.0>
  }
}
#declare Cylndr566 = object {
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 2.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.2, 0.0, 4.5>
  }
}
#declare Cube2197 = object {
  box { // Cube2197
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 0.12, 1.25>
    rotate 90.0*z
    translate  <0.825, 0.0, 0.375>
  }
}
#declare Cube2202 = object {
  box { // Cube2202
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.25, 1.25>
    rotate 90.0*z
    translate  <0.0, 1.5, -1.5>
  }
}
#declare Cube2208 = object {
  box { // Cube2208
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus041 = object {
  torus { // Torus041
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube2220 = object {
  box { // Cube2220
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube2225 = object {
  box { // Cube2225
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube2230 = object {
  box { // Cube2230
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube2231 = object {
  box { // Cube2231
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube2232 = object {
  box { // Cube2232
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube2245 = object {
  box { // Cube2245
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube2246 = object {
  box { // Cube2246
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube2247 = object {
  box { // Cube2247
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube2248 = object {
  box { // Cube2248
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare SuperQ131 = object {
  superellipsoid { // SuperQ131
    <0.1, 0.1>
    scale <0.8, 0.37, 0.3>
    translate  <-2.2, 0.0, 4.0>
  }
}
#declare Cube2257 = object {
  box { // Cube2257
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.6>
    translate  <-2.0, 0.2, 3.2>
  }
}
#declare Cube2260 = object {
  box { // Cube2260
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 0.12, 1.25>
    rotate 90.0*z
    translate  <0.825, 0.0, 0.375>
  }
}
#declare Cube2265 = object {
  box { // Cube2265
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.2, 1.05>
    rotate 90.0*z
    translate  <0.0, 0.9, -1.5>
  }
}
#declare Cylndr573 = object {
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 1.0, 2.5>
    rotate <-0.0, -90.0, 0.0>
    translate  <1.25, -2.0, -1.5>
  }
}
#declare Cylndr575 = object {
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 1.0, 2.5>
    rotate <-0.0, -90.0, -90.0>
    translate  <2.0, -1.25, -1.5>
  }
}
#declare Cube2269 = object {
  box { // Cube2269
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.05, 0.55>
    translate  <-1.2, 0.0, -2.05>
  }
}
#declare Cube2271 = object {
  box { // Cube2271
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus043 = object {
  torus { // Torus043
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube2283 = object {
  box { // Cube2283
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube2288 = object {
  box { // Cube2288
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube2293 = object {
  box { // Cube2293
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube2294 = object {
  box { // Cube2294
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube2295 = object {
  box { // Cube2295
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube2308 = object {
  box { // Cube2308
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube2309 = object {
  box { // Cube2309
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube2310 = object {
  box { // Cube2310
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube2311 = object {
  box { // Cube2311
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare Engine55 = difference {
  superellipsoid { // SuperQ133
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube2271 }
  object { // Cube2272->Cube2271
    Cube2271
    rotate -15.0*z
  }
  object { // Cube2273->Cube2271
    Cube2271
    rotate -30.0*z
  }
  object { // Cube2274->Cube2271
    Cube2271
    rotate -45.0*z
  }
  object { // Cube2275->Cube2271
    Cube2271
    rotate -60.0*z
  }
  object { // Cube2276->Cube2271
    Cube2271
    rotate -75.0*z
  }
  object { // Cube2277->Cube2271
    Cube2271
    rotate -90.0*z
  }
  object { // Cube2278->Cube2271
    Cube2271
    rotate -105.0*z
  }
  object { // Cube2279->Cube2271
    Cube2271
    rotate -120.0*z
  }
  object { // Cube2280->Cube2271
    Cube2271
    rotate -135.0*z
  }
  object { // Cube2281->Cube2271
    Cube2271
    rotate -150.0*z
  }
  object { // Cube2282->Cube2271
    Cube2271
    rotate -165.0*z
  }
  object { Torus043 }
  object { // Torus044->Torus043
    Torus043
    translate  -2.4*z
  }
  object { Cube2283 }
  object { // Cube2284->Cube2283
    Cube2283
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2285->Cube2283
    Cube2283
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2286->Cube2283
    Cube2283
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2287->Cube2283
    Cube2283
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2288 }
  object { // Cube2289->Cube2288
    Cube2288
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2290->Cube2288
    Cube2288
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2291->Cube2288
    Cube2288
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2292->Cube2288
    Cube2288
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2293 }
  object { Cube2294 }
  object { Cube2295 }
  object { // Cube2296->Cube2295
    Cube2295
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2297->Cube2295
    Cube2295
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2298->Cube2295
    Cube2295
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2299->Cube2295
    Cube2295
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2300->Cube2293
    Cube2293
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2301->Cube2293
    Cube2293
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2302->Cube2293
    Cube2293
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2303->Cube2293
    Cube2293
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2304->Cube2294
    Cube2294
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2305->Cube2294
    Cube2294
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2306->Cube2294
    Cube2294
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2307->Cube2294
    Cube2294
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2308 }
  object { Cube2309 }
  object { Cube2310 }
  object { Cube2311 }
  object { // Cube2312->Cube2308
    Cube2308
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2313->Cube2308
    Cube2308
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2314->Cube2309
    Cube2309
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube2315->Cube2309
    Cube2309
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube2316->Cube2310
    Cube2310
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2317->Cube2310
    Cube2310
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2318->Cube2311
    Cube2311
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube2319->Cube2311
    Cube2311
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine56 = union {
  cone { // Cone206
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine55 }
  material {
    Brushed_Aluminum
  }
  scale 0.7
  rotate <90.0, 0.0, -90.0>
  translate  -2.4*x
}
#declare SuperQ134 = object {
  superellipsoid { // SuperQ134
    <0.1, 0.1>
    scale <0.8, 0.37, 0.3>
    translate  <-2.2, 0.0, 4.0>
  }
}
#declare Cube2320 = object {
  box { // Cube2320
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.6>
    translate  <-2.0, 0.2, 3.2>
  }
}
#declare Plus_part_motor_befestigung15 = union {
  object { SuperQ134 }
  object { Cube2320 }
  object { // Cube2321->Cube2320
    Cube2320
    translate  -0.4*y
  }
  object { // SuperQ135->SuperQ134
    SuperQ134
    translate  1.0*z
  }
}
#declare Motor_Befestigung19 = difference {
  object { Plus_part_motor_befestigung15 }
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    scale <0.73, 0.73, 1.8>
    rotate -90.0*y
    translate  <-1.3, 0.0, 4.5>
  }
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.6>
    rotate -90.0*x
    translate  <-2.59, -0.3, 2.61>
  }
  translate  <0.15, 0.0, -4.5>
}
#declare Cube2323 = object {
  box { // Cube2323
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.12, 1.05, 1.05>
    translate  <-0.96, 0.0, 0.0>
  }
}
#declare Cube2328 = object {
  box { // Cube2328
    <-1, -1, -1>, <1, 1, 1>
    scale <1.02, 0.1, 1.02>
    translate  <0.0, 0.8, -3.0>
  }
}
#declare Cube2351 = object {
  box { // Cube2351
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.684375, 0.0>
  }
}
#declare Cube2358 = object {
  box { // Cube2358
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.5, 1.25>
    rotate 90.0*z
    translate  <0.0, 1.5, -0.075>
  }
}
#declare Cylndr592 = object {
  cylinder { // Cylndr592
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.8, 2.6>
    rotate -90.0*x
    translate  <-2.2, -1.3, 4.0>
  }
}
#declare Cylndr594 = object {
  cylinder { // Cylndr594
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 2.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.2, 0.0, 4.5>
  }
}
#declare Cube2365 = object {
  box { // Cube2365
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 0.12, 1.25>
    rotate 90.0*z
    translate  <0.825, 0.0, 0.375>
  }
}
#declare Cube2370 = object {
  box { // Cube2370
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.25, 1.25>
    rotate 90.0*z
    translate  <0.0, 1.5, -1.5>
  }
}
#declare Cube2376 = object {
  box { // Cube2376
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus045 = object {
  torus { // Torus045
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube2388 = object {
  box { // Cube2388
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube2393 = object {
  box { // Cube2393
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube2398 = object {
  box { // Cube2398
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube2399 = object {
  box { // Cube2399
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube2400 = object {
  box { // Cube2400
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube2413 = object {
  box { // Cube2413
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube2414 = object {
  box { // Cube2414
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube2415 = object {
  box { // Cube2415
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube2416 = object {
  box { // Cube2416
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare SuperQ137 = object {
  superellipsoid { // SuperQ137
    <0.1, 0.1>
    scale <0.8, 0.37, 0.3>
    translate  <-2.2, 0.0, 4.0>
  }
}
#declare Cube2425 = object {
  box { // Cube2425
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.6>
    translate  <-2.0, 0.2, 3.2>
  }
}
#declare Cube2428 = object {
  box { // Cube2428
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 0.12, 1.25>
    rotate 90.0*z
    translate  <0.825, 0.0, 0.375>
  }
}
#declare Cube2433 = object {
  box { // Cube2433
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.2, 1.05>
    rotate 90.0*z
    translate  <0.0, 0.9, -1.5>
  }
}
#declare Cylndr601 = object {
  cylinder { // Cylndr601
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 1.0, 2.5>
    rotate <-0.0, -90.0, 0.0>
    translate  <1.25, -2.0, -1.5>
  }
}
#declare Cylndr603 = object {
  cylinder { // Cylndr603
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 1.0, 2.5>
    rotate <-0.0, -90.0, -90.0>
    translate  <2.0, -1.25, -1.5>
  }
}
#declare Cube2437 = object {
  box { // Cube2437
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.05, 0.55>
    translate  <-1.2, 0.0, -2.05>
  }
}
#declare Cube2439 = object {
  box { // Cube2439
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus047 = object {
  torus { // Torus047
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube2451 = object {
  box { // Cube2451
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube2456 = object {
  box { // Cube2456
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube2461 = object {
  box { // Cube2461
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube2462 = object {
  box { // Cube2462
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube2463 = object {
  box { // Cube2463
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube2476 = object {
  box { // Cube2476
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube2477 = object {
  box { // Cube2477
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube2478 = object {
  box { // Cube2478
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube2479 = object {
  box { // Cube2479
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare Engine60 = difference {
  superellipsoid { // SuperQ139
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr605
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube2439 }
  object { // Cube2440->Cube2439
    Cube2439
    rotate -15.0*z
  }
  object { // Cube2441->Cube2439
    Cube2439
    rotate -30.0*z
  }
  object { // Cube2442->Cube2439
    Cube2439
    rotate -45.0*z
  }
  object { // Cube2443->Cube2439
    Cube2439
    rotate -60.0*z
  }
  object { // Cube2444->Cube2439
    Cube2439
    rotate -75.0*z
  }
  object { // Cube2445->Cube2439
    Cube2439
    rotate -90.0*z
  }
  object { // Cube2446->Cube2439
    Cube2439
    rotate -105.0*z
  }
  object { // Cube2447->Cube2439
    Cube2439
    rotate -120.0*z
  }
  object { // Cube2448->Cube2439
    Cube2439
    rotate -135.0*z
  }
  object { // Cube2449->Cube2439
    Cube2439
    rotate -150.0*z
  }
  object { // Cube2450->Cube2439
    Cube2439
    rotate -165.0*z
  }
  object { Torus047 }
  object { // Torus048->Torus047
    Torus047
    translate  -2.4*z
  }
  object { Cube2451 }
  object { // Cube2452->Cube2451
    Cube2451
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2453->Cube2451
    Cube2451
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2454->Cube2451
    Cube2451
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2455->Cube2451
    Cube2451
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2456 }
  object { // Cube2457->Cube2456
    Cube2456
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2458->Cube2456
    Cube2456
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2459->Cube2456
    Cube2456
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2460->Cube2456
    Cube2456
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2461 }
  object { Cube2462 }
  object { Cube2463 }
  object { // Cube2464->Cube2463
    Cube2463
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2465->Cube2463
    Cube2463
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2466->Cube2463
    Cube2463
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2467->Cube2463
    Cube2463
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2468->Cube2461
    Cube2461
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2469->Cube2461
    Cube2461
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2470->Cube2461
    Cube2461
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2471->Cube2461
    Cube2461
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2472->Cube2462
    Cube2462
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2473->Cube2462
    Cube2462
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2474->Cube2462
    Cube2462
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2475->Cube2462
    Cube2462
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2476 }
  object { Cube2477 }
  object { Cube2478 }
  object { Cube2479 }
  object { // Cube2480->Cube2476
    Cube2476
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2481->Cube2476
    Cube2476
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2482->Cube2477
    Cube2477
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube2483->Cube2477
    Cube2477
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube2484->Cube2478
    Cube2478
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2485->Cube2478
    Cube2478
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2486->Cube2479
    Cube2479
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube2487->Cube2479
    Cube2479
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine61 = union {
  cone { // Cone208
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine60 }
  material {
    Brushed_Aluminum
  }
  scale 0.7
  rotate <90.0, 0.0, -90.0>
  translate  -2.4*x
}
#declare SuperQ140 = object {
  superellipsoid { // SuperQ140
    <0.1, 0.1>
    scale <0.8, 0.37, 0.3>
    translate  <-2.2, 0.0, 4.0>
  }
}
#declare Cube2488 = object {
  box { // Cube2488
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.05, 0.6>
    translate  <-2.0, 0.2, 3.2>
  }
}
#declare Plus_part_motor_befestigung17 = union {
  object { SuperQ140 }
  object { Cube2488 }
  object { // Cube2489->Cube2488
    Cube2488
    translate  -0.4*y
  }
  object { // SuperQ141->SuperQ140
    SuperQ140
    translate  1.0*z
  }
}
#declare Motor_Befestigung22 = difference {
  object { Plus_part_motor_befestigung17 }
  cylinder { // Cylndr606
    <0,0,1>, <0,0,0>, 1 
    scale <0.73, 0.73, 1.8>
    rotate -90.0*y
    translate  <-1.3, 0.0, 4.5>
  }
  cylinder { // Cylndr607
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.6>
    rotate -90.0*x
    translate  <-2.59, -0.3, 2.61>
  }
  translate  <0.15, 0.0, -4.5>
}
#declare Cube2491 = object {
  box { // Cube2491
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.12, 1.05, 1.05>
    translate  <-0.96, 0.0, 0.0>
  }
}
#declare Cube2496 = object {
  box { // Cube2496
    <-1, -1, -1>, <1, 1, 1>
    scale <1.02, 0.1, 1.02>
    translate  <0.0, 0.8, -3.0>
  }
}
#declare CSG346 = union {
  superellipsoid { // SuperQ142
    <0.1, 0.1>
    scale <0.7, 0.7, 0.9>
    translate  <-1.2, 1.95, 0.0>
  }
  superellipsoid { // SuperQ143
    <0.1, 0.1>
    scale <0.9, 0.2, 0.9>
    translate  <-1.0, 1.5, 0.0>
  }
}
#declare fix_the_engine4 = difference {
  object { CSG346 }
  cylinder { // Cylndr620
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.6>
    rotate -90.0*x
    translate  <-2.0, 1.1, 0.0>
  }
}
#declare Cylndr624 = object {
  cylinder { // Cylndr624
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 0.375>
    rotate -90.0*x
    translate  -1.2*y
  }
}
#declare Minus_4_Scheiben22 = union {
  object { Cylndr624 }
  object { // Cylndr625->Cylndr624
    Cylndr624
    rotate <0.0, -0.0, -0.0>
    translate  0.675*y
  }
  object { // Cylndr626->Cylndr624
    Cylndr624
    rotate <0.0, -0.0, -0.0>
    translate  1.35*y
  }
  object { // Cylndr627->Cylndr624
    Cylndr624
    rotate <0.0, -0.0, -0.0>
    translate  2.025*y
  }
  translate  -4.5*x
}
#declare CSG347 = difference {
  cylinder { // Cylndr630
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
  }
  cone { // Cone209
    <0,0,0>, 0.9, <0,0,1>, 0.7
    scale <1.0, 1.0, 0.2>
    translate  0.45*z
  }
  cylinder { // Cylndr631
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 0.45>
  }
}
#declare Cube2524 = object {
  box { // Cube2524
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.5, 0.3>
    translate  0.4*z
  }
}
#declare Schraube__minus_solid_part_14 = union {
  object { CSG347 }
  object { Cube2524 }
  object { // Cube2525->Cube2524
    Cube2524
    rotate -120.0*z
  }
  object { // Cube2526->Cube2524
    Cube2524
    rotate 120.0*z
  }
  scale 0.2
  rotate <-0.0, -90.0, -180.0>
  translate  <-0.614227, 2.116537, 0.454676>
}
#declare Cube2527 = object {
  box { // Cube2527
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.1, 1.0>
  }
}
#declare Torus049 = object {
  torus { // Torus049
    1.0, 0.05  rotate -x*90
    translate  1.2*z
  }
}
#declare Cube2539 = object {
  box { // Cube2539
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.2, 1.3>
  }
}
#declare Cube2544 = object {
  box { // Cube2544
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.2, 1.3>
  }
}
#declare Cube2549 = object {
  box { // Cube2549
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.0, 1.3>
  }
}
#declare Cube2550 = object {
  box { // Cube2550
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, 0.4, 1.3>
  }
}
#declare Cube2551 = object {
  box { // Cube2551
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.4, -0.4, 1.3>
  }
}
#declare Cube2564 = object {
  box { // Cube2564
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.6, 0.2, 1.3>
  }
}
#declare Cube2565 = object {
  box { // Cube2565
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, 0.6, 1.3>
  }
}
#declare Cube2566 = object {
  box { // Cube2566
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <0.6, 0.2, 1.3>
  }
}
#declare Cube2567 = object {
  box { // Cube2567
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.3>
    translate  <-0.2, -0.6, 1.3>
  }
}
#declare Engine64 = difference {
  superellipsoid { // SuperQ147
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr633
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube2527 }
  object { // Cube2528->Cube2527
    Cube2527
    rotate -15.0*z
  }
  object { // Cube2529->Cube2527
    Cube2527
    rotate -30.0*z
  }
  object { // Cube2530->Cube2527
    Cube2527
    rotate -45.0*z
  }
  object { // Cube2531->Cube2527
    Cube2527
    rotate -60.0*z
  }
  object { // Cube2532->Cube2527
    Cube2527
    rotate -75.0*z
  }
  object { // Cube2533->Cube2527
    Cube2527
    rotate -90.0*z
  }
  object { // Cube2534->Cube2527
    Cube2527
    rotate -105.0*z
  }
  object { // Cube2535->Cube2527
    Cube2527
    rotate -120.0*z
  }
  object { // Cube2536->Cube2527
    Cube2527
    rotate -135.0*z
  }
  object { // Cube2537->Cube2527
    Cube2527
    rotate -150.0*z
  }
  object { // Cube2538->Cube2527
    Cube2527
    rotate -165.0*z
  }
  object { Torus049 }
  object { // Torus050->Torus049
    Torus049
    translate  -2.4*z
  }
  object { Cube2539 }
  object { // Cube2540->Cube2539
    Cube2539
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2541->Cube2539
    Cube2539
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2542->Cube2539
    Cube2539
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2543->Cube2539
    Cube2539
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2544 }
  object { // Cube2545->Cube2544
    Cube2544
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2546->Cube2544
    Cube2544
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2547->Cube2544
    Cube2544
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2548->Cube2544
    Cube2544
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2549 }
  object { Cube2550 }
  object { Cube2551 }
  object { // Cube2552->Cube2551
    Cube2551
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2553->Cube2551
    Cube2551
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2554->Cube2551
    Cube2551
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2555->Cube2551
    Cube2551
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2556->Cube2549
    Cube2549
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2557->Cube2549
    Cube2549
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2558->Cube2549
    Cube2549
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2559->Cube2549
    Cube2549
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2560->Cube2550
    Cube2550
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2561->Cube2550
    Cube2550
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2562->Cube2550
    Cube2550
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2563->Cube2550
    Cube2550
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2564 }
  object { Cube2565 }
  object { Cube2566 }
  object { Cube2567 }
  object { // Cube2568->Cube2564
    Cube2564
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2569->Cube2564
    Cube2564
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2570->Cube2565
    Cube2565
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube2571->Cube2565
    Cube2565
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube2572->Cube2566
    Cube2566
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2573->Cube2566
    Cube2566
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2574->Cube2567
    Cube2567
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube2575->Cube2567
    Cube2567
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine65 = union {
  cone { // Cone211
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine64 }
  material {
    Brushed_Aluminum
  }
  scale <1.0, 1.0, 0.5>
  rotate <-90.0, 0.0, -0.0>
  translate  <-2.0, 2.35, 0.0>
}
#declare CSG348 = union {
  box { // Cube2576
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.06, 0.6>
    rotate -44.0*z
    translate  <-1.009846, -0.017627, 0.5>
  }
  box { // Cube2577
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.06, 0.6>
    rotate -46.0*z
    translate  <-1.009846, 0.017627, 0.5>
  }
  box { // Cube2578
    <-1, -1, -1>, <1, 1, 1>
    scale <0.084994, 0.016146, 0.6>
    translate  <-1.01, 0.0, 0.5>
  }
}
#declare Viertel_hohl_zylinder1 = difference {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <111.0, 111.0, 1.1>
    translate  10.0*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <109.0, 109.0, 1.3>
    translate  9.9*z
  }
}
#declare Viertel_hohl_zylinder2 = difference {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <121.0, 121.0, 1.1>
    translate  10.0*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <119.0, 119.0, 1.3>
    translate  9.9*z
  }
}
#declare Viertel_hohl_zylinder = difference {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <120.0, 120.0, 11.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <110.0, 110.0, 11.2>
    translate  -0.1*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 122.0, 11.2>
    rotate -25.0*z
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 122.0, 11.2>
    rotate 25.0*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -25.0*z
    translate  <81.8, 30.0, 0.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -65.0*z
    translate  <81.7, -30.3, 0.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -25.0*z
    translate  <-80.2, -30.3, 0.0>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -65.0*z
    translate  <-81.4, 29.8, 0.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    translate  <1.5, -63.9, 0.0>
  }
  object { Viertel_hohl_zylinder1 }
  object { Viertel_hohl_zylinder2 }
  box { // Cube876
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 122.0, 1.1>
    rotate -25.0*z
    translate  10.0*z
  }
}
#declare torus_innen = difference {
  torus { // Torus001
    111.0, 1.0  rotate -x*90
    translate  10.0*z
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 122.0, 11.2>
    rotate -25.0*z
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 122.0, 11.2>
    rotate 25.0*z
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -25.0*z
    translate  <81.8, 30.0, 0.0>
  }
  box { // Cube865
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -65.0*z
    translate  <81.7, -30.3, 0.0>
  }
  box { // Cube866
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -25.0*z
    translate  <-80.2, -30.3, 0.0>
  }
  box { // Cube867
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -65.0*z
    translate  <-81.4, 29.8, 0.0>
  }
  box { // Cube868
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    translate  <1.5, -63.9, 0.0>
  }
}
#declare torus_aussen = difference {
  torus { // Torus002
    119.0, 1.0  rotate -x*90
    translate  10.0*z
  }
  box { // Cube869
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 122.0, 11.2>
    rotate -25.0*z
  }
  box { // Cube870
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 122.0, 11.2>
    rotate 25.0*z
  }
  box { // Cube871
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -25.0*z
    translate  <81.8, 30.0, 0.0>
  }
  box { // Cube872
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -65.0*z
    translate  <81.7, -30.3, 0.0>
  }
  box { // Cube873
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -25.0*z
    translate  <-80.2, -30.3, 0.0>
  }
  box { // Cube874
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    rotate -65.0*z
    translate  <-81.4, 29.8, 0.0>
  }
  box { // Cube875
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 11.2>
    translate  <1.5, -63.9, 0.0>
  }
}
union { // Sitzgelegenheit
  object { Viertel_hohl_zylinder }
  object { torus_innen }
  object { torus_aussen }
  material {
    SandstP
  }
}
union { // Laufpfad
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1500.0, 14.0, 0.5>
    translate  <-1500.0, 0.0, 0.5>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <60.0, 60.0, 1.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <1600.0, 14.0, 0.5>
    rotate 45.0*z
    translate  <1140.0, 1140.0, 0.5>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1500.0, 14.0, 0.5>
    rotate 90.0*z
    translate  <0.0, -1500.0, 0.5>
  }
  material {
    SandstP
  }
  scale <2.0, 2.0, 6.0>
  translate  -6.0*z
}
sphere { // Sky_sphere
  <0,0,0>,1
  material {
    Light_Clouds
  }
  hollow
  scale 5000.0
}
#declare plus_part18 = union {
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 3.0>
    rotate <-90.0, 0.0, -90.0>
    translate  -1.5*x
  }
  box { // Cube1728
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 2.0>
    translate  2.0*z
  }
  superellipsoid { // SuperQ099
    <0.1, 0.1>
    scale <4.0, 1.5, 1.5>
    translate  3.5*z
  }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 3.5>
  }
}
#declare Minus_5_Scheiben24 = union {
  object { Cube1729 }
  object { // Cube1730->Cube1729
    Cube1729
    translate  <-0.0, 0.84375, 0.0>
  }
  object { // Cube1731->Cube1729
    Cube1729
    translate  <-0.0, 1.6875, 0.0>
  }
  object { // Cube1732->Cube1729
    Cube1729
    translate  <-0.0, 2.53125, 0.0>
  }
  object { // Cube1733->Cube1729
    Cube1729
    translate  <-0.0, 3.375, 0.0>
  }
  box { // Cube1734
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.78437, -0.05>
  }
  object { // Cube1735->Cube1729
    Cube1729
    translate  3.475*y
  }
  scale <1.2, 0.8, 1.2>
  rotate -90.0*z
  translate  0.075*z
}
#declare mittel_haupt_saele_1_14 = difference {
  object { plus_part18 }
  object { Minus_5_Scheiben24 }
  superellipsoid { // SuperQ100
    <0.1, 0.1>
    scale <1.0, 0.2, 0.8>
    translate  <0.0, -1.6, 3.5>
  }
}
#declare Zahnrad_Schraee22 = difference {
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone146
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <1.05, 1.05, 2.0>
  translate  0.92*z
}
#declare Zahnrad_Schraee23 = difference {
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone147
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <1.05, 1.05, 2.0>
  rotate -180.0*y
  translate  0.08*z
}
#declare Zahnrad_gross6 = difference {
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
  }
  object { CSG262 }
  object { // CSG263->CSG262
    CSG262
    rotate -12.0*z
  }
  object { // CSG264->CSG262
    CSG262
    rotate -24.0*z
  }
  object { // CSG265->CSG262
    CSG262
    rotate -36.0*z
  }
  object { // CSG266->CSG262
    CSG262
    rotate -48.0*z
  }
  object { // CSG267->CSG262
    CSG262
    rotate -60.0*z
  }
  object { // CSG268->CSG262
    CSG262
    rotate -72.0*z
  }
  object { // CSG269->CSG262
    CSG262
    rotate -84.0*z
  }
  object { // CSG270->CSG262
    CSG262
    rotate -96.0*z
  }
  object { // CSG271->CSG262
    CSG262
    rotate -108.0*z
  }
  object { // CSG272->CSG262
    CSG262
    rotate -120.0*z
  }
  object { // CSG273->CSG262
    CSG262
    rotate -132.0*z
  }
  object { // CSG274->CSG262
    CSG262
    rotate -144.0*z
  }
  object { // CSG275->CSG262
    CSG262
    rotate -156.0*z
  }
  object { // CSG276->CSG262
    CSG262
    rotate -168.0*z
  }
  object { // CSG277->CSG262
    CSG262
    rotate 180.0*z
  }
  object { // CSG278->CSG262
    CSG262
    rotate 168.0*z
  }
  object { // CSG279->CSG262
    CSG262
    rotate 156.0*z
  }
  object { // CSG280->CSG262
    CSG262
    rotate 144.0*z
  }
  object { // CSG281->CSG262
    CSG262
    rotate 132.0*z
  }
  object { // CSG282->CSG262
    CSG262
    rotate 120.0*z
  }
  object { // CSG283->CSG262
    CSG262
    rotate 108.0*z
  }
  object { // CSG284->CSG262
    CSG262
    rotate 96.0*z
  }
  object { // CSG285->CSG262
    CSG262
    rotate 84.0*z
  }
  object { // CSG286->CSG262
    CSG262
    rotate 72.0*z
  }
  object { // CSG287->CSG262
    CSG262
    rotate 60.0*z
  }
  object { // CSG288->CSG262
    CSG262
    rotate 48.0*z
  }
  object { // CSG289->CSG262
    CSG262
    rotate 36.0*z
  }
  object { // CSG290->CSG262
    CSG262
    rotate 24.0*z
  }
  object { // CSG291->CSG262
    CSG262
    rotate 12.0*z
  }
  object { Zahnrad_Schraee22 }
  object { Zahnrad_Schraee23 }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 2.0>
    translate  -0.5*z
  }
  scale <1.65, 1.65, 0.5>
  rotate -90.0*y
  translate  -4.1*x
}
#declare plus_part_15 = union {
  superellipsoid { // SuperQ105
    <0.1, 0.1>
    scale <1.7, 1.5, 1.5>
    translate  -6.3*x
  }
  superellipsoid { // SuperQ106
    <1.0, 0.1>
    scale 1.5
    rotate -90.0*x
    translate  -8.0*x
  }
}
#declare Minus_5_Scheiben25 = union {
  object { Cube1791 }
  object { // Cube1792->Cube1791
    Cube1791
    translate  <-0.0, 0.84375, 0.0>
  }
  object { // Cube1793->Cube1791
    Cube1791
    translate  <-0.0, 1.6875, 0.0>
  }
  object { // Cube1794->Cube1791
    Cube1791
    translate  <-0.0, 2.53125, 0.0>
  }
  object { // Cube1795->Cube1791
    Cube1791
    translate  <-0.0, 3.375, 0.0>
  }
  box { // Cube1796
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.78437, -0.05>
  }
  object { // Cube1797->Cube1791
    Cube1791
    translate  3.475*y
  }
  scale <1.3, 0.8, 1.2>
  translate  <-8.0, 0.0, 0.075>
}
#declare Hauptteil4 = difference {
  object { plus_part_15 }
  object { Minus_5_Scheiben25 }
  material {
    std_red
  }
}
#declare plus_part_16 = union {
  superellipsoid { // SuperQ107
    <0.1, 0.1>
    scale <1.5, 1.5, 1.0>
    translate  -1.0*z
  }
  superellipsoid { // SuperQ108
    <1.0, 0.1>
    scale 1.5
    rotate -90.0*x
  }
  cone { // Cone148
    <0,0,0>, 1.1, <0,0,1>, 1.4
    scale <1.0, 1.0, 0.7>
    translate  -2.6*z
  }
}
#declare minus_x_scheiben4 = union {
  object { Cube1798 }
  object { // Cube1799->Cube1798
    Cube1798
    rotate 0.0*z
    translate  <-0.0, 0.675, 0.0>
  }
  object { // Cube1800->Cube1798
    Cube1798
    rotate -0.0*z
    translate  <-0.0, 1.35, 0.0>
  }
  object { // Cube1801->Cube1798
    Cube1798
    rotate -0.0*z
    translate  <-0.0, 2.025, 0.0>
  }
}
#declare Hauptteil_8 = difference {
  object { plus_part_16 }
  object { minus_x_scheiben4 }
}
#declare another_plus_part4 = union {
  box { // Cube1802
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 2.5>
    translate  -3.2*z
  }
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    material {
      black_yellow_stripes
    }
    scale <1.1, 1.1, 1.0>
    translate  -0.9*z
  }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 2.2>
    rotate -90.0*y
    translate  <1.1, 0.0, -5.7>
  }
}
#declare abrunden9 = difference {
  box { // Cube1803
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 1.8, 0.3>
  }
  cone { // Cone149
    <0,0,0>, 1.1, <0,0,1>, 1.5
    scale <1.0, 1.0, 0.7>
    translate  -0.35*z
  }
  scale <1.0, 1.0, 1.5>
  rotate -180.0*y
  translate  -1.1*z
}
#declare minus_y_scheiben8 = union {
  object { Cube1804 }
  object { // Cube1805->Cube1804
    Cube1804
    translate  0.4875*x
  }
  object { // Cube1806->Cube1804
    Cube1804
    translate  0.975*x
  }
  object { // Cube1807->Cube1804
    Cube1804
    translate  1.4625*x
  }
}
#declare Hauptteil__4 = difference {
  object { another_plus_part4 }
  object { abrunden9 }
  object { minus_y_scheiben8 }
  translate  13.65*z
}
#declare plus_part_17 = union {
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 2.2>
    rotate <-0.0, -90.0, 0.0>
    translate  1.1*x
  }
  box { // Cube1808
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 1.3>
    translate  -1.3*z
  }
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 4.7>
    rotate -0.0*x
    translate  -7.5*z
  }
}
#declare minus_y_scheiben9 = union {
  object { Cube1809 }
  object { // Cube1810->Cube1809
    Cube1809
    rotate -0.0*y
    translate  <0.4875, 0.0, 0.0>
  }
  object { // Cube1811->Cube1809
    Cube1809
    rotate -0.0*y
    translate  <0.975, 0.0, 0.0>
  }
  object { // Cube1812->Cube1809
    Cube1809
    rotate -0.0*y
    translate  <1.4625, 0.0, 0.0>
  }
  object { // Cube1813->Cube1809
    Cube1809
    rotate -0.0*y
    translate  <1.95, 0.0, 0.0>
  }
  box { // Cube1814
    <-1, -1, -1>, <1, 1, 1>
    scale <0.125, 1.12, 1.12>
    translate  -0.995*x
  }
  object { // Cube1815->Cube1809
    Cube1809
    rotate -0.0*y
    translate  <1.97, 0.0, 0.0>
  }
}
#declare abrunden10 = difference {
  box { // Cube1816
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 1.8, 0.3>
  }
  cone { // Cone150
    <0,0,0>, 0.8, <0,0,1>, 1.7
    scale <1.0, 1.0, 0.7>
    translate  -0.35*z
  }
  scale <1.0, 1.0, 2.5>
  translate  -2.0*z
}
#declare Hauptteil_9 = difference {
  object { plus_part_17 }
  object { minus_y_scheiben9 }
  object { abrunden10 }
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 3.6>
    rotate -0.0*x
    translate  -7.0*z
  }
  object { minus_something12 }
  object { // minus_something13->minus_something12
    minus_something12
    rotate -120.0*z
  }
  object { // minus_something14->minus_something12
    minus_something12
    rotate 120.0*z
  }
}
#declare plus_part_finger36 = union {
  box { // Cube1818
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader144 }
  object { // ader145->ader144
    ader144
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader146->ader144
    ader144
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader147->ader144
    ader144
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part36 = difference {
  object { plus_part_finger36 }
  object { Cube1819 }
  object { Cube1820 }
  object { // Cube1821->Cube1820
    Cube1820
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1822->Cube1820
    Cube1820
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1823->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1824->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1825->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1826
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1827
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone152
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone153
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger37 = union {
  box { // Cube1828
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader148 }
  object { // ader149->ader148
    ader148
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader150->ader148
    ader148
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader151->ader148
    ader148
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part37 = difference {
  object { plus_part_finger37 }
  object { Cube1829 }
  object { Cube1830 }
  object { // Cube1831->Cube1830
    Cube1830
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1832->Cube1830
    Cube1830
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1833->Cube1829
    Cube1829
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1834->Cube1829
    Cube1829
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1835->Cube1829
    Cube1829
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1836
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1837
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone154
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone155
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger38 = union {
  box { // Cube1838
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader152 }
  object { // ader153->ader152
    ader152
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader154->ader152
    ader152
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader155->ader152
    ader152
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part38 = difference {
  object { plus_part_finger38 }
  object { Cube1839 }
  object { // Cube1840->Cube1839
    Cube1839
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1841->Cube1839
    Cube1839
    // All transformations fixed
    translate  0.4*x
  }
  cone { // Cone156
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone157
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare Finger_left_37 = union {
  object { finger_part38 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -30.0*x
  translate  -1.57*y
}
#declare Finger_left_38 = union {
  object { finger_part37 }
  object { Finger_left_37 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -10.0*x
  translate  -1.6*y
}
#declare Finger_left_39 = union {
  object { finger_part36 }
  object { Finger_left_38 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 30.0*x
  translate  <-0.85, -0.7, 0.0>
}
#declare plus_part_palm4 = union {
  box { // Cube1842
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.2, 0.7, 0.3>
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 2.4>
    rotate -90.0*y
    translate  <1.2, -0.7, 0.0>
  }
  // All transformations fixed
}
#declare palm8 = difference {
  object { plus_part_palm4 }
  box { // Cube1843
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.4>
    rotate 25.0*z
    translate  <1.65, 0.03, 0.0>
  }
  box { // Cube1844
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.4>
    rotate -25.0*z
    translate  <-1.65, 0.03, 0.0>
  }
  object { Cube1845 }
  object { // Cube1846->Cube1845
    Cube1845
    // All transformations fixed
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube1847->Cube1845
    Cube1845
    // All transformations fixed
    translate  <0.4, 0.0, 0.0>
  }
  object { // Cube1848->Cube1845
    Cube1845
    // All transformations fixed
    translate  <0.6, 0.0, 0.0>
  }
  object { // Cube1849->Cube1856
    Cube1856
    // All transformations fixed
    translate  <0.6, -0.0, 0.0>
  }
  object { // Cube1850->Cube1856
    Cube1856
    // All transformations fixed
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube1851->Cube1856
    Cube1856
    // All transformations fixed
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube1852->Cube1855
    Cube1855
    // All transformations fixed
    rotate -0.0*z
    translate  <0.6, -0.0, 0.0>
  }
  object { // Cube1853->Cube1855
    Cube1855
    // All transformations fixed
    rotate -0.0*z
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube1854->Cube1855
    Cube1855
    // All transformations fixed
    rotate -0.0*z
    translate  <0.2, -0.0, 0.0>
  }
  object { Cube1855 }
  object { Cube1856 }
  box { // Cube1857
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-1.16, -0.7, 0.0>
  }
  box { // Cube1858
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <1.16, -0.7, 0.0>
  }
  // All transformations fixed
}
#declare ader156 = union {
  sphere { // Sphere095
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere096
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare plus_part_finger39 = union {
  box { // Cube1859
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader156 }
  object { // ader157->ader144
    ader144
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader158->ader144
    ader144
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader159->ader144
    ader144
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part39 = difference {
  object { plus_part_finger39 }
  box { // Cube1860
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
  box { // Cube1861
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
  object { // Cube1862->Cube1820
    Cube1820
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1863->Cube1820
    Cube1820
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1864->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1865->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1866->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1867
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1868
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone158
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone159
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger40 = union {
  box { // Cube1869
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader160 }
  object { // ader161->ader160
    ader160
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader162->ader160
    ader160
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader163->ader160
    ader160
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part40 = difference {
  object { plus_part_finger40 }
  object { Cube1870 }
  object { Cube1871 }
  object { // Cube1872->Cube1871
    Cube1871
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1873->Cube1871
    Cube1871
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1874->Cube1870
    Cube1870
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1875->Cube1870
    Cube1870
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1876->Cube1870
    Cube1870
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1877
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1878
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone160
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone161
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger41 = union {
  box { // Cube1879
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader164 }
  object { // ader165->ader164
    ader164
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader166->ader164
    ader164
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader167->ader164
    ader164
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part41 = difference {
  object { plus_part_finger41 }
  object { Cube1880 }
  object { // Cube1881->Cube1880
    Cube1880
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1882->Cube1880
    Cube1880
    // All transformations fixed
    translate  0.4*x
  }
  cone { // Cone162
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone163
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare Finger_left_40 = union {
  object { finger_part41 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 20.0*x
  translate  -1.57*y
}
#declare Finger_left_41 = union {
  object { finger_part40 }
  object { Finger_left_40 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 10.0*x
  translate  -1.6*y
}
#declare Finger_left_42 = union {
  object { finger_part39 }
  object { Finger_left_41 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -30.0*x
  translate  -0.7*y
}
#declare ader168 = union {
  sphere { // Sphere101
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere102
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare plus_part_finger42 = union {
  box { // Cube1883
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader168 }
  object { // ader169->ader144
    ader144
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader170->ader144
    ader144
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader171->ader144
    ader144
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part42 = difference {
  object { plus_part_finger42 }
  box { // Cube1884
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
  box { // Cube1885
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
  object { // Cube1886->Cube1820
    Cube1820
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1887->Cube1820
    Cube1820
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1888->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1889->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1890->Cube1819
    Cube1819
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1891
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1892
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone164
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone165
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger43 = union {
  box { // Cube1893
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader172 }
  object { // ader173->ader172
    ader172
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader174->ader172
    ader172
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader175->ader172
    ader172
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part43 = difference {
  object { plus_part_finger43 }
  object { Cube1894 }
  object { Cube1895 }
  object { // Cube1896->Cube1895
    Cube1895
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1897->Cube1895
    Cube1895
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1898->Cube1894
    Cube1894
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1899->Cube1894
    Cube1894
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1900->Cube1894
    Cube1894
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1901
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1902
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone166
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone167
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger44 = union {
  box { // Cube1903
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader176 }
  object { // ader177->ader176
    ader176
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader178->ader176
    ader176
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader179->ader176
    ader176
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part44 = difference {
  object { plus_part_finger44 }
  object { Cube1904 }
  object { // Cube1905->Cube1904
    Cube1904
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1906->Cube1904
    Cube1904
    // All transformations fixed
    translate  0.4*x
  }
  cone { // Cone168
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone169
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare Finger_left_43 = union {
  object { finger_part44 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -30.0*x
  translate  -1.57*y
}
#declare Finger_left_44 = union {
  object { finger_part43 }
  object { Finger_left_43 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -10.0*x
  translate  -1.6*y
}
#declare Finger_left_45 = union {
  object { finger_part42 }
  object { Finger_left_44 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 30.0*x
  translate  <0.85, -0.7, 0.0>
}
#declare plus_part_palm_6 = union {
  cone { // Cone170
    <0,0,0>, 0.29, <0,0,1>, 0.8
    rotate -90.0*x
    translate  -0.27*y
  }
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 2.0>
    rotate -90.0*x
    translate  0.73*y
  }
}
#declare palm9 = difference {
  object { plus_part_palm_6 }
  box { // Cube1907
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.1>
    translate  <0.0, 1.43, 0.8>
  }
  box { // Cube1908
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.1>
    rotate 27.0*x
    translate  <0.0, 0.16, 0.57>
  }
}
#declare HAND2 = union {
  object { Finger_left_39 }
  object { palm8 }
  object { Finger_left_42 }
  object { Finger_left_45 }
  object { palm9 }
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.09, 1.8>
    rotate -90.0*x
    translate  <0.0, 0.73, 0.7>
  }
  sphere { // Sphere107
    <0,0,0>,1
    scale 0.09
    translate  <0.0, 0.73, 0.7>
  }
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.09, 1.2>
    rotate -63.0*x
    translate  <0.0, -0.34, 0.155>
  }
  // Scaling fixed
  // Rot Z limited (-360.0 to   360.0)
  // Translation fixed
  scale 0.7
  rotate <90.0, 0.0, 105.0>
  translate  -9.0*z
}
#declare UNTERARM4 = union {
  object { Hauptteil_9 }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  -3.0*z
  }
  object { Cylndr449 }
  object { // Cylndr450->Cylndr449
    Cylndr449
    rotate <0.0, 0.0, -120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr451->Cylndr449
    Cylndr449
    rotate <0.0, 0.0, 120.0>
  }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.2>
    rotate -0.0*x
    translate  -7.3*z
  }
  cone { // Cone151
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <1.0, 1.0, 0.5>
    translate  -7.999*z
  }
  object { HAND2 }
  // Scaling fixed
  // Rot X limited (-160.0 to   160.0)
  // Translation fixed
  rotate <-10.0, -0.0, 0.0>
  translate  7.95*z
}
#declare OBERARM_4 = union {
  object { Hauptteil__4 }
  object { UNTERARM4 }
  // Scaling fixed
  // Rot Z limited (-360.0 to   360.0)
  // Translation fixed
  rotate <-0.0, 0.0, 80.0>
  translate  -16.2*z
}
#declare SCHULTER_GANZ_AUSSEN4 = union {
  object { Hauptteil_8 }
  object { OBERARM_4 }
  // Scaling fixed
  // Rot Y limited (-30.0 to   235.0)
  // Translation fixed
  rotate <0.0, 9.0, -0.0>
  translate  -8.0*x
}
#declare SCHULTER_HALB_AUSSEN4 = union {
  object { Zahnrad_gross6 }
  object { Hauptteil4 }
  object { SCHULTER_GANZ_AUSSEN4 }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rot X limited (-360.0 to   360.0)
  // Translation fixed
  rotate -0.01*x
  translate  3.5*z
}
#declare Zahnrad_Schraee24 = difference {
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone171
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <1.05, 1.05, 2.0>
  translate  0.92*z
}
#declare Zahnrad_Schraee25 = difference {
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone172
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <1.05, 1.05, 2.0>
  rotate -180.0*y
  translate  0.08*z
}
#declare Zahnrad_gross7 = difference {
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
  }
  object { CSG292 }
  object { // CSG293->CSG292
    CSG292
    rotate -12.0*z
  }
  object { // CSG294->CSG292
    CSG292
    rotate -24.0*z
  }
  object { // CSG295->CSG292
    CSG292
    rotate -36.0*z
  }
  object { // CSG296->CSG292
    CSG292
    rotate -48.0*z
  }
  object { // CSG297->CSG292
    CSG292
    rotate -60.0*z
  }
  object { // CSG298->CSG292
    CSG292
    rotate -72.0*z
  }
  object { // CSG299->CSG292
    CSG292
    rotate -84.0*z
  }
  object { // CSG300->CSG292
    CSG292
    rotate -96.0*z
  }
  object { // CSG301->CSG292
    CSG292
    rotate -108.0*z
  }
  object { // CSG302->CSG292
    CSG292
    rotate -120.0*z
  }
  object { // CSG303->CSG292
    CSG292
    rotate -132.0*z
  }
  object { // CSG304->CSG292
    CSG292
    rotate -144.0*z
  }
  object { // CSG305->CSG292
    CSG292
    rotate -156.0*z
  }
  object { // CSG306->CSG292
    CSG292
    rotate -168.0*z
  }
  object { // CSG307->CSG292
    CSG292
    rotate 180.0*z
  }
  object { // CSG308->CSG292
    CSG292
    rotate 168.0*z
  }
  object { // CSG309->CSG292
    CSG292
    rotate 156.0*z
  }
  object { // CSG310->CSG292
    CSG292
    rotate 144.0*z
  }
  object { // CSG311->CSG292
    CSG292
    rotate 132.0*z
  }
  object { // CSG312->CSG292
    CSG292
    rotate 120.0*z
  }
  object { // CSG313->CSG292
    CSG292
    rotate 108.0*z
  }
  object { // CSG314->CSG292
    CSG292
    rotate 96.0*z
  }
  object { // CSG315->CSG292
    CSG292
    rotate 84.0*z
  }
  object { // CSG316->CSG292
    CSG292
    rotate 72.0*z
  }
  object { // CSG317->CSG292
    CSG292
    rotate 60.0*z
  }
  object { // CSG318->CSG292
    CSG292
    rotate 48.0*z
  }
  object { // CSG319->CSG292
    CSG292
    rotate 36.0*z
  }
  object { // CSG320->CSG292
    CSG292
    rotate 24.0*z
  }
  object { // CSG321->CSG292
    CSG292
    rotate 12.0*z
  }
  object { Zahnrad_Schraee24 }
  object { Zahnrad_Schraee25 }
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 2.0>
    translate  -0.5*z
  }
  scale <1.65, 1.65, 0.5>
  rotate -90.0*y
  translate  -4.1*x
}
#declare plus_part_18 = union {
  superellipsoid { // SuperQ109
    <0.1, 0.1>
    scale <1.7, 1.5, 1.5>
    translate  -6.3*x
  }
  superellipsoid { // SuperQ110
    <1.0, 0.1>
    scale 1.5
    rotate -90.0*x
    translate  -8.0*x
  }
}
#declare Minus_5_Scheiben26 = union {
  object { Cube1912 }
  object { // Cube1913->Cube1912
    Cube1912
    translate  <-0.0, 0.84375, 0.0>
  }
  object { // Cube1914->Cube1912
    Cube1912
    translate  <-0.0, 1.6875, 0.0>
  }
  object { // Cube1915->Cube1912
    Cube1912
    translate  <-0.0, 2.53125, 0.0>
  }
  object { // Cube1916->Cube1912
    Cube1912
    translate  <-0.0, 3.375, 0.0>
  }
  box { // Cube1917
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.78437, -0.05>
  }
  object { // Cube1918->Cube1912
    Cube1912
    translate  3.475*y
  }
  scale <1.3, 0.8, 1.2>
  translate  <-8.0, 0.0, 0.075>
}
#declare Hauptteil5 = difference {
  object { plus_part_18 }
  object { Minus_5_Scheiben26 }
  material {
    std_red
  }
}
#declare plus_part_19 = union {
  superellipsoid { // SuperQ111
    <0.1, 0.1>
    scale <1.5, 1.5, 1.0>
    translate  -1.0*z
  }
  superellipsoid { // SuperQ112
    <1.0, 0.1>
    scale 1.5
    rotate -90.0*x
  }
  cone { // Cone173
    <0,0,0>, 1.1, <0,0,1>, 1.4
    scale <1.0, 1.0, 0.7>
    translate  -2.6*z
  }
}
#declare minus_x_scheiben5 = union {
  object { Cube1919 }
  object { // Cube1920->Cube1919
    Cube1919
    rotate 0.0*z
    translate  <-0.0, 0.675, 0.0>
  }
  object { // Cube1921->Cube1919
    Cube1919
    rotate -0.0*z
    translate  <-0.0, 1.35, 0.0>
  }
  object { // Cube1922->Cube1919
    Cube1919
    rotate -0.0*z
    translate  <-0.0, 2.025, 0.0>
  }
}
#declare Hauptteil_10 = difference {
  object { plus_part_19 }
  object { minus_x_scheiben5 }
}
#declare another_plus_part5 = union {
  box { // Cube1923
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 2.5>
    translate  -3.2*z
  }
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    material {
      black_yellow_stripes
    }
    scale <1.1, 1.1, 1.0>
    translate  -0.9*z
  }
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 2.2>
    rotate -90.0*y
    translate  <1.1, 0.0, -5.7>
  }
}
#declare abrunden11 = difference {
  box { // Cube1924
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 1.8, 0.3>
  }
  cone { // Cone174
    <0,0,0>, 1.1, <0,0,1>, 1.5
    scale <1.0, 1.0, 0.7>
    translate  -0.35*z
  }
  scale <1.0, 1.0, 1.5>
  rotate -180.0*y
  translate  -1.1*z
}
#declare minus_y_scheiben10 = union {
  object { Cube1925 }
  object { // Cube1926->Cube1925
    Cube1925
    translate  0.4875*x
  }
  object { // Cube1927->Cube1925
    Cube1925
    translate  0.975*x
  }
  object { // Cube1928->Cube1925
    Cube1925
    translate  1.4625*x
  }
}
#declare Hauptteil__5 = difference {
  object { another_plus_part5 }
  object { abrunden11 }
  object { minus_y_scheiben10 }
  translate  13.65*z
}
#declare plus_part_20 = union {
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 2.2>
    rotate <-0.0, -90.0, 0.0>
    translate  1.1*x
  }
  box { // Cube1929
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 1.3>
    translate  -1.3*z
  }
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 4.7>
    rotate -0.0*x
    translate  -7.5*z
  }
}
#declare minus_y_scheiben11 = union {
  object { Cube1930 }
  object { // Cube1931->Cube1930
    Cube1930
    rotate -0.0*y
    translate  <0.4875, 0.0, 0.0>
  }
  object { // Cube1932->Cube1930
    Cube1930
    rotate -0.0*y
    translate  <0.975, 0.0, 0.0>
  }
  object { // Cube1933->Cube1930
    Cube1930
    rotate -0.0*y
    translate  <1.4625, 0.0, 0.0>
  }
  object { // Cube1934->Cube1930
    Cube1930
    rotate -0.0*y
    translate  <1.95, 0.0, 0.0>
  }
  box { // Cube1935
    <-1, -1, -1>, <1, 1, 1>
    scale <0.125, 1.12, 1.12>
    translate  -0.995*x
  }
  object { // Cube1936->Cube1930
    Cube1930
    rotate -0.0*y
    translate  <1.97, 0.0, 0.0>
  }
}
#declare abrunden12 = difference {
  box { // Cube1937
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 1.8, 0.3>
  }
  cone { // Cone175
    <0,0,0>, 0.8, <0,0,1>, 1.7
    scale <1.0, 1.0, 0.7>
    translate  -0.35*z
  }
  scale <1.0, 1.0, 2.5>
  translate  -2.0*z
}
#declare Hauptteil_11 = difference {
  object { plus_part_20 }
  object { minus_y_scheiben11 }
  object { abrunden12 }
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 3.6>
    rotate -0.0*x
    translate  -7.0*z
  }
  object { minus_something15 }
  object { // minus_something16->minus_something15
    minus_something15
    rotate -120.0*z
  }
  object { // minus_something17->minus_something15
    minus_something15
    rotate 120.0*z
  }
}
#declare plus_part_finger45 = union {
  box { // Cube1939
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader180 }
  object { // ader181->ader180
    ader180
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader182->ader180
    ader180
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader183->ader180
    ader180
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part45 = difference {
  object { plus_part_finger45 }
  object { Cube1940 }
  object { Cube1941 }
  object { // Cube1942->Cube1941
    Cube1941
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1943->Cube1941
    Cube1941
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1944->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1945->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1946->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1947
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1948
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone177
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone178
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger46 = union {
  box { // Cube1949
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader184 }
  object { // ader185->ader184
    ader184
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader186->ader184
    ader184
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader187->ader184
    ader184
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part46 = difference {
  object { plus_part_finger46 }
  object { Cube1950 }
  object { Cube1951 }
  object { // Cube1952->Cube1951
    Cube1951
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1953->Cube1951
    Cube1951
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1954->Cube1950
    Cube1950
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1955->Cube1950
    Cube1950
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1956->Cube1950
    Cube1950
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1957
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1958
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone179
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone180
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger47 = union {
  box { // Cube1959
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader188 }
  object { // ader189->ader188
    ader188
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader190->ader188
    ader188
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader191->ader188
    ader188
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part47 = difference {
  object { plus_part_finger47 }
  object { Cube1960 }
  object { // Cube1961->Cube1960
    Cube1960
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1962->Cube1960
    Cube1960
    // All transformations fixed
    translate  0.4*x
  }
  cone { // Cone181
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone182
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare Finger_left_46 = union {
  object { finger_part47 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 5.0*x
  translate  -1.57*y
}
#declare Finger_left_47 = union {
  object { finger_part46 }
  object { Finger_left_46 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 5.0*x
  translate  -1.6*y
}
#declare Finger_left_48 = union {
  object { finger_part45 }
  object { Finger_left_47 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -0.01*x
  translate  <-0.85, -0.7, 0.0>
}
#declare plus_part_palm5 = union {
  box { // Cube1963
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.2, 0.7, 0.3>
  }
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 2.4>
    rotate -90.0*y
    translate  <1.2, -0.7, 0.0>
  }
  // All transformations fixed
}
#declare palm10 = difference {
  object { plus_part_palm5 }
  box { // Cube1964
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.4>
    rotate 25.0*z
    translate  <1.65, 0.03, 0.0>
  }
  box { // Cube1965
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 0.4>
    rotate -25.0*z
    translate  <-1.65, 0.03, 0.0>
  }
  object { Cube1966 }
  object { // Cube1967->Cube1966
    Cube1966
    // All transformations fixed
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube1968->Cube1966
    Cube1966
    // All transformations fixed
    translate  <0.4, 0.0, 0.0>
  }
  object { // Cube1969->Cube1966
    Cube1966
    // All transformations fixed
    translate  <0.6, 0.0, 0.0>
  }
  object { // Cube1970->Cube1977
    Cube1977
    // All transformations fixed
    translate  <0.6, -0.0, 0.0>
  }
  object { // Cube1971->Cube1977
    Cube1977
    // All transformations fixed
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube1972->Cube1977
    Cube1977
    // All transformations fixed
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube1973->Cube1976
    Cube1976
    // All transformations fixed
    rotate -0.0*z
    translate  <0.6, -0.0, 0.0>
  }
  object { // Cube1974->Cube1976
    Cube1976
    // All transformations fixed
    rotate -0.0*z
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube1975->Cube1976
    Cube1976
    // All transformations fixed
    rotate -0.0*z
    translate  <0.2, -0.0, 0.0>
  }
  object { Cube1976 }
  object { Cube1977 }
  box { // Cube1978
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-1.16, -0.7, 0.0>
  }
  box { // Cube1979
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <1.16, -0.7, 0.0>
  }
  // All transformations fixed
}
#declare ader192 = union {
  sphere { // Sphere114
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere115
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare plus_part_finger48 = union {
  box { // Cube1980
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader192 }
  object { // ader193->ader180
    ader180
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader194->ader180
    ader180
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader195->ader180
    ader180
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part48 = difference {
  object { plus_part_finger48 }
  box { // Cube1981
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
  box { // Cube1982
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
  object { // Cube1983->Cube1941
    Cube1941
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1984->Cube1941
    Cube1941
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1985->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1986->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1987->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1988
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1989
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone183
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone184
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger49 = union {
  box { // Cube1990
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader196 }
  object { // ader197->ader196
    ader196
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader198->ader196
    ader196
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader199->ader196
    ader196
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part49 = difference {
  object { plus_part_finger49 }
  object { Cube1991 }
  object { Cube1992 }
  object { // Cube1993->Cube1992
    Cube1992
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube1994->Cube1992
    Cube1992
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube1995->Cube1991
    Cube1991
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube1996->Cube1991
    Cube1991
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube1997->Cube1991
    Cube1991
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube1998
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube1999
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone185
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone186
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger50 = union {
  box { // Cube2000
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader200 }
  object { // ader201->ader200
    ader200
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader202->ader200
    ader200
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader203->ader200
    ader200
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part50 = difference {
  object { plus_part_finger50 }
  object { Cube2001 }
  object { // Cube2002->Cube2001
    Cube2001
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube2003->Cube2001
    Cube2001
    // All transformations fixed
    translate  0.4*x
  }
  cone { // Cone187
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone188
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare Finger_left_49 = union {
  object { finger_part50 }
  // Scaling fixed
  // Rot X limited (-150.0 to   150.0)
  // Translation fixed
  rotate 20.0*x
  translate  -1.57*y
}
#declare Finger_left_50 = union {
  object { finger_part49 }
  object { Finger_left_49 }
  // Scaling fixed
  // Rot X limited (-150.0 to   150.0)
  // Translation fixed
  rotate 10.0*x
  translate  -1.6*y
}
#declare Finger_left_51 = union {
  object { finger_part48 }
  object { Finger_left_50 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 5.0*x
  translate  -0.7*y
}
#declare ader204 = union {
  sphere { // Sphere120
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -1.15, 0.3>
  }
  sphere { // Sphere121
    <0,0,0>,1
    // All transformations fixed
    scale 0.05
    translate  <-0.2, -0.45, 0.3>
  }
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.05, 0.05, 0.7>
    rotate -90.0*x
    translate  <-0.2, -1.15, 0.3>
  }
  // All transformations fixed
}
#declare plus_part_finger51 = union {
  box { // Cube2004
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader204 }
  object { // ader205->ader180
    ader180
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader206->ader180
    ader180
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader207->ader180
    ader180
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part51 = difference {
  object { plus_part_finger51 }
  box { // Cube2005
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.3, -1.6, 0.0>
  }
  box { // Cube2006
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  -0.2*x
  }
  object { // Cube2007->Cube1941
    Cube1941
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube2008->Cube1941
    Cube1941
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube2009->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube2010->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube2011->Cube1940
    Cube1940
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube2012
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube2013
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone189
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone190
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger52 = union {
  box { // Cube2014
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader208 }
  object { // ader209->ader208
    ader208
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader210->ader208
    ader208
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader211->ader208
    ader208
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part52 = difference {
  object { plus_part_finger52 }
  object { Cube2015 }
  object { Cube2016 }
  object { // Cube2017->Cube2016
    Cube2016
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube2018->Cube2016
    Cube2016
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube2019->Cube2015
    Cube2015
    // All transformations fixed
    rotate -0.0*z
    translate  0.2*x
  }
  object { // Cube2020->Cube2015
    Cube2015
    // All transformations fixed
    rotate -0.0*z
    translate  0.4*x
  }
  object { // Cube2021->Cube2015
    Cube2015
    // All transformations fixed
    rotate -0.0*z
    translate  0.6*x
  }
  box { // Cube2022
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <-0.31, -1.6, 0.0>
  }
  box { // Cube2023
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.33, 0.33>
    translate  <0.31, -1.6, 0.0>
  }
  cone { // Cone191
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone192
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare plus_part_finger53 = union {
  box { // Cube2024
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.35, 0.8, 0.3>
    translate  -0.8*y
  }
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  0.35*x
  }
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.3, 0.3, 0.7>
    rotate -90.0*y
    translate  <0.35, -1.6, 0.0>
  }
  object { ader212 }
  object { // ader213->ader212
    ader212
    // All transformations fixed
    translate  0.4*x
  }
  object { // ader214->ader212
    ader212
    // All transformations fixed
    translate  -0.6*z
  }
  object { // ader215->ader212
    ader212
    // All transformations fixed
    translate  <0.4, 0.0, -0.6>
  }
  // All transformations fixed
}
#declare finger_part53 = difference {
  object { plus_part_finger53 }
  object { Cube2025 }
  object { // Cube2026->Cube2025
    Cube2025
    // All transformations fixed
    translate  0.2*x
  }
  object { // Cube2027->Cube2025
    Cube2025
    // All transformations fixed
    translate  0.4*x
  }
  cone { // Cone193
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate -90.0*y
    translate  -0.31*x
  }
  cone { // Cone194
    <0,0,0>, 0.0, <0,0,1>, 0.2
    // All transformations fixed
    scale <1.0, 1.0, 0.05>
    rotate <0.0, -90.0, -180.0>
    translate  0.31*x
  }
  // All transformations fixed
  rotate <-180.0, -180.0, -180.0>
}
#declare Finger_left_52 = union {
  object { finger_part53 }
  // Scaling fixed
  // Rot X limited (-150.0 to   150.0)
  // Translation fixed
  rotate 30.0*x
  translate  -1.57*y
}
#declare Finger_left_53 = union {
  object { finger_part52 }
  object { Finger_left_52 }
  // Scaling fixed
  // Rot X limited (-150.0 to   150.0)
  // Translation fixed
  rotate 30.0*x
  translate  -1.6*y
}
#declare Finger_left_54 = union {
  object { finger_part51 }
  object { Finger_left_53 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate 10.0*x
  translate  <0.85, -0.7, 0.0>
}
#declare plus_part_palm_7 = union {
  cone { // Cone195
    <0,0,0>, 0.29, <0,0,1>, 0.8
    rotate -90.0*x
    translate  -0.27*y
  }
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 2.0>
    rotate -90.0*x
    translate  0.73*y
  }
}
#declare palm11 = difference {
  object { plus_part_palm_7 }
  box { // Cube2028
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.1>
    translate  <0.0, 1.43, 0.8>
  }
  box { // Cube2029
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.1>
    rotate 27.0*x
    translate  <0.0, 0.16, 0.57>
  }
}
#declare Hand3 = union {
  object { Finger_left_48 }
  object { palm10 }
  object { Finger_left_51 }
  object { Finger_left_54 }
  object { palm11 }
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.09, 1.8>
    rotate -90.0*x
    translate  <0.0, 0.73, 0.7>
  }
  sphere { // Sphere126
    <0,0,0>,1
    scale 0.09
    translate  <0.0, 0.73, 0.7>
  }
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    scale <0.09, 0.09, 1.2>
    rotate -63.0*x
    translate  <0.0, -0.34, 0.155>
  }
  // Scaling fixed
  // Rot Z limited (-360.0 to   360.0)
  // Translation fixed
  scale 0.7
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare UNTERARM5 = union {
  object { Hauptteil_11 }
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*x
    translate  -3.0*z
  }
  object { Cylndr496 }
  object { // Cylndr497->Cylndr496
    Cylndr496
    rotate <0.0, 0.0, -120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr498->Cylndr496
    Cylndr496
    rotate <0.0, 0.0, 120.0>
  }
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.2>
    rotate -0.0*x
    translate  -7.3*z
  }
  cone { // Cone176
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <1.0, 1.0, 0.5>
    translate  -7.999*z
  }
  object { Hand3 }
  // Scaling fixed
  // Rot X limited (-160.0 to   160.0)
  // Translation fixed
  rotate -0.01*x
  translate  7.95*z
}
#declare OBERARM_5 = union {
  object { Hauptteil__5 }
  object { UNTERARM5 }
  // Scaling fixed
  // Rot Z limited (-360.0 to   360.0)
  // Translation fixed
  rotate <-0.0, 0.0, 180.0>
  translate  -16.2*z
}
#declare SCHULTER_GANZ_AUSSEN5 = union {
  object { Hauptteil_10 }
  object { OBERARM_5 }
  // Scaling fixed
  // Rot Y limited (-30.0 to   235.0)
  // Translation fixed
  rotate <-0.0, 5.0, -0.0>
  translate  -8.0*x
}
#declare SCHULTER_HALB_AUSSEN5 = union {
  object { Zahnrad_gross7 }
  object { Hauptteil5 }
  object { SCHULTER_GANZ_AUSSEN5 }
  // Scaling fixed
  // Rot X limited (-360.0 to   360.0)
  // Translation fixed
  rotate <-0.01, 0.0, -180.0>
  translate  3.5*z
}
#declare plus_part_hals_5 = union {
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.7, 0.7, 1.4>
    rotate -90.0*y
    translate  0.7*x
  }
  box { // Cube2030
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.7
    translate  -0.7*z
  }
  // All transformations fixed
}
#declare es_werde_rund2 = difference {
  box { // Cube2034
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
  }
  cone { // Cone196
    <0,0,0>, 0.4, <0,0,1>, 0.7
    // All transformations fixed
    scale <1.0, 1.0, 2.1>
    translate  -1.05*z
  }
  // All transformations fixed
  scale <1.5, 1.5, 0.4>
  translate  -1.05*z
}
#declare hals_5 = difference {
  object { plus_part_hals_5 }
  object { Cube2031 }
  object { // Cube2032->Cube2031
    Cube2031
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube2033->Cube2031
    Cube2031
    // All transformations fixed
    translate  0.8*x
  }
  object { es_werde_rund2 }
  cone { // Cone197
    <0,0,0>, 0.0, <0,0,1>, 0.35
    // All transformations fixed
    scale <1.0, 1.0, 0.06>
    rotate -90.0*y
    translate  -0.65*x
  }
  cone { // Cone198
    <0,0,0>, 0.0, <0,0,1>, 0.35
    // All transformations fixed
    scale <1.0, 1.0, 0.06>
    rotate <0.0, -90.0, -180.0>
    translate  0.65*x
  }
  // All transformations fixed
}
#declare plus_part_head3 = union {
  superellipsoid { // SuperQ113
    <0.1, 0.1>
    // All transformations fixed
    scale <2.0, 1.5, 1.0>
  }
  superellipsoid { // SuperQ114
    <0.1, 1.2>
    // All transformations fixed
    scale <1.0, 2.0, 2.8>
    rotate <-90.0, -90.0, -180.0>
    translate  1.4*y
  }
  superellipsoid { // SuperQ115
    <1.0, 0.1>
    // All transformations fixed
    scale <0.7, 0.7, 1.0>
    rotate -90.0*x
    translate  <-1.0, -1.3, 0.0>
  }
  superellipsoid { // SuperQ116
    <1.0, 0.1>
    // All transformations fixed
    scale <0.7, 0.7, 1.0>
    rotate -90.0*x
    translate  <1.0, -1.3, 0.0>
  }
  object { head_line4 }
  object { // head_line5->head_line4
    head_line4
    // All transformations fixed
    translate  2.0*x
  }
  // All transformations fixed
}
#declare main_part_head3 = difference {
  object { plus_part_head3 }
  superellipsoid { // SuperQ117
    <1.0, 0.1>
    // All transformations fixed
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <-1.0, -1.5, 0.0>
  }
  superellipsoid { // SuperQ118
    <1.0, 0.1>
    // All transformations fixed
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <1.0, -1.5, 0.0>
  }
  // All transformations fixed
  translate  <0.0, -0.5, 2.0>
}
#declare CSG322 = intersection {
  sphere { // Sphere129
    <0,0,0>,1
    // All transformations fixed
    scale <1.0, 0.6, 1.0>
    translate  -0.25*y
  }
  sphere { // Sphere130
    <0,0,0>,1
    // All transformations fixed
    scale <1.0, 0.6, 1.0>
    translate  0.25*y
  }
  material {
    Orange_Glass
  }
  // All transformations fixed
  scale 0.5
  translate  <-1.0, -2.5, 2.0>
}
#declare CSG323 = intersection {
  sphere { // Sphere131
    <0,0,0>,1
    // All transformations fixed
    scale <1.0, 0.6, 1.0>
    translate  -0.25*y
  }
  sphere { // Sphere132
    <0,0,0>,1
    // All transformations fixed
    scale <1.0, 0.6, 1.0>
    translate  0.25*y
  }
  material {
    Orange_Glass
  }
  // All transformations fixed
  scale 0.5
  translate  <1.0, -2.5, 2.0>
}
#declare plus_part_hals_6 = union {
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.7, 0.7, 1.4>
    rotate -90.0*y
    translate  0.7*x
  }
  box { // Cube2035
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.7, 0.7, 1.0>
    translate  1.0*z
  }
  // All transformations fixed
}
#declare hals_6 = difference {
  object { plus_part_hals_6 }
  object { Cube2036 }
  object { // Cube2037->Cube2036
    Cube2036
    // All transformations fixed
    translate  0.4*x
  }
  object { // Cube2038->Cube2036
    Cube2036
    // All transformations fixed
    translate  0.8*x
  }
  object { // Cube2039->Cube2036
    Cube2036
    // All transformations fixed
    translate  1.2*x
  }
  box { // Cube2040
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.1, 0.75, 0.75>
    translate  -0.65*x
  }
  box { // Cube2041
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.1, 0.75, 0.75>
    translate  0.65*x
  }
  // All transformations fixed
}
#declare head3 = union {
  object { main_part_head3 }
  object { CSG322 }
  object { CSG323 }
  object { hals_6 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -1.0*x
}
#declare HALS2 = union {
  object { hals_5 }
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.64, 0.64, 1.0>
    translate  -2.0*z
  }
  object { head3 }
  // Scaling fixed
  // Rot Z limited (-360.0 to   360.0)
  // Translation fixed
  scale 1.2
  rotate 1.0*z
  translate  7.0*z
}
#declare SCHULTER3 = union {
  object { mittel_haupt_saele_1_14 }
  object { Motor_etc4 }
  object { // Motor_etc5->Motor_etc4
    Motor_etc4
    rotate <180.0, 0.0, 180.0>
    translate  7.0*z
  }
  object { SCHULTER_HALB_AUSSEN4 }
  object { SCHULTER_HALB_AUSSEN5 }
  object { HALS2 }
  text {   // TText003
    ttf      "E:\WINDOWS\Fonts\Arial.ttf",
    "C",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      std_red
    }
    scale <1.5, 1.5, 0.4>
    rotate 90.0*x
    translate  <-0.45, -1.1, 3.0>
  }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -0.01*x
  translate  4.0*z
}
#declare plus_part19 = union {
  object { Cylndr535 }
  box { // Cube2042
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 2.0>
    translate  2.5*z
  }
  object { // Cylndr536->Cylndr535
    Cylndr535
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 0.0, -4.0>
  }
}
#declare Minus_4_Scheiben16 = union {
  object { Cube2043 }
  object { // Cube2044->Cube2043
    Cube2043
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 0.675, 0.0>
  }
  object { // Cube2045->Cube2043
    Cube2043
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 1.35, 0.0>
  }
  object { // Cube2046->Cube2043
    Cube2043
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 2.025, 0.0>
  }
  scale <1.2, 1.0, 1.2>
  rotate -90.0*z
  translate  4.1*z
}
#declare Minus_5_Scheiben27 = union {
  object { Cube2047 }
  object { // Cube2048->Cube2047
    Cube2047
    translate  <-0.0, 0.84375, 0.0>
  }
  object { // Cube2049->Cube2047
    Cube2047
    translate  <-0.0, 1.6875, 0.0>
  }
  object { // Cube2050->Cube2047
    Cube2047
    translate  <-0.0, 2.53125, 0.0>
  }
  object { // Cube2051->Cube2047
    Cube2047
    translate  <-0.0, 3.375, 0.0>
  }
  box { // Cube2052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  <0.0, -1.78437, 0.358333>
  }
  object { // Cube2053->Cube2047
    Cube2047
    translate  3.475*y
  }
  scale <1.2, 0.8, 1.2>
  rotate -90.0*z
  translate  0.075*z
}
#declare mittel_haupt_saele_1_15 = difference {
  object { plus_part19 }
  object { Minus_4_Scheiben16 }
  object { Minus_5_Scheiben27 }
  translate  -0.5*z
}
#declare Plus_part_motor_befestigung12 = union {
  object { SuperQ120 }
  object { // SuperQ121->SuperQ120
    SuperQ120
    translate  4.4*x
  }
  object { Cube2103 }
  object { // Cube2104->Cube2103
    Cube2103
    translate  -0.4*y
  }
  object { // Cube2105->Cube2103
    Cube2103
    translate  4.0*x
  }
  object { // Cube2106->Cube2103
    Cube2103
    translate  <4.0, -0.4, 0.0>
  }
  object { // SuperQ122->SuperQ120
    SuperQ120
    translate  1.0*z
  }
  object { Cube2107 }
  object { // Cube2108->Cube2107
    Cube2107
    rotate -0.0*y
    translate  <4.08, 0.0, 0.0>
  }
  object { // SuperQ123->SuperQ120
    SuperQ120
    translate  <4.4, 0.0, 1.0>
  }
}
#declare Motor_Befestigung16 = difference {
  object { Plus_part_motor_befestigung12 }
  object { Cylndr538 }
  object { // Cylndr539->Cylndr538
    Cylndr538
    rotate 0.0*y
    translate  4.4*x
  }
  object { Cylndr540 }
  object { // Cylndr541->Cylndr540
    Cylndr540
    translate  <5.18, 0.0, 0.0>
  }
  object { Cylndr542 }
  object { // Cylndr543->Cylndr542
    Cylndr542
    rotate <-0.0, 0.0, -0.0>
    translate  5.298*x
  }
  translate  -0.5*z
}
#declare rest_of_wirbel5 = union {
  object { mittel_haupt_saele_1_15 }
  object { Engine47 }
  object { Motor_Befestigung16 }
  object { // Engine48->Engine47
    Engine47
    rotate <0.0, 0.0, 180.0>
    translate  0.0*y
  }
}
#declare WIRBEL_5 = union {
  object { SCHULTER3 }
  object { rest_of_wirbel5 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -0.01*x
  translate  4.5*z
}
#declare plus_part20 = union {
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 3.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.5, 0.0, 4.5>
  }
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    material {
      black_yellow_stripes
    }
    scale <1.5, 1.5, 0.5>
  }
  box { // Cube2109
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 2.0>
    translate  2.5*z
  }
}
#declare Minus_4_Scheiben17 = union {
  object { Cube2110 }
  object { // Cube2111->Cube2110
    Cube2110
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 0.675, 0.0>
  }
  object { // Cube2112->Cube2110
    Cube2110
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 1.35, 0.0>
  }
  object { // Cube2113->Cube2110
    Cube2110
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 2.025, 0.0>
  }
  scale <1.2, 1.0, 1.2>
  rotate -90.0*z
  translate  4.1*z
}
#declare ueergang_rund_eckig4 = difference {
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 1.5>
  }
  cone { // Cone200
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.51>
  }
  rotate -180.0*y
  translate  1.9*z
}
#declare mittel_haupt_saele_1_16 = difference {
  object { plus_part20 }
  object { Minus_4_Scheiben17 }
  object { ueergang_rund_eckig4 }
}
#declare Plus_part_motor_befestigung13 = union {
  object { SuperQ124 }
  object { // SuperQ125->SuperQ124
    SuperQ124
    translate  4.4*x
  }
  object { Cube2114 }
  object { // Cube2115->Cube2114
    Cube2114
    translate  -0.4*y
  }
  object { // Cube2116->Cube2114
    Cube2114
    translate  4.0*x
  }
  object { // Cube2117->Cube2114
    Cube2114
    translate  <4.0, -0.4, 0.0>
  }
  object { // SuperQ126->SuperQ124
    SuperQ124
    translate  1.0*z
  }
  object { Cube2118 }
  object { // Cube2119->Cube2118
    Cube2118
    rotate -0.0*y
    translate  <4.08, 0.0, 0.0>
  }
  object { // SuperQ127->SuperQ124
    SuperQ124
    translate  <4.4, 0.0, 1.0>
  }
}
#declare Motor_Befestigung17 = difference {
  object { Plus_part_motor_befestigung13 }
  object { Cylndr548 }
  object { // Cylndr549->Cylndr548
    Cylndr548
    rotate 0.0*y
    translate  4.4*x
  }
  object { Cylndr550 }
  object { // Cylndr551->Cylndr550
    Cylndr550
    translate  <5.18, 0.0, 0.0>
  }
  object { Cylndr552 }
  object { // Cylndr553->Cylndr552
    Cylndr552
    rotate <-0.0, 0.0, -0.0>
    translate  5.298*x
  }
}
#declare Motor_befestigung_3 = difference {
  box { // Cube2120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.175>
    translate  <0.0, 3.0, 1.675>
  }
  object { Schraube__minus_solid_part_12 }
  object { // Schraube__minus_solid_part_13->Schraube_(minus_solid_part)12
    Schraube__minus_solid_part_12
    rotate <-0.0, -0.0, -0.0>
    translate  <0.0, 0.0, -1.0>
  }
  object { Cube2124 }
  object { // Cube2125->Cube2124
    Cube2124
    rotate -90.0*x
    translate  <0.0, 0.25, 3.61>
  }
}
#declare plus_part_zahnrad_klein5 = union {
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    scale <0.53, 0.53, 1.0>
  }
  object { CSG325 }
  object { // CSG326->CSG325
    CSG325
    rotate -40.0*z
  }
  object { // CSG327->CSG325
    CSG325
    rotate -80.0*z
  }
  object { // CSG328->CSG325
    CSG325
    rotate -120.0*z
  }
  object { // CSG329->CSG325
    CSG325
    rotate -160.0*z
  }
  object { // CSG330->CSG325
    CSG325
    rotate 160.0*z
  }
  object { // CSG331->CSG325
    CSG325
    rotate 120.0*z
  }
  object { // CSG332->CSG325
    CSG325
    rotate 80.0*z
  }
  object { // CSG333->CSG325
    CSG325
    rotate 40.0*z
  }
  superellipsoid { // SuperQ128
    <1.0, 0.1>
    scale <0.2, 0.2, 3.2>
    rotate -10.0*z
    translate  2.7*z
  }
}
#declare Zahnrad_Schraee26 = difference {
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone202
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.5>
    translate  -0.05*z
  }
  scale <0.65, 0.65, 2.0>
  translate  0.92*z
}
#declare Zahnrad_Schraee27 = difference {
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone203
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <0.65, 0.65, 2.0>
  rotate -180.0*y
  translate  0.08*z
}
#declare Zahnrad_klein5 = difference {
  object { plus_part_zahnrad_klein5 }
  object { Zahnrad_Schraee26 }
  object { Zahnrad_Schraee27 }
  scale <1.0, 1.0, 0.5>
  rotate 10.0*z
  translate  <0.0, 2.2, -0.4>
}
#declare rest_of_wirbel6 = union {
  object { mittel_haupt_saele_1_16 }
  object { Cylndr547 }
  object { Motor_Befestigung17 }
  object { // Engine49->Engine52
    Engine52
    material {
      Brushed_Aluminum
    }
    rotate <-0.0, -90.0, 0.0>
    translate  <-1.0, -2.2, 4.5>
  }
  object { // Engine50->Engine52
    Engine52
    material {
      Brushed_Aluminum
    }
    rotate 90.0*y
    translate  <1.0, -2.2, 4.5>
  }
  object { Motor_befestigung_3 }
  object { // Cube2126->Cube2127
    Cube2127
    scale <1.0, 0.6, 1.0>
    translate  <0.0, 1.16, 2.15>
  }
  object { Cube2127 }
  object { // Cylndr556->Cylndr547
    Cylndr547
    scale <1.0, 1.0, 0.5>
    translate  2.15*z
  }
  object { // Cube2128->Cube2181
    Cube2181
    scale <1.0, 1.0, 0.5>
    translate  2.15*z
  }
  object { Zahnrad_klein5 }
  object { Engine52 }
  object { Cube2181 }
}
#declare WIRBEL_6 = union {
  object { WIRBEL_5 }
  object { rest_of_wirbel6 }
  // Scaling fixed
  // Rot Z limited (-180.0 to   180.0)
  // Translation fixed
  rotate -1.0*z
  translate  4.6*z
}
#declare plus_part21 = union {
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 3.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.5, 0.0, 0.0>
  }
  box { // Cube2182
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.2, 2.0>
    translate  2.0*z
  }
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 2.4>
    rotate -90.0*x
    translate  <0.0, -1.2, 4.0>
  }
}
#declare Minus_5_Scheiben28 = union {
  object { Cube2183 }
  object { // Cube2184->Cube2183
    Cube2183
    translate  <-0.0, 0.84375, 0.0>
  }
  object { // Cube2185->Cube2183
    Cube2183
    translate  <-0.0, 1.6875, 0.0>
  }
  object { // Cube2186->Cube2183
    Cube2183
    translate  <-0.0, 2.53125, 0.0>
  }
  object { // Cube2187->Cube2183
    Cube2183
    translate  <-0.0, 3.375, 0.0>
  }
  box { // Cube2188
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  -1.78437*y
  }
  object { // Cube2189->Cube2183
    Cube2183
    translate  3.475*y
  }
  scale <1.0, 0.8, 1.0>
  rotate -90.0*z
  translate  0.0*y
}
#declare Minus_5_Scheiben29 = union {
  object { Cube2190 }
  object { // Cube2191->Cube2190
    Cube2190
    rotate 0.0*z
    translate  <-0.0, -0.6, 0.0>
  }
  object { // Cube2192->Cube2190
    Cube2190
    rotate 0.0*z
    translate  <-0.0, -1.2, 0.0>
  }
  object { // Cube2193->Cube2190
    Cube2190
    rotate 0.0*z
    translate  <-0.0, -1.8, 0.0>
  }
  object { // Cube2194->Cube2190
    Cube2190
    rotate 0.0*z
    translate  <-0.0, -2.4, 0.0>
  }
  object { // Cube2195->Cube2190
    Cube2190
    rotate 0.0*z
    translate  <-0.0, -3.0, 0.0>
  }
  scale <1.0, 0.8, 1.0>
  translate  4.075*z
}
#declare Oberschenkel_5 = difference {
  object { plus_part21 }
  object { Minus_5_Scheiben28 }
  object { Minus_5_Scheiben29 }
  object { Cylndr564 }
  object { // Cylndr565->Cylndr564
    Cylndr564
    rotate <0.0, 0.0, 0.0>
    translate  <4.4, 0.0, 0.0>
  }
  rotate <180.0, 0.0, -90.0>
}
#declare plus_part22 = union {
  object { Cylndr566 }
  box { // Cube2196
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 3.0>
    translate  1.5*z
  }
  object { // Cylndr567->Cylndr566
    Cylndr566
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 0.0, -6.0>
  }
}
#declare Minus_4_Scheiben18 = union {
  object { Cube2197 }
  object { // Cube2198->Cube2197
    Cube2197
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.48, -0.0, 0.0>
  }
  object { // Cube2199->Cube2197
    Cube2197
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.96, -0.0, 0.0>
  }
  object { // Cube2200->Cube2197
    Cube2197
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.44, -0.0, 0.0>
  }
  object { // Cube2201->Cube2197
    Cube2197
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.92, -0.0, 0.0>
  }
  translate  <0.134944, 0.0, 4.119679>
}
#declare Minus_5_Scheiben30 = union {
  object { Cube2202 }
  object { // Cube2203->Cube2202
    Cube2202
    rotate 0.0*z
    translate  <-0.0, -0.6, 0.0>
  }
  object { // Cube2204->Cube2202
    Cube2202
    rotate 0.0*z
    translate  <-0.0, -1.2, 0.0>
  }
  object { // Cube2205->Cube2202
    Cube2202
    rotate 0.0*z
    translate  <-0.0, -1.8, 0.0>
  }
  object { // Cube2206->Cube2202
    Cube2202
    rotate 0.0*z
    translate  <-0.0, -2.4, 0.0>
  }
  object { // Cube2207->Cube2202
    Cube2202
    rotate 0.0*z
    translate  <-0.0, -3.0, 0.0>
  }
  scale <1.0, 0.8, 1.0>
  rotate -90.0*z
}
#declare mittel_haupt_saele_1_17 = difference {
  object { plus_part22 }
  object { Minus_4_Scheiben18 }
  object { Minus_5_Scheiben30 }
  translate  -4.5*z
}
#declare Engine53 = difference {
  superellipsoid { // SuperQ130
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube2208 }
  object { // Cube2209->Cube2208
    Cube2208
    rotate -15.0*z
  }
  object { // Cube2210->Cube2208
    Cube2208
    rotate -30.0*z
  }
  object { // Cube2211->Cube2208
    Cube2208
    rotate -45.0*z
  }
  object { // Cube2212->Cube2208
    Cube2208
    rotate -60.0*z
  }
  object { // Cube2213->Cube2208
    Cube2208
    rotate -75.0*z
  }
  object { // Cube2214->Cube2208
    Cube2208
    rotate -90.0*z
  }
  object { // Cube2215->Cube2208
    Cube2208
    rotate -105.0*z
  }
  object { // Cube2216->Cube2208
    Cube2208
    rotate -120.0*z
  }
  object { // Cube2217->Cube2208
    Cube2208
    rotate -135.0*z
  }
  object { // Cube2218->Cube2208
    Cube2208
    rotate -150.0*z
  }
  object { // Cube2219->Cube2208
    Cube2208
    rotate -165.0*z
  }
  object { Torus041 }
  object { // Torus042->Torus041
    Torus041
    translate  -2.4*z
  }
  object { Cube2220 }
  object { // Cube2221->Cube2220
    Cube2220
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2222->Cube2220
    Cube2220
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2223->Cube2220
    Cube2220
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2224->Cube2220
    Cube2220
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2225 }
  object { // Cube2226->Cube2225
    Cube2225
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2227->Cube2225
    Cube2225
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2228->Cube2225
    Cube2225
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2229->Cube2225
    Cube2225
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2230 }
  object { Cube2231 }
  object { Cube2232 }
  object { // Cube2233->Cube2232
    Cube2232
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2234->Cube2232
    Cube2232
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2235->Cube2232
    Cube2232
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2236->Cube2232
    Cube2232
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2237->Cube2230
    Cube2230
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2238->Cube2230
    Cube2230
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2239->Cube2230
    Cube2230
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2240->Cube2230
    Cube2230
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2241->Cube2231
    Cube2231
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2242->Cube2231
    Cube2231
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2243->Cube2231
    Cube2231
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2244->Cube2231
    Cube2231
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2245 }
  object { Cube2246 }
  object { Cube2247 }
  object { Cube2248 }
  object { // Cube2249->Cube2245
    Cube2245
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2250->Cube2245
    Cube2245
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2251->Cube2246
    Cube2246
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube2252->Cube2246
    Cube2246
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube2253->Cube2247
    Cube2247
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2254->Cube2247
    Cube2247
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2255->Cube2248
    Cube2248
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube2256->Cube2248
    Cube2248
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine54 = union {
  cone { // Cone205
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine53 }
  material {
    Brushed_Aluminum
  }
  scale 0.7
  rotate <90.0, 0.0, -90.0>
  translate  -2.4*x
}
#declare Plus_part_motor_befestigung14 = union {
  object { SuperQ131 }
  object { Cube2257 }
  object { // Cube2258->Cube2257
    Cube2257
    translate  -0.4*y
  }
  object { // SuperQ132->SuperQ131
    SuperQ131
    translate  1.0*z
  }
}
#declare Motor_Befestigung18 = difference {
  object { Plus_part_motor_befestigung14 }
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    scale <0.73, 0.73, 1.8>
    rotate -90.0*y
    translate  <-1.3, 0.0, 4.5>
  }
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.6>
    rotate -90.0*x
    translate  <-2.59, -0.3, 2.61>
  }
  translate  <0.15, 0.0, -4.5>
}
#declare plus_part23 = union {
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 2.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.2, 0.0, 4.5>
  }
  box { // Cube2259
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 3.0>
    translate  1.5*z
  }
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.2>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.1, 0.0, -1.5>
  }
}
#declare Minus_4_Scheiben19 = union {
  object { Cube2260 }
  object { // Cube2261->Cube2260
    Cube2260
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.48, -0.0, 0.0>
  }
  object { // Cube2262->Cube2260
    Cube2260
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.96, -0.0, 0.0>
  }
  object { // Cube2263->Cube2260
    Cube2260
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.44, -0.0, 0.0>
  }
  object { // Cube2264->Cube2260
    Cube2260
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.92, -0.0, 0.0>
  }
  translate  <0.134944, 0.0, 4.119679>
}
#declare Minus_5_Scheiben31 = union {
  object { Cube2265 }
  object { // Cube2266->Cube2265
    Cube2265
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.6, -0.0>
  }
  object { // Cube2267->Cube2265
    Cube2265
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -1.2, -0.0>
  }
  object { // Cube2268->Cube2265
    Cube2265
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -1.8, -0.0>
  }
  scale <1.0, 0.8, 1.0>
  rotate -90.0*z
}
#declare mittel_haupt_saele_1_18 = difference {
  object { plus_part23 }
  object { Minus_4_Scheiben19 }
  object { Minus_5_Scheiben31 }
  object { Cylndr573 }
  object { // Cylndr574->Cylndr573
    Cylndr573
    translate  4.0*y
  }
  object { Cylndr575 }
  object { // Cylndr576->Cylndr575
    Cylndr575
    rotate <0.0, 0.0, -0.0>
    translate  <-4.0, 0.0, 0.0>
  }
  object { Cube2269 }
  object { // Cube2270->Cube2269
    Cube2269
    translate  2.4*x
  }
  translate  -4.5*z
}
#declare plus_part_knoechel4 = union {
  box { // Cube2322
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
    translate  -1.5*z
  }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, -3.0>
  }
}
#declare Knoechel_4 = difference {
  object { plus_part_knoechel4 }
  object { Cube2323 }
  object { // Cube2324->Cube2323
    Cube2323
    translate  0.48*x
  }
  object { // Cube2325->Cube2323
    Cube2323
    translate  0.96*x
  }
  object { // Cube2326->Cube2323
    Cube2323
    translate  1.44*x
  }
  object { // Cube2327->Cube2323
    Cube2323
    translate  1.92*x
  }
  object { Cube2328 }
  object { // Cube2329->Cube2328
    Cube2328
    translate  -0.4*y
  }
  object { // Cube2330->Cube2328
    Cube2328
    translate  -0.8*y
  }
  object { // Cube2331->Cube2328
    Cube2328
    translate  -1.2*y
  }
  object { // Cube2332->Cube2328
    Cube2328
    translate  -1.6*y
  }
}
#declare plus_part_fuss4 = union {
  box { // Cube2333
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.4, 1.0>
  }
  box { // Cube2334
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.1, 0.6>
    translate  <-1.3, 2.2, -0.8>
  }
  box { // Cube2335
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.1, 0.6>
    translate  <1.3, 2.2, -0.8>
  }
  box { // Cube2336
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.6, 0.6>
    translate  <-1.3, -2.0, -0.8>
  }
  box { // Cube2337
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.6, 0.6>
    translate  <1.3, -2.0, -0.8>
  }
}
#declare CSG334 = union {
  box { // Cube2344
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr584
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  scale <1.05, 0.05, 1.05>
  translate  1.235*y
}
#declare CSG335 = union {
  box { // Cube2345
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr585
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  scale <1.05, 0.1, 1.05>
  translate  0.87*y
}
#declare CSG336 = union {
  box { // Cube2346
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr586
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  scale <1.05, 0.1, 1.05>
  translate  0.47*y
}
#declare CSG337 = union {
  box { // Cube2347
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr587
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  scale <1.05, 0.1, 1.05>
  translate  0.07*y
}
#declare CSG338 = union {
  box { // Cube2348
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr588
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  scale <1.05, 0.1, 1.05>
  translate  -0.33*y
}
#declare CSG339 = union {
  box { // Cube2349
    <-1, -1, -1>, <1, 1, 1>
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr589
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  scale <1.05, 0.05, 1.05>
  translate  -0.665*y
}
#declare Fuss_4 = difference {
  object { plus_part_fuss4 }
  box { // Cube2338
    <-1, -1, -1>, <1, 1, 1>
    scale <1.65, 1.2, 0.2>
    translate  <0.0, -1.525, -1.25>
  }
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.2, 3.4>
    rotate -90.0*y
    translate  <1.7, -2.725, -1.45>
  }
  box { // Cube2339
    <-1, -1, -1>, <1, 1, 1>
    scale <1.65, 0.8, 0.33>
    rotate 45.0*x
    translate  <0.0, -3.5, -0.52>
  }
  box { // Cube2340
    <-1, -1, -1>, <1, 1, 1>
    scale <1.65, 0.8, 0.33>
    rotate -60.0*x
    translate  <0.0, 3.228154, -0.35>
  }
  box { // Cube2341
    <-1, -1, -1>, <1, 1, 1>
    scale <1.65, 0.8, 0.2>
    translate  <0.0, 1.89, -1.25>
  }
  cylinder { // Cylndr583
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.2, 3.4>
    rotate -90.0*y
    translate  <1.7, 2.69, -1.45>
  }
  box { // Cube2342
    <-1, -1, -1>, <1, 1, 1>
    scale <1.65, 0.8, 0.33>
    rotate -60.0*x
    translate  <0.0, 2.285779, 0.65779>
  }
  box { // Cube2343
    <-1, -1, -1>, <1, 1, 1>
    scale <1.65, 1.0, 0.45>
    rotate 45.0*x
    translate  <0.0, -2.132202, 0.916136>
  }
  object { CSG334 }
  object { CSG335 }
  object { CSG336 }
  object { CSG337 }
  object { CSG338 }
  object { CSG339 }
  rotate -180.0*z
  translate  <0.0, 0.7, -0.5>
}
#declare FUSS4 = union {
  object { Fuss_4 }
  // Scaling fixed
  // Rot Y limited (-60.0 to   60.0)
  // Translation fixed
  rotate 10.0*y
  translate  <0.0, -0.4, -3.0>
}
#declare KNOECHEL4 = union {
  object { Knoechel_4 }
  object { FUSS4 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -0.01*x
  translate  <0.0, 0.0, -6.0>
}
#declare UNTERSCHENKEL_RECHTS4 = union {
  object { mittel_haupt_saele_1_18 }
  object { Engine56 }
  object { Motor_Befestigung19 }
  object { // Engine57->Engine56
    Engine56
    scale 0.8
    rotate -0.0*y
    translate  <-0.05, 0.0, -6.0>
  }
  object { // Motor_Befestigung20->Motor_Befestigung19
    Motor_Befestigung19
    scale 0.8
    rotate 180.0*x
    translate  <0.05, 0.0, -6.0>
  }
  object { KNOECHEL4 }
  translate  <0.0, 0.0, 0.0>
  // Scaling fixed
  // Rot X limited (-100.0 to   100.0)
  // Translation fixed
  rotate -0.01*x
  translate  <0.0, 0.0, -6.0>
}
#declare MITTELSCHENKEL_RECHTS4 = union {
  object { mittel_haupt_saele_1_17 }
  object { Engine54 }
  object { Motor_Befestigung18 }
  object { UNTERSCHENKEL_RECHTS4 }
  translate  <0.0, 0.0, 0.0>
  // Scaling fixed
  // Rot X limited (-100.0 to   100.0)
  // Translation fixed
  rotate <-0.01, 0.0, -180.0>
  translate  <0.0, 0.0, -4.0>
}
#declare OBERSCHENKEL_RECHTS2 = union {
  object { Oberschenkel_5 }
  object { MITTELSCHENKEL_RECHTS4 }
  // Scaling fixed
  // Rot Y limited (-10.0 to   45.0)
  // Translation fixed
  rotate <0.0, 10.0, -0.0>
  translate  -4.5*x
}
#declare plus_part24 = union {
  cylinder { // Cylndr590
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 3.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.5, 0.0, 0.0>
  }
  box { // Cube2350
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.2, 2.0>
    translate  2.0*z
  }
  cylinder { // Cylndr591
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 2.4>
    rotate -90.0*x
    translate  <0.0, -1.2, 4.0>
  }
}
#declare Minus_5_Scheiben32 = union {
  object { Cube2351 }
  object { // Cube2352->Cube2351
    Cube2351
    translate  <-0.0, 0.84375, 0.0>
  }
  object { // Cube2353->Cube2351
    Cube2351
    translate  <-0.0, 1.6875, 0.0>
  }
  object { // Cube2354->Cube2351
    Cube2351
    translate  <-0.0, 2.53125, 0.0>
  }
  object { // Cube2355->Cube2351
    Cube2351
    translate  <-0.0, 3.375, 0.0>
  }
  box { // Cube2356
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1875, 1.291667, 1.291667>
    rotate 90.0*z
    translate  -1.78437*y
  }
  object { // Cube2357->Cube2351
    Cube2351
    translate  3.475*y
  }
  scale <1.0, 0.8, 1.0>
  rotate -90.0*z
  translate  0.0*y
}
#declare Minus_5_Scheiben33 = union {
  object { Cube2358 }
  object { // Cube2359->Cube2358
    Cube2358
    rotate 0.0*z
    translate  <-0.0, -0.6, 0.0>
  }
  object { // Cube2360->Cube2358
    Cube2358
    rotate 0.0*z
    translate  <-0.0, -1.2, 0.0>
  }
  object { // Cube2361->Cube2358
    Cube2358
    rotate 0.0*z
    translate  <-0.0, -1.8, 0.0>
  }
  object { // Cube2362->Cube2358
    Cube2358
    rotate 0.0*z
    translate  <-0.0, -2.4, 0.0>
  }
  object { // Cube2363->Cube2358
    Cube2358
    rotate 0.0*z
    translate  <-0.0, -3.0, 0.0>
  }
  scale <1.0, 0.8, 1.0>
  translate  4.075*z
}
#declare Oberschenkel_6 = difference {
  object { plus_part24 }
  object { Minus_5_Scheiben32 }
  object { Minus_5_Scheiben33 }
  object { Cylndr592 }
  object { // Cylndr593->Cylndr592
    Cylndr592
    rotate <0.0, 0.0, 0.0>
    translate  <4.4, 0.0, 0.0>
  }
  rotate <180.0, 0.0, -90.0>
}
#declare plus_part25 = union {
  object { Cylndr594 }
  box { // Cube2364
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 3.0>
    translate  1.5*z
  }
  object { // Cylndr595->Cylndr594
    Cylndr594
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, 0.0, -6.0>
  }
}
#declare Minus_4_Scheiben20 = union {
  object { Cube2365 }
  object { // Cube2366->Cube2365
    Cube2365
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.48, -0.0, 0.0>
  }
  object { // Cube2367->Cube2365
    Cube2365
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.96, -0.0, 0.0>
  }
  object { // Cube2368->Cube2365
    Cube2365
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.44, -0.0, 0.0>
  }
  object { // Cube2369->Cube2365
    Cube2365
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.92, -0.0, 0.0>
  }
  translate  <0.134944, 0.0, 4.119679>
}
#declare Minus_5_Scheiben34 = union {
  object { Cube2370 }
  object { // Cube2371->Cube2370
    Cube2370
    rotate 0.0*z
    translate  <-0.0, -0.6, 0.0>
  }
  object { // Cube2372->Cube2370
    Cube2370
    rotate 0.0*z
    translate  <-0.0, -1.2, 0.0>
  }
  object { // Cube2373->Cube2370
    Cube2370
    rotate 0.0*z
    translate  <-0.0, -1.8, 0.0>
  }
  object { // Cube2374->Cube2370
    Cube2370
    rotate 0.0*z
    translate  <-0.0, -2.4, 0.0>
  }
  object { // Cube2375->Cube2370
    Cube2370
    rotate 0.0*z
    translate  <-0.0, -3.0, 0.0>
  }
  scale <1.0, 0.8, 1.0>
  rotate -90.0*z
}
#declare mittel_haupt_saele_1_19 = difference {
  object { plus_part25 }
  object { Minus_4_Scheiben20 }
  object { Minus_5_Scheiben34 }
  translate  -4.5*z
}
#declare Engine58 = difference {
  superellipsoid { // SuperQ136
    <1.0, 0.2>
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr596
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 2.6>
    translate  -1.3*z
  }
  object { Cube2376 }
  object { // Cube2377->Cube2376
    Cube2376
    rotate -15.0*z
  }
  object { // Cube2378->Cube2376
    Cube2376
    rotate -30.0*z
  }
  object { // Cube2379->Cube2376
    Cube2376
    rotate -45.0*z
  }
  object { // Cube2380->Cube2376
    Cube2376
    rotate -60.0*z
  }
  object { // Cube2381->Cube2376
    Cube2376
    rotate -75.0*z
  }
  object { // Cube2382->Cube2376
    Cube2376
    rotate -90.0*z
  }
  object { // Cube2383->Cube2376
    Cube2376
    rotate -105.0*z
  }
  object { // Cube2384->Cube2376
    Cube2376
    rotate -120.0*z
  }
  object { // Cube2385->Cube2376
    Cube2376
    rotate -135.0*z
  }
  object { // Cube2386->Cube2376
    Cube2376
    rotate -150.0*z
  }
  object { // Cube2387->Cube2376
    Cube2376
    rotate -165.0*z
  }
  object { Torus045 }
  object { // Torus046->Torus045
    Torus045
    translate  -2.4*z
  }
  object { Cube2388 }
  object { // Cube2389->Cube2388
    Cube2388
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2390->Cube2388
    Cube2388
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2391->Cube2388
    Cube2388
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2392->Cube2388
    Cube2388
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2393 }
  object { // Cube2394->Cube2393
    Cube2393
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2395->Cube2393
    Cube2393
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2396->Cube2393
    Cube2393
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2397->Cube2393
    Cube2393
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2398 }
  object { Cube2399 }
  object { Cube2400 }
  object { // Cube2401->Cube2400
    Cube2400
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2402->Cube2400
    Cube2400
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2403->Cube2400
    Cube2400
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2404->Cube2400
    Cube2400
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2405->Cube2398
    Cube2398
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2406->Cube2398
    Cube2398
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2407->Cube2398
    Cube2398
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2408->Cube2398
    Cube2398
    rotate 0.0*y
    translate  0.8*x
  }
  object { // Cube2409->Cube2399
    Cube2399
    rotate 0.0*y
    translate  0.2*x
  }
  object { // Cube2410->Cube2399
    Cube2399
    rotate 0.0*y
    translate  0.4*x
  }
  object { // Cube2411->Cube2399
    Cube2399
    rotate 0.0*y
    translate  0.6*x
  }
  object { // Cube2412->Cube2399
    Cube2399
    rotate 0.0*y
    translate  0.8*x
  }
  object { Cube2413 }
  object { Cube2414 }
  object { Cube2415 }
  object { Cube2416 }
  object { // Cube2417->Cube2413
    Cube2413
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2418->Cube2413
    Cube2413
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2419->Cube2414
    Cube2414
    rotate <0.0, -0.0, -0.0>
    translate  <0.2, -0.0, 0.0>
  }
  object { // Cube2420->Cube2414
    Cube2414
    rotate <0.0, -0.0, -0.0>
    translate  <0.4, -0.0, 0.0>
  }
  object { // Cube2421->Cube2415
    Cube2415
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // Cube2422->Cube2415
    Cube2415
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // Cube2423->Cube2416
    Cube2416
    rotate <-0.0, -0.0, 0.0>
    translate  <0.2, 0.0, 0.0>
  }
  object { // Cube2424->Cube2416
    Cube2416
    rotate <-0.0, -0.0, 0.0>
    translate  <0.4, 0.0, 0.0>
  }
}
#declare Engine59 = union {
  cone { // Cone207
    <0,0,0>, 0.6, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.3>
    translate  -1.75*z
  }
  object { Engine58 }
  material {
    Brushed_Aluminum
  }
  scale 0.7
  rotate <90.0, 0.0, -90.0>
  translate  -2.4*x
}
#declare Plus_part_motor_befestigung16 = union {
  object { SuperQ137 }
  object { Cube2425 }
  object { // Cube2426->Cube2425
    Cube2425
    translate  -0.4*y
  }
  object { // SuperQ138->SuperQ137
    SuperQ137
    translate  1.0*z
  }
}
#declare Motor_Befestigung21 = difference {
  object { Plus_part_motor_befestigung16 }
  cylinder { // Cylndr597
    <0,0,1>, <0,0,0>, 1 
    scale <0.73, 0.73, 1.8>
    rotate -90.0*y
    translate  <-1.3, 0.0, 4.5>
  }
  cylinder { // Cylndr598
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.6>
    rotate -90.0*x
    translate  <-2.59, -0.3, 2.61>
  }
  translate  <0.15, 0.0, -4.5>
}
#declare plus_part26 = union {
  cylinder { // Cylndr599
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 2.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.2, 0.0, 4.5>
  }
  box { // Cube2427
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 3.0>
    translate  1.5*z
  }
  cylinder { // Cylndr600
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.2>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.1, 0.0, -1.5>
  }
}
#declare Minus_4_Scheiben21 = union {
  object { Cube2428 }
  object { // Cube2429->Cube2428
    Cube2428
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.48, -0.0, 0.0>
  }
  object { // Cube2430->Cube2428
    Cube2428
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.96, -0.0, 0.0>
  }
  object { // Cube2431->Cube2428
    Cube2428
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.44, -0.0, 0.0>
  }
  object { // Cube2432->Cube2428
    Cube2428
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.92, -0.0, 0.0>
  }
  translate  <0.134944, 0.0, 4.119679>
}
#declare Minus_5_Scheiben35 = union {
  object { Cube2433 }
  object { // Cube2434->Cube2433
    Cube2433
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -0.6, -0.0>
  }
  object { // Cube2435->Cube2433
    Cube2433
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -1.2, -0.0>
  }
  object { // Cube2436->Cube2433
    Cube2433
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, -1.8, -0.0>
  }
  scale <1.0, 0.8, 1.0>
  rotate -90.0*z
}
#declare mittel_haupt_saele_1_20 = difference {
  object { plus_part26 }
  object { Minus_4_Scheiben21 }
  object { Minus_5_Scheiben35 }
  object { Cylndr601 }
  object { // Cylndr602->Cylndr601
    Cylndr601
    translate  4.0*y
  }
  object { Cylndr603 }
  object { // Cylndr604->Cylndr603
    Cylndr603
    rotate <0.0, 0.0, -0.0>
    translate  <-4.0, 0.0, 0.0>
  }
  object { Cube2437 }
  object { // Cube2438->Cube2437
    Cube2437
    translate  2.4*x
  }
  translate  -4.5*z
}
#declare plus_part_knoechel5 = union {
  box { // Cube2490
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
    translate  -1.5*z
  }
  cylinder { // Cylndr608
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr609
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, -3.0>
  }
}
#declare Knoechel_5 = difference {
  object { plus_part_knoechel5 }
  object { Cube2491 }
  object { // Cube2492->Cube2491
    Cube2491
    translate  0.48*x
  }
  object { // Cube2493->Cube2491
    Cube2491
    translate  0.96*x
  }
  object { // Cube2494->Cube2491
    Cube2491
    translate  1.44*x
  }
  object { // Cube2495->Cube2491
    Cube2491
    translate  1.92*x
  }
  object { Cube2496 }
  object { // Cube2497->Cube2496
    Cube2496
    translate  -0.4*y
  }
  object { // Cube2498->Cube2496
    Cube2496
    translate  -0.8*y
  }
  object { // Cube2499->Cube2496
    Cube2496
    translate  -1.2*y
  }
  object { // Cube2500->Cube2496
    Cube2496
    translate  -1.6*y
  }
}
#declare plus_part_fuss5 = union {
  box { // Cube2501
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 2.4, 1.0>
  }
  box { // Cube2502
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.3, 1.1, 0.6>
    translate  <-1.3, 2.2, -0.8>
  }
  box { // Cube2503
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.3, 1.1, 0.6>
    translate  <1.3, 2.2, -0.8>
  }
  box { // Cube2504
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.3, 1.6, 0.6>
    translate  <-1.3, -2.0, -0.8>
  }
  box { // Cube2505
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.3, 1.6, 0.6>
    translate  <1.3, -2.0, -0.8>
  }
  // All transformations fixed
}
#declare CSG340 = union {
  box { // Cube2512
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr612
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  // All transformations fixed
  scale <1.05, 0.05, 1.05>
  translate  1.235*y
}
#declare CSG341 = union {
  box { // Cube2513
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr613
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  // All transformations fixed
  scale <1.05, 0.1, 1.05>
  translate  0.87*y
}
#declare CSG342 = union {
  box { // Cube2514
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr614
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  // All transformations fixed
  scale <1.05, 0.1, 1.05>
  translate  0.47*y
}
#declare CSG343 = union {
  box { // Cube2515
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr615
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  // All transformations fixed
  scale <1.05, 0.1, 1.05>
  translate  0.07*y
}
#declare CSG344 = union {
  box { // Cube2516
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr616
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  // All transformations fixed
  scale <1.05, 0.1, 1.05>
  translate  -0.33*y
}
#declare CSG345 = union {
  box { // Cube2517
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.05, 1.0, 0.3>
    translate  <0.0, 0.3, 0.8>
  }
  cylinder { // Cylndr617
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.01, 1.01, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 0.5>
  }
  // All transformations fixed
  scale <1.05, 0.05, 1.05>
  translate  -0.665*y
}
#declare Fuss_5 = difference {
  object { plus_part_fuss5 }
  box { // Cube2506
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.65, 1.2, 0.2>
    translate  <0.0, -1.525, -1.25>
  }
  cylinder { // Cylndr610
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.4, 0.2, 3.4>
    rotate -90.0*y
    translate  <1.7, -2.725, -1.45>
  }
  box { // Cube2507
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.65, 0.8, 0.33>
    rotate 45.0*x
    translate  <0.0, -3.5, -0.52>
  }
  box { // Cube2508
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.65, 0.8, 0.33>
    rotate -60.0*x
    translate  <0.0, 3.228154, -0.35>
  }
  box { // Cube2509
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.65, 0.8, 0.2>
    translate  <0.0, 1.89, -1.25>
  }
  cylinder { // Cylndr611
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.4, 0.2, 3.4>
    rotate -90.0*y
    translate  <1.7, 2.69, -1.45>
  }
  box { // Cube2510
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.65, 0.8, 0.33>
    rotate -60.0*x
    translate  <0.0, 2.285779, 0.65779>
  }
  box { // Cube2511
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.65, 1.0, 0.45>
    rotate 45.0*x
    translate  <0.0, -2.132202, 0.916136>
  }
  object { CSG340 }
  object { CSG341 }
  object { CSG342 }
  object { CSG343 }
  object { CSG344 }
  object { CSG345 }
  rotate -180.0*z
  translate  <0.0, 0.7, -0.5>
  // All transformations fixed
}
#declare FUSS5 = union {
  object { Fuss_5 }
  // Scaling fixed
  // Rot Y limited (-45.0 to   45.0)
  // Translation fixed
  rotate -10.0*y
  translate  <0.0, -0.4, -3.0>
}
#declare KNOECHEL5 = union {
  object { Knoechel_5 }
  object { FUSS5 }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate <-0.01, 0.0, -180.0>
  translate  <0.0, 0.0, -6.0>
}
#declare UNTERSCHENKEL_RECHTS5 = union {
  object { mittel_haupt_saele_1_20 }
  object { Engine61 }
  object { Motor_Befestigung22 }
  object { // Engine62->Engine61
    Engine61
    scale 0.8
    rotate -0.0*y
    translate  <-0.05, 0.0, -6.0>
  }
  object { // Motor_Befestigung23->Motor_Befestigung22
    Motor_Befestigung22
    scale 0.8
    rotate 180.0*x
    translate  <0.05, 0.0, -6.0>
  }
  object { KNOECHEL5 }
  translate  <0.0, 0.0, 0.0>
  // Scaling fixed
  // Rot X limited (-100.0 to   100.0)
  // Translation fixed
  rotate -0.01*x
  translate  <0.0, 0.0, -6.0>
}
#declare MITTELSCHENKEL_RECHTS5 = union {
  object { mittel_haupt_saele_1_19 }
  object { Engine59 }
  object { Motor_Befestigung21 }
  object { UNTERSCHENKEL_RECHTS5 }
  translate  <0.0, 0.0, 0.0>
  // Scaling fixed
  // Rot X limited (-100.0 to   100.0)
  // Translation fixed
  rotate <-0.01, 0.0, -180.0>
  translate  <0.0, 0.0, -4.0>
}
#declare OBERSCHENKEL_LINKS2 = union {
  object { Oberschenkel_6 }
  object { MITTELSCHENKEL_RECHTS5 }
  // Scaling fixed
  // Rot Y limited (-10.0 to   45.0)
  // Translation fixed
  rotate <0.0, 10.0, -180.0>
  translate  4.5*x
}
#declare plus_parts2 = union {
  cylinder { // Cylndr618
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 3.0>
    rotate -90.0*x
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube2518
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 1.5, 1.2>
  }
  cylinder { // Cylndr619
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 3.0>
    rotate -90.0*x
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube2519
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 1.0, 1.0>
    translate  2.0*z
  }
  box { // Cube2520
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 1.45>
    translate  2.55*z
  }
  box { // Cube2521
    <-1, -1, -1>, <1, 1, 1>
    scale <2.8, 1.5, 0.7>
    translate  -1.8*z
  }
  object { fix_the_engine4 }
  object { // fix_the_engine5->fix_the_engine4
    fix_the_engine4
    rotate <180.0, 0.0, 180.0>
  }
  superellipsoid { // SuperQ144
    <0.1, 0.1>
    scale <0.8, 0.1, 1.6>
    translate  <-1.5, -1.5, -0.6>
  }
  superellipsoid { // SuperQ145
    <0.1, 0.1>
    scale <1.5, 0.1, 1.0>
    translate  <1.0, -1.5, 0.0>
  }
  superellipsoid { // SuperQ146
    <0.1, 0.1>
    scale <1.3, 0.1, 0.4>
    translate  <0.8, -1.5, -1.6>
  }
  cylinder { // Cylndr621
    <0,0,1>, <0,0,0>, 1 
    scale 1.5
    translate  3.0*z
  }
}
#declare ueergang_rund_eckig5 = difference {
  cylinder { // Cylndr632
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 1.5>
  }
  cone { // Cone210
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.51>
  }
  translate  2.501*z
}
#declare Hip_2 = difference {
  object { plus_parts2 }
  cylinder { // Cylndr622
    <0,0,1>, <0,0,0>, 1 
    scale <1.8, 1.8, 4.0>
    rotate -90.0*x
    translate  <-3.3, -2.0, 3.0>
  }
  cylinder { // Cylndr623
    <0,0,1>, <0,0,0>, 1 
    scale <1.8, 1.8, 4.0>
    rotate -90.0*x
    translate  <3.3, -2.0, 3.0>
  }
  object { Minus_4_Scheiben22 }
  object { // Minus_4_Scheiben23->Minus_4_Scheiben22
    Minus_4_Scheiben22
    translate  9.0*x
  }
  box { // Cube2522
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 2.0, 0.6>
    translate  <-2.8, 0.0, -2.1>
  }
  cylinder { // Cylndr628
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 4.0>
    rotate -90.0*x
    translate  <-2.8, -2.0, -1.5>
  }
  box { // Cube2523
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 2.0, 0.6>
    translate  <2.8, 0.0, -2.1>
  }
  cylinder { // Cylndr629
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 4.0>
    rotate -90.0*x
    translate  <2.8, -2.0, -1.5>
  }
  object { Schraube__minus_solid_part_14 }
  object { // Schraube__minus_solid_part_15->Schraube_(minus_solid_part)14
    Schraube__minus_solid_part_14
    rotate <0.0, -0.0, 0.0>
    translate  <0.0, 0.0, -0.89>
  }
  object { // Schraube__minus_solid_part_16->Schraube_(minus_solid_part)14
    Schraube__minus_solid_part_14
    rotate <-180.0, -0.0, 180.0>
    translate  <0.001546, 0.0, 0.909351>
  }
  object { // Schraube__minus_solid_part_17->Schraube_(minus_solid_part)14
    Schraube__minus_solid_part_14
    rotate <-180.0, -0.0, 180.0>
    translate  <0.001546, 0.0, 0.009351>
  }
  object { ueergang_rund_eckig5 }
}
#declare Zahnrad_Schraee28 = difference {
  cylinder { // Cylndr635
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone212
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <1.05, 1.05, 2.0>
  translate  0.92*z
}
#declare Zahnrad_Schraee29 = difference {
  cylinder { // Cylndr636
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone213
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
  }
  scale <1.05, 1.05, 2.0>
  rotate -180.0*y
  translate  0.08*z
}
#declare Zahnrad_gross8 = difference {
  cylinder { // Cylndr634
    <0,0,1>, <0,0,0>, 1 
  }
  object { CSG348 }
  object { // CSG349->CSG348
    CSG348
    rotate -12.0*z
  }
  object { // CSG350->CSG348
    CSG348
    rotate -24.0*z
  }
  object { // CSG351->CSG348
    CSG348
    rotate -36.0*z
  }
  object { // CSG352->CSG348
    CSG348
    rotate -48.0*z
  }
  object { // CSG353->CSG348
    CSG348
    rotate -60.0*z
  }
  object { // CSG354->CSG348
    CSG348
    rotate -72.0*z
  }
  object { // CSG355->CSG348
    CSG348
    rotate -84.0*z
  }
  object { // CSG356->CSG348
    CSG348
    rotate -96.0*z
  }
  object { // CSG357->CSG348
    CSG348
    rotate -108.0*z
  }
  object { // CSG358->CSG348
    CSG348
    rotate -120.0*z
  }
  object { // CSG359->CSG348
    CSG348
    rotate -132.0*z
  }
  object { // CSG360->CSG348
    CSG348
    rotate -144.0*z
  }
  object { // CSG361->CSG348
    CSG348
    rotate -156.0*z
  }
  object { // CSG362->CSG348
    CSG348
    rotate -168.0*z
  }
  object { // CSG363->CSG348
    CSG348
    rotate 180.0*z
  }
  object { // CSG364->CSG348
    CSG348
    rotate 168.0*z
  }
  object { // CSG365->CSG348
    CSG348
    rotate 156.0*z
  }
  object { // CSG366->CSG348
    CSG348
    rotate 144.0*z
  }
  object { // CSG367->CSG348
    CSG348
    rotate 132.0*z
  }
  object { // CSG368->CSG348
    CSG348
    rotate 120.0*z
  }
  object { // CSG369->CSG348
    CSG348
    rotate 108.0*z
  }
  object { // CSG370->CSG348
    CSG348
    rotate 96.0*z
  }
  object { // CSG371->CSG348
    CSG348
    rotate 84.0*z
  }
  object { // CSG372->CSG348
    CSG348
    rotate 72.0*z
  }
  object { // CSG373->CSG348
    CSG348
    rotate 60.0*z
  }
  object { // CSG374->CSG348
    CSG348
    rotate 48.0*z
  }
  object { // CSG375->CSG348
    CSG348
    rotate 36.0*z
  }
  object { // CSG376->CSG348
    CSG348
    rotate 24.0*z
  }
  object { // CSG377->CSG348
    CSG348
    rotate 12.0*z
  }
  object { Zahnrad_Schraee28 }
  object { Zahnrad_Schraee29 }
  scale <1.65, 1.65, 0.5>
  translate  4.2*z
}
#declare rest_of_hip2 = union {
  object { Hip_2 }
  object { // Engine63->Engine65
    Engine65
    rotate <0.0, 0.0, 0.0>
    translate  <4.0, 0.0, 0.0>
  }
  object { Engine65 }
  object { Zahnrad_gross8 }
}
union { // C
  object { WIRBEL_6 }
  object { OBERSCHENKEL_RECHTS2 }
  object { OBERSCHENKEL_LINKS2 }
  object { rest_of_hip2 }
  material {
    Aluminum
  }
  rotate <-0.01, -0.0, -180.0>
  translate  <0.01, 0.01, 20.6>
}
