#include "textures.inc"
#include "colors.inc"
#include "metals.inc"
#include "golds.inc"

#if (clock<=3)
 #declare xc = pow(clock/3,2)*3;
#else
 #declare xc = 6-(pow((6-clock)/3,2)*3);
#end 
#declare xc = xc/6;
camera{
     location <150-150*xc,-140+90*xc,-1600+1800*xc>
     look_at <150-300*xc,-340+200*xc+90*xc,00+200*xc>
     }
#if (clock <= 2.5)
 text{ttf "timrom.ttf" "CIA HEADQUARTERS" .1,0 translate <145-150*xc,-144+90*xc,-1590+1800*xc> pigment{color rgb <0,0,.75>} no_shadow}
 text{ttf "timrom.ttf" "0300 HOURS" .1,0 translate <147.5-150*xc,-145+90*xc,-1590+1800*xc> pigment{color rgb <0,0,.75>} no_shadow}
#end
#declare wmarble = pigment{marble
                                turbulence 0.5
                                lambda 1.5
                                omega 0.8
                                octaves 5
                                frequency 5
                                color_map { 
                                     [0.00 rgb <1,1,1>*2]
                                     [0.50 rgb <.9,.9,.9>*2]
                                     [1.00 rgb <.8,.8,.8>*2]
                                          }
                               }

#declare bmarble = pigment{marble
                                turbulence 0.5
                                lambda 1.5
                                omega 0.8
                                octaves 5
                                frequency 5
                                color_map { 
                                     [0.00 color Gray40]  
                                     [0.50 color Gray20]
                                     [1.00 color Black]
                                          } 
                               }

#declare bolt2 = sphere{<0,0,0>,10 scale <1,.25,1> texture{T_Chrome_2A}}

#declare doorxx =
union{
union{
 box{<-70,-145,3>,<70,75,9> pigment{P_Chrome3}}
 superellipsoid{<.1,.1> translate <-1,1,0> scale <15,125+5,9> translate <-70,-160,0>}
 superellipsoid{<.1,.1> translate <1,1,0> scale <12.5,125+5,9> translate <70,-160,0>} 
 superellipsoid{<.1,.1> translate <0,1,0> scale <80,12.5,9> translate <0,75,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <-70,-160,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <70,-160,0>} 
 superellipsoid{<.25,.25> translate <0,0,0> scale <80,5,3> translate <0,75,0>}
 texture{pigment{P_Chrome2}}
 }                                                                            
union{        
  superellipsoid{<1,.25> scale <10,10,2> translate <-50,-40,3>}
  cone{<-50,-40,1.9>,10,<-50,-40,-1>,5}
  difference{
   superellipsoid{<1,.25> scale <5,5,2> translate <-50,-40,-1>}
   superellipsoid{<1,.25> scale <4.5,4.5,6> translate <-50,-40,-1>} 
   }
  superellipsoid{<1,.25> scale <4,4,8> translate <-50,-40,-1>}
  sphere{<0,0,0>,8 scale <1,1,.5> translate <-50,-40,-12>}
  texture{T12}
 }
union{                
  superellipsoid{<.25,.25> scale <10,20,2>}
  superellipsoid{<.25,.25> scale <7,20,8> translate <-3,0,0>}
  superellipsoid{<.25,.25> scale <2,20,7> translate <8,0,0>}
  union{
   cylinder{<-6,10,1>,<-6,10,-9>,2}
   sphere{<-6,10,-9>,2}
   pigment{color rgb <.75,0,0>}
   finish{ambient 1}
   }
  union{
   cylinder{<0,10,1>,<0,10,-9>,2}
   sphere{<0,10,-9>,2}
   pigment{color rgb <0,.75,0>}
   finish{ambient 0}
   }
  pigment{color rgb <.2,.2,.2>}
  translate <-85,-40,-9>
 } 
//sign 
  union{
   superellipsoid{<.05,.05> scale <40,20,1> translate <0,25,3> pigment{color rgb <.8,.8,.8>}}   
   text{ttf "timrom.ttf" "RESTRICTED" 1,0.1*x scale <10,15,1> translate <-35,27.5,1.5> pigment{color Red}}
   text{ttf "timrom.ttf" "AREA" 1,0.1*x scale <10,15,1> translate <-16,12.5,1.5> pigment{color Black}} 
   }   
}

#declare ventx =
union{
 union{  
 difference{
  superellipsoid{<.1,.1> scale <300,75,75>}
  union{
   superellipsoid{<.1,.1> scale <350,70,70>}
   superellipsoid{<.1,.1> scale <50,100,50>}
   }
 }
 superellipsoid{<.1,.1> scale <12.5,80,80> translate <-80,0,0>} 
 superellipsoid{<.1,.1> scale <12.5,80,80> translate <80,0,0>}
 object{bolt2 rotate 90*x translate <-80,-20,-80>}
 object{bolt2 rotate 90*x translate <-80,-60,-80>}
 object{bolt2 rotate 90*x translate <80,-20,-80>}
 object{bolt2 rotate 90*x translate <80,-60,-80>}
 object{bolt2 rotate 90*x translate <-80,-20,80>}
 object{bolt2 rotate 90*x translate <-80,-60,80>}
 object{bolt2 rotate 90*x translate <80,-20,80>}
 object{bolt2 rotate 90*x translate <80,-60,80>}
 object{bolt2 translate <80,-80,-50>}
 object{bolt2 translate <80,-80,0>} 
 object{bolt2 translate <80,-80,50>}
 object{bolt2 translate <-80,-80,-50>}
 object{bolt2 translate <-80,-80,0>} 
 object{bolt2 translate <-80,-80,50>}
 //hinges
 superellipsoid{<.1,.1> scale <5,2.5,10> translate <-50,-72.5,-40>}
 superellipsoid{<.1,.1> scale <5,2.5,10> translate <-50,-72.5,0>}
 superellipsoid{<.1,.1> scale <5,2.5,10> translate <-50,-72.5,40>}
 superellipsoid{<1,.25> scale <2.5,2.5,10> translate <-45,-72.5,-40>}
 superellipsoid{<1,.25> scale <2.5,2.5,10> translate <-45,-72.5,0>}
 superellipsoid{<1,.25> scale <2.5,2.5,10> translate <-45,-72.5,40>} 
 texture{T_Chrome_3A}
 }
 //grating
 union{  
   //hinges
   superellipsoid{<1,.25> scale <2.5,2.5,9.5> translate <-47.5,-72.5,20>}
   superellipsoid{<1,.25> scale <2.5,2.5,9.5> translate <-47.5,-72.5,-20>}
   superellipsoid{<.1,.1> scale <5,2.5,9.5> translate <-42.5,-72.5,-20>}
   superellipsoid{<.1,.1> scale <5,2.5,9.5> translate <-42.5,-72.5,20>}
   //grate
   superellipsoid{<.1,.1> scale <4.8,2.5,49.8> translate <-37.5,-72.5,0>}
   superellipsoid{<.1,.1> scale <40,2.5,4.8> translate <5,-72.5,45>}
   superellipsoid{<.1,.1> scale <40,2.5,4.8> translate <5,-72.5,-45>}
   superellipsoid{<.1,.1> scale <4.8,2.5,49.8> translate <45,-72.5,0>}
   box{<47.5,-70,-49.8>,<49.5,-75,49.8>} 
   //bars
   cylinder{<-27.5,-72.5,-45>,<-27.5,-72.5,45>,2.5}
   cylinder{<-20,-72.5,-45>,<-20,-72.5,45>,2.5}
   cylinder{<-12.5,-72.5,-45>,<-12.5,-72.5,45>,2.5}
   cylinder{<-5,-72.5,-45>,<-5,-72.5,45>,2.5}
   cylinder{<2.5,-72.5,-45>,<2.5,-72.5,45>,2.5}
   cylinder{<10,-72.5,-45>,<10,-72.5,45>,2.5}
   cylinder{<17.5,-72.5,-45>,<17.5,-72.5,45>,2.5} 
   cylinder{<25,-72.5,-45>,<25,-72.5,45>,2.5} 
   cylinder{<32.5,-72.5,-45>,<32.5,-72.5,45>,2.5}
   cylinder{<40,-72.5,-45>,<40,-72.5,45>,2.5}  
   texture {T_Chrome_2A}
  }
 translate <0,150,0>
}

#declare doorx =
union{
union{
 box{<-70,-145,3>,<70,75,9> pigment{P_Chrome3}}
 superellipsoid{<.1,.1> translate <-1,1,0> scale <15,125+5,9> translate <-70,-160,0>}
 superellipsoid{<.1,.1> translate <1,1,0> scale <12.5,125+5,9> translate <70,-160,0>} 
 superellipsoid{<.1,.1> translate <0,1,0> scale <80,12.5,9> translate <0,75,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <-70,-160,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <70,-160,0>} 
 superellipsoid{<.25,.25> translate <0,0,0> scale <80,5,3> translate <0,75,0>}
 texture{pigment{P_Chrome2}}
 }                                                                            
union{        
  superellipsoid{<1,.25> scale <10,10,2> translate <-50,-40,3>}
  cone{<-50,-40,1.9>,10,<-50,-40,-1>,5}
  difference{
   superellipsoid{<1,.25> scale <5,5,2> translate <-50,-40,-1>}
   superellipsoid{<1,.25> scale <4.5,4.5,6> translate <-50,-40,-1>} 
   }
  superellipsoid{<1,.25> scale <4,4,8> translate <-50,-40,-1>}
  sphere{<0,0,0>,8 scale <1,1,.5> translate <-50,-40,-12>}
  texture{T12}
 }
union{                
  superellipsoid{<.25,.25> scale <10,20,2>}
  superellipsoid{<.25,.25> scale <7,20,8> translate <-3,0,0>}
  superellipsoid{<.25,.25> scale <2,20,7> translate <8,0,0>}
  union{
   cylinder{<-6,10,1>,<-6,10,-9>,2}
   sphere{<-6,10,-9>,2}
   pigment{color rgb <.75,0,0>}
   finish{ambient 1}
   }
  union{
   cylinder{<0,10,1>,<0,10,-9>,2}
   sphere{<0,10,-9>,2}
   pigment{color rgb <0,.75,0>}
   finish{ambient 0}
   }
  pigment{color rgb <.2,.2,.2>}
  translate <-85,-40,-9>
 } 
}

#declare venty = superellipsoid{<.1,.1> scale <350,70,70> translate 150*y} 

#declare doory = box{<-80,-160,20>,<80,85,-20> pigment{P_Chrome3}}                                                                            

#declare lightx =
 union{
   union{
    sphere{<0,0,-175>,20 scale <1,.25,1>}
    cylinder{<0,0,-175>,<0,-37.5,-175>,6}
    sphere{<0,0,175>,20 scale <1,.25,1>}
    cylinder{<0,0,175>,<0,-37.5,175>,6}
    difference{
     cylinder{<0,0,-200>,<0,0,200>,50 scale <1,.75,1> translate -75*y}
     union{
      cylinder{<0,0,-195>,<0,0,195>,45 scale <1,.75,1> translate -75*y}
      box{<-100,-75,-202>,<100,-200,202>} 
      }
     } 
    texture{pigment{color rgb <1.5,1.5,1.5>}
            finish{ambient 0.35
    brilliance 2
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/20
                  }
           }
   }
   //plastic cover
   intersection{
    cylinder{<0,0,-195>,<0,0,195>,45 scale <1,.75,1> translate -75*y}
    box{<-95,-73,-195>,<90,-71,195>}
    texture{pigment{color rgbf <.8,.8,.8,.5>}
            normal{bumps .5}
            finish{
              phong .25
              phong_size 150
              reflection .1
              }
           }
    } 
   //lights
   union{
    cylinder{<20,-55,195>,<20,-55,180>,7.5}
    cylinder{<20,-55,-195>,<20,-55,-180>,7.5}
    cylinder{<-20,-55,195>,<-20,-55,180>,7.5}
    cylinder{<-20,-55,-195>,<-20,-55,-180>,7.5}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <20,-55,-180>} 
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <20,-55,160>}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <-20,-55,-180>}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <-20,-55,160>}
    texture{T_Silver_3B}
    } 
   light_source{
    <0,-60,0>
    color rgb <1,1,1>*.33
    adaptive 1
    }
   light_source{
    <0,-150,0>
    color rgb <1,1,1>*.33
    shadowless
    } 
    cylinder{<-20,-55,160>,<-20,-55,-160>,14.9 pigment{color rgb <5,5,5>} finish{ambient 1} no_shadow}
    cylinder{<20,-55,160>,<20,-55,-160>,14.9 pigment{color rgb <5,5,5>} finish{ambient 1} no_shadow} 
    scale <.75,.75,1>
  }
  
//hall walls
difference{ 
 union{
  box{<200,-150,-2000>,<220,150,1000>}
  box{<-200,-150,-2000>,<-220,150,1000>}
  box{<500,-150,1400>,<-500,150,1400>}
  }
 union{  
  object{doory rotate 90*y translate <200,0,-1800>} 
  object{doory rotate -90*y translate <-200,0,-1800>}
  object{doory rotate 90*y translate <200,0,-1200>} 
  object{doory rotate -90*y translate <-200,0,-1200>}
  object{doory rotate 90*y translate <200,0,-800>} 
  object{doory rotate -90*y translate <-200,0,-800>}
  object{doory rotate 90*y translate <200,0,-200>} 
  object{doory rotate -90*y translate <-200,0,-200>}
  object{doory rotate 90*y translate <200,0,200>}
  object{doory rotate -90*y translate <-200,0,200>}
  object{doory rotate 90*y translate <200,0,800>}
  object{doory rotate -90*y translate <-200,0,800>}
  object{doory translate <0,0,1400>}
  }
 texture{
  pigment{color White}
  normal{bumps .1}
  }
 }
//floor
plane{y,-150  
      texture{
       pigment{checker pigment{wmarble}, pigment{bmarble} scale <80,80,80> translate <40,0,0>}
              finish{reflection .1
                     phong .5
                     phong_size 250
                     }
            }
     }
//ceiling 
difference{
 union{
  plane{y,150 inverse  
      texture{       
        gradient x
        texture_map{
         [0.1 pigment{P_Silver3} finish{ambient 0.35 brilliance 2 diffuse 0.3 metallic specular 0.80 roughness 1/20}]
         [0.1 pigment{color rgbt <1,1,1,1>}]
         }
       scale <80,80,80>
       translate <360,0,8000>
       }
      }
  plane{y,150.01 inverse   
      texture{       
        gradient z
        texture_map{
         [0.1 pigment{P_Silver3} finish{ambient 0.35 brilliance 2 diffuse 0.3 metallic specular 0.80 roughness 1/20}]
         [0.1 pigment{color rgbt <1,1,1,1>}]
         } 
        scale <80,80,80>
        translate <360,0,8000>
       }
      }
  plane{y,151 inverse   
       texture{
        pigment{rgb <1.2,1.2,1.2>}
        normal{dents 5 scale <2,2,2>}
        }
      }
   }
  object{venty translate <0,0,500>}
 }

object{lightx translate <0,150,-100>}
object{lightx translate <0,150,-1100>}
object{lightx translate <0,150,900>}  
object{lightx translate <0,150,-2000>}

object{doorx rotate 90*y translate <200,0,-1800>} 
object{doorx rotate -90*y translate <-200,0,-1800>}
object{doorx rotate 90*y translate <200,0,-1200>} 
object{doorx rotate -90*y translate <-200,0,-1200>}
object{doorx rotate 90*y translate <200,0,-800>} 
object{doorx rotate -90*y translate <-200,0,-800>}
object{doorx rotate 90*y translate <200,0,-200>} 
object{doorx rotate -90*y translate <-200,0,-200>}
object{doorx rotate 90*y translate <200,0,200>}
object{doorxx rotate -90*y translate <-200,0,200>}
object{doorx rotate 90*y translate <200,0,800>}
object{doorx rotate -90*y translate <-200,0,800>}
object{doorx translate <0,0,1400>}

object{ventx translate <0,0,500>}      