#include "textures.inc"
#include "colors.inc"
#include "metals.inc"
#include "golds.inc"

#if (clock<=1)
 #declare xc = pow(clock,2);
#else
 #declare xc = 2-(pow((2-clock),2));
#end   
#declare xc = xc/2;
#if (clock > 2)
 #declare xc = 1;
#end
camera{
     location <0,-50,200>
     look_at <-150+150*xc,-50+150*xc,200+300*xc>
     }
#if (clock <= 2.5)
 text{ttf "timrom.ttf" "CIA HEADQUARTERS" .1,0 translate <145-150*xc,-144+90*xc,-1590+1800*xc> pigment{color rgb <0,0,.75>} no_shadow}
 text{ttf "timrom.ttf" "0300 HOURS" .1,0 translate <147.5-150*xc,-145+90*xc,-1590+1800*xc> pigment{color rgb <0,0,.75>} no_shadow}
#end
#declare wmarble = pigment{marble
                                turbulence 0.5
                                lambda 1.5
                                omega 0.8
                                octaves 5
                                frequency 5
                                color_map { 
                                     [0.00 rgb <1,1,1>*2]
                                     [0.50 rgb <.9,.9,.9>*2]
                                     [1.00 rgb <.8,.8,.8>*2]
                                          }
                               }

#declare bmarble = pigment{marble
                                turbulence 0.5
                                lambda 1.5
                                omega 0.8
                                octaves 5
                                frequency 5
                                color_map { 
                                     [0.00 color Gray40]  
                                     [0.50 color Gray20]
                                     [1.00 color Black]
                                          } 
                               }

#declare bolt2 = sphere{<0,0,0>,10 scale <1,.25,1> texture{T_Chrome_2A}}
#declare light_on = 0;

#declare move = 1; //tread movement boolean
#declare m = 0; //movement rate
#if (move = 1)                 
 #declare m = clock*80; //change rate here
 #declare mr = m*5.2365*2; //rotation variable 
 #while (m >2)
  #declare m = m - 2;
 #end
#end

#declare close = .1; //close hand, not > 1.3 
#declare extract = 0; //push out/in hand, no greater than | 10 | 
#declare r1 = -45; //rotate 1st segment on x
#declare r2 = 0; //rotate 2nd segment on y
#declare r3 = -135; //rotate 3rd segment on x
#declare r4 = 0; //rotate 4th segment on y
#declare r5 = 135; //rotate 5th segment on y
#declare r6 = 45; //rotate 6th segment on y

#declare bolt2 = sphere{<0,0,0>,10 scale <1,.25,1> texture{T_Chrome_2A}}
#declare bolt3 = sphere{<0,0,0>,1.5 scale <1,.5,1> texture{T_Chrome_2A}}                                    
#declare bolt =
 intersection{
   prism{
      linear_spline
      0,
      2,
      7,
      <1,0>,
      <0.5,0.5*pow(3,0.5)>,
      <-0.5,0.5*pow(3,0.5)>,
      <-1,0>,
      <-0.5,-0.5*pow(3,0.5)>,
      <0.5,-0.5*pow(3,0.5)>,
      <1,0>
      }
   superellipsoid{
      <0.25,1>
      rotate 90*x
      translate 1*y
      } 
   scale <1.5,1,1.5>
   texture{T_Chrome_1A}
  }

#declare screw =    
 difference{
  sphere{<0,0,0>,.75 scale <1,.5,1>}
  union{
   box{<-.1,.125,1>,<.1,.5,-1>}
   box{<1,.125,-.1>,<-1,.5,.1>}
   }
  texture{T_Chrome_2A}
   } 
#declare robot =                
union{ 
 //tread wheels                               
 union{ 
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,-30>}
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,-10>}
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,10>}
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,30>}
  texture{T_Chrome_5B}
  translate 1*y
  }  
 union{ 
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,-30>}
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,-10>}
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,10>}
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,30>}  
  texture{T_Brass_3A}
  translate 1*y
  } 
  difference{                                  
   box{<-24,11,-30>,<24,21,30> texture {T_Chrome_4A}}
   union{
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,-30>}
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,-10>}
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,10>}
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,30>}
    }
   }
  intersection{
    union{
       sphere{<0,10,30>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,30>,8 scale <.125,1,1> translate -26*x}
       sphere{<0,10,-30>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,-30>,8 scale <.125,1,1> translate -26*x}
       sphere{<0,10,10>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,10>,8 scale <.125,1,1> translate -26*x}
       sphere{<0,10,-10>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,-10>,8 scale <.125,1,1> translate -26*x}
       }
    union{
       box{<-27,-1,-10>,<27,1,10> rotate mr*x translate <0,10,10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+15)*x translate <0,10,-10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+45)*x translate <0,10,30>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+60)*x translate <0,10,-30>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+90)*x translate <0,10,10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+105)*x translate <0,10,-10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+135)*x translate <0,10,30>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+150)*x translate <0,10,-30>}
       }
    texture{T_Brass_4A}
    translate 1*y
   } 
  //treads
  union{
    box{<-20,21,30>,<20,21.25,-30>}
    box{<-20,1,30>,<20,0.75,-30>}
    intersection{
      union{
       box{<-20,23,30>,<20,20,-30>}
       box{<-20,-1,30>,<20,2,-30>}
        }
      union{
       #declare i = -30; //counter
       #while (i < 29)
        superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,21.5,i+m>}
        superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,0.5,-i-m>}
        #declare i = i + 2;
       #end 
        }
       texture{pigment{color Gray20}}
      }
    cylinder{<-20,11,30>,<20,11,30>,10.25}
    cylinder{<-20,11,-30>,<20,11,-30>,10.25}
    intersection{
      union{
         cylinder{<-20,11,30>,<20,11,30>,11}
         cylinder{<-20,11,-30>,<20,11,-30>,11}
        }
      union{
         #declare i = 11.46; //counter
         #while ((i-((m/2)*11.46)) <= 180)
          superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,10.5,0> rotate (-(i-((m/2)*11.46)))*x translate <0,11,-30>}
          superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,-10.5,0> rotate (-(i-((m/2)*11.46)))*x translate <0,11,30>}
          #declare i = i + 11.46;
         #end
        } 
      texture{pigment{color Gray20}}
     }
    texture{
       pigment{color Black}
       normal{dents 5 scale <2,2,2>}
       finish{ambient .1}
      }
   }  
//body      
union{
 //main body 
 union{ 
  union{
   box{<-24,20,-25.1>,<-21,28,25.1>}
   box{<24,20,-25.1>,<21,28,25.1>} 
   texture{T_Chrome_4A}
   }
  union{ 
   box{<-22,24,-25>,<22,30,25>}
   //hole in right side 
   difference{
    box{<-22,25,-25>,<-21,58,25>}
    cylinder{<-21,42,-15>,<-35,42,-15>,2.5}
    }
   //hole in left side
   difference{
    box{<22,25,-25>,<21,58,25>}
    cylinder{<21,42,-15>,<35,42,-15>,2.5}
    }
   //holes in front
   difference{
    union{
     box{<-22,25,-25>,<22,58,-23>}
     box{<-13,34,-24>,<13,38,0>}
     } 
    union{                                                         
     //disk slot
     superellipsoid{<.1,.1> scale <12.5,1.25,21> translate <0,36,-25>}
     //button hole
     cylinder{<-17,36,-26>,<-17,36,-24.9>,2.5}
     texture{T_Chrome_1A}
     }
   } 
   box{<-22,25,25>,<22,58,23>}
   //hole in top
   difference{  
     union{
      box{<-22,60,25>,<22,55,-25>}
      box{<6,58,6>,<-6,61,-6> texture{T_Chrome_4A}}
      } 
     cylinder{<0,50,0>,<0,65,0>,2.01}
     } 
   object{screw translate <5,61,5>}
   object{screw translate <-5,61,5>}
   object{screw translate <5,61,-5>}
   object{screw translate <-5,61,-5>} 
   texture{T_Chrome_3A}
   }
  object{bolt rotate 90*z translate <-24,26,0>}
  object{bolt rotate 90*z translate <-24,26,20>} 
  object{bolt rotate 90*z translate <-24,26,-20>}
  object{bolt rotate -90*z translate <24,26,0>}
  object{bolt rotate -90*z translate <24,26,20>} 
  object{bolt rotate -90*z translate <24,26,-20>}
  object{bolt rotate 90*z translate <-22,58,0>}
  object{bolt rotate 90*z translate <-22,58,20>} 
  object{bolt rotate 90*z translate <-22,58,-20>}
  object{bolt rotate -90*z translate <22,58,0>}
  object{bolt rotate -90*z translate <22,58,20>} 
  object{bolt rotate -90*z translate <22,58,-20>} 
  object{bolt rotate 90*z translate <-22,36.33,23>} 
  object{bolt rotate 90*z translate <-22,46.66,23>}
  object{bolt rotate 90*z translate <-22,36.33,-23>} 
  object{bolt rotate 90*z translate <-22,46.66,-23>} 
  object{bolt rotate -90*z translate <22,36.33,23>}
  object{bolt rotate -90*z translate <22,46.66,23>}
  object{bolt rotate -90*z translate <22,36.33,-23>}
  object{bolt rotate -90*z translate <22,46.66,-23>} 
  } 
  //infered sensor
  union{
    //plastic
    superellipsoid{
          <.25,.25>
          scale <8,.5,3>
          translate <0,50,-25>
          }
    superellipsoid{
          <.25,.25>
          scale <8,.5,3>
          translate <0,44,-25>
          }
    difference{
     superellipsoid{
          <1,.25>
          scale <3.5,3.5,3>
          translate <-8,47,-25>
          }  
     superellipsoid{
          <1,.25>
          scale <3.5,3,4>
          translate <-7,47,-25>
          }
        }
    difference{
     superellipsoid{
          <1,.25>
          scale <3.5,3.5,3>
          translate <8,47,-25>
          }  
     superellipsoid{
          <1,.25>
          scale <3.5,3,4>
          translate <7,47,-25>
          }
        }  
    box{<-8,44,-25.1>,<8,50,-24.9>} 
    cylinder{<8,47,-25.1>,<8,47,-24.9>,3}
    cylinder{<-8,47,-25.1>,<-8,47,-24.9>,3}
    pigment{color Black}
   } 
 merge{
   //bulb                       
   cylinder{<8,47,-25>,<-8,47,-25>,3 hollow}
   sphere{<8,47,-25>,3 hollow}
   sphere{<-8,47,-25>,3 hollow}
   texture{
     pigment{color rgbf <1,0,0,.1>}
     finish{ambient 1} 
    }
   }  
 light_source{<0,47,-25.2> color rgb<5,5,5>} 
 //rope out top hole  
 difference{
  cone{<0,60.9,0>,2.5,<0,63,0>,2}
  cone{<0,60.9,0>,1.5*1.25,<0,63,0>,1.5}
  pigment{color Black} 
  }
 torus{1.75,.25 translate <0,63,0> pigment{color Black}}
 //rope begins   
 union{
  cylinder{<0,55,0>,<0,63,0>,.5}
  intersection{
   torus{2,.5 translate <0,0,2>}
   box{<0,-2,-2>,<3,2,2>}
   rotate 90*z
   translate <0,63,0>
   }                 
  cylinder{<0,65,2>,<0,65,25>,.5}
  pigment{P_Chrome1}
 } 
 //button
 superellipsoid{<1,.25> scale <2,2,2> translate <-17,36,-25>
     texture{pigment{color rgb <0,.5,1>} finish{phong .5 phong_size 110}}
     }
 
 //left arm
 union{  
  cylinder{<21,42,-15>,<35,42,-15>,2}
  superellipsoid{<.25,.25> scale <3,2,2> translate <33,42,-15>}
  box{<35,44,-17>,<40,43.1,-13>}
  box{<35,40,-17>,<40,40.9,-13>}
  cylinder{<40,43.1,-15>,<40,44,-15>,2}
  cylinder{<40,40,-15>,<40,40.9,-15>,2}
  object{bolt3 translate <40,44,-15>}
  object{bolt3 translate <40,40,-15>}
  //laser section 
  union{  
    superellipsoid{<.25,.25> scale <1.1,1.1,20> translate <40,42,-33>}
    cylinder{<40,42,-33>,<40,42,-63>,1 pigment{color Black}}
    torus{.9,.1 rotate 90*x translate <40,42,-63> pigment{color Black}}
    sphere{<40,42,-63>,.8 pigment{color rgbf <1,0,0,.5>} finish{ambient light_on}}
    ///
    translate <40,42,-15>*(-1)
    rotate (0)*y
    translate <40,42,-15>
    ///  
   } 
  ///
  translate <0,42,-15>*(-1)
  rotate (-0)*x
  translate <0,42,-15>
  /// 
  texture{T_Chrome_1A}
  }  
 //right arm
 union{
  cylinder{<-21,42,-15>,<-35,42,-15>,2}
  superellipsoid{<.25,.25> scale <3,2,2> translate <-33,42,-15>}
  box{<-35,44,-17>,<-40,43.1,-13>}
  box{<-35,40,-17>,<-40,40.9,-13>}
  cylinder{<-40,43.1,-15>,<-40,44,-15>,2}
  cylinder{<-40,40,-15>,<-40,40.9,-15>,2}
  object{bolt3 translate <-40,44,-15>}
  object{bolt3 translate <-40,40,-15>}
  union{
    superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-23>}
    superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-33>}
    box{<-38,44,-42>,<-38.9,40,-47>} 
    box{<-42,44,-42>,<-41.1,40,-47>}
    cylinder{<-38.9,42,-47>,<-38,42,-47>,2} 
    cylinder{<-42,42,-47>,<-41.1,42,-47>,2}
    object{bolt3 rotate 90*z translate <-42,42,-47>}
    object{bolt3 rotate 90*z translate <-38,42,-47>} 
     union{
       superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-55>}
       superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-65>}
       box{<-38,44,-74>,<-42,43.1,-79>} 
       box{<-42,40,-74>,<-38,40.9,-79>}
       cylinder{<-40,44,-79>,<-40,43.1,-79>,2} 
       cylinder{<-40,40,-79>,<-40,40.9,-79>,2}
       object{bolt3 translate <-40,44,-79>}
       object{bolt3 translate <-40,40,-79>}  
       union{
         superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-87>}
         superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-97>}
         box{<-38,44,-106>,<-42,43.1,-111>} 
         box{<-42,40,-106>,<-38,40.9,-111>}
         cylinder{<-40,44,-111>,<-40,43.1,-111>,2} 
         cylinder{<-40,40,-111>,<-40,40.9,-111>,2}
         object{bolt3 translate <-40,44,-111>}
         object{bolt3 translate <-40,40,-111>}
         union{ 
           superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-119>}
           superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-129>}
           box{<-38,44,-138>,<-42,43.1,-143>} 
           box{<-42,40,-138>,<-38,40.9,-143>}
           cylinder{<-40,44,-143>,<-40,43.1,-143>,2} 
           cylinder{<-40,40,-143>,<-40,40.9,-143>,2}
           object{bolt3 translate <-40,44,-143>}
           object{bolt3 translate <-40,40,-143>} 
           union{
             superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-151>}
             difference{
              superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-161>} 
              superellipsoid{<.25,.25> scale <1.5,1.75,10> translate <-40,42,-171>}
              }                                                                    
             superellipsoid{<.1,.1> scale <1.4,.2,10> translate <-40,43.5-close,-171-extract>} 
             superellipsoid{<.1,.1> scale <1.4,.2,10> translate <-40,40.5+close,-171-extract>}
             ///6th section turn
             translate <-40,42,-143>*(-1)
             rotate (r6)*y 
             translate <-40,42,-143>
             ///
            }
           ///5th section turn
           translate <-40,42,-111>*(-1)
           rotate (r5)*y 
           translate <-40,42,-111>
           ///
          }
         ///4th section turn
         translate <-40,42,-79>*(-1)
         rotate (r4)*y 
         translate <-40,42,-79>
         ///
        }
       ///3rd section turn
       translate <-40,42,-47>*(-1)
       rotate (r3)*x   
       translate <-40,42,-47>
       ///
      }
    /// 2nd section turn
    translate <-40,42,-15>*(-1)
    rotate (r2)*y
    translate <-40,42,-15>
    ///
   } 
  /// 1st section turn
  translate <0,42,-15>*(-1)
  rotate (r1)*x
  translate <0,42,-15>
  ///
  texture{T_Chrome_1A}
  }
 //rotate main body in correct direction (+z)
 rotate 180*y 
 }            
}  

#declare doorxx =
union{
union{
 box{<-70,-145,3>,<70,75,9> pigment{P_Chrome3}}
 superellipsoid{<.1,.1> translate <-1,1,0> scale <15,125+5,9> translate <-70,-160,0>}
 superellipsoid{<.1,.1> translate <1,1,0> scale <12.5,125+5,9> translate <70,-160,0>} 
 superellipsoid{<.1,.1> translate <0,1,0> scale <80,12.5,9> translate <0,75,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <-70,-160,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <70,-160,0>} 
 superellipsoid{<.25,.25> translate <0,0,0> scale <80,5,3> translate <0,75,0>}
 texture{pigment{P_Chrome2}}
 }                                                                            
union{        
  superellipsoid{<1,.25> scale <10,10,2> translate <-50,-40,3>}
  cone{<-50,-40,1.9>,10,<-50,-40,-1>,5}
  difference{
   superellipsoid{<1,.25> scale <5,5,2> translate <-50,-40,-1>}
   superellipsoid{<1,.25> scale <4.5,4.5,6> translate <-50,-40,-1>} 
   }
  superellipsoid{<1,.25> scale <4,4,8> translate <-50,-40,-1>}
  sphere{<0,0,0>,8 scale <1,1,.5> translate <-50,-40,-12>}
  texture{T12}
 }
union{                
  superellipsoid{<.25,.25> scale <10,20,2>}
  superellipsoid{<.25,.25> scale <7,20,8> translate <-3,0,0>}
  superellipsoid{<.25,.25> scale <2,20,7> translate <8,0,0>}
  union{
   cylinder{<-6,10,1>,<-6,10,-9>,2}
   sphere{<-6,10,-9>,2}
   pigment{color rgb <.75,0,0>}
   finish{ambient 1}
   }
  union{
   cylinder{<0,10,1>,<0,10,-9>,2}
   sphere{<0,10,-9>,2}
   pigment{color rgb <0,.75,0>}
   finish{ambient 0}
   }
  pigment{color rgb <.2,.2,.2>}
  translate <-85,-40,-9>
 } 
//sign 
  union{
   superellipsoid{<.05,.05> scale <40,20,1> translate <0,25,3> pigment{color rgb <.8,.8,.8>}}   
   text{ttf "timrom.ttf" "RESTRICTED" 1,0.1*x scale <10,15,1> translate <-35,27.5,1.5> pigment{color Red}}
   text{ttf "timrom.ttf" "AREA" 1,0.1*x scale <10,15,1> translate <-16,12.5,1.5> pigment{color Black}} 
   }   
}

#declare ventx =
union{
 union{  
 difference{  
  union{
   superellipsoid{<.1,.1> scale <12.5,80,80> translate <-80,0,0>} 
   superellipsoid{<.1,.1> scale <12.5,80,80> translate <80,0,0>}
   superellipsoid{<.1,.1> scale <300,75,75>} 
   }
  union{
   superellipsoid{<.1,.1> scale <350,70,70>}
   superellipsoid{<.1,.1> scale <50,100,50> translate -70*y}
   }
 }
 object{bolt2 rotate 90*x translate <-80,-20,-80>}
 object{bolt2 rotate 90*x translate <-80,-60,-80>}
 object{bolt2 rotate 90*x translate <80,-20,-80>}
 object{bolt2 rotate 90*x translate <80,-60,-80>}
 object{bolt2 rotate 90*x translate <-80,-20,80>}
 object{bolt2 rotate 90*x translate <-80,-60,80>}
 object{bolt2 rotate 90*x translate <80,-20,80>}
 object{bolt2 rotate 90*x translate <80,-60,80>}
 object{bolt2 translate <80,-80,-50>}
 object{bolt2 translate <80,-80,0>} 
 object{bolt2 translate <80,-80,50>}
 object{bolt2 translate <-80,-80,-50>}
 object{bolt2 translate <-80,-80,0>} 
 object{bolt2 translate <-80,-80,50>}
 //hinges
 superellipsoid{<.1,.1> scale <5,2.5,10> translate <-50,-72.5,-40>}
 superellipsoid{<.1,.1> scale <5,2.5,10> translate <-50,-72.5,0>}
 superellipsoid{<.1,.1> scale <5,2.5,10> translate <-50,-72.5,40>}
 superellipsoid{<1,.25> scale <2.5,2.5,10> translate <-45,-72.5,-40>}
 superellipsoid{<1,.25> scale <2.5,2.5,10> translate <-45,-72.5,0>}
 superellipsoid{<1,.25> scale <2.5,2.5,10> translate <-45,-72.5,40>} 
 texture{T_Chrome_3A}
 }
 //grating
 union{  
   //hinges
   superellipsoid{<1,.25> scale <2.5,2.5,9.5> translate <-47.5,-72.5,20>}
   superellipsoid{<1,.25> scale <2.5,2.5,9.5> translate <-47.5,-72.5,-20>}
   superellipsoid{<.1,.1> scale <5,2.5,9.5> translate <-42.5,-72.5,-20>}
   superellipsoid{<.1,.1> scale <5,2.5,9.5> translate <-42.5,-72.5,20>}
   //grate
   superellipsoid{<.1,.1> scale <4.8,2.5,49.8> translate <-37.5,-72.5,0>}
   superellipsoid{<.1,.1> scale <40,2.5,4.8> translate <5,-72.5,45>}
   superellipsoid{<.1,.1> scale <40,2.5,4.8> translate <5,-72.5,-45>}
   superellipsoid{<.1,.1> scale <4.8,2.5,49.8> translate <45,-72.5,0>}
   box{<47.5,-70,-49.8>,<49.5,-75,49.8>} 
   //bars
   cylinder{<-27.5,-72.5,-45>,<-27.5,-72.5,45>,2.5}
   cylinder{<-20,-72.5,-45>,<-20,-72.5,45>,2.5}
   cylinder{<-12.5,-72.5,-45>,<-12.5,-72.5,45>,2.5}
   cylinder{<-5,-72.5,-45>,<-5,-72.5,45>,2.5}
   cylinder{<2.5,-72.5,-45>,<2.5,-72.5,45>,2.5}
   cylinder{<10,-72.5,-45>,<10,-72.5,45>,2.5}
   cylinder{<17.5,-72.5,-45>,<17.5,-72.5,45>,2.5} 
   cylinder{<25,-72.5,-45>,<25,-72.5,45>,2.5} 
   cylinder{<32.5,-72.5,-45>,<32.5,-72.5,45>,2.5}
   cylinder{<40,-72.5,-45>,<40,-72.5,45>,2.5}  
   texture {T_Chrome_2A}
  } 
 translate <0,150,0>
}  

#declare doorx =
union{
union{
 box{<-70,-145,3>,<70,75,9> pigment{P_Chrome3}}
 superellipsoid{<.1,.1> translate <-1,1,0> scale <15,125+5,9> translate <-70,-160,0>}
 superellipsoid{<.1,.1> translate <1,1,0> scale <12.5,125+5,9> translate <70,-160,0>} 
 superellipsoid{<.1,.1> translate <0,1,0> scale <80,12.5,9> translate <0,75,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <-70,-160,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <70,-160,0>} 
 superellipsoid{<.25,.25> translate <0,0,0> scale <80,5,3> translate <0,75,0>}
 texture{pigment{P_Chrome2}}
 }                                                                            
union{        
  superellipsoid{<1,.25> scale <10,10,2> translate <-50,-40,3>}
  cone{<-50,-40,1.9>,10,<-50,-40,-1>,5}
  difference{
   superellipsoid{<1,.25> scale <5,5,2> translate <-50,-40,-1>}
   superellipsoid{<1,.25> scale <4.5,4.5,6> translate <-50,-40,-1>} 
   }
  superellipsoid{<1,.25> scale <4,4,8> translate <-50,-40,-1>}
  sphere{<0,0,0>,8 scale <1,1,.5> translate <-50,-40,-12>}
  texture{T12}
 }
union{                
  superellipsoid{<.25,.25> scale <10,20,2>}
  superellipsoid{<.25,.25> scale <7,20,8> translate <-3,0,0>}
  superellipsoid{<.25,.25> scale <2,20,7> translate <8,0,0>}
  union{
   cylinder{<-6,10,1>,<-6,10,-9>,2}
   sphere{<-6,10,-9>,2}
   pigment{color rgb <.75,0,0>}
   finish{ambient 1}
   }
  union{
   cylinder{<0,10,1>,<0,10,-9>,2}
   sphere{<0,10,-9>,2}
   pigment{color rgb <0,.75,0>}
   finish{ambient 0}
   }
  pigment{color rgb <.2,.2,.2>}
  translate <-85,-40,-9>
 } 
}

#declare venty = superellipsoid{<.1,.1> scale <350,70,70> translate 150*y} 

#declare doory = box{<-80,-160,20>,<80,85,-20> pigment{P_Chrome3}}                                                                            

#declare lightx =
 union{
   union{
    sphere{<0,0,-175>,20 scale <1,.25,1>}
    cylinder{<0,0,-175>,<0,-37.5,-175>,6}
    sphere{<0,0,175>,20 scale <1,.25,1>}
    cylinder{<0,0,175>,<0,-37.5,175>,6}
    difference{
     cylinder{<0,0,-200>,<0,0,200>,50 scale <1,.75,1> translate -75*y}
     union{
      cylinder{<0,0,-195>,<0,0,195>,45 scale <1,.75,1> translate -75*y}
      box{<-100,-75,-202>,<100,-200,202>} 
      }
     } 
    texture{pigment{color rgb <1.5,1.5,1.5>}
            finish{ambient 0.35
    brilliance 2
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/20
                  }
           }
   }
   //plastic cover
   intersection{
    cylinder{<0,0,-195>,<0,0,195>,45 scale <1,.75,1> translate -75*y}
    box{<-95,-73,-195>,<90,-71,195>}
    texture{pigment{color rgbf <.8,.8,.8,.5>}
            normal{bumps .5}
            finish{
              phong .25
              phong_size 150
              reflection .1
              }
           }
    } 
   //lights
   union{
    cylinder{<20,-55,195>,<20,-55,180>,7.5}
    cylinder{<20,-55,-195>,<20,-55,-180>,7.5}
    cylinder{<-20,-55,195>,<-20,-55,180>,7.5}
    cylinder{<-20,-55,-195>,<-20,-55,-180>,7.5}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <20,-55,-180>} 
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <20,-55,160>}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <-20,-55,-180>}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <-20,-55,160>}
    texture{T_Silver_3B}
    } 
   light_source{
    <0,-60,0>
    color rgb <1,1,1>*.33
    adaptive 1
    }
   light_source{
    <0,-150,0>
    color rgb <1,1,1>*.33
    shadowless
    } 
    cylinder{<-20,-55,160>,<-20,-55,-160>,14.9 pigment{color rgb <5,5,5>} finish{ambient 1} no_shadow}
    cylinder{<20,-55,160>,<20,-55,-160>,14.9 pigment{color rgb <5,5,5>} finish{ambient 1} no_shadow} 
    scale <.75,.75,1>
  }
  
//hall walls
difference{ 
 union{
  box{<200,-150,-2000>,<220,150,1000>}
  box{<-200,-150,-2000>,<-220,150,1000>}
  box{<500,-150,1400>,<-500,150,1400>}
  }
 union{
  object{doory rotate 90*y translate <200,0,-1200>} 
  object{doory rotate -90*y translate <-200,0,-1200>}
  object{doory rotate 90*y translate <200,0,-800>} 
  object{doory rotate -90*y translate <-200,0,-800>}
  object{doory rotate 90*y translate <200,0,-200>} 
  object{doory rotate -90*y translate <-200,0,-200>}
  object{doory rotate 90*y translate <200,0,200>}
  object{doory rotate -90*y translate <-200,0,200>}
  object{doory rotate 90*y translate <200,0,800>}
  object{doory rotate -90*y translate <-200,0,800>}
  object{doory translate <0,0,1400>}
  }
 texture{
  pigment{color White}
  normal{bumps .1}
  }
 }
//floor
plane{y,-150  
      texture{
       pigment{checker pigment{wmarble}, pigment{bmarble} scale <80,80,80> translate <40,0,0>}
              finish{reflection .1
                     phong .5
                     phong_size 250
                     }
            }
     }
//ceiling 
difference{
 union{
  plane{y,150 inverse  
      texture{       
        gradient x
        texture_map{
         [0.1 pigment{P_Silver3} finish{ambient 0.35 brilliance 2 diffuse 0.3 metallic specular 0.80 roughness 1/20}]
         [0.1 pigment{color rgbt <1,1,1,1>}]
         }
       scale <80,80,80>
       translate <360,0,8000>
       }
      }
  plane{y,150.01 inverse   
      texture{       
        gradient z
        texture_map{
         [0.1 pigment{P_Silver3} finish{ambient 0.35 brilliance 2 diffuse 0.3 metallic specular 0.80 roughness 1/20}]
         [0.1 pigment{color rgbt <1,1,1,1>}]
         } 
        scale <80,80,80>
        translate <360,0,8000>
       }
      }
  plane{y,151 inverse   
       texture{
        pigment{rgb <1.2,1.2,1.2>}
        normal{dents 5 scale <2,2,2>}
        }
      }
   }
  object{venty translate <0,0,500>}
 }

object{lightx translate <0,150,-100>}
object{lightx translate <0,150,-1100>}
object{lightx translate <0,150,900>}  
object{lightx translate <0,150,-2000>}

object{doorx rotate 90*y translate <200,0,-1800>} 
object{doorx rotate -90*y translate <-200,0,-1800>}
object{doorx rotate 90*y translate <200,0,-1200>} 
object{doorx rotate -90*y translate <-200,0,-1200>}
object{doorx rotate 90*y translate <200,0,-800>} 
object{doorx rotate -90*y translate <-200,0,-800>}
object{doorx rotate 90*y translate <200,0,-200>} 
object{doorx rotate -90*y translate <-200,0,-200>}
object{doorx rotate 90*y translate <200,0,200>}
object{doorxx rotate -90*y translate <-200,0,200>}
object{doorx rotate 90*y translate <200,0,800>}
object{doorx rotate -90*y translate <-200,0,800>}
object{doorx translate <0,0,1400>}

object{ventx translate <0,0,500>}

object{robot rotate (-90)*y translate <290-80*clock,80,500>}      