#include "colors.inc"
#include "textures.inc"
#include "metals.inc"   
#include "woods.inc"
   
#declare xc = 1;
#if (clock<.5)
 #declare xc = pow(clock/.5,.5);
#end
   
camera{
   location <60,-50,105>
   look_at <0,-20-80*xc,200>
   }    

   
#declare r1 = -110.4;  //rotate 1st segment on x
#declare r2 = 0; //rotate 2nd segment on y
#declare r3 = 110.4; //rotate 3rd segment on x
#declare r4 = -139.51;
#declare r5 = 149.92;
#declare r6 = -10.41; 

#declare l1 = 90;
#declare l2 = 0;    

#declare close = .55; //close hand, not > 1.3 
#declare extract = 0; //push out/in hand, no greater than | 10 |

#if (clock<1)
 #declare r4 = -139.51-((-139.51+105.78)*clock);
 #declare r5 = 149.92-((149.92-135.37)*clock);
 #declare r6 = -10.41-((-10.41+29.6)*clock); 
#else
 #declare r4 = -105.78;
 #declare r5 = 135.37;
 #declare r6 = -29.6;
#end

#if (clock >=1)
 #if (clock <1.4) 
  #declare extract = -((5*(clock-1))/0.4);
  #declare close = .55-((.15*(clock-1))/0.4);
 #else
  #if (clock <1.5)
   #declare extract = -5;
   #declare close = .4+((.8*(clock-1.4))/0.1);
  #else
   #if (clock < 2)                            
    #declare extract = -5 + ((11*(clock-1.5))/0.5);
    #declare close = 1.2;
   #else                 
    #declare extract = 6;
    #declare close = 1.2;
   #end
  #end
 #end
#end

#declare venty = superellipsoid{<.1,.1> scale <1200,70,70> translate 150*y pigment{color Black}} 

#declare bolt2 = sphere{<0,0,0>,10 scale <1,.25,1> pigment{P_Chrome2}}
#declare bolt3 = sphere{<0,0,0>,1.5 scale <1,.5,1> pigment{P_Chrome2}}                                    
#declare bolt =
 intersection{
   prism{
      linear_spline
      0,
      2,
      7,
      <1,0>,
      <0.5,0.5*pow(3,0.5)>,
      <-0.5,0.5*pow(3,0.5)>,
      <-1,0>,
      <-0.5,-0.5*pow(3,0.5)>,
      <0.5,-0.5*pow(3,0.5)>,
      <1,0>
      }
   superellipsoid{
      <0.25,1>
      rotate 90*x
      translate 1*y
      } 
   scale <1.5,1,1.5>
   pigment{P_Chrome1}
  }

#declare screw =    
 difference{
  sphere{<0,0,0>,.75 scale <1,.5,1>}
  union{
   box{<-.1,.125,1>,<.1,.5,-1>}
   box{<1,.125,-.1>,<-1,.5,.1>}
   }
  pigment{P_Chrome2}
   } 
#declare m = 0;
#declare move = 0;
#declare mr = 0;
#declare light_on = 0; 

#declare disk =             
union{
 //main body                                    
 difference{
  superellipsoid{<.01,.01> scale <12,.75,12>}
  union{
    superellipsoid{<.1,.1> scale <9,.25,14> translate <0,.75,-12>}
    superellipsoid{<.1,.1> scale <9,.25,3.5> translate <0,-.75,-12>}
    superellipsoid{<.1,.1> scale <9,1,.25> translate <0,0,-12>} 
    superellipsoid{<.1,.1> scale <7,.25,8> translate <-2,.75,12>}
    superellipsoid{<.1,.1> scale <7,.25,8> translate <-2,-.75,12>}
    superellipsoid{<.1,.1> scale <.75,2,.75> translate <-10.5,0.75,-9>}
    superellipsoid{<.1,.1> scale <.75,2,.75> translate <10.5,0.75,-9>} 
    superellipsoid{<.1,.1> scale <.75,.75,1.5> translate <-10.5,-0.75,-9.75>} 
    box{<1.5,-1.5,-1.5>,<-1.5,1.5,1.5> rotate 45*y translate <12,0,12>} 
    superellipsoid{<.1,.1> scale <.5,.25,1> translate <-10.5,0.75,8>}
    prism{linear_spline 0.5,1,4 <-1,.5>,<1,.5>,<0,3>,<-1,.5> translate <-10.5,0,8>}
    cylinder{<12,0,9>,<12,-1,9>,1.5} 
    cylinder{<-12,0,9>,<-12,-1,9>,1.5}   
    cylinder{<10.5,0,6>,<10.5,-1,6>,.75} 
    cylinder{<-10.5,0,6>,<-10.5,-1,6>,.75} 
    cylinder{<0,0,0>,<0,-1,0>,4}
   }
  }
 superellipsoid{<.1,.1> scale <.7,.375,.7> translate <-10.5,-0.375,-9>}
 //metallic edge
 union{   
  difference{            
   union{
    superellipsoid{<.1,.1> scale <5,.125,4> translate <0,0.625,8>}   
    superellipsoid{<.1,.1> scale <5,.125,4> translate <0,-0.625,8>}
    superellipsoid{<.1,.1> scale <5,.75,.125> translate <0,0,11.875>}
    }
   superellipsoid{<.1,.1> scale <1,1,3> translate <1,0,8>}
   } 
  difference{
   cylinder{<0,0,0>,<0,-.75,0>,3.5}
   union{
    superellipsoid{<.25,.25> scale <.5,1,.5> translate <0,-.375,0> rotate 30*y}
    superellipsoid{<.25,.25> scale <1.5,1,.75> translate <0,-.375,1.75> rotate 45*y} 
    }
   }
  texture{T_Silver_3A}
  }
 pigment{color Gray20} 
 rotate 180*y
 translate -12*z
 }  

#declare robot =                
union{ 
 //tread wheels                               
 union{ 
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,-30>}
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,-10>}
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,10>}
  cylinder{<-25,0,0>,<25,0,0>,10 rotate mr*x translate <0,10,30>}
  pigment{P_Chrome5}
  translate 1*y
  }  
 union{ 
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,-30>}
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,-10>}
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,10>}
  cylinder{<-26,0,0>,<26,0,0>,8 rotate mr*x translate <0,10,30>}  
  texture{T_Brass_3A}
  translate 1*y
  } 
  difference{                                  
   box{<-24,11,-30>,<24,21,30> pigment{P_Chrome4}}
   union{
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,-30>}
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,-10>}
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,10>}
     cylinder{<-25,0,0>,<25,0,0>,10.2 rotate mr*x translate <0,10,30>}
    }
   }
  intersection{
    union{
       sphere{<0,10,30>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,30>,8 scale <.125,1,1> translate -26*x}
       sphere{<0,10,-30>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,-30>,8 scale <.125,1,1> translate -26*x}
       sphere{<0,10,10>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,10>,8 scale <.125,1,1> translate -26*x}
       sphere{<0,10,-10>,8 scale <.125,1,1> translate 26*x}
       sphere{<0,10,-10>,8 scale <.125,1,1> translate -26*x}
       }
    union{
       box{<-27,-1,-10>,<27,1,10> rotate mr*x translate <0,10,10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+15)*x translate <0,10,-10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+45)*x translate <0,10,30>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+60)*x translate <0,10,-30>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+90)*x translate <0,10,10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+105)*x translate <0,10,-10>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+135)*x translate <0,10,30>}
       box{<-27,-1,-10>,<27,1,10> rotate (mr+150)*x translate <0,10,-30>}
       }
    pigment{P_Brass4}
    translate 1*y
   } 
  //treads
  union{
    box{<-20,21,30>,<20,21.25,-30>}
    box{<-20,1,30>,<20,0.75,-30>}
    intersection{
      union{
       box{<-20,23,30>,<20,20,-30>}
       box{<-20,-1,30>,<20,2,-30>}
        }
      union{
       #declare i = -30; //counter
       #while (i < 29)
        superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,21.5,i+m>}
        superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,0.5,-i-m>}
        #declare i = i + 2;
       #end 
        }
       texture{pigment{color Gray20}}
      }
    cylinder{<-20,11,30>,<20,11,30>,10.25}
    cylinder{<-20,11,-30>,<20,11,-30>,10.25}
    intersection{
      union{
         cylinder{<-20,11,30>,<20,11,30>,11}
         cylinder{<-20,11,-30>,<20,11,-30>,11}
        }
      union{
         #declare i = 11.46; //counter
         #while ((i-((m/2)*11.46)) <= 180)
          superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,10.5,0> rotate (-(i-((m/2)*11.46)))*x translate <0,11,-30>}
          superellipsoid{<.5,.5> translate 1*z scale <20,.5,.5> translate <0,-10.5,0> rotate (-(i-((m/2)*11.46)))*x translate <0,11,30>}
          #declare i = i + 11.46;
         #end
        } 
      texture{pigment{color Gray20}}
     }
    texture{
       pigment{color Black}
       normal{dents 5 scale <2,2,2>}
       finish{ambient .1}
      }
   }  
//body      
union{
 //main body 
 union{ 
  union{
   box{<-24,20,-25.1>,<-21,28,25.1>}
   box{<24,20,-25.1>,<21,28,25.1>} 
   texture{T_Chrome_4A}
   }
  union{ 
   box{<-22,24,-25>,<22,30,25>}
   //hole in right side 
   difference{
    box{<-22,25,-25>,<-21,58,25>}
    cylinder{<-21,42,-15>,<-35,42,-15>,2.5}
    }
   //hole in left side
   difference{
    box{<22,25,-25>,<21,58,25>}
    cylinder{<21,42,-15>,<35,42,-15>,2.5}
    }
   //holes in front
   difference{
    union{
     box{<-22,25,-25>,<22,58,-23>}
     box{<-13,34,-24>,<13,38,0>}
     } 
    union{                                                         
     //disk slot
     superellipsoid{<.1,.1> scale <12.5,1.25,21> translate <0,36,-25>}
     //button hole
     cylinder{<-17,36,-26>,<-17,36,-24.9>,2.5}
     pigment{P_Chrome1}
     }
   } 
   box{<-22,25,25>,<22,58,23>}
   //hole in top
   difference{  
     union{
      box{<-22,60,25>,<22,55,-25>}
      box{<6,58,6>,<-6,61,-6> pigment{P_Chrome4}}
      } 
     cylinder{<0,50,0>,<0,65,0>,2.01}
     } 
   object{screw translate <5,61,5>}
   object{screw translate <-5,61,5>}
   object{screw translate <5,61,-5>}
   object{screw translate <-5,61,-5>} 
   pigment{P_Chrome3}
   }
  object{bolt rotate 90*z translate <-24,26,0>}
  object{bolt rotate 90*z translate <-24,26,20>} 
  object{bolt rotate 90*z translate <-24,26,-20>}
  object{bolt rotate -90*z translate <24,26,0>}
  object{bolt rotate -90*z translate <24,26,20>} 
  object{bolt rotate -90*z translate <24,26,-20>}
  object{bolt rotate 90*z translate <-22,58,0>}
  object{bolt rotate 90*z translate <-22,58,20>} 
  object{bolt rotate 90*z translate <-22,58,-20>}
  object{bolt rotate -90*z translate <22,58,0>}
  object{bolt rotate -90*z translate <22,58,20>} 
  object{bolt rotate -90*z translate <22,58,-20>} 
  object{bolt rotate 90*z translate <-22,36.33,23>} 
  object{bolt rotate 90*z translate <-22,46.66,23>}
  object{bolt rotate 90*z translate <-22,36.33,-23>} 
  object{bolt rotate 90*z translate <-22,46.66,-23>} 
  object{bolt rotate -90*z translate <22,36.33,23>}
  object{bolt rotate -90*z translate <22,46.66,23>}
  object{bolt rotate -90*z translate <22,36.33,-23>}
  object{bolt rotate -90*z translate <22,46.66,-23>} 
  } 
  //infered sensor
  union{
    //plastic
    superellipsoid{
          <.25,.25>
          scale <8,.5,3>
          translate <0,50,-25>
          }
    superellipsoid{
          <.25,.25>
          scale <8,.5,3>
          translate <0,44,-25>
          }
    difference{
     superellipsoid{
          <1,.25>
          scale <3.5,3.5,3>
          translate <-8,47,-25>
          }  
     superellipsoid{
          <1,.25>
          scale <3.5,3,4>
          translate <-7,47,-25>
          }
        }
    difference{
     superellipsoid{
          <1,.25>
          scale <3.5,3.5,3>
          translate <8,47,-25>
          }  
     superellipsoid{
          <1,.25>
          scale <3.5,3,4>
          translate <7,47,-25>
          }
        }  
    box{<-8,44,-25.1>,<8,50,-24.9>} 
    cylinder{<8,47,-25.1>,<8,47,-24.9>,3}
    cylinder{<-8,47,-25.1>,<-8,47,-24.9>,3}
    pigment{color Black}
   } 
 merge{
   //bulb                       
   cylinder{<8,47,-25>,<-8,47,-25>,3 hollow}
   sphere{<8,47,-25>,3 hollow}
   sphere{<-8,47,-25>,3 hollow}
   texture{
     pigment{color rgbf <1,0,0,.1>}
     finish{ambient 1} 
    }
   }  
 light_source{<0,47,-25.2> color rgb<.5,.5,.5>} 
 //rope out top hole  
 difference{
  cone{<0,60.9,0>,2.5,<0,63,0>,2}
  cone{<0,60.9,0>,1.5*1.25,<0,63,0>,1.5}
  pigment{color Black} 
  }
 torus{1.75,.25 translate <0,63,0> pigment{color Black}}
 //rope begins   
 union{
  cylinder{<0,55,0>,<0,63,0>,.5}              
  cylinder{<0,63,0>,<0,310,0>,.5}
  pigment{P_Chrome1}
 } 
 //button
 superellipsoid{<1,.25> scale <2,2,2> translate <-17,36,-25> 
     #if (clock >=1)
     #if (clock < 1.25)
      #if ((-5+((clock-1)*4)*7) > 0)
       translate (-5+((clock-1)*4)*7)*z
      #end
     #else
      #if (clock < 1.5) 
       #if ((2-((clock-1.25)*4)*4) > 0)
        translate (2-((clock-1.25)*4)*4)*z
       #end 
      #end
     #end
     #end
     texture{pigment{color rgb <0,.5,1>} finish{phong .5 phong_size 110}}
     }
 
 //left arm
 union{  
  cylinder{<21,42,-15>,<35,42,-15>,2}
  superellipsoid{<.25,.25> scale <3,2,2> translate <33,42,-15>}
  box{<35,44,-17>,<40,43.1,-13>}
  box{<35,40,-17>,<40,40.9,-13>}
  cylinder{<40,43.1,-15>,<40,44,-15>,2}
  cylinder{<40,40,-15>,<40,40.9,-15>,2}
  object{bolt3 translate <40,44,-15>}
  object{bolt3 translate <40,40,-15>}
  //laser section 
  union{  
    superellipsoid{<.25,.25> scale <1.1,1.1,20> translate <40,42,-33>}
    cylinder{<40,42,-33>,<40,42,-63>,1 pigment{color Black}}
    torus{.9,.1 rotate 90*x translate <40,42,-63> pigment{color Black}}
    sphere{<40,42,-63>,.8 pigment{color rgbf <1,0,0,.5>} finish{ambient light_on}}
    ///
    translate <40,42,-15>*(-1)
    rotate (l2)*y
    translate <40,42,-15>
    ///  
   } 
  ///
  translate <0,42,-15>*(-1)
  rotate (l1)*x
  translate <0,42,-15>
  /// 
  pigment{P_Chrome1}
  }  
 //right arm
 union{
  cylinder{<-21,42,-15>,<-35,42,-15>,2}
  superellipsoid{<.25,.25> scale <3,2,2> translate <-33,42,-15>}
  box{<-35,44,-17>,<-40,43.1,-13>}
  box{<-35,40,-17>,<-40,40.9,-13>}
  cylinder{<-40,43.1,-15>,<-40,44,-15>,2}
  cylinder{<-40,40,-15>,<-40,40.9,-15>,2}
  object{bolt3 translate <-40,44,-15>}
  object{bolt3 translate <-40,40,-15>}
  union{
    superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-23>}
    superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-33>}
    box{<-38,44,-42>,<-38.9,40,-47>} 
    box{<-42,44,-42>,<-41.1,40,-47>}
    cylinder{<-38.9,42,-47>,<-38,42,-47>,2} 
    cylinder{<-42,42,-47>,<-41.1,42,-47>,2}
    object{bolt3 rotate 90*z translate <-42,42,-47>}
    object{bolt3 rotate 90*z translate <-38,42,-47>} 
     union{
       superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-55>}
       superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-65>}
       box{<-38,44,-74>,<-42,43.1,-79>} 
       box{<-42,40,-74>,<-38,40.9,-79>}
       cylinder{<-40,44,-79>,<-40,43.1,-79>,2} 
       cylinder{<-40,40,-79>,<-40,40.9,-79>,2}
       object{bolt3 translate <-40,44,-79>}
       object{bolt3 translate <-40,40,-79>}  
       union{
         superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-87>}
         superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-97>}
         box{<-38,44,-106>,<-42,43.1,-111>} 
         box{<-42,40,-106>,<-38,40.9,-111>}
         cylinder{<-40,44,-111>,<-40,43.1,-111>,2} 
         cylinder{<-40,40,-111>,<-40,40.9,-111>,2}
         object{bolt3 translate <-40,44,-111>}
         object{bolt3 translate <-40,40,-111>}
         union{ 
           superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-119>}
           superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-129>}
           box{<-38,44,-138>,<-42,43.1,-143>} 
           box{<-42,40,-138>,<-38,40.9,-143>}
           cylinder{<-40,44,-143>,<-40,43.1,-143>,2} 
           cylinder{<-40,40,-143>,<-40,40.9,-143>,2}
           object{bolt3 translate <-40,44,-143>}
           object{bolt3 translate <-40,40,-143>} 
           union{
             superellipsoid{<.25,.25> scale <1.1,1.1,10> translate <-40,42,-151>}
             difference{
              superellipsoid{<.25,.25> scale <2,2,10> translate <-40,42,-161>} 
              superellipsoid{<.25,.25> scale <1.5,1.75,10> translate <-40,42,-171>}
              }                                                                    
             superellipsoid{<.1,.1> scale <1.4,.2,10> translate <-40,43.5-close,-171-extract>} 
             superellipsoid{<.1,.1> scale <1.4,.2,10> translate <-40,40.5+close,-171-extract>}
             #if (clock <1)
              object{disk translate <-40,42,-176-extract>}  
             #end
             ///6th section turn
             translate <-40,42,-143>*(-1)
             rotate (r6)*y 
             translate <-40,42,-143>
             ///
            }
           ///5th section turn
           translate <-40,42,-111>*(-1)
           rotate (r5)*y 
           translate <-40,42,-111>
           ///
          }
         ///4th section turn
         translate <-40,42,-79>*(-1)
         rotate (r4)*y 
         translate <-40,42,-79>
         ///
        }
       ///3rd section turn
       translate <-40,42,-47>*(-1)
       rotate (r3)*x   
       translate <-40,42,-47>
       ///
      }
    /// 2nd section turn
    translate <-40,42,-15>*(-1)
    rotate (r2)*y
    translate <-40,42,-15>
    ///
   } 
  /// 1st section turn
  translate <0,42,-15>*(-1)
  rotate (r1)*x
  translate <0,42,-15>
  /// 
  translate 15*z
  translate -42*y
  texture{T_Chrome_1A}
  }
 //rotate main body in correct direction (+z)
 rotate 180*y 
 }            
}  

#declare alarm = 0; //turn alarm on
   
#declare key = 
 prism{
  linear_spline
  conic_sweep
  .75,
  1,
  5,
  <-3,3>,
  <-3,-3>,
  <3,-3>,
  <3,3>,
  <-3,3>
  scale <1,20,1>
  translate -15*y rotate 180*x translate 5*y
  } 
#declare arrow = 
 union{
  prism{
   linear_spline
   -.25,
   0,
   4,
   <-.5,0>,
   <.5,0>,
   <0,1>,
   <-.5,0>
   }   
  box{<-0.25,-0.25,0>,<0.25,0,-1.5>}
  }
  
#declare d_light = 0; //disk working light 
#declare t2=texture{
 pigment{ 
  gradient x
  color_map{
   [0.1 color rgbt <1,1,1,1>]
   [0.1 color rgb <0,1,0>]
   }
  }
   scale <1,1,1>*.1 
 finish{ambient 1}
 }

texture{
 pigment{ 
  gradient y
  color_map{
   [0.1 color rgbt <1,1,1,1>]
   [0.1 color rgb <0,1,0>]
   }
  }
   scale <1,1,1>*.1 
   finish{ambient 1} 
 }
 


#declare doorx =
union{
union{
 box{<-70,-145,3>,<70,75,9> pigment{P_Chrome3}}
 superellipsoid{<.1,.1> translate <-1,1,0> scale <15,125+5,9> translate <-70,-160,0>}
 superellipsoid{<.1,.1> translate <1,1,0> scale <12.5,125+5,9> translate <70,-160,0>} 
 superellipsoid{<.1,.1> translate <0,1,0> scale <80,12.5,9> translate <0,75,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <-70,-160,0>}
 superellipsoid{<.25,.25> translate <0,1,0> scale <5,125+5,3> translate <70,-160,0>} 
 superellipsoid{<.25,.25> translate <0,0,0> scale <80,5,3> translate <0,75,0>}
 texture{pigment{P_Chrome2}}
 }                                                                            
union{        
  superellipsoid{<1,.25> scale <10,10,2> translate <-50,-40,3>}
  cone{<-50,-40,1.9>,10,<-50,-40,-1>,5}
  difference{
   superellipsoid{<1,.25> scale <5,5,2> translate <-50,-40,-1>}
   superellipsoid{<1,.25> scale <4.5,4.5,6> translate <-50,-40,-1>} 
   }
  superellipsoid{<1,.25> scale <4,4,8> translate <-50,-40,-1>}
  sphere{<0,0,0>,8 scale <1,1,.5> translate <-50,-40,-12>}
  texture{T12}
 }
} 

#declare doory = box{<-80,-160,20>,<80,85,-20> pigment{P_Chrome3}} 

  
#declare wmarble = pigment{marble
                                turbulence 0.5
                                lambda 1.5
                                omega 0.8
                                octaves 5
                                frequency 5
                                color_map { 
                                     [0.00 rgb <1,1,1>*2]
                                     [0.50 rgb <.9,.9,.9>*2]
                                     [1.00 rgb <.8,.8,.8>*2]
                                          }
                               }

#declare bmarble = pigment{marble
                                turbulence 0.5
                                lambda 1.5
                                omega 0.8
                                octaves 5
                                frequency 5
                                color_map { 
                                     [0.00 color Gray40]  
                                     [0.50 color Gray20]
                                     [1.00 color Black]
                                          } 
                               } 
                               
#declare ty = 
   intersection{
    torus{10,5}
    box{<0,-20,0>,<-20,20,20>}
    translate -10*z
    rotate -90*z   
   }   
 
#declare tz = 
   intersection{
    torus{10,3}
    box{<0,-20,0>,<-20,20,20>}
    translate -10*z
    rotate -90*z   
   } 
                     
#declare cam = 
 union{
  union{
   box{<-10,-10,0>,<10,10,-1>}
   superellipsoid{<.1,.1> scale <5,5,10> translate <0,0,-10>}
   box{<-5,-5,-15>,<-4,5,-25>} 
   box{<5,-5,-15>,<4,5,-25>}
   cylinder{<-5,0,-25>,<-4,0,-25>,5}
   cylinder{<5,0,-25>,<4,0,-25>,5}
   object{bolt3 scale <2,2,2> rotate 90*z translate <-5,0,-25>} 
   object{bolt3 scale <2,2,2> rotate 90*z translate <5,0,-25>}
   texture{T_Chrome_1A} 
  }                    
  union{
   superellipsoid{<.1,.1> scale <4,4,10> translate <0,0,-7>}
   superellipsoid{<.1,.1> scale <10,15,10> translate <0,0,-25>}
   difference{
    superellipsoid{<1,.25> rotate 90*x scale <5,6,5> translate <0,-20,-27> texture{T_Chrome_1A}}
    cylinder{<0,-14,-27>,<0,-30,-27>,3.5}
    }                                 
   cylinder{<0,-23.5,-27>,<0,-24.5,-27>,4.5 texture{Glass}}
    union{
     text{ttf "timrom.ttf" "Nick Santos" 1,0 scale <2,2,2> rotate (-90)*x translate <-5,-16,-19>}
     text{ttf "timrom.ttf" "Security Cameras" 1,0 scale <2,2,2> rotate (-90)*x translate <-7,-16,-17>}
     pigment{color White}
    }  
   merge{
    cylinder{<-7,-14,-32>,<-7,-16,-32>,1}
    sphere{<-7,-16,-32>,1}
    pigment{color rgb <.75,0,0>}
    finish{ambient 1}
    }                
   rotate 60*x
   translate <0,0,-25>
   texture{T_Chrome_3A}
  }
 }
#declare lightxx =
 union{
   union{
    sphere{<0,0,-175>,20 scale <1,.25,1>}
    cylinder{<0,0,-175>,<0,-75,-175>,6}
    sphere{<0,0,175>,20 scale <1,.25,1>}
    cylinder{<0,0,175>,<0,-75,175>,6}
    difference{
     cylinder{<0,0,-200>,<0,0,200>,50 scale <1,.75,1> translate -115*y}
     union{
      cylinder{<0,0,-195>,<0,0,195>,45 scale <1,.75,1> translate -115*y}
      box{<-100,-115,-202>,<100,-240,202>} 
      }
     } 
    texture{pigment{color rgb <1.5,1.5,1.5>}
            finish{ambient 0.35
    brilliance 2
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/20
                  }
           }
   }
   //plastic cover
   intersection{
    cylinder{<0,0,-195>,<0,0,195>,45 scale <1,.75,1> translate -115*y}
    box{<-95,-113,-195>,<90,-111,195>}
    texture{pigment{color rgbf <.8,.8,.8,.5>}
            normal{bumps .5}
            finish{
              phong .25
              phong_size 150
              reflection .1
              }
           }
    } 
   //lights
   union{
    cylinder{<20,-95,195>,<20,-95,180>,7.5}
    cylinder{<20,-95,-195>,<20,-95,-180>,7.5}
    cylinder{<-20,-95,195>,<-20,-95,180>,7.5}
    cylinder{<-20,-95,-195>,<-20,-95,-180>,7.5}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <20,-95,-180>} 
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <20,-95,160>}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <-20,-95,-180>}
    superellipsoid{<1,.25> translate 1*z scale <15,15,10> translate <-20,-95,160>}
    texture{T_Silver_3B}
    } 
   light_source{
    <0,-100,0>
    color rgb <1,1,1>*.33
    adaptive 1
    }
   light_source{
    <0,-190,0>
    color rgb <1,1,1>*.33
    shadowless
    } 
    cylinder{<-20,-95,160>,<-20,-95,-160>,14.9 pigment{color rgb <5,5,5>} finish{ambient 1} no_shadow}
    cylinder{<20,-95,160>,<20,-95,-160>,14.9 pigment{color rgb <5,5,5>} finish{ambient 1} no_shadow} 
    scale <.75,.75,.75>
  }                               

//floor
plane{y,-150  
      texture{
       pigment{checker pigment{wmarble}, pigment{bmarble} scale <80,80,80> translate <40,0,0>}
              finish{reflection .1
                     phong .5
                     phong_size 250
                     }
            }
     }
//ceiling  
  plane{y,400 inverse pigment{color Black}}
  
   
//hall walls
difference{ 
 union{
  box{<270,-155,-300>,<-270,455,-340>}
  box{<270,-155,300>,<-270,455,340>}
  box{<250,-155,340>,<270,455,-340>} 
  box{<-250,-155,340>,<-270,455,-340>}
  }                                       
 union{
  object{doory rotate 180*y translate -300*z} 
  object{venty rotate 90*y translate 180*y} 
  }
 texture{
  pigment{color White}
  normal{bumps .1}
  }
 }
object{doorx rotate 180*y translate -300*z}
object{venty rotate 90*y translate 180*y translate 124.5*z}
//rope corner
intersection{
 torus{1,.5}
 box{<0,-2,0>,<-2,2,2>}
 pigment{P_Chrome1}
 rotate -90*z
 translate <0,260,74>
 }
cylinder{<0,261,74>,<0,261,0>,.5} 

object{lightxx translate <150,400,0>} 
object{lightxx translate <-150,400,0>} 

object{cam scale <2,2,2> rotate 180*y translate <0,150,-300>} 

//desk
union{  
 union{
  box{<-150,-150,150>,<-140,-40,300>}
  box{<150,-150,150>,<140,-40,300>}  
  pigment{DMFWood4 rotate 90*y rotate 90*z scale <15,15,15>}
  } 
 box{<-75,-150,155>,<-85,-40,300>}
 box{<75,-150,155>,<85,-40,300>}  
 box{<-145,-145,155>,<-80,-40,300>}
 box{<145,-145,155>,<80,-40,300>} 
 superellipsoid{<.25,.25> scale <150,10,10> translate <0,-50,150>}
 box{<-150,-60,150>,<150,-40,300>}   
 //system shelf
 box{<-80,-100,155>,<80,-110,260>}
 box{<-80,-50,155>,<-60,-110,260>} 
 box{<80,-50,155>,<60,-110,260>}
 pigment{DMFWood4 rotate 90*y scale <17,17,17>}
 } 

//monitor
union{
 //stand
 cylinder{<0,0,0>,<0,2.5,0>,40}
 cone{<0,2.5,0>,40,<0,15,0>,(15.5*pow(2,.5)) open}
 sphere{<0,0,0>,30 scale <1,.5,1> translate <0,22.5,0>}  
 //body
 difference{
  union{   
   superellipsoid{<.25,.25> scale <45,30,50> translate <0,52.5,5>}
   superellipsoid{<.25,.25> translate <0,1,-1> scale <45,30,55> rotate 10*x translate <0,22.5,55>}  
   intersection{
    superellipsoid{<.25,1>}
    box{<-2,-2,0>,<2,2,2>}
    translate <0,1,-1> scale <48,36,100> rotate 10*x translate <0,12.5,45> 
    } 
   superellipsoid{<.25,.25> scale <48,36,10> rotate 10*x translate <0,48.5+100*sin(radians(10)),-50>}
   } 
    superellipsoid{<.25,.25> scale <40,30,15> rotate 10*x translate <0,48.5+100*sin(radians(10)),-50>}
  } 
 superellipsoid{<.25,1> scale <40,30,2> rotate 10*x translate <0,48.5+110*sin(radians(10)),-50-10*cos(radians(10))> texture{Glass}}
 superellipsoid{<.25,1> scale <40,30,1> rotate 10*x translate <0,48.5+105*sin(radians(10)),-50-5*cos(radians(10))> pigment{color Black}}
 //scrolling text
  union{
    #declare i2 = 1;           
    ///
    #while (i2 <= 80)//80
     #declare tranx = -39 + i2;
     #declare i = 1; 
     #declare rate = 17*i2;           
     ///
     #while (rate > 100)
      #declare rate = rate - 100;
     #end
     ///
     #declare rate = (rate / 100) * 50;
     ///
     #while (i <= 60) 
      #declare trany = 30-i-((clock+9)*rate);
      ///
      #while (trany < -30)
       #declare trany = trany + 60;
      #end 
      ///
      #declare letter = 3*(i+i2);
      ///
      #while (letter > 30)
       #declare letter = letter - 30;
      #end
      //////////////letter matching
      #if (letter = 0)
       text{ttf "timrom.ttf" "A" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end
      #if (letter = 1)
       text{ttf "timrom.ttf" "B" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end 
      #if (letter = 2)
       text{ttf "timrom.ttf" "C" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end  
      #if (letter = 3)
       text{ttf "timrom.ttf" "D" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end 
      #if (letter = 4)
       text{ttf "timrom.ttf" "E" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end 
      #if (letter = 5)
       text{ttf "timrom.ttf" "F" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end  
      #if (letter = 6)
       text{ttf "timrom.ttf" "G" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 7)
       text{ttf "timrom.ttf" "H" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end 
      #if (letter = 8)
       text{ttf "timrom.ttf" "I" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end 
      #if (letter = 9)
       text{ttf "timrom.ttf" "J" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end             
      #if (letter = 10)
       text{ttf "timrom.ttf" "K" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end            
      #if (letter = 11)
       text{ttf "timrom.ttf" "L" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 12)
       text{ttf "timrom.ttf" "M" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 13)
       text{ttf "timrom.ttf" "N" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 14)
       text{ttf "timrom.ttf" "O" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 15)
       text{ttf "timrom.ttf" "P" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 16)
       text{ttf "timrom.ttf" "Q" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 17)
       text{ttf "timrom.ttf" "R" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 18)
       text{ttf "timrom.ttf" "S" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 19)
       text{ttf "timrom.ttf" "T" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 20)
       text{ttf "timrom.ttf" "U" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 21)
       text{ttf "timrom.ttf" "V" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 22)
       text{ttf "timrom.ttf" "W" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 23)
       text{ttf "timrom.ttf" "X" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 24)
       text{ttf "timrom.ttf" "Y" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter = 25)
       text{ttf "timrom.ttf" "Z" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end                     
      #if (letter > 25)
       text{ttf "timrom.ttf" "_" .1,0 scale <5,5,5> translate <tranx,trany,0>}
      #end
      //////////////  
      #declare i = i + 5;
     #end
     ///
     #declare i2 = i2 + 6;    
    #end  
    texture{pigment{Green} finish{ambient 1}}
    rotate 10*x translate <0,48.5+108*sin(radians(10)),-50-8*cos(radians(10))>
   } 
 light_source{<0,0,0> color rgb <.2,.2,.2> translate <0,48.5+109*sin(radians(10)),-50-9*cos(radians(10))>}                                                                                       
 scale <.9,.9,.9>                
 rotate -45*y
 translate <-80,-40,225>
 pigment{color White}
 }
 
//keyboard
union{
   difference{   
  union{   
   superellipsoid{<.1,.1> translate <0,1,1> scale <60,3,25>} 
   superellipsoid{<1,.1> rotate 90*y scale <60,3,6> translate <0,3,3>}
   superellipsoid{<1,.1> rotate 90*y scale <60,3,6> translate <0,3,47>} 
   superellipsoid{<.25,.25> translate <0,0,1> scale <10,3,25*sin(radians(10))+1.5> rotate 110*x translate <-40,3,50>}  
   superellipsoid{<.25,.25> translate <0,0,1> scale <10,3,25*sin(radians(10))+1.5> rotate 110*x translate <40,3,50>}
   } 
  union{
    superellipsoid{<.01,.01> scale <45,3,15> translate <-10,6,20>}
    superellipsoid{<.01,.01> scale <3,3,3> translate <-52,6,41>}
    superellipsoid{<.01,.01> scale <12,3,3> translate <-31,6,41>} 
    superellipsoid{<.01,.01> scale <12,3,3> translate <-4,6,41>} 
    superellipsoid{<.01,.01> scale <12,3,3> translate <23,6,41>}
    superellipsoid{<.01,.01> scale <9,3,3> translate <47,6,41>}
    superellipsoid{<.01,.01> scale <9,3,6> translate <47,6,29>}
    superellipsoid{<.01,.01> scale <9,3,3> translate <47,6,8>}
    superellipsoid{<.01,.01> scale <3,3,6> translate <47,6,11>}
   }
  }
 //keys
 union{                                       
  //row 1
  object{key scale <7,1,1> translate <-10,3,8>} 
  //row 2
  object{key translate <-40,3,14>}
  object{key translate <-34,3,14>}
  object{key translate <-28,3,14>} 
  object{key translate <-22,3,14>} 
  object{key translate <-16,3,14>}
  object{key translate <-10,3,14>}
  object{key translate <-4,3,14>} 
  object{key translate <2,3,14>}
  object{key translate <8,3,14>}
  object{key translate <14,3,14>}
  //row 3                  
  object{key translate <-43,3,20>}
  object{key translate <-37,3,20>}
  object{key translate <-31,3,20>}
  object{key translate <-25,3,20>}
  object{key translate <-19,3,20>}
  object{key translate <-13,3,20>} 
  object{key translate <-7,3,20>} 
  object{key translate <-1,3,20>}
  object{key translate <5,3,20>}
  object{key translate <11,3,20>}
  object{key translate <17,3,20>} 
  //row 4                
  object{key translate <-44.5,3,26>}
  object{key translate <-38.5,3,26>}
  object{key translate <-32.5,3,26>}
  object{key translate <-26.5,3,26>}
  object{key translate <-20.5,3,26>}
  object{key translate <-14.5,3,26>} 
  object{key translate <-8.5,3,26>} 
  object{key translate <-2.5,3,26>}
  object{key translate <3.5,3,26>}
  object{key translate <9.5,3,26>}
  object{key translate <15.5,3,26>}
  object{key translate <21.5,3,26>} 
  object{key scale <1.75,1,1> translate <29.75,3,26>}  
  //row 5
  object{key translate <-52,3,32>} 
  object{key translate <-46,3,32>}
  object{key translate <-40,3,32>}
  object{key translate <-34,3,32>}
  object{key translate <-28,3,32>}
  object{key translate <-22,3,32>}
  object{key translate <-16,3,32>}
  object{key translate <-10,3,32>}
  object{key translate <-4,3,32>}
  object{key translate <2,3,32>} 
  object{key translate <8,3,32>} 
  object{key translate <14,3,32>} 
  object{key translate <20,3,32>} 
  //row 6
  object{key translate <-40,3,41>}
  object{key translate <-34,3,41>}
  object{key translate <-28,3,41>}
  object{key translate <-22,3,41>}
  object{key translate <-13,3,41>}
  object{key translate <-7,3,41>}
  object{key translate <-1,3,41>}
  object{key translate <5,3,41>}
  object{key translate <14,3,41>}
  object{key translate <20,3,41>}
  object{key translate <26,3,41>}
  object{key translate <32,3,41>}
  //keypad
  object{key translate <41,3,41>} 
  object{key translate <47,3,41>}
  object{key translate <53,3,41>}
  object{key translate <41,3,32>} 
  object{key translate <47,3,32>}
  object{key translate <53,3,32>}
  object{key translate <41,3,26>} 
  object{key translate <47,3,26>}
  object{key translate <53,3,26>}
  pigment{color rgb <1.25,1.25,1.25>}
  }
 //special keys
 union{                                 
  //row 1
  object{key scale <2,1,1> translate <-49,3,8>} 
  object{key scale <2,1,1> translate <-37,3,8>}                               
  object{key scale <2,1,1> translate <29,3,8>} 
  object{key scale <2,1,1> translate <17,3,8>}  
  //row 2
  object{key scale <2,1,1> translate <-49,3,14>} 
  object{key scale <3,1,1> translate <26,3,14>}                             
  //row 3
  object{key scale <1.5,1,1> translate <-50.5,3,20>}
  object{key scale <2.5,1,1> translate <27.5,3,20>}
  //row 4
  object{key scale <1.25,1,1> translate <-51.25,3,26>}
  //row 5
  object{key scale <2,1,1> translate <29,3,32>}
  //row 6
  object{key translate <-52,3,41>}
  //keypad
  object{key translate <47,3,14>}
  object{key translate <41,3,8>} 
  object{key translate <47,3,8>}
  object{key translate <53,3,8>}
  pigment{color Gray} 
  }                         
 rotate -10*x                                               
 translate <60,-40,150>
 pigment{color White}
}
  
//system unit 
union{  
 difference{ 
  union{          
   superellipsoid{<.1,.1> scale <55,15,40> translate <0,-85,215> pigment{color Grey}}
   superellipsoid{<.1,.1> scale <55,15,15> translate <0,-85,175>}
   superellipsoid{<.1,.1> scale <25,15,5> translate <30,-85,160>} 
   superellipsoid{<.1,.1> scale <20,5,5.1> translate <30,-80,160> pigment{rgb <1,1,1>}}
   superellipsoid{<.1,.1> scale <20,5,5.1> translate <30,-90,160> pigment{rgb <1,1,1>}}
   }
  union{ 
   //disk slot
   superellipsoid{<.1,.1> scale <12.5,1.25,21> translate <25,-80,155>} 
   //
   cylinder{<40,-80,150>,<40,-80,170>,2.5}
   superellipsoid{<.25,.25> scale <25,1,2> translate <-25,-77.5,160>}
   superellipsoid{<.25,.25> scale <25,1,2> translate <-25,-80,160>}
   superellipsoid{<.25,.25> scale <17.5,1,2> translate <-32.5,-82.5,160>}
   superellipsoid{<.25,.25> scale <17.5,1,2> translate <-32.5,-85,160>}
   superellipsoid{<.25,.25> scale <17.5,1,2> translate <-32.5,-87.5,160>} 
   superellipsoid{<.25,.25> scale <25,1,2> translate <-25,-90,160>} 
   superellipsoid{<.25,.25> scale <25,1,2> translate <-25,-92.5,160>}
   }
  } 
 superellipsoid{<1,.25> scale <2,2,2> translate <40,-80,155> pigment{color rgb <0,.5,1>} finish{phong .5 phong_size 110}}
 box{<-2,-1,-1>,<2,1,1> translate <45,-77.5,155> pigment{color Green} finish{ambient d_light}} 
 superellipsoid{<1,.1> rotate 90*y scale <17.5,2.25,.5> translate <30,-88,155>}
 superellipsoid{<.25,.25> scale <2,1,.5> translate <42.5,-92.5,155>}
 superellipsoid{<.25,.25> scale <2,1,.5> translate <37,-92.5,155>}
 superellipsoid{<.5,.5> scale <7.5,1,.5> translate <22.5,-92.5,155>} 
 superellipsoid{<.1,.1> scale <3,3,3> translate <0,-85,160> pigment{color rgb <2,2,2>}}
 box{<-3,-1,-1>,<2,1,1> translate <-7.5,-83,160> pigment{color Green} finish{ambient 1}} 
 box{<-3,-1,-1>,<2,1,1> translate <-7.5,-87,160> pigment{color Yellow} finish{ambient 0}} 
 pigment{color rgb <1.5,1.5,1.5>} 
 translate 5*z
 }
 
//alarm light
union{
 torus{10,2.5 rotate 90*x translate <0,100,300> pigment{color Black}}
 sphere{<0,0,0>,8 scale <1,1,0.5> translate <0,100,300> pigment{color Black}}
 cone{<0,0,0>,10,<0,0,-20>,7.5 translate <0,100,300> pigment{color rgbf <1,0,0,.5>} finish{ambient alarm}}
 sphere{<0,0,0>,7.5 scale <1,1,.5> translate <0,100,280> pigment{color rgbf <1,0,0,.5>} finish{ambient alarm}}
 #if (alarm = 1)
  light_source{<0,100,275> color rgb <2+2*sin(2*pi*clock),0,0>} 
 #end
 } 
 
object{robot translate <0,-50,75>}

#if (clock >=1)
 #if (clock < 1.5)
  object{disk translate 12*z rotate 180*y translate 12*z translate <25,-80,148>}
 #else
  #if (clock < 2) 
   object{disk translate 12*z rotate 180*y translate 12*z translate <25,-80,148> translate ((11*(clock-1.5))/0.5)*z}
  #else
   object{disk translate 12*z rotate 180*y translate 12*z translate <25,-80,148> translate 11*z}
  #end
 #end
#end 