// Persistence of Vision Ray Tracer Scene Description File
// File: g.pov
// Vers: 3.1
// Desc: Alien Invasion - IRTC Anim 10/00 (Aliens)
// Date: 10.10.00
// Auth: Uwe Post, up@upcenter.de
// Take: G. Thankyou-Schild wird runtergelassen, dreht sich, Email-Adr. auf Rckseite
//

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

#declare clock1=clock;
//#declare clock1=1.4;

// ----------------------------------------
camera
{
  location  <0.0, 1, -4.0>   //0,1,-4
  direction 1.5*z
  right     4/3*x
  angle 35          // 35
  look_at   <0.0, 1,  0.0>  // 0,1,0
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 2, -4> // <x y z> position of light
  point_at <0, 1, 0>      // direction of spotlight
  radius 9                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 11               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-1, 2, -4> // <x y z> position of light
  point_at <1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <1, 2, -4> // <x y z> position of light
  point_at <-1, 0.5, 0>      // direction of spotlight
  radius 6                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}


// Bhne ----------------------------------------
plane { -y, 0 
 clipped_by { plane { -z,0 } }
 pigment {color rgb <0.7,0.5,0.3>}
}

plane { z, 0 
 clipped_by { plane { y,0 } }
 pigment {color rgb <0.7,0.4,0.3>}
}

// Vorhangumrandung
polygon {
    9,
    <-1.2, 0.0>, <-1.15, 1.85>,
    <0,1.9>,<1.15,1.85>,
    <1.2,0>,
    <3,0>,<3,3333>,
    <-3,3333>,<-3,0>
    pigment { color rgb <1, 0, 0> }
 }

#if (clock1>=2)
 #declare vfreq=(clock1-2)*5 +5;
#else
 #declare vfreq=5;
#end

// Vorhang
#declare Vorhang1 = texture
{
  pigment
  {
    gradient x
    turbulence 0.1  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency vfreq
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1
    turbulence 0.1
    frequency vfreq*2
    scale <0.1, 0.4, 0.1>
  }
}
#declare Vorhang2 = texture
{
  pigment
  {
    gradient x
    turbulence 0.11  octaves 5
    color_map
    {
      [0.00 color rgb<0.133, 0.0, 0.0>]
      [0.22 color rgb<0.004, 0.000, 0.000>]
      [0.32 color rgb<1.000, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.000, 0.000>]
    }
    frequency vfreq
    translate <0.0, 0.0, -2.0>
  }
  normal
  {
    wrinkles 1.01
    turbulence 0.11
    frequency vfreq*2
    phase 10
    scale <0.1, 0.41, 0.1>
  }
}

// Der eigentliche Vorhang
#declare vorh_auf=0; // ganz auf: 1.1
#if (clock1>=2)
 #declare vorh_auf=(clock1-2)*1.1;
#end 

plane {
 z,0.05
 clipped_by { plane {x,0} }
 texture { Vorhang1 }
 translate -vorh_auf*x
}

plane {
 z,0.051
 clipped_by { plane {-x,0} }
 texture { Vorhang2 }
 translate vorh_auf*x
}
 
// Das Titelschild
#if(clock1<0.5)
 #declare s1=1-2*clock1;
#else
 #declare s1=1-2*0.5;
#end

union
{
polygon {
4,
<0,0>,<1,0>,
<1,0.5>,<0,0.5>
pigment{
image_map
{
#if (clock1<1.5)
  sys "thankyou.bmp" // the file to read (iff/gif/tga/png/sys)
#else
  sys "uwepost.bmp" // the file to read (iff/gif/tga/png/sys)
#end
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index]
  once
} // image_map
  scale y*0.5
  #if (clock1>=1.5)
//  scale -x
  #end
}
finish
{ specular 0.1
  
}
translate -0.5*x
scale 1.0*<1,0.5,1>
#if (clock1<=1)
 rotate -z*5*sin(clock1*40*pi)
#else
 #if (clock1<=2)
  rotate y*(clock1-1)*180
 #else
  rotate y*180
 #end
#end
translate<0,1,0.03>
}
// Das Seil
polygon
{
4,
<-0.004,1.23>,<0.004,1.23>,
<0.004,5>,<-0.004,5>
//rotate -z*1*sin(clock1*20*pi)
pigment { color rgb 0 }
translate  0.031*z
}
translate <-0.35+0.25+0.002*sin(clock1*20*pi),s1,-1.2>
}
