
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.0

#declare Nebel_An = 0;
#declare Aufblenden = 0;

#include "colors.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 1.0
}

#render concat("clock=",str(clock,5,2),"\n")
// aufblenden, d.h. l von 0 bis 1 laufen lassen fr clock=0 bis 3 oder so
#declare l=1;
#if ((Aufblenden=1)&(clock<=4))
 #declare l=clock/4;
#end
#render concat("Helligkeit=",str(l,5,2),"\n")


//  Texturen
// Weie Flche mit Roststellen
#declare WeissMitRost = texture
{
  pigment
  {
    bozo
    turbulence 0.8  omega 0.69
    color_map
    {
      [0.00 color rgb<0.545, 0.337, 0.008>]
      [0.03 color rgb<0.949, 0.667, 0.506>]
      [0.12 color rgb<0.965, 0.976, 0.984>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
  }
  finish {
    ambient 0.5*l
    diffuse 0.4*l
    specular 0.09
  }
  //scale 0.1
}
#declare Chrome_Metal = texture
{
  pigment
  {
    colour rgb<0.659,0.659,0.659>
  }
  finish {
    ambient 0.3*l
    diffuse 0.7*l
    brilliance 8.0
    specular 0.8    roughness 0.1
    reflection 0.15
  }
}

#declare Gelbes_Metall = texture
{
  pigment
  {
    colour rgb<0.937,0.737,0.200>
  }
  finish {
    ambient 0.45*l
    diffuse 0.65*l
    brilliance 2.8
    specular 0.4    metallic
    reflection 0.1
  }
}
// White and light blue cement by David Anjo.
#declare Proto_Cement = texture
{
  pigment
  {
    agate
    color_map
    {
      [0.00 color rgb 0.8*<0.898, 0.949, 0.949>]
      [0.70 color rgb 0.8*<0.988, 0.988, 0.988>]
      [0.70 color rgb 0.8*<0.918, 0.937, 0.949>]
      [0.90 color rgb 0.8*<0.988, 0.988, 0.988>]
      [0.90 color rgb 0.8*<0.847, 0.898, 0.898>]
      [1.00 color rgb 0.8*<0.988, 0.988, 0.988>]
    }
  }
  finish {
    diffuse 0.3*l
  }
  normal {bumps scale 0.01}
}

#declare Blue_Sky4 = texture
{
  pigment
  {
    bozo
    turbulence 0.5  octaves 3  lambda 6.0
    color_map
    {
      [0.00 color rgb<0.192, 0.600, 0.800>]
      [0.10 color rgb<0.192, 0.600, 0.800>]
      [0.70 color rgb<0.800, 0.800, 0.831>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
  }
  finish {
    ambient l
    diffuse 0.0
  }
  scale <3000.0, 850.0, 2000.0>
}

#declare Brushed = texture
{
  pigment
  {
    bozo
    turbulence 1.0  omega 1.0
    color_map
    {
      [0.00 color rgb<0.698, 0.698, 0.698>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    scale <30.0, 1.0, 50.0>
  }
  finish {
    ambient 0.15*l
    diffuse 0.65*l
    brilliance 1.5*l
    specular 0.5    roughness 0.03
    reflection 0.05
  }
}

// Wood by Eric Barish
#declare EMBWood1 =
texture {
  pigment
  {
    wood
    turbulence 0.05
    color_map
    {
      [0.00 color rgb<0.576, 0.447, 0.227>]
      [0.34 color rgb<0.647, 0.447, 0.247>]
      [0.40 color rgb<0.329, 0.227, 0.129>]
      [0.47 color rgb<0.600, 0.400, 0.200>]
      [1.00 color rgb<0.247, 0.149, 0.047>]
    }
  }
  normal
  {
    bumps 0.05
  }
  finish {
    ambient 0.32*l
    diffuse 0.63*l
    phong 0.2    phong_size 10
    crand 0.02
  } 
  //scale 0.1 // wieder anschalten!!!!!
  rotate <70.0, 0.0, 0.0>
}
texture {
  pigment
  {
    bozo
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.80 color rgbf<1.000, 0.898, 0.800, 0.800>]
      [1.00 color rgbf<0.298, 0.200, 0.098, 0.400>]
    }
    scale <0.25, 0.25, 0.25>
  }
}




// Fenster-Ausschnitt
#declare fenster_ausschnitt= 
 box { -<0.75,0.75,0.75>, <0.75,0.75,0.75> }


//Fenster x-Richtung
#declare fenster = 
 union {
  // Scheibe
  box { -<0.75,0.75,0.01>, <0.75,0.75,0.01> 
   pigment {color rgbt<1,1,1,1>} finish {reflection 0.9 specular 1}
  }
  // Fensterbrett
  box { -<0.75,0.74,0.11>,<0.75,-0.751,0.01> texture {Chrome_Metal}}
  // mittlerer horizontaler Balken
  box { <-0.76,0.249,-0.11>,<0.76,0.25,0.11> texture {EMBWood1} }
  // oberer horizontaler Balken
  box { <-0.76,0.74,-0.11>,<0.76,0.76,0.11> texture {EMBWood1} }
  // senkrechte Balken
  // linker Balken
  box { <-0.76,-0.75,-0.11>,<-0.74,0.75,0.11> texture {EMBWood1} }
  // mittlerer Balken
  box { <-0.05,-0.75,-0.11>,<0.05,0.75,0.11> texture {EMBWood1} }
  // rechter Balken
  box { <0.74,-0.75,-0.11>,<0.76,0.75,0.11> texture {EMBWood1} }
 }


//Fenster x-Richtung

//Fenster z-Richtung
#declare fenster_z =  object { fenster  rotate 90*y   }

#declare ang0=70 //40;
#declare ang1=15;
#declare ang=ang0;
#declare kam_y=0.5;  // bersicht: 5;
//---Kamera----------------------------------------
#if (clock<=8)
 #declare lo=<-4,kam_y,5>;
#end
#if ((clock>8)&(clock<=15))
 //#declare lo=<-2+8*((clock-11)/18),1.8-0.7*(clock-11)/18,-3.5*((clock-11)/18)>;
 #declare lo=<-4+9*(clock-8)/7,kam_y,5-9*(clock-8)/7>;
// #declare ang=ang1;
#end
#if ((clock>15)&(clock<=29))
 #declare lo=<5,kam_y,-4>;
 #declare ang=ang0-(ang0-ang1)*(clock-15)/14;
#end
#render concat("Kamera-Oeffnungswinkel:",str(ang,5,0),"\n")

camera
{
  location  <-5, 1, -4.0>   //<-3,1.5,-6>
  look_at    <-1.5,2.5,5>
  angle ang  // bersicht: 75
}

//------Nebel-------
#if (Nebel_An=1)
fog {
    fog_type 1 // 1=constant, 2=ground_fog
    distance 150
    color White
}
#end

//-------- Himmel ---------------
plane{ y,100 hollow no_shadow
 texture {Blue_Sky4 scale 0.1}
}

//------Atmosphre



// Lichtquelle --------------------
light_source
{
  0*x // light's position (translated below)
  color rgb l*<1,1,1>
  translate <-15, 30, -15>
}

// -Der Boden ---------------------------------------
plane { y, -0.0001 pigment {color rgb <0.5,0.5,0.5>} normal {bumps scale 0.01} }

#declare R1 = seed(333);

//--------Das Haus 
#declare haus=
union{
// Das Mauerwerk
difference {
 box { <-0.1,0,-0.1> <8.1,14,6.1>}
 // Innenraum
 box { <0.1,0,0.1>,<7.9,13.9,5.9>}
 // Fenster-Ausschnitte

 // Reihe unten rechts
 object{ fenster_ausschnitt translate <1.5,2.25,0>}
 object{ fenster_ausschnitt translate <4  ,2.25,0>}
 object{ fenster_ausschnitt translate <6.5,2.25,0>}
 // Reihe 1. Stock rechts
 object{ fenster_ausschnitt translate <1.5,5.25,0>}
 object{ fenster_ausschnitt translate <4  ,5.25,0>}
 object{ fenster_ausschnitt translate <6.5,5.25,0>}
 // Reihe 2. Stock rechts
 object{ fenster_ausschnitt translate <1.5,8.25,0>}
 object{ fenster_ausschnitt translate <4  ,8.25,0>}
 object{ fenster_ausschnitt translate <6.5,8.25,0>}
 // Reihe 3. Stock rechts
 object{ fenster_ausschnitt translate <1.5,11.25,0>}
 object{ fenster_ausschnitt translate <4  ,11.25,0>}
 object{ fenster_ausschnitt translate <6.5,11.25,0>}

 // Reihe unten links
 object{ fenster_ausschnitt translate <0,2.25,1.5>}
 object{ fenster_ausschnitt translate <0,2.25,4>}
 // Reihe 1. Stock links
 object{ fenster_ausschnitt translate <0,5.25,1.5>}
 object{ fenster_ausschnitt translate <0,5.25,4>}
 // Reihe 2. Stock links
 object{ fenster_ausschnitt translate <0,8.25,1.5>}
 object{ fenster_ausschnitt translate <0,8.25,4>}
 // Reihe 3. Stock links
 object{ fenster_ausschnitt translate <0,11.25,1.5>}
 object{ fenster_ausschnitt translate <0,11.25,4>}

 #declare haus_farbe = rgb <0.6-0.5*rand(R1),0.1,0.1>;
 #declare moertel_farbe = rgb <0.8,0.8,0.8>*rand(R1);
 pigment { brick  color moertel_farbe color haus_farbe mortar 0.3 scale 0.05 }
}// Ende Mauerwerk
 // Die Fenster mit Scheiben und Rahmen
 object{ fenster translate <1.5,2.25,0>}
 object{ fenster translate <4  ,2.25,0>}
 object{ fenster translate <6.5,2.25,0>}
 // Reihe 1. Stock rechts
 object{ fenster translate <1.5,5.25,0>}
 object{ fenster translate <4  ,5.25,0>}
 object{ fenster translate <6.5,5.25,0>}
 // Reihe 2. Stock rechts
 object{ fenster translate <1.5,8.25,0>}
 object{ fenster translate <4  ,8.25,0>}
 object{ fenster translate <6.5,8.25,0>}
 // Reihe 3. Stock rechts
 object{ fenster translate <1.5,11.25,0>}
 object{ fenster translate <4  ,11.25,0>}
 object{ fenster translate <6.5,11.25,0>}

 // Reihe unten links
 object{ fenster_z translate <0,2.25,1.5>}
 object{ fenster_z translate <0,2.25,4>}
 // Reihe 1. Stock links
 object{ fenster_z translate <0,5.25,1.5>}
 object{ fenster_z translate <0,5.25,4>}
 // Reihe 2. Stock links
 object{ fenster_z translate <0,8.25,1.5>}
 object{ fenster_z translate <0,8.25,4>}
 // Reihe 3. Stock links
 object{ fenster_z translate <0,11.25,1.5>}
 object{ fenster_z translate <0,11.25,4>}
 
} // Ende Haus

// Die Huser in z-Richtung, rechte Straenseite
object { haus }
object { haus scale <1,0.8,1> translate <0,0,6.1> }
object { haus scale <1,1,1.2> translate <0,0,13.3> }
object { haus scale <1,1.1,1> translate <0,0,19.4> }
object { haus scale <1,1.2,1> translate <0,0,25.4> }
object { haus scale <1,0.9,1> translate <0,0,31.4> }
object { haus scale <1,1.1,1> translate <0,0,37.4> }
object { haus scale <1,1.2,1> translate <0,0,43.4> }
// Die Huser in z-Richtung, linke Straenseite
object { haus rotate y*180 translate <-10,0,6>}
object { haus rotate y*180 translate <-10,0,12>}
object { haus rotate y*180 translate <-10,0,18>}
object { haus rotate y*180 translate <-10,0,24>}
// Die Huser in z-Richtung, hinterer Abschlu der Szene
object { haus translate <-10,0,50> }
object { haus scale <1,1.2,1> translate <-18,0,50> }
object { haus translate <-4,0,50> }
// Die Huser in x-Richtung, linke Seite
object { haus scale <1,1.3,1> translate <8,0,0> }
object { haus scale <1,0.9,1> translate <16,0,0> }
object { haus scale <1,1.1,1> translate <24,0,0> }
object { haus scale <1,1.1,1> translate <32,0,0> }
// Die Huser in x-Richtung, rechte Seite
object { haus rotate y*180 scale <1,1.3,1> translate <8,0,-10> }
object { haus rotate y*180 scale <1,0.9,1> translate <16,0,-10> }
object { haus rotate y*180 scale <1,1.1,1> translate <24,0,-10> }
object { haus rotate y*180 scale <1,1.1,1> translate <32,0,-10> }
// Die Huser in x-Richtung, hinterer Abschlu der Szene
object { haus scale <1,0.8,1> translate <44,0,-15> }
object { haus scale <1,0.7,1> translate <42,0,-9> }
object { haus scale <1,0.9,1> translate <44,0,-3> }


// Die Laterne
#declare laterne=union{
cylinder {0,<0,3.5,0>,0.03 texture {Chrome_Metal}}
cylinder {<0,3.5,0>,<0,3.51,0>,0.25 texture {Chrome_Metal}}
cone { <0,3.51,0>,0.25,<0,4,0>,0.3 pigment {color rgb <0.8,0.8,0.8>} finish {specular 1} }
cylinder {<0,4,0>,<0,4.01,0>,0.32 texture {Chrome_Metal}}
}

// Die Strae -------------------------------------------------

// Der Gehweg, rechts ----------------------
// Kante
union{
 box {<0,0,-1.6>,<20,0.09999,0> }
 box {<-1.6,0,0>,<-1.5,0.09999,20> }
 cylinder{  0,  <0,0.09999,0>,  1.6 }
 texture { Proto_Cement} 
 }
 // Gehsteig
union{
 box {<0,0,-1.5>,<100,0.1,0> }
 box {<-1.5,0,0>,<0,0.1,100> }
 cylinder{  0,  <0,0.1,0>,  1.5 }
 pigment { brick color rgb <0,0,0> color rgb <0.8,0.8,0.8> brick_size <10,10,10> scale 0.05}
}
// Der Gehweg, links ----------------------
// Kante
union{
 box {<0,0,-1.6>,<20,0.09999,0> }
 box {<-1.6,0,0>,<-1.5,0.09999,20> }
 texture { Proto_Cement} 
 rotate 180*y
 translate <-10,0,0>
}
 // Gehsteig
union{
 box {<0,0,-1.5>,<100,0.1,0> }
 box {<-1.5,0,0>,<0,0.1,100> }
 pigment { brick color rgb <0,0,0> color rgb <0.8,0.8,0.8> brick_size <10,10,10> scale 0.05}
 rotate 180*y
 translate <-10,0,0>
}

// Die Laternen pflanzen

object { laterne translate <-1,0,-1> }
object { laterne translate <-1,0,10> }
object { laterne translate <-1,0,21> }
object { laterne translate <-1,0,32> }
object { laterne translate <10,0,-1> }
object { laterne translate <21,0,-1> }
object { laterne translate <32,0,-1> }




