/* alien1.pov - aliens' ship enters Earth's atmosphere above the pacific
Created:     2000.10.09.19.05
Last edited: 2000.10.10.17.05
By:          William de Beaumont
*/
#include "colors.inc"

global_settings {max_trace_level 20}

camera
{
 scale <1,2/3,1>
 location <0,0,0>
 look_at <0,-4,10>
}
light_source {<-100,200,500> color White}

#declare dees=seed(5424527482);
#declare stars=0;
#while (stars<5000)
 sphere 
 { <0,0,5000>,8+rand(dees)*2
   rotate <rand(dees)*360,rand(dees)*360,rand(dees)*360>
   texture
   {
    finish {ambient 1}
    #declare offs=rand(dees)*.8;
    pigment {color rgb <offs+rand(dees)/5,offs+rand(dees)/5,offs+rand(dees)/5>}
   }
 }
 #declare stars=stars+1;
#end

//earth
sphere 
{ <0,-510,0>,500 
  texture
  {
   finish {phong 5 phong_size 100 ambient .2 reflection .1}
   normal {bozo .2 scale .1 translate <clock,clock/4,0>}
   pigment{color rgb <0,.1,.2>}
  }
}
//clouds
union
{
 sphere {<0,-510,0>,501}
 sphere {<0,-510,0>,501.2}
 sphere {<0,-510,0>,501.4}
 texture
 {
  finish {ambient .8}
  pigment
  {
   bozo
   color_map
   {
    [0.0 rgbt <.8,.8,1,1>]
    [0.5 rgbt <.8,.8,1,1>]
    [1.0 rgbt <.8,.8,1,.8>]
   }
   scale 10
   translate <clock*5,0,clock*-2>
  }
 }
}
sphere 
{ <0,-510,0>,501.9
 texture
 {
  finish {ambient 1}
  pigment {color rgbt <.8,.8,1, .9>}
 }
}
sphere 
{ <0,-510,0>,502.4
 texture
 {
  finish {ambient 1}
  pigment {color rgbt <.7,.7,1, .9>}
 }
}
sphere 
{ <0,-510,0>,502.9
 texture
 {
  finish {ambient 1}
  pigment {color rgbt <.6,.6,1, .9>}
 }
}
sphere 
{ <0,-510,0>,503.4
 texture
 {
  finish {ambient 1}
  pigment {color rgbt <.4,.4,1, .9>}
 }
}
//ship
blob
{
 threshold .5
 #declare ship=-10;
 #while (ship<10)
  sphere {<0,0,ship>,sin((ship+10)/20*3.1415)*5, 2.66}
  #declare ship=ship+1;
 #end   
 texture
 {
  finish {reflection .3 phong 1}
  pigment {color rgb<.5,.5,.5>}
 }
 translate z*3
 rotate x*15
 scale .05
// translate <.3,-5*clock,clock*20>
 translate <.3,-3*clock*(clock+1),clock*(clock+3)*8>
}
union
{
 intersection
 {
  difference
  {
   torus
   { 5,6.01
    rotate x*90
    scale <1,1,2>
   }
   torus
   { 5,6
    rotate x*90
    scale <1,1,2>
   }
  }
  plane {z,0}
 }
 intersection
 {
  difference
  {
   torus
   { 5,6.01
    rotate x*90
    scale <1,1,4>
   }
   torus
   { 5,6
    rotate x*90
    scale <1,1,4>
   }
  }
  plane {-z,0}
 }
 texture
 {
  finish {ambient 1}
  pigment
  { cylindrical
    color_map
    {
     [0.0 rgbt<.3,0,.5,1>]
     [0.5 rgbt<.3,0,.5,.92-clock*.3>]
     [1.0 rgbt<.6,clock*.3,1,.88-clock*.6>]
    }
    rotate x*90
    scale 8+clock*10
  }
 }
 texture
 {
  finish {ambient .8+clock*.2}
  pigment
  { bozo
    color_map
    {
     [0.0 rgbt<.4,0,.5,1>]
     [0.5 rgbt<.4,0,.5,.92>]
     [1.0 rgbt<.8-clock*.4,clock*.3,1,.88>]
    }
    scale 2
    translate z*clock*200
  }
 }
 rotate x*15
 scale .05
 translate <.3,-3*clock*(clock+1),clock*(clock+3)*8>
}
