/* alien3.pov - ants come out and are squished
Created:     2000.10.15.08.45
Last edited: 2000.10.15.21.20
By:          William de Beaumont
*/
#include "colors.inc"

global_settings {max_trace_level 10}

camera
{
 scale <1,2/3,1>
 location <-16,-2,4>
 #if (clock<.5)
  #declare mul=(clock*clock*2);
 #else
  #declare mul=1-(1-clock)*(1-clock)*2;
 #end
 rotate y*mul*160
 translate <0,mul*3,4>
 look_at <0,0,4>
}
light_source {<-100,1000,100> color White}

plane
{
 y,2000
 texture
 {
  finish {ambient 1}
  pigment {color Blue}
 }
}
plane
{
 y,-10
 texture
 {
  finish {reflection .2 phong 1 ambient .4}
  normal {bozo}
  pigment {color rgb <.2,.2,.5>}
 }
}
#declare clouds=0;
#while (clouds<5)
 plane
 {
  y,25+clouds
  texture
  {
   finish {ambient 1}
   pigment 
   { bozo
     color_map
     {
      [0.0 rgbt <1,1,1,1>]
      [0.5 rgbt <1,1,1,1>]
      [0.8 rgbt <.9,.9,.9,.7>]
      [1.0 rgbt <.7,.7,.7,.5>]
     }
     translate <(clock+1)*2,(clock+1)/4,0>
     scale 25
   }
  }
 }
 #declare clouds=clouds+1;
#end

blob
{
 threshold .5
 #declare ship=-10;
 #while (ship<10)
  sphere {<0,0,ship>,sin((ship+10)/20*3.1415)*5, 2.66}
  #declare ship=ship+1;
 #end   
 texture
 {
  finish {reflection .3 phong 1}
  pigment {color rgb<.5,.5,.5>}
 }
 rotate x*sin((clock+1)*5.5+1)/((clock+1)*3/4+.25)*10
 translate z*4
}
 
height_field
{ tga "height.tga"
  smooth
  translate -.5
  scale <100,50,100>
  rotate y*180
  translate y*-3
  texture
  {
   finish {ambient .5}
   pigment {color rgb <.5,.5,.3>}
  }
  translate <-9,0,4>
}
height_field
{ tga "height.tga"
  smooth
  translate -.5
  scale <100,10,100>
  translate y*-2
  interior {ior 1.5}
  texture
  {
   finish {reflection .2 phong 1}
   pigment {color rgbt <0,0,.5,.8>}
  }
  translate x*clock+1
}
