/* alien4.pov - ants come out and are squished
Created:     2000.10.15.19.25
Last edited: 2000.10.15.23.35
By:          William de Beaumont
*/
#include "colors.inc"

global_settings {max_trace_level 10}
 #if (clock<.5)
  #declare mul=(clock*clock*2);
 #else
  #declare mul=1-(1-clock)*(1-clock)*2;
 #end
camera
{
 scale <1,2/3,1>
 /*location <-16,-2,4>
 rotate y*160*/
 location <16.40316251,-2-mul,1.71355181-mul*1.71355181>
 translate <0,3,4>
 //location <0,24,0>
 look_at <0,0,4>
}
light_source {<-100,1000,100> color White}

plane
{
 y,2000
 texture
 {
  finish {ambient 1}
  pigment {color Blue}
 }
}
plane
{
 y,-10
 texture
 {
  finish {reflection .2 phong 1 ambient .4}
  normal {bozo}
  pigment {color rgb <.2,.2,.5>}
 }
}
#declare clouds=0;
#while (clouds<5)
 plane
 {
  y,25+clouds
  texture
  {
   finish {ambient 1}
   pigment 
   { bozo
     color_map
     {
      [0.0 rgbt <1,1,1,1>]
      [0.5 rgbt <1,1,1,1>]
      [0.8 rgbt <.9,.9,.9,.7>]
      [1.0 rgbt <.7,.7,.7,.5>]
     }
     translate <(clock+2)*2,(clock+2)/4,0>
     scale 25
   }
  }
 }
 #declare clouds=clouds+1;
#end

blob
{
 threshold .5
 #declare ship=-10;
 #while (ship<10)
  sphere {<0,0,ship>,sin((ship+10)/20*3.1415)*5, 2.66}
  #declare ship=ship+1;
 #end   
 texture
 {
  finish {reflection .3 phong 1}
  pigment {color rgb<.5,.5,.5>}
 }
 rotate x*sin((clock+2)*5.5+1)/((clock+2)*3/4+.25)*10
 translate z*4
}
 
height_field
{ tga "height.tga"
  smooth
  translate -.5
  scale <100,50,100>
  rotate y*180
  translate y*-3
  texture
  {
   finish {ambient .5}
   pigment {color rgb <.5,.5,.3>}
  }
  translate <-9,0,4>
}
height_field
{ tga "height.tga"
  smooth
  translate -.5
  scale <100,10,100>
  translate y*-2
  interior {ior 1.5}
  texture
  {
   finish {reflection .2 phong 1}
   pigment {color rgbt <0,0,.5,.8>}
  }
  translate x*clock+1
}

//GIANT (not really) ANT
#if (clock>.25)
 #declare antclock=(clock-.25)*13;
#else
 #declare antclock=-1;
#end
union
{
 union //head
 {
  union
  {
   intersection
   {
    sphere {<0,0,0>,.7 scale <1,1.43,.4> translate y*.5}
    box {<-1,.5,-1>,<1,-2,1>}
   }
   intersection
   {
    sphere {<0,.5,0>,.7 scale <1,1,.4>}
    box {<-1,.5,-1>,<1,2,1>}
   }
   //antennae
   #declare cnt=0;
   #while (cnt<120)
    cone {<1,0,0>,.02,<1,.1,0>.03 rotate z*cnt translate <-1.1,.7,.3> rotate <-30,-20,0>}
    cone {<-1,0,0>,.02,<-1,.1,0>.03 rotate -z*cnt translate <1.1,.7,.3> rotate <-30,20,0>}
    #declare cnt=cnt+5;
   #end
   //mandibles
   difference
   {
    sphere {<0,0,0>,.2 scale <1,1,.3>}
    sphere {<0,0,0>,.2 translate x*.1}
    translate <-.1,-.6,0>
   }
   difference
   {
    sphere {<0,0,0>,.2 scale <1,1,.3>}
    sphere {<0,0,0>,.2 translate x*-.1}
    translate <.1,-.6,0>
   }
   texture
   {
    finish {phong 1 reflection .1}
    pigment {color Gray40}
   }
  }
  union //eyes
  {
   sphere {<-.3,0,0>,.4 scale <1,1.3,.5> translate <0,.6,-.1>}
   sphere {<.3,0,0>,.4 scale <1,1.3,.5> translate <0,.6,-.1>}
   texture
   {
    finish {phong 1 reflection .1}
    normal{hexagon rotate x*90 scale .01}  
    pigment {color rgb <.5,0,0>}
   }
  }
  rotate x*30
  translate z*-1.5
 }
 union //thorax and abdomen
 {
  sphere  
  { <0,0,0>,.5
    scale <1,1,2>
    translate y*.5
  }
  sphere  
  { <0,0,0>,.7
    scale <1,1,2>
    translate <0,.5,2.2>
  }
 /* d=distance between joints                
    (x1,y1) given foot point (hip assumed (0,0))
    (x2,y2) calculated middle joint point
                       /        ____________    \
                      / 2   / -/x1^2 + y1^2  \ 2 \
                      |d  - |----------------|   |{yx}1
          {xy}1       \     \        2       /  /
 {xy}2 = ------- {-+} --------------------------------
            2                  __________
                             -/x1^2 + y1^2
 */
  #declare x1=1.75-sin(antclock*6.28)/4;
  #declare y1=-.8-sin(antclock*6.28)*.2;
  #declare z1=-cos(antclock*6.28)*.45;
  #declare x2=(x1/2) - ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*y1)/sqrt(x1*x1+y1*y1+z1*z1);
  #declare y2=(y1/2) + ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*x1)/sqrt(x1*x1+y1*y1+z1*z1);
  #declare z2=z1/2;
  union
  {
   cylinder {<x2,y2,z2>,<0,0,0>,.1} 
   cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
   sphere {<x2,y2,z2>,.1} 
   translate z*.5
  } 
  union
  {
   cylinder {<x2,y2,z2>,<0,0,0>,.1} 
   cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
   sphere {<x2,y2,z2>,.1} 
   scale <-1,1,1>
   translate z*-.5
  }
  union
  {
   cylinder {<x2,y2,z2>,<0,0,0>,.1} 
   cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
   sphere {<x2,y2,z2>,.1} 
   scale <-1,1,1>
   translate z*1.5
  }
  #declare x1=1.75+sin(antclock*6.28)/4;
  #declare y1=-.8+sin(antclock*6.28)*.2;
  #declare z1=cos(antclock*6.28)*.45;
  #declare x2=(x1/2) - ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*y1)/sqrt(x1*x1+y1*y1+z1*z1);
  #declare y2=(y1/2) + ((2-(sqrt(x1*x1+y1*y1+z1*z1)/2)*(sqrt(x1*x1+y1*y1+z1*z1)/2))*x1)/sqrt(x1*x1+y1*y1+z1*z1);
  #declare z2=z1/2;
  union
  {
   cylinder {<x2,y2,z2>,<0,0,0>,.1} 
   cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
   sphere {<x2,y2,z2>,.1} 
   translate z*-.5
  } 
  union
  {
   cylinder {<x2,y2,z2>,<0,0,0>,.1} 
   cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
   sphere {<x2,y2,z2>,.1} 
   translate z*1.5
  } 
  union
  {
   cylinder {<x2,y2,z2>,<0,0,0>,.1} 
   cylinder {<x1,y1,z1>,<x2,y2,z2>,.1} 
   sphere {<x2,y2,z2>,.1} 
   scale <-1,1,1>
   translate z*.5
  } 
  texture
  {
   finish {phong 1 reflection .1}
   pigment {color Gray40}
  }
 }
 #if (clock>.95)
   scale <1,.2,1>
 #end
 translate z*-2*antclock
 scale .4
 rotate y*-90
 rotate z*-8
 translate <4,0,4>
}
box 
{ <0,-.35,-1>,<16,-1,1>
  rotate z*-8
  translate <4,0,4>
  texture
  {
   finish {reflection .1 phong 1}
   pigment 
   { 
    #if (clock<.3)
     bozo
     color_map
     {
      [0 rgbt<.5,.5,.5,1>]
      [1-clock*3 rgbt<.5,.5,.5,1>]
      [1 rgbt<.5,.5,.5,0>]
     }
    #else
     color rgb<.5,.5,.5>
    #end
   }
  }
}
 
#if (clock>.95)
 union
 {
  intersection
  {
   blob
   { threshold .5
     sphere {<0,0,0>,2, 2 scale <1,1,2>}
     sphere {<0,0,0>,2, 2 translate z*4}
   }
   box {<-100,-.3,-100>,<100,.3,100>}
   texture
   {
    finish {ambient .3 phong 1}
    pigment {color White}
   }
  }
  intersection
  {
   blob
   { threshold .5
     sphere {<0,0,0>,1.9, 2 scale <1,1,2>}
     sphere {<0,0,4>,1.9, 2}
     cylinder {<0,0,0>,<0,2,4>,1.7, 2 }
   }
   box {<-100,10,-100>,<100,.3,100>}
   texture
   {
    finish {ambient .3}
    pigment {color rgb <.5,.5,.5>}
   }
  }
  translate <11,-.75,4>
 }
#end
