// Persistence of Vision Ray Tracer Scene Description File
// File: HINFRI.inc
// Vers: 3.1
// Desc: Hinostenian ship, sketched out in MSE (by Pete Goodwin) and finished in Windows POV internal Editor.
// Date: 16/6/98
// Auth: Thomas D. York
/*
Things to do:

Replace accommodation module prisms with curvilinear cylinder/box intersections - Done 12/7/00
Replace 'pyramids' on acc. modules with raised ellipsoids with lights           - Done 12/7/00
Replace triangular brackets with curved wineglass-type shapes                   - Done 12/7/00
Replace central box with cylinder                                               - Done 12/7/00
Replace main guns with inset cannon ports                                       - Done 12/7/00
Replace turret prisms with ellipsoidal turrets with inset ports                 - Done 12/7/00

Fixed reactor vents                                                             - Done 16/7/00
Automated turret rotation via 2 angle declares for each turret                  - Done 16/7/00 
Automated power output and weapon activation levels                             - Done 16/7/00

*/

// Settings

#ifndef(hf_baydoor) #declare hf_baydoor = 0.0;
#end
#if(hf_baydoor>2.0) #declare hf_baydoor = 2.0;
#else
#if(hf_baydoor<0.0) #declare hf_baydoor = 0.0;
#end
#end

#ifndef(hf_turret_upper_angle) #declare hf_turret_upper_angle = 0;
#end
#ifndef(hf_turret_lower_angle) #declare hf_turret_lower_angle = 0;
#end
#ifndef(hf_turret_right_angle) #declare hf_turret_right_angle = 0;
#end
#ifndef(hf_turret_left_angle) #declare hf_turret_left_angle = 0;
#end

#ifndef(hf_weapons_level) #declare hf_weapons_level = 1;
#end

#ifndef(hf_reactor_level) #declare hf_reactor_level = 1;
#end

// Textures

#declare AMB_TEST = 0.0;

#include "hfmetals.inc"

#declare HFEngineTube = texture
 {
  pigment {
           color rgb <1, 0.0, 0.0>
          }

  finish {
          ambient (<1.0, 1.0, 1.0>*hf_reactor_level)
         }
 }

#declare HFlights = texture
 {
  pigment {
           color rgb <0.0, 1.0, 1.0>                      
          }

  finish {
          ambient <1.0, 1.0, 1.0>
         }
 }

#declare HFHull = texture
 {
  material_map {
                gif "hfhull1.gif"
                map_type 2
                texture { 
                         T_Chrome_2A
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.06 ambient AMB_TEST phong 0.9 phong_size 60}
                        }
                        
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.6 ambient AMB_TEST phong 0.9 phong_size 60 }  
                        }
                        
                texture {
                         T_Chrome_2A
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.6 ambient AMB_TEST phong 0.9 phong_size 60}
                        }
                        
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }                         
                         finish { reflection 0.15 ambient AMB_TEST phong 0.9 phong_size 60}  
                        }
               }
}

#declare HFHull2 = texture
 {
  material_map {
                gif "hfhull1.gif"
                map_type 1
                texture { 
                         T_Chrome_2A
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.06 ambient AMB_TEST phong 0.9 phong_size 60}
                        }
                        
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.6 ambient AMB_TEST phong 0.9 phong_size 60 }  
                        }
                        
                texture {
                         T_Chrome_2A
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.6 ambient AMB_TEST phong 0.9 phong_size 60}
                        }
                        
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }                         
                         finish { reflection 0.15 ambient AMB_TEST phong 0.9 phong_size 60}  
                        }
               }
}

#declare HFHull3 = texture
 {
  material_map {
                gif "hfhull1.gif"
                map_type 0
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.15 ambient AMB_TEST }                            
                        }
                        
                texture { 
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.3 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.5 ambient AMB_TEST }   
                        }
                        
                texture {
                         T_Chrome_2D
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.7 ambient AMB_TEST }    
                        }
               }
 rotate <0, 90, 0>                                  // We want yz not xy plane mapping
}

#declare HFHull4 = texture
 {  
  material_map {
                gif "hfhull2.gif"                
                map_type 2
                texture { 
                         T_Chrome_2A
                         pigment { color rgb <0.4, 0.4, 0.4> } 
                         finish { reflection 0.06 ambient AMB_TEST }
                        }
                        
                texture {
                         T_Chrome_2B                       
                         pigment { color rgb <0.4, 0.4, 0.4> } 
                         finish { reflection 0.15 ambient AMB_TEST }                            
                        }
                        
                texture {
                         T_Chrome_2C
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.3 ambient AMB_TEST } 
                        }
                         
                texture {
                         T_Chrome_2D
                         pigment { color rgb <0.4, 0.4, 0.4> } 
                         finish { reflection 0.6 ambient AMB_TEST }    
                        }  
               }
 
 scale <1, 1, 1>
 rotate <0, 45, 0>
}

#declare HFHull5 = texture
 {
  material_map {
                gif "hfhull1.gif"
                map_type 0 
                texture { 
                         T_Chrome_2A                          
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.15 ambient AMB_TEST }
                        }
                        
                texture {
                         T_Chrome_2B                          
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.3 ambient AMB_TEST }                            
                        }
                        
                texture {
                         T_Chrome_2C                          
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.5 ambient AMB_TEST } 
                        }
                         
                texture {
                         T_Chrome_2D                          
                         pigment { color rgb <0.4, 0.4, 0.4> }
                         finish { reflection 0.7 ambient AMB_TEST }    
                        }  
               }
}

#declare HFpc_glow = texture
{
 pigment {
          color rgb <0, 0.5, 1.0>
         }

 finish {         
         ambient (<0, 0.5, 1.0> + <1.0, 1.0, 1.0>*hf_weapons_level)
        }
}


#declare HFpc_rilled = texture
{
 pigment {
          radial
          frequency 24
          color_map {
                     [0.00 color rgb <0.50, 0.50, 0.50>]
                     [0.25 color rgb <0.50, 0.50, 0.50>]
                     [0.5  color rgb <0.01, 0.01, 0.01>]
                     [0.75 color rgb <0.01, 0.01, 0.01>]
                     [1.00 color rgb <0.50, 0.50, 0.50>]
                    }
         }

 finish {
         ambient AMB_TEST
         brilliance 4
         diffuse 0.5
         metallic
         specular 0.80
         roughness 0.0125
         reflection 0.1
         
        }
}

#declare HFBay = texture
 {
  material_map {
                gif "hfhull1.gif"
                map_type 0 
                texture { 
                         T_Chrome_2A                          
                         pigment { color rgb <0.1, 0.1, 0.1> }
                         finish { reflection 0.1 ambient AMB_TEST }
                        }
                        
                texture {
                         T_Chrome_2B
                         pigment { color rgb <0.1, 0.1, 0.1> } 
                         finish { reflection 0.1 ambient AMB_TEST }                            
                        }
                        
                texture {
                         T_Chrome_2C
                         pigment { color rgb <0.1, 0.1, 0.1> }
                         finish { reflection 0.3 ambient AMB_TEST } 
                        }
                         
                texture {
                         T_Chrome_2A
                         pigment { color rgb <0.1, 0.1, 0.1> }                             
                         finish { reflection 0.3 ambient AMB_TEST }                             
                        }                  
               }
               
  rotate <90, 0, 0>               
 }

#declare HFBayDoor = texture
 {
  material_map {
                gif "hfhull1.gif"
                map_type 0
                texture { 
                         T_Chrome_4C                            
                         pigment { color rgb <0.5, 0.5, 0.5> }
                         finish { reflection 0.3 ambient AMB_TEST }  
                        }            
                        
                texture {
                         T_Chrome_4B                          
                         pigment { color rgb <0.5, 0.5, 0.5> }
                         finish { reflection 0.3 ambient AMB_TEST }
                        }
                         
                texture {
                         T_Chrome_4C                          
                         pigment { color rgb <0.5, 0.5, 0.5> }
                         finish { reflection 0.3 ambient AMB_TEST } 
                        }
                        
                texture {
                         T_Chrome_4A                          
                         pigment { color rgb <0.5, 0.5, 0.5> }
                         finish { reflection 0.07 ambient AMB_TEST }                              
                        }                
               }                    
               
  rotate <270, 0, 0>                             
 }


// Declared objects

#declare half_ring = object {                   // Engine ring                             
                             difference {
                                         lathe {
                                                cubic_spline     
                                                5,
        
                                                <1, 0.5>, <1.1, 0.5>, <1.1, -0.5>, <1.0, -0.5>, <1, 0.5>                                                
                                               }          
       
                                         box {
                                              <-1.6,  1.8, 0>,
                                              <1.6, -1.8, 1.6>
                                             }
                                             
                                         texture { 
                                                  HFHull3 
                                                  scale <0.75, 0.75, 0.65>
                                                 }                                                   
                                        }     
                             
                             
                             rotate <0, 0, 90>
                             rotate <0, -90, 0>                             
                             scale <1, 0.66667, 1>
                            }

#declare pulse_cannon = union {
                               difference {         
                                           sphere {
                                                   <0, 0, 0>,
                                                   0.15             
                                                   
                                                   texture { HFHull2 }
                                   
                                                   scale <2, 0.5, 2>
                                                  }
                                              
                                           box {
                                                <-1, -1, 1>,
                                                <1, 0, -1>
                                                
                                                texture { HFHull2 }
                                               }       
                                               
                                           box  {
                                                 <-0.1, 1, 0.2>,
                                                 <0.1, -1, 0.4>
                                                 
                                                 texture { HFHull2 }
                                                }                 
                                           
                                           box {
                                                <-0.06, 0.05, 0.3>,
                                                <0.06, 0.01, 0.1>
                                                
                                                texture { 
                                                         HFHull3                                                         
                                                        }
                                               } 
                                          }
                                          
                               box {
                                    <-0.06, 0.05, 0.18>,
                                    <0.06, 0.01, 0.1>
                                    
                                    texture { HFpc_glow }
                                   }
                                   
                               rotate <0, 180, 0>
                               translate <0, 0.25, 0>                                                    
                              }
                              
#declare pc_mount = union {
                           difference {
                                       sphere {
                                               <0, 0, 0>,
                                               0.5
                                              }
                                                   
                                       cylinder {
                                                 <0, 0, -1>,
                                                 <0, 0, 1>,
                                                 0.48
                                                }
                                                   
                                       box {
                                            <1,-0.05,-1>,
                                            <-1,-1,1>                                     
                                           }
                                                            
                                       scale <1.5, 0.5, 0.5>
                                       
                                       texture { 
                                                HFHull2
                                               }                                         
                                      }
                                                  
                           difference {
                                       sphere {
                                               <0, 0, 0>,
                                               0.5
                                              }
                                                   
                                       cylinder {
                                                 <1, 0, 0>,
                                                 <-1, 0, 0>,
                                                 0.48
                                                } 
                                                            
                                       box {
                                            <1,-0.03,-1>,
                                            <-1,-1,1>
                                           }         
                                                   
                                       scale <0.5, 0.5, 1.0>
                                       
                                       texture { 
                                                HFHull2
                                               }                                
                                      }
                           
                           cylinder {
                                     <0, 0.0, 0>,
                                     <0, 0.3, 0>,
                                     0.05
                                     
                                     texture { HFHull }                                
                                    }
                           
                           difference {         
                                       sphere {
                                               <0, 0, 0>,
                                               0.15
                                   
                                               scale <1, 0.5, 1>
                                              }
                                              
                                       box {
                                            <-1, -1, 1>,
                                            <1, 0, -1>
                                           }       
                                              
                                       texture { HFHull2 }                
                                       
                                       translate <0, 0.25, 0>
                                      }
                          }            


#declare bracket = difference {         
box {
     <0.82, -0.03, 0.5>,
     <-0.82, 0.03, -0.5>
    }
    
cylinder {
          <0, 1, 0.0>,
          <0, -1, 0.0>,
          0.54
          
          scale <0.5, 1, 1>
          translate <0.82, 0, 0>
         }
         
cylinder {
          <0, 1, 0.0>,
          <0, -1, 0.0>,
          0.54
          
          scale <0.5, 1, 1>
          translate <-0.82, 0, 0>
         }

texture { HFHull3 }
scale <1, 1, 0.6>
translate <0, -0.19, 2.18>
} 

#declare brackets = union {    

                           #declare loop = 0;
                           #while(loop<5)
                           object {
                                   bracket
                                   
                                   translate <0, 0, loop * 1.08>
                                  }
                           
                           #declare loop = loop + 1;
                           #end
                          }      

#declare HFac_t = union {                                 
                         difference {
                                     intersection {
                                                   cylinder { 
                                                             <0, 0, -1>,
                                                             <0, 0, 1>,
                                                             1.5
                                                                     
                                                             scale <1, 0.146667, 1>
                                                            }
                                                                    
                                                   box {
                                                        <-1.1, 0.0, -0.72>,
                                                        <1.1, 0.22, 0.0>
                                                       }         
                                                               
                                                   texture { 
                                                            HFHull5
                                                            rotate <90, 0, 0>                                                           
                                                           }        
                                                  }
                                             
                                     box {
                                          <0.75, -0.1, 1>,
                                          <-0.75, 0.1, -1>
                                                  
                                          texture { 
                                                   HFHull5
                                                   rotate <90, 0, 0>                                                   
                                                  }
                                         }
                                                 
                                     cylinder {
                                               <0, 0.1, 0>,
                                               <0, -0.1, 0>,
                                               0.10
                      
                                               texture { HFlights }
                                            
                                               translate <0.95, 0, -0.2>
                                              }
                            
                                     cylinder {
                                               <0, 0.1, 0>,
                                               <0, -0.1, 0>,
                                               0.10
                      
                                               texture { HFlights }
                                            
                                               translate <0.95, 0, -0.5>
                                              }
                            
                                     cylinder {
                                               <0, 0.1, 0>,
                                               <0, -0.1, 0>,
                                               0.10
                      
                                               texture { HFlights }
                                            
                                               translate <-0.95, 0, -0.2>
                                              }
                            
                                     cylinder {
                                               <0, 0.1, 0>,
                                               <0, -0.1, 0>,
                                               0.10
                      
                                               texture { HFlights }
                                            
                                               translate <-0.95, 0, -0.5>
                                              }                                         
                                    }
                         
                         difference {
                                     sphere {
                                             <0, 0, 0>, 
                                             0.4
                                             
                                             scale <1, 0.15, 0.4>
                                 
                                             texture {
                                                      HFHull5  
                                                      rotate <90, 0, 0>
                                                     }
                                            }          
                                            
                                     cylinder {
                                               <0, 0.01, 0>, 
                                               <0, 0.1, 0>,
                                               0.01
                                               
                                               texture { HFlights }
                                              }
                                     
                                     translate <0, 0.20, -0.36>         
                                    }     
                         }

#declare HFac_b = object {
                          HFac_t
                          rotate <0, 0, 180>
                         } 
                         

#declare HF_ac_module = union {
                               object { HFac_b }
                     
                               object { HFac_t }
                              }    
       
#declare engine = object {
union {              
    lathe {
           linear_spline
           5,
           <0.5, 0>, <0.55, 0>, <0.55, 0.2>, <0.5, 0.2>, <0.5, 0>
           texture { HFpc_rilled }
           
           scale <1, 5, 1>
           rotate <-90, 0, 0>
           translate <0.0, 0.2, 0.90>
          } 
              
    lathe {
           linear_spline
           5,
           <0.5, 0>, <0.55, 0>, <0.55, 0.2>, <0.5, 0.2>, <0.5, 0>
           texture { HFpc_rilled }
                             
           scale <1, 5, 1>                  
           rotate <90, 0, 0>           
           translate <0.0, 0.2, -0.90>
          } 
    
    
    cylinder {
              <0, 1.0000, 0>
              <0, -1.0000, 0>
              1.0000
              texture { HFEngineTube }
              scale <0.2000, 1.0000, 0.2000>
              rotate <-90.00, 0, 0>
              translate <0.3000, 0.3000, 0.0000>
             }

    cylinder {
              <0, 1.0000, 0>
              <0, -1.0000, 0>
              1.0000
              texture { HFEngineTube }
              scale <0.2000, 1.0000, 0.2000>
              rotate <-90.00, 0, 0>
              translate <-0.3000, 0.3000, 0.0000>
             }

    cylinder {
             <0, 1.0000, 0>
             <0, -1.0000, 0>
             1.0000
             texture { HFEngineTube }
             scale <0.2000, 1.0000, 0.2000>
             rotate <-90.00, 0, 0>
            }

    cylinder {
              <0, 1.0000, 0>
              <0, -1.0000, 0>
              1.0000
              texture { HFHull3 }
              scale <0.5000, 0.1000, 0.5000>
              rotate <-90.00, 0, 0>
              translate <0.0000, 0.2000, 1.0000>
             }

    cylinder {
              <0, 1.0000, 0>
              <0, -1.0000, 0>
              1.0000
              texture { HFHull3 }
              scale <0.5000, 0.1000, 0.5000>
              rotate <-90.00, 0, 0>
              translate <0.0000, 0.2000, -1.0000>
             }

    cone {
          <0, 1.0000, 0>, 0.4100
          <0, -1.0000, 0>, 1.0000
          texture { HFHull }
          scale <0.5000, 0.2000, 0.5000>
          rotate < 90.00, 0, 0>
          translate <0.0000, 0.20000, 1.3000>
         }

    cone {
          <0, 1.0000, 0>, 0.4100
          <0, -1.0000, 0>, 1.0000
          texture { HFHull }
          scale <0.5000, 0.2000, 0.5000>
          rotate <-90.00, 0, 0>
          translate <0.0000, 0.20000, -1.3000>
         }
      }                                             // End of union

 scale <0.5, 0.5, 1>
 rotate <90,0,0>
}


#declare Hin_frigate = union
{                                           // Beginning of massive union

// Resource section (connects command section to drive section)

object {
        HF_ac_module 
        translate <0.0000, -0.1900, 3.1000>
       }

object {
        HF_ac_module 
        translate <0.0000, -0.1900, 4.1800>
       }

object {
        HF_ac_module 
        translate <0.0000, -0.1900, 5.2400>
       }

cylinder {                                      // Port transport tube
          <0, 1.0000, 0>
          <0, -1.0000, 0>
          1.0000            
          texture { 
                   HFHull 
                   scale <0.25, 0.25, 0.25>
                  } 
                  
          scale <0.1200, 2.0000, 0.1200>
          rotate <-90.00, 0, 0>
          translate <0.8200, -0.1900, 3.0000>
         }

cylinder {                                      // Starboard transport tube
          <0, 1.0000, 0>
          <0, -1.0000, 0>
          1.0000
          texture { 
                   HFHull 
                   scale <0.25, 0.25, 0.25>
                  }
                  
          scale <0.1200, 2.0000, 0.1200>
          rotate <-90.00, 0, 0>
          translate <-0.8200, -0.1900, 3.0000>
         }

cylinder {                                           // Central gantry
          <0, 0, -1>,
          <0, 0, 1>,
          1
          
          scale <0.3000, 0.1000, 2.0000>
          
          texture { 
                   HFHull 
                   rotate <90, 0, 0>
                   scale <0.25, 0.25, 0.25>
                  }
          
          translate <0.0000, -0.1900, 3.0400>
         }
        
// transport tube support brackets        

object { brackets }    

// Aft weaponry

union {
       object { 
               pulse_cannon 
               rotate <0, hf_turret_upper_angle, 0>
              }
       
       object { pc_mount }
       
       translate <0, 0.4, 6.4>
      }
           
union {
       object { 
               pulse_cannon 
               rotate <0, hf_turret_lower_angle, 0>
              }
       
       object { pc_mount }
       
       rotate <0, 0, 180>
       translate <0, -0.8, 6.4>
      }


// Power section (rear + engines)

difference {
            union {                                 // Aft main section
                   cone {
                         <0, 1.0000, 0>, 0.6300
                         <0, 0.7800, 0>, 0.8500
                        }

                   cone {
                         <0, 0.7800, 0>, 0.8500
                         <0, 0.4200, 0>, 0.9700
                        }

                   cone {
                         <0, 0.4200, 0>, 0.9700
                         <0, 0.0000, 0>, 1.0000
                        }

                   texture {
                            HFHull4
                            rotate <0, -45, 0>
                            rotate <0, 90, 0>
                           }
                           
                   scale <0.2000, 2.0000, 1.0000>
                   rotate <0, 0, 90.0>
                   rotate <0, 90.00, 0>
                   translate <0.0000, -0.1900, 5.1600>
                  }

         cylinder {
                   <0, 0, 0>,
                   <0, 0, 1>,
                   0.5

                   texture {
                            HFHull4
                            rotate <0, -45, 0>
                            rotate <0, 90, 0>
                           }
                   
                   scale <1, 0.2, 1>
                   translate <0, -0.19, 6.56>
                  }
        }

difference {
            sphere {
                    <0, 0, 0>,
                    1                                       
               
                    texture { HFHull2 }                        
                   } 
                            
            #declare alf = 0;        
            #while(alf<8)                    
            
            box {
                 <0.5, -1, -0.05>
                 <0.505, 1, 0.05>
                         
                 texture { HFEngineTube }
                 rotate <0, alf * 45, 0>
                }                         
                   
            box {
                 <0.504, -1, -0.05>
                 <1.5, 1, 0.05>
                         
                 texture { HFHull2 }
                 rotate <0, alf * 45, 0>
                }                         
                    
            #declare alf = alf + 1;
            #end
                   
            scale <0.5, 0.35, 0.5>        
            translate <0, -0.21, 6.3>     
           } 
     
cylinder {
          <0, 0, 0>,
          <0, 0, 1>,
          0.5

          texture { HFHull4 }
                  
          scale <1, 0.2, 1>
          translate <0, -0.19, 6.00>
         }

cylinder {                                          // Horizontal engine support pylon
          <0, 1.0, 0>
          <0, -1.0, 0>
          1.0
          scale <0.05, 2.0, 0.2>
          texture { HFHull3 }
          rotate <0, 0, 90>
          translate <0.0, -0.2, 6.3>
         }
          
cylinder {                                          // Vertical engine support pylon
          <0, 1.0, 0>
          <0, -1.0, 0>
          1.0
          scale <0.05, 0.64, 0.2>
          texture { HFHull3 }
          rotate <0, 0, 0>
          translate <0.0, -0.25, 6.3>
         }
          

object {
        merge {
               object { 
                       half_ring 
               
                       matrix < 1, 0, 0.25,
                                0, 1, 0,                       
                                0, 0, 1,
                                0, 0, 0 >                                      
                      }
               
               object { 
                       half_ring 

                       matrix < 1, 0, 0.25,
                                0, 1, 0,                       
                                0, 0, 1,
                                0, 0, 0 >                       
                       
                       matrix < -1, 0, 0,
                                 0, 1, 0,                       
                                 0, 0, 1,
                                 0, 0, 0 >                       
                      }               
              }
              
        scale <2.0, 0.8, 1.5>
        rotate <0, 180, 0>
        translate <0, -0.2, 6.5>
       }

object {                                        // Engines
        engine
        rotate <-90, 0, 0>
        scale <1, 0.5, 0.8>
        translate <1.7, -0.25, 6.1>
       }

object {
        engine
        rotate <-90, 0, 0>
        scale <1, 0.5, 0.8>
        translate <-1.7, -0.25, 6.1>
       }

// Modified command section, better than previous design 

difference {
            merge {
                   object { 
                           half_ring 
                      
                           matrix < 1, 0, 0.25,
                                    0, 1, 0,                       
                                    0, 0, 1,
                                    0, 0, 0 >                                      
                          }
               
                   object { 
                           half_ring 

                           matrix < 1, 0, 0.25,
                                    0, 1, 0,                       
                                    0, 0, 1,
                                    0, 0, 0 >                       
                       
                           matrix < -1, 0, 0,
                                     0, 1, 0,                       
                                     0, 0, 1,
                                     0, 0, 0 >                       
                          }               

                   scale <1.5, 0.5, 1.5>
                   translate <0, -0.2, 1.0>
                  }
            
            box {                                 // Make hole for transport bay
                 <-1, -0.1, -1>
                 <1, 0.4, 1>
                 
                 texture { 
                          HFHull3 
                          scale <0.75, 0.75, 0.65>
                         }                                                                                 
                 
                 scale <0.333, 0.333, 0.333>
                 translate <0, -.65, 1.3>
                }                
           }      

cone {                                // Front section (holds main guns and bits on front)
      <0, 0, 0>, 0.5,
      <0, 0, -1>, 0.35            

      texture {
               HFHull3
               rotate <0, 0, 90>
               scale <0.4, 0.4, 0.4>
              } 
                   
      scale <3, 0.72, 2>
      translate <0, -0.21, 0.75>           
     }

sphere {
        <0, 0, 0>,
        0.2
        
        texture {
                 HFHull3
                 rotate <0, 0, 90>
                 scale <0.4, 0.4, 0.4>
                } 
       
       scale <1.54, 0.54, 1.3>                                                  
       translate <0, -0.2, -2>                
      }             

object {
        pulse_cannon 
        scale <0.5, 1, 1>
        rotate <0, hf_turret_right_angle, 0>
        rotate <0, 0, 90> 
        translate <-1.30, -0.2, 0.5>
       }
       
object {
        pulse_cannon
        scale <0.5, 1, 1>
        rotate <0, hf_turret_left_angle, 0>
        rotate <0, 0, -90>
        translate <1.30, -0.2, 0.5>
       }

sphere {
        <0, 0, 0>,
        1
               
        texture { 
                 HFHull3
                 rotate <90, 0, 0> 
                 scale <0.8, 0.8, 0.8>
                } 
                       
        scale <0.25, 0.5, 0.75>        
        rotate <0, 0, 90>
        translate <1.4, -0.2, 1.2>
       }

sphere {
        <0, 0, 0>,
        1
               
        texture { 
                 HFHull3                 
                 rotate <90, 0, 0> 
                 scale <0.8, 0.8, 0.8>
                } 
                       
        scale <0.25, 0.5, 0.75>        
        rotate <0, 0, -90>
        translate <-1.4, -0.2, 1.2>
       }
       
sphere {
        <0, 0, 0>,                 // Port for'd cannon
        1
               
        texture { 
                 HFHull3
                 rotate <90, 0, 0> 
                 scale <0.5, 0.5, 0.5>
                } 
                       
        scale <0.3, 0.45, 1.02>        
        translate <0.8, -0.2, 1.0>
       }
           
sphere {
        <0, 0, 0>,                 // Starboard for'd cannon
        1
               
        texture { 
                 HFHull3
                 rotate <90, 0, 0> 
                 scale <0.5, 0.5, 0.5>
                } 
                       
        scale <0.3, 0.45, 1.02>        
        translate <-0.8, -0.2, 1.0>
       }

union {
       difference {
        sphere {                                // This is the front sphere, into which the main guns are inset
                <0, 0, 0>,
                1        
        
                scale <1, 0.18, 0.9>        
        
                texture {
                         HFHull3
                         rotate <0, 0, 90>
                         scale <0.75, 0.75, 0.75>
                        }
               
                translate <0.0, -0.2, -1.2>
               } 
        
        cylinder {
                  <0, 0, -2.045>,
                  <0, 0, -1>,
                  0.1
                  
                  texture { 
                           HFHull3
                           rotate <0, 0, 90>
                           scale <0.75, 0.75, 0.75>
                          }
                  
                  scale <1, 0.5, 1>
                  translate <0.4, -0.2, 0>
                 } 
        
        cylinder {
                  <0, 0, -2.045>,
                  <0, 0, -1>,
                  0.1
                  
                  texture { 
                           HFHull3
                           rotate <0, 0, 90>
                           scale <0.75, 0.75, 0.75>
                          }
                  
                  scale <1, 0.5, 1>
                  translate <-0.4, -0.2, 0>
                 }           
       }
       
       cylinder {
                  <0, 0, -1.9>,
                  <0, 0, -1>,
                  0.1
                  
                  texture { 
                           HFpc_glow
                           rotate <0, 0, 90>
                           scale <0.75, 0.75, 0.75>
                          }
                  
                  scale <1, 0.5, 1>
                  translate <0.4, -0.2, 0>
                 } 
                 
       cylinder {
                  <0, 0, -1.9>,
                  <0, 0, -1>,
                  0.1
                  
                  texture { 
                           HFpc_glow
                           rotate <0, 0, 90>
                           scale <0.75, 0.75, 0.75>
                          }
                  
                  scale <1, 0.5, 1>
                  translate <-0.4, -0.2, 0>                 
                 }    
      }         
               
               
sphere {
        <0, 0, 0>,
        1
        
        texture { 
                 HFHull3              
                 rotate <0, 0, 90>
                }                    
                   
        scale <0.666, 0.38, 1>
        translate <0, 0.0, 0.75>
       }
  
// Shuttle bay
union {
       difference {
                   difference {
                               difference {                                    
                                           box {
                                                <-1, 0.0, -1>
                                                <1, 0.4, 1>                             
                                               } 
                        
                                           box {
                                                <-0.8, -0.1, -0.8>
                                                <0.8, 0.5, 0.8>
                                               }                                        
                                          }      

                               box {
                                    <-0.9, 0.1, -0.9>
                                    <0.9, 0.15, 0.9>      
                 
                                    texture { HFpc_rilled }
                                   }                        
                              }            
                             
                   box {
                        <-1.2, 0.0, -1.2>
                        <1.2, -0.5, 1.2>
                 
                        rotate <5.7106, 0, 0>                 
                        translate <0, 0.0, 0>
                       }
                
                   texture { HFBay }            
                  }          
     
       box {
            <-0.9, 0.1, -0.9>     
            <0.9, 0.15, 0.9>
     
            translate <0, 0, hf_baydoor * 0.9>
     
            texture { HFBayDoor }
           } 

       rotate <0, 180, 0>
       scale <0.333, 0.333, 0.333>       
       translate <0, -0.56, 1.3>
      }

       
}                                                       // End of Massive Union

