/* Animation 1 scene 3b

Camera & VFX  OK
HN corvette pulse fire (6 delweap.inc)   OK
DL frigate laser fire (7) 
DL frigate missile fire (2)
HN corvette 1   OK
HN corvette 2   OK
DL corvette 1 + explosion and 'sparks'  
DL frigate
Planet
Planetary lighting
Nebula background

*/

/* ----------Camera & VFX---------- */
#macro lissajous(centre_dir, amplitude, series, decay, complexity, start_clock, end_clock)
#local liss = <0.0, 0.0, 0.0>;
#if(clock>=start_clock & clock<=end_clock) 
#local lis_time = (clock - start_clock)/(end_clock - start_clock);

#local fish = 1;
#local coeff = 1;
#while(fish<=complexity)
#local liss = liss + <coeff*cos(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time) + pi*0.66>;
#local fish = fish + 1;
#local coeff = coeff - decay;
#end

#end
(liss*amplitude + centre_dir)
#end

#declare camera_location = <-3, 1, -1>;
#declare camera_look_at = lissajous(<0, 0, -clock>, 0.04, 0.25, 0.05, 3, 0, 1);

camera {        
        location <0, 0, 0>
        direction <0, 0, 1>
        up <0, 1, 0>
        right <4/3, 0, 0>
        
        rotate <0, 0, 70*clock>
        rotate <-57.29577 * atan2(camera_look_at.y - camera_location.y, vlength(<camera_look_at.z - camera_location.z, 0, camera_look_at.x - camera_location.x>)), 0, 0>
        rotate <0, 57.29577 * atan2(camera_look_at.x - camera_location.x, camera_look_at.z - camera_location.z), 0>
        translate camera_location 
       }       
/*
#declare effect_type = "Headlight2"
#declare effect_scale = <0.8, 0.8, 0.8>;
#declare source_colour = <0.9, 0.8, 1.1>;
#declare effect_colour = <0.7, 0.8, 1.1>;
#declare light_loc = <-20, 2, -128>;
#declare effect_location = light_loc;
#declare effect_brightness = 1.5;                    
#declare effect_always_on_top = true;
#declare options_only = true;
#include "Lensfx\Lens.inc"  
#declare spots_frequency = 0.75;
#declare spots_scale = <0.7, 0.4, 0.7>;
#include "Lensfx\LnsEfcts.inc"  
#declare options_only = false;    // protect galaxy inc from lens setting
*/

/* Hino corvette 1 pulse fire */

#declare DW_scale = 1.0;
#declare dlweap_start = 0.1;
#declare dlweap_stop = 0.2; 
#declare dlweap_src = <-6, 0, 0>;
#declare dlweap_trg = <0, 0, 0>;
#declare DW_colour = <0.7, 0.7, 1>;
#declare DW_bright = 30;
#declare dlweap_mode = 1;

#include "delweap.inc"

#declare dlweap_start = 0.0;
#declare dlweap_stop = 1; 
#declare dlweap_src = <-6, 0, 0>;
#declare dlweap_trg = <60, -8, 2>;

#include "delweap.inc"

#declare dlweap_start = 0.2;
#declare dlweap_stop = 0.32; 
#declare dlweap_src = <-6, 0, 0>;
#declare dlweap_trg = <1.2, 0, 0>;

#include "delweap.inc"   

#declare dlweap_start = 0.6;
#declare dlweap_stop = 1; 
#declare dlweap_src = <0, -0.5, 0>;
#declare dlweap_trg = <36, -0.5, 0>;

#include "delweap.inc"

#declare dlweap_start = 0.7;
#declare dlweap_stop = 1; 
#declare dlweap_src = <1, -0.5, 0>;
#declare dlweap_trg = <31, -0.5, 0>;

#include "delweap.inc"

#declare dlweap_start = 0.8;
#declare dlweap_stop = 1; 
#declare dlweap_src = <2, -0.5, 0>;
#declare dlweap_trg = <26, -0.5, 0>;

#include "delweap.inc"
   
   
/* Deltori frigate returns fire */

#declare dlweap_start = 0.12;
#declare dlweap_stop = 0.24; 
#declare dlweap_src = <20, 0, 0>;
#declare dlweap_trg = <-6, 3, 5 - (clock-0.12)*40>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;

#include "delweap.inc"

#declare dlweap_start = 0.18;
#declare dlweap_stop = 0.36; 
#declare dlweap_src = <20, 0, 0>;
#declare dlweap_trg = <-6, -5 + (clock-0.18)*80, -5 + (clock-0.18)*60>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;

#include "delweap.inc"

#declare dlweap_start = 0.43;
#declare dlweap_stop = 0.46; 
#declare dlweap_src = <20, 0, 0>;
#declare dlweap_trg = <20, 15, -34>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;

#include "delweap.inc"

#declare dlweap_start = 0.47;
#declare dlweap_stop = 0.50; 
#declare dlweap_src = <20, 0, 0>;
#declare dlweap_trg = <-6, 15-(clock-0.47)*15, -10>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;

#include "delweap.inc"

#declare dlweap_start = 0.43;
#declare dlweap_stop = 0.52; 
#declare dlweap_src = <20, 0, 0>;
#declare dlweap_trg = <0, 5 - 10*(clock-0.37), -6>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;

#include "delweap.inc"
                                     
#declare dlweap_start = 0.80;
#declare dlweap_stop = 0.92; 
#declare dlweap_src = <20, 0, 0>;
#declare dlweap_trg = <-6, 4 + (clock-0.8)*2, -40>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;

#include "delweap.inc"

#declare dlweap_start = 0.93;
#declare dlweap_stop = 1.00; 
#declare dlweap_src = <20, 0, 0>;
#declare dlweap_trg = <-3, -6, 5 + 10*((clock-0.93)/0.07)>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;

#include "delweap.inc"
   
   
/* DL corvette missiles */

#declare dlweap_start = 0.60;
#declare dlweap_stop = 1.00; 
#declare dlweap_src = <20.2, 0, -1.2>;
#declare dlweap_trg = <-6, 0, -1.2>;
#declare DW_colour = <0.1, 1.0, 0.2>;
#declare DW_bright = 60;
#declare dlweap_mode = 1;

#include "delweap.inc"

#declare dlweap_start = 0.60;
#declare dlweap_stop = 1.00; 
#declare dlweap_src = <20, 0, 1.2>;
#declare dlweap_trg = <-6, 0, 1.2>;
#declare DW_colour = <0.1, 1.0, 0.2>;
#declare DW_bright = 60;
#declare dlweap_mode = 1;

#include "delweap.inc"
#if(clock>0.7)    

disc {
      <0, 0, 0>,
      (camera_location - <20.2 - 26.2 * ((clock-0.6)/0.4), 0, 1.2>),
      0.4  
      
      hollow
      no_shadow
      
      pigment {
               onion
               colour_map {
                        [0.0 colour rgbt <0.7, 0.9, 0.7, (clock-0.6)/0.4>]
                        [1.0 colour rgbt <0.6, 0.9, 0.7, 1.0>]
                        }
                        
               scale 0.4         
              }
              
      finish {
              diffuse 0.0
              ambient 1.5*((clock-0.6)/0.4)                   
             }
              
      scale ((clock-0.7)/0.3)
      translate <20.2 - 26.2 * ((clock-0.6)/0.4), 0, 1.2>      
     }

disc {
      <0, 0, 0>,
      (camera_location - <20.2 - 26.2 * ((clock-0.6)/0.4), 0, -1.2>),
      0.4  
      
      hollow
      no_shadow
      
      pigment {
               onion
               colour_map {
                        [0.0 colour rgbt <0.7, 0.9, 0.7, (clock-0.6)/0.4>]
                        [1.0 colour rgbt <0.6, 0.9, 0.7, 1.0>]
                        }
                        
               scale 0.4         
              }
              
      finish {
              diffuse 0.0
              ambient 1.5*((clock-0.6)/0.4)                   
             } 

      scale ((clock-0.7)/0.3) 
      translate <20.2 - 26.2 * ((clock-0.6)/0.4), 0, 1.2>      
     }
      
#end

/* Hinosten corvette 1 */

#include "hincor.inc"

object {
        HN_CORVETTE
        
        scale <0.2, 0.2, 0.2>
        rotate <0, 90, 0>
        rotate <0, 0, 90>
        rotate <0, 270 * clock, 0>        
        translate <0, 6 - 10 * clock, -2.0>
        
        light_group "!planetary"
       } 
   
   
/* Hinosten corvette 2 */

object {
        HN_CORVETTE
        
        scale <0.2, 0.2, 0.2>
        rotate <0, -90, 0>
        rotate <clock*400, 0, 0>
        translate <-6 + 10 * clock, -0.5, 0>
        
        light_group "!planetary"
       } 
   
   
/* Deltori corvette 1 + explosion */

#include "delcor.inc"

#if(clock<0.2)
object { 
        DL_corvette          
        
        scale <0.2, 0.2, 0.2>
        
        rotate <0, 90, 0>
        
        #if(clock>0.1)
        rotate <600 * (clock-0.1), 0, 0>        
        rotate <0, 0, 1800 * (clock-0.1)>
        #end          
       
        translate <-2 + 10 * clock, 0, 0>
        
        light_group "!planetary"
       }
       
#else 
#if(clock<=0.32)
object { 
        DL_corvette          
        
        scale <0.2, 0.2, 0.2>
        
        rotate <0, 90, 0>
             
        rotate <60 + 100 * (clock-0.2), 0, 0>
        rotate <0, 0, 180 + 300 * (clock-0.2)>
                
        translate <-2 + 10 * clock, 0, 0>
        
        light_group "!planetary"
       }

#declare s_shield_colour = <0.7, 0.7, 1.2>;
#declare s_shot_colour = <0.7, 0.7, 1.2>;
#declare s_scale = <0.3, 0.3, 0.3>;
#declare s_shot_dir = <-0.707, -0.3, 0.707>;
#declare s_centre = <0, 0.05, 0>;
#declare s_decay = 0.0; 
#declare s_cstart = 0.2;
#declare s_cend = 0.32;
#declare s_coverage = 0.08;
#declare s_shield_intensity = 1.0;  
#declare s_shot_intensity = 1.0;
#declare s_shield_grain = <1, 1, 1>;
#declare s_turbulence = <0.2, 0.2, 0.2>;
#declare s_background = 0;
#declare s_scramble = <2, 2, 2>;
#declare s_shield_style = "lightening"                      
#declare s_create = false;     
       
#include "shield\shield.inc"   

object {
        myshield

        rotate <0, 90, 0>
        rotate <60 + 100 * (clock-0.2), 0, 0>
        rotate <0, 0, 180 + 300 * (clock-0.2)>
        translate <-2 + 10 * clock, 0, 0>
       } 
                  
#else
#declare explode_object = object {
                                  DL_corvette 
                                  scale 0.2 
                                  rotate <0, 90, 0> 
                                  rotate <72, 0, 0>
                                  rotate <0, 0, 216>
                                  translate <-2 + 10 * clock, 0, 0>
                                  
                                  light_group "!planetary"
                                 }
                                 
#declare object_corner1 = (vrotate(vrotate(<-0.14769, -0.05538, -0.22769>, <0, 90, 0>), <72, 0, 216>) + <-2 + 10*clock, 0, 0>);
#declare object_corner2 = (vrotate(vrotate(<0.14769, 0.11077, 0.28307>, <0, 90, 0>), <72, 0, 216>) + <-2 + 10*clock, 0, 0>);
#declare object_hollow = false;
#declare particle_res = <3, 3, 3>;
//#declare particle_texture = texture { pigment { color rgb (1 - ((clock-0.32)/0.68)) } }
#declare exp_strength = 3;
#declare exp_falloff = 20;
#declare exp_spin = 0.3;
#declare exp_turb = 0.5;
#declare explode_clock = (clock - 0.32)/0.68;
#include "explode\explode.inc"

#declare TP_speed = 17;
#declare TP_spdir = <1, 1, 0>;
#declare TP_centre = <-2 + 10*clock, 0, 0>;  
#declare TP_particles = 2000;

#declare TP_start = 0.32;
#declare TP_end = 0.60;

#declare TP_camera_location = camera_location;
#declare TP_camera_look_at = camera_look_at;
#declare TP_glowenable = false;
                                  
#include "texplode.inc"
/*
light_source {
              <-2 + 10*clock, 0, 0>,
              <((clock - 0.32)/0.68), ((clock - 0.32)/0.68), ((clock - 0.32)/0.68)>
              
              fade_distance 5
              fade_power 1000
             }
*/             
#end
#end       


       
/* Deltori Frigate */                                                

#include "deldes.inc"

object {
        Del_frigate 
        
        rotate <0, 10 * clock, 0>
        translate <20, 0, 0>
        
        light_group "!planetary"
       } 
             

/* Planet */

#declare PG_centre = <0, 0, 10>;
#declare PG_scale = 17;
#declare PG_atmosdisc = true;      
#declare PG_atmosthick = 0.05;
#declare PG_atmoscol1 = <32, 32, 32>;
#declare PG_atmoscol2 = <16, 16, 16>;
#declare PG_rotate = <0, 0, 0>;

#include "plangen.inc"


/*
#include "colors.inc"

#declare Clouds1 = pigment {
      bozo
      turbulence 0.5
      octaves 3
      color_map {
        [0.0 color White filter 0.9]
        [0.6 color White]
       }
     }

#declare Clouds2 = pigment {
    quilted
    turbulence 0.4    
    color_map {
      [0.0 color White filter 0.9]      
      [0.6 color White]
     }
   }

#declare Cl = pigment { colour rgbf <1, 1, 0.8, 0.8> }

#declare CloudArea = texture {
    pigment {
      wrinkles
      
      scale <0.4, 0.4, 0.4> 
      rotate <90, 180, 0>
      pigment_map {        
        [0.58 Clouds1]
        [0.95 Clouds2 ]
      }  
    }
   
 
   finish { ambient 0 diffuse 1 }
   scale <0.1, 0.1, 0.1> 
  }

  
#declare LandArea = texture {
      pigment {
        crackle
        turbulence 1
        lambda 1.5
        omega .8
        octaves 8
        color_map {
          [0.00 color rgb <.1, .45, .25>]
          [0.33 color rgb <.3, .3, .1>]
          [0.86 color rgb <.4, .4, .1>]
          [0.99 color rgb <.1, .35, .15>]
          [1.00 color rgb <1, 1, 1>]
          
        }
      }
    }
    
#declare OceanArea = texture {
      pigment {
        wrinkles
        turbulence .5
        lambda 2  
        octaves 2
        color_map {
          [0.00, 0.33 color rgb <0, 0.4, 1>
                      color rgb <0, 0.6, 1>]
          [0.33, 0.66 color rgbt <1, 1, 1, 1>
                      color rgbt <1, 1, 1, 1>]
          [0.66, 1.0  color rgb <0, 0.4, 0.8>
                      color rgb <0, 0.6, 0.8>]
        }
      }
        finish {
                ambient 0.13
                diffuse 0.27
               }

    }



union { 
sphere {
        <0, 0, 0>,
        0.5     
        
        //texture { OceanArea scale <0.25, 0.1, 0.25> }

        texture { 
                 pigment {
                          wrinkles
                          color_map {
                                [0.0 rgb <0.9, 0.8, 0.9> ] 
                                [0.25 rgb <0.7, 0.8, 0.7> ]
                                [0.5 rgb <0.4, 0.4, 0.5> ]
                                [0.75 rgb <0.5, 0.6, 0.6> ]
                                [1.0 rgb <0.8, 0.8, 0.8> ]
                                }
                          
                          scale <0.005, 0.005, 0.005>      
                          rotate <0, 0, 90>
                          scale <1, 0.5, 1>
                         }    
                         
                 normal {
                         wrinkles 0.5
                         
                         scale <0.005, 0.0025, 0.005>
                        }  
                         
                 finish { ambient 0 diffuse 1 }       
                }
        
        scale <614400, 614400, 614400>
        translate <0, 0, 312000>
        
        
        light_group "planetary"
       }

disc {
      <0, 0, 0>,
      camera_location,
      318000, 310000
      
      texture {
               pigment { 
                        onion 
                        sine_wave                         
                        colour_map {
                                    [0.0 colour rgbt <0.9, 0.9, 0.9, 0> ]
                                    [1.0 colour rgbt <0.9, 0.9, 1, 1> ]
                                   }
                                   
                        scale <318000*0.082, 318000*0.082, 318000*0.082>            
                       }      
                       
               finish {
                       ambient 1.0
                       diffuse 0.0
                      }                       
              }
               
      scale <0.9999, 0.9999, 0.9999>        
              
      translate <0, 0, 312000>
      
      no_shadow
     }
}
*/

/* --------Planetary backlight--------- */
     
light_source {
              <-3e5, 0, -1e5>,
              <1, 1, 1> 
              
              groups "planetary"
             }

light_source {
              <0, 0, 10>,
              <0.60, 0.60, 0.70>
             } 

/* --------Nebula background---------- */       

#declare galaxy_seed = (.127 - .5) * 2e5;
#declare galaxy_bgstars = false;
#declare galaxy_objects = 0;
#declare galaxy_starfield = 1; 
#declare galaxy_distance = 50003;
#declare galaxy_pattern_origin = <clock*0.4, clock*0.4, 0>;

#declare star_type = 1;
#declare star_colour = <0.8, 0.8, 0.8>; 
#declare star_colour_turb = <0.5, 0.5, 0.5>;
#declare star_count = 7000;
#declare star_distance = 50000;

#include "galaxy\galaxy.inc"

global_settings {max_trace_level 30}

       