#macro lissajous(centre_dir, amplitude, series, decay, complexity, start_clock, end_clock)
#local liss = <0.0, 0.0, 0.0>;
#if(clock>=start_clock & clock<=end_clock) 
#local lis_time = (clock - start_clock)/(end_clock - start_clock);

#local fish = 1;
#local coeff = 1;
#while(fish<=complexity)
#local liss = liss + <coeff*cos(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time), coeff*sin(2*pi*(series*fish)*lis_time) + pi*0.66>;
#local fish = fish + 1;
#local coeff = coeff - decay;
#end

#end
(liss*amplitude + centre_dir)
#end

#declare camera_location = <1-clock, 0.5 - 0.5*clock, 0.8 + clock * 0.2>;
#declare camera_look_at = lissajous(<-6, 0.1, 2 - clock>, 0.04, 0.25, 0.05, 3, 0, 1);

camera {        
        location camera_location
        look_at  camera_look_at
       }

#declare light_loc = <28, 2, -128>;
#declare flare_scale = <0.55, 0.55, 0.55>;
#declare flare_colour = <0.7, 1.1, 0.9>;
#declare bar_colour = <1.1, 0.9, 0.9>;
//#declare flare_location = <-20, 2, -128>;
#declare flare_location = <-1.21, 0.1388, -5.32>;
#declare flare_brightness = 1.3;

//#include "tlens.inc"   

light_source {              
              light_loc
              <1, 1, 1>
             }

/* Planet */

//#declare PG_centre = <0, 0, 312000>;
//#declare PG_scale = 614400;
#declare PG_centre = <0, 0, 10>;
#declare PG_scale = 15;
#declare PG_atmosdisc = true;      
#declare PG_atmosthick = 0.1;
#declare PG_atmoscol1 = <32, 32, 32>;
#declare PG_atmoscol2 = <4, 4, 4>;
#declare PG_rotate = <0, 180, 0>;

#include "plangen.inc"

/* --------Planetary light--------- */
     
light_source {
              <3e5, 0, -3e5>,
              <1, 1, 1> 
              
              groups "planetary"
             }

/* --------Nebula background---------- */       

#declare galaxy_seed = (.127 - .5) * 2e5;
#declare galaxy_bgstars = false;
#declare galaxy_objects = 0;
#declare galaxy_starfield = 1; 
#declare galaxy_distance = 50003;
#declare galaxy_pattern_origin = <clock*0.4, clock*0.4, 0>;

#declare star_type = 1;
#declare star_colour = <0.8, 0.8, 0.8>; 
#declare star_colour_turb = <0.5, 0.5, 0.5>;
#declare star_count = 7000;
#declare star_distance = 50000;

#include "galaxy\galaxy.inc"

global_settings {max_trace_level 30}

 
#include "hinfriej.inc"

object {
        Hin_frigatedes
        
        scale <0.5, 0.5, 0.5>
        rotate <0, -90, 0>
        translate <-2.3, 0.5, 1>
        
        light_group "!planetary"
       }
       
#include "hinfri.inc"

object {
        Hin_frigate
        
        scale <0.5, 0.5, 0.5>
        rotate <0, -90, 0>
        translate <-8.3, 3.5, 3>
        
        light_group "!planetary"
       }

  
#declare dlweap_start = 0.0;
#declare dlweap_stop = 0.3000; 
#declare dlweap_src = <16, -16, 16>;
#declare dlweap_trg = <-2.3, 0.5, 1.0>;
#declare DW_colour = <0.0, 0.9, 0.4>;
#declare DW_bright = 30;
#declare dlweap_mode = 0;
#declare DW_scale = 1;

#include "delweap.inc"

#declare dlweap_start = 0.0;
#declare dlweap_stop = 0.3000; 
#declare dlweap_src = <16, -16, 3>;
#declare dlweap_trg = <-2.7 + (clock * 1.3333), 0.5, 1.0>;

#include "delweap.inc"

#declare dlweap_start = 0.0;
#declare dlweap_stop = 0.3000; 
#declare dlweap_src = <16, -5, 1.1>;
#declare dlweap_trg = <-2.0 - (clock * 1.3333), 0.5, 1.0>;

#include "delweap.inc"
  
#declare TP_speed = 17;
#declare TP_spdir = <1, 1, 0>;
#declare TP_centre = <-1.3, 0.3, 1.0>;  
#declare TP_particles = 1000;
//#declare TP_glowscale = <0.125, 0.125, 0.125>;

#declare TP_start = 0.25;
#declare TP_end = 0.85001 ;

#declare TP_camera_location = camera_location;
#declare TP_camera_look_at = camera_look_at;
#declare TP_glowenable = false;
                                  
#include "texplode.inc"   

#declare Rn1 = seed(1000);

#declare s_shot_colour = <0.0, 1.4, 0.0> + (<0, 0.5, 0>*(clock*4));
#declare s_shield_colour = <0.7, 0.7, 1.2>;
#declare s_scale = <2.75, 0.7, 1.75>;
#declare s_shot_dir = <-0.956, 0.2922, 0.0>;
#declare s_centre = <-1.4 - 2.3, 0.4, 1>;
#declare s_decay = 0.1; 
#declare s_cstart = 0;
#declare s_cend = 0.249;
#declare s_coverage = 0.05 + 0.05*(rand(Rn1) - 0.5);
#declare s_shield_intensity = 1.0 + 0.2 * (rand(Rn1) - 0.5);  
#declare s_shot_intensity = 1.0 + 0.2 * (rand(Rn1) - 0.5);
#declare s_shield_grain = 0.3;
#declare s_turbulence = <0.2, 0.2, 0.2>;
#declare s_background = 0;
#declare s_scramble = <3600, 3600, 3600>;

#declare s_shield_style = "hybrid"                      

#include "shield\shield.inc"
  
  
global_settings { max_trace_level 40 }