// Persistence of Vision Ray Tracer Scene Description File
// File: delcor.inc
// Vers: 3.1, MegaPOV modification
// Desc: Deltori Corvette mk I 
// Date: 14/4/2000 
// Auth: TD York 

/* 
   This ship's line is along the +z axis, +y is up
   
   The crackle textures in this file are the only MegaPOV specific items. To convert to ordinary
   POV, remove the form() statements in the crackle textures, and the reflect_metallic item.
   
   Some textures included in this file are for special effects related to the model, and aren't 
   used in this file (eg DLdamage* series are for debris).
   
   The corvette is ~25m long, and is designed for fast recon and light patrol duty
*/


// ------ Textures ------

#declare DLmetal1 = texture {
                          pigment {
                                   crackle
                                   form <1,0,0>
                                   color_map {
                                              [0.0 colour rgb <0.0, 0.5, 1.0>]
                                              [0.2 colour rgb <0.0, 1.0, 0.5>]
                                              [0.4 colour rgb <0.0, 0.5, 0.5>]
                                              [0.6 colour rgb <0.0, 1.0, 0.167>]
                                              [0.8 colour rgb <0.0, 0.5, 1.0>]
                                             } 
                                                                      
                                   scale <0.1, 0.1, 0.1>
                                  }
                          
                          normal {
                                  crackle 1.5
                                  scale <0.1, 0.1, 0.1>
                                 }
                                  
                          finish {
                                  metallic 1.0 
                                  reflect_metallic
                                  brilliance 5
                                  specular 0.7
                                  reflection <0.2, 0.2, 0.2>
                                  roughness 0.01
                                  ambient 0.0
                                 }
                                 
                   //       scale <0.1, 0.1, 0.1>       
                            } 

#declare DLenginetext = texture {
                                 pigment {
                                          leopard
                                          turbulence <10, 10, 10>                                          
                                          color_map {
                                                     [0.0 rgbt <0, 0, 0, 0>]
                                                     [0.8 rgbt <0, 1, 1, 0>]
                                                     [1.0 rgbt <0, 2, 2, 0>]
                                                    }
                                         }            
                                         
                                 finish {
                                         ambient 1.0                                                                                  
                                         diffuse 0.0
                                        }        
                                         
                                 scale <0.3, 0.3, 0.3>
                                }

#declare DLweapon = texture {
                             pigment {
                                      color rgbt <0, 2, 0, -1>
                                     }
                                     
                             finish {
                                     ambient 1.0
                                     diffuse 0.0
                                    }               
                            }          
                             

// ------ Components ------

// reactor pod (goes aft)

#declare DLCRVreactor = blob {      
                              threshold 0.6
                              sphere { <0, 0, 0>, 0.34, 1 }
                              sphere { <0, 0, -0.4>, 0.6, 1 }
                              cylinder { <0, 0.10, 0.0>, <0, 0.17, -0.37>, 0.12, 1 }
                              cylinder { <0, -0.10, 0.0>, <0, -0.17, -0.37>, 0.12, 1 }
                              
                              rotate <0, 0, 90>
                              scale <1, 0.7, 1>
                              
                              texture {
                                       radial
                                       triangle_wave 
                                       frequency 20
                 
                                       texture_map {             
                                                    [0.6500 DLmetal1 ]
                                                    [0.6501 DLenginetext ]
                                                   }
                                       
                                       rotate <90, 0, 0>            
                                      }
                             } 

// pulse cannon pod

#declare DLCRVcannon = union {
                              difference {
                                          sphere {          
                                                  <0, 0, 0>,
                                                  1.0
                                                                                                                                                             
                                                  scale <0.16, 0.096, 0.20>
                                                  
                                                  texture { DLmetal1 }
                                                 }                                                            
                                                  
                                          cylinder {
                                                    <0, 0, 0.03>,
                                                    <0, 0, 1.0>,
                                                    0.04
                                                    
                                                    scale <1.3, 0.6, 1.3>
                                                    
                                                    texture { DLweapon }
                                                   }
                                         }
                              
                              cylinder {
                                        <0, 0, 0.03>,
                                        <0, 0, 0.08>,
                                        0.04
                                        
                                        scale <1.3, 0.6, 1.3>
                                                    
                                        texture { DLweapon }
                                       } 
                             }

// laser cluster

#declare DLCRVlaser = difference {
                                  superellipsoid {          
                                                  <1, 0.2>                                           
                                             
                                                  scale <0.16, 0.17, 0.16>                                                        
                                                  
                                                  texture { DLmetal1 }
                                                 }                           
                                  
                                  #declare loop = 0;           
                                  #while(loop<18)
                                
                                  box {
                                       <0.15, -0.008, 1>,
                                       <0.2, 0.008, -1>
                                     
                                       texture { DLweapon }
                                     
                                       rotate <0, 0, loop * 20>
                                      } 
                                                                
                                  #declare loop = loop + 1;
                                  #end                                                                                                       
                                 }


// command module

#declare DLCRVcommand = sphere {                                     
                                <0, 0, 0.6>,
                                0.6
                              
                                scale <0.3, 0.2, 0.3>                                    
                                    
                                texture { DLmetal1 }       
                               }                     
                              

// inertial drive pod

#declare DLCRVengine = sphere {
                               <0, 0, 0>,
                               0.15
                               
                               scale <1, 1, 4>
                               
                               texture { 
                                        DLmetal1
                                       }
                              } 

                              

// main body

#declare DLCRVhull = blob {      
                           threshold 0.6
                           sphere { <0, 0, 0.2>, 0.34, 1 }
                           sphere { <0, 0, 0.5>, 0.34, 1 }
                           cylinder { <0, -0.10, 0.2>, <0.46, -0.17, 0.87>, 0.2, 1 scale <1,1,1> }
                           cylinder { <0, -0.10, 0.2>, <-0.46, -0.17, 0.87>, 0.2, 1 scale <1,1,1> }
                           cylinder { <0.4, -0.17, 0.9>, <0.46, -0.17, 0.87>, 0.15, 1 scale <1,1,1> }
                           cylinder { <-0.4, -0.17, 0.9>, <-0.46, -0.17, 0.87>, 0.15, 1 scale <1,1,1> }
                           sphere { <0, 0, 0.8>, 0.34, 1 }
                           cylinder { <0, 0.0, 0.3>, <0.46, 0.0, -0.4>, 0.15, 1 scale <1,1,1> rotate <0, 0, -30>}
                           cylinder { <0, 0.0, 0.3>, <-0.46, 0.0, -0.4>, 0.15, 1 scale <1,1,1> rotate <0, 0, 30>}
                           cylinder { <0, 0.0, 0.3>, <0.46, 0.0, -0.4>, 0.15, 1 scale <1,1,1> rotate <0, 0, 90>}
                           sphere { <-0.5, 0, -0.4>, 0.15, 1.2 rotate <0, 0, 30>}
                           sphere { <0.5, 0, -0.4>, 0.15, 1.2 rotate <0, 0, -30>}
                           sphere { <0.5, 0, -0.4>, 0.15, 1.2 rotate <0, 0, 90>}
                           
                           scale <1.3, 0.6, 1.3>
                              
                           texture { DLmetal1 }
                          } 


// ------ Finished object ------


#declare DL_corvette = union {
                              object { DLCRVreactor }
                              
                              object { DLCRVhull }
                                    
                              object { 
                                      DLCRVcommand 
                                      
                                      rotate <25, 0, 0>
                                      translate <0, 0.01, 0.8>
                                     }
                              
                              object {
                                      DLCRVengine
                                      
                                      translate <0, 0.65, -0.5>
                                      rotate <0, 0, -100>
                                     }
                                     
                              object {
                                      DLCRVengine
                                      
                                      translate <0, 0.65, -0.5>
                                      rotate <0, 0, 100>
                                     }
                                     
                              object {
                                      DLCRVengine
                                      
                                      translate <0, 0.40, -0.5>
                                     }                  
                              
                              object {
                                      DLCRVcannon
                                      
                                      translate <-0.57, -0.12, 1.3>
                                     }

                              object {
                                      DLCRVcannon
                                      
                                      translate <0.57, -0.12, 1.3>
                                     }
                              
                              object { 
                                      DLCRVlaser           
                                      
                                      translate <0, -0.025, 0.5>
                                     }
                             }

