// Persistence of Vision Ray Tracer Scene Description File
// File: deldes.inc
// Vers: 3.1
// Desc: Deltori Frigate mk II 
// Date: 29/4/1999 
// Auth: TD York 

/* 
   Some textures included in this file are for special effects related to the model, and aren't 
   used in this file (eg DLdamage* series are for debris).
*/


#declare damaged = false; 
#declare damage_seed = seed(clock*1000);

// Base surfaces

#declare DLmetal1 = texture {
                          pigment {
                                   crackle
                                   form <1,0,0>
                                   color_map {
                                              [0.0 colour rgb <0.0, 0.5, 1.0>]
                                              [0.2 colour rgb <0.0, 1.0, 0.5>]
                                              [0.4 colour rgb <0.0, 0.5, 0.5>]
                                              [0.6 colour rgb <0.0, 1.0, 0.167>]
                                              [0.8 colour rgb <0.0, 0.5, 1.0>]
                                             } 
                                                                      
                                   scale <0.1, 0.1, 0.1>
                                  }
                          
                          normal {
                                  crackle 1.5
                                  scale <0.25, 0.1, 0.25>
                                 }
                                  
                          finish {
                                  metallic 1.0 
                                  reflect_metallic
                                  brilliance 5
                                  specular 0.7
                                  reflection <0.2, 0.2, 0.2>
                                  roughness 0.01
                                  ambient 0.0
                                 }
                            } 

#declare DLmetal2 = texture {
                          pigment {
                                   crackle 
                                   form <1,0,0>
                                   color_map {
                                              [0.0 colour rgb <0.0, 0.5, 1.0>]
                                              [0.2 colour rgb <0.0, 1.0, 0.5>]
                                              [0.4 colour rgb <0.0, 0.5, 0.5>]
                                              [0.6 colour rgb <0.0, 1.0, 0.167>]
                                              [0.8 colour rgb <0.0, 0.5, 1.0>]
                                             } 
                                                                      
                                   scale <0.1, 0.1, 0.1>
                                  }
                          
                          normal {
                                  crackle 1.5
                                  scale <0.1, 0.1, 0.1>
                                 }
                                  
                          finish {
                                  metallic 1.0
                                  reflect_metallic
                                  brilliance 5
                                  specular 0.7
                                  reflection <0.2, 0.2, 0.2>
                                  roughness 0.01   
                                  ambient 0.0
                                 }
                            } 

#declare DLenginetext = texture {
                                 pigment {
                                          leopard
                                          turbulence <10, 10, 10>                                          
                                          color_map {
                                                     [0.0 rgbt <0, 0, 0, 0>]
                                                     [0.8 rgbt <0, 1, 1, 0>]
                                                     [1.0 rgbt <0, 2, 2, 0>]
                                                    }
                                         }            
                                         
                                 finish {
                                         #if(damaged) ambient rand(damage_seed)
                                         #else ambient 1.0                                         
                                         #end 
                                         
                                         diffuse 0.0
                                        }        
                                         
                                 scale <0.03, 0.03, 0.03>
                                }
                                
#declare DLdockbay = texture {
                              pigment {
                                       bozo 
                                       turbulence <0.6, 0.6, 0.6>
                                       phase (clock*4)
                                       color_map {
                                                  [0.0 rgbt <0, 0, 0, 0>]
                                                  [0.7 rgbt <0.2, 0.8, 0.2, 0>]
                                                  [0.8 rgbt <0.4, 0.99, 0.4, 0>]
                                                  [0.9 rgbt <0.6, 1.0, 0.6, 0>]
                                                  [1.0 rgbt <0.6, 2.0, 0.6, 0>]
                                                 }
                                      }
                                      
                              finish {
                                      ambient 1.0
                                      diffuse 0.0
                                     }                     
                              
                              scale <0.002, 0.002, 0.002>                              
                             }         

#declare DLweapon = texture {
                             pigment {
                                      color rgbt <0, 2, 0, -1>
                                     }
                                     
                             finish {
                                     ambient 1.0
                                     diffuse 0.0
                                    }               
                            }          

#declare DLweapondrain = texture {
                                  pigment {
                                           colour rgbt <0, 2, 0, -1>
                                          }
                                          
                                  finish {
                                          #if(damaged) ambient rand(damage_seed)
                                          #else ambient 1.0
                                          #end
                                         }
                                 }          

#declare DLdamagefire = texture {
                                 pigment {
                                          leopard
                                          turbulence <10, 10, 10>
                                          color_map {
                                                     [0.0 rgb <0.0, 0.0, 0.0>]
                                                     [0.5 rgb <1.0, 0.2, 0.0>]
                                                     [1.0 rgb <2, 2, 0>]
                                                    }
                                         }
                                         
                                 finish {
                                         ambient 1.0
                                         diffuse 0.5
                                        }
                                        
                                 scale <0.03, 0.03, 0.03>                   
                                }

#declare DLdamageburnt = texture {
                                  pigment {
                                           crackle 
                                           form <1,0,0>
                                           color_map {
                                                      [0.0 colour rgb <0.0, 0.2, 0.5>]
                                                      [0.2 colour rgb <0.0, 0.5, 0.2>]
                                                      [0.4 colour rgb <0.0, 0.2, 0.2>]
                                                      [0.6 colour rgb <0.0, 0.5, 0.07>]
                                                      [0.8 colour rgb <0.0, 0.2, 0.5>]
                                                     } 
                                          }                            
        
                                  finish {
                                          metallic 0.5 
                                          reflect_metallic
                                          brilliance 5
                                          specular 0.5                                          
                                          reflection 0.0
                                          roughness 0.01
                                          ambient 0.0
                                         }
                                         
                                  scale <0.1, 0.1, 0.1>
                                 }

#declare DLrim = texture {
                          pigment {
                                   radial 
                                   frequency 24
                                   colour_map {
                                               [0.0 colour rgb <0.1, 0.1, 0.1>]
                                               [0.1 colour rgb <0, 0.8, 0>]
                                               [0.9 colour rgb <0, 0.8, 0>]
                                               [1.0 colour rgb <0.1, 0.1, 0.1>]                                              
                                              }
                                  } 

                          finish {
                                  metallic 0.5 
                                  reflect_metallic
                                  brilliance 5
                                  specular 0.5                                          
                                  reflection 0.0
                                  roughness 0.01
                                  ambient 0.3
                                 }                                  
                         }  
// Declares

#declare Bay_door_seg = difference {
                                    cylinder {
                                              <0.05, 0, 0>,
                                              <-0.05, 0, 0>,
                                              0.15
                                                                                            
                                              texture { DLmetal1 }                                              
                                             }
                                    
                                    box {
                                         <1, 1, 1>,
                                         <-1, -1, 0>
                                         
                                         texture { DLenginetext }
                                         
                                         rotate <-45, 0, 0>
                                        }
                                        
                                    box {
                                         <1, 1, -1>,
                                         <-1, -1, 0>
                                         
                                         texture { DLenginetext }
                                         
                                         rotate <45, 0, 0>
                                        }
                                    
                                    /*    
                                    translate <0, 0.15, 0>
                                    scale <1, 0.5, 1>
                                    translate <0, -0.15, 0>    */
                                   }

#declare TS_ring = difference {
                               cylinder {
                                         <0, 0, 0>,
                                         <0, 0.1, 0>,
                                         0.8
                                         
                                         texture { DLmetal2 }
                                        }
                                        
                               cylinder {          
                                         <0, -0.2, 0>,
                                         <0, 0.2, 0>,
                                         0.5
                                                             
                                         texture { DLmetal2 }                                                                                                      
                                        }
                                           
                                         
                               #declare loop = 0;       
                                        
                               #while(loop<6)
                               
                               box {
                                    <0.7, -0.2, -0.05>,
                                    <0.9, 0.2, 0.05>
                                                                        
                                    texture { DLmetal2 }                                                                                                      
                                    
                                    rotate <0, loop*36, 0>
                                   }
                                   
                               cylinder {
                                         <0.7, -0.2, 0>,
                                         <0.7, 0.03, 0>,
                                         0.08
                                         
                                         texture { DLenginetext }                                                                                                      
                                         
                                         rotate <0, 18+(loop*36), 0>
                                        }                                                                                      
                               
                               cylinder {
                                         <0.7, 0.2, 0>,
                                         <0.7, 0.07, 0>,
                                         0.08
                                         
                                         texture { DLenginetext }
                                         
                                         rotate <0, 18+(loop*36), 0>
                                        }                                                                                      
                               
                               #declare loop = loop + 1;
                               #end
                               
                               box {
                                    <-1, -0.2, 0>,
                                    <1, 0.2, 1>
                                    
                                    texture { DLmetal2 }
                                   }                               
                              } 
                                       
                             
#declare DLTS_drive = union {                                                       
                             cylinder {
                                       <0, -0.4, 0>,
                                       <0, 1.6, 0>,
                                       0.10
                                         
                                       texture { DLmetal2 }                                                  
                                      }
                     /*        
                             #declare loop = 0;       
                                        
                             #while(loop<5)                               
                                      
                             
                             union {
                                    cylinder {
                                              <-0.55, 0, -0.025>,
                                              <0.55, 0, -0.025>,
                                              0.05
                                       
                                              texture { DLmetal2 }                                       
                                             }                            
                                             
                                    cylinder {
                                              <0, 0, 0>,
                                              <0, 0, -0.55>,
                                              0.05
                                              
                                              texture { DLmetal2 }
                                             }
                                    
                                    object { 
                                            TS_ring
                                            translate <0, -0.05, 0.025>
                                           }         
                                             
                                    rotate <0, 90*loop, 0>
                                    translate <0, (loop*0.3), 0>         
                                   }                                   
                                   
                             #declare loop = loop + 1;
                             #end*/
                             
                             #declare loop = 0;
                             
                             #while(loop<4)   
                             
                             difference {
                             cylinder {
                                       <0, 0, 0>,
                                       <0, 0.2, 0>,
                                       0.76
                                       scale <0.5, 1, 1>
                                       
                                       texture { DLmetal2 }
                                      } 
                                      
                             cylinder {
                                       <0, -0.1, 0>,
                                       <0, 0.3, 0>,
                                       0.76
                                       scale <0.5, 1, 1>
                                       
                                       texture { DLmetal2 }
                                      }         
                                      
                             box {
                                  <1, 0.19999, 1>,
                                  <-1, 1, -1>
                                  
                                  texture { DLrim }
                                 }     
                                                                      
                             box {
                                  <1, 0.000001, 1>,
                                  <-1, -1, -1>
                                  
                                  texture { DLrim }
                                 }     
                                                                      
                             translate <0, 0.3*loop>                                 
                             }
                              
                             #declare loop = loop + 1; 
                             #end      
                            }              

#declare DLbubble = difference {
                                union {                                
                                       superellipsoid {          
                                                       <1, 0.2>                                           
                                           
                                                       scale <0.16, 0.16, 0.16>
                                                       rotate <0, 90, 0>
                                                       translate <-0.20, 0, 0>
                                                                          
                                                       texture { DLmetal2 }                                                                                                           
                                                      }                           
                           
                                       cylinder {
                                                 <-0.15, 0, 0>,
                                                 <0.05, 0, 0>,
                                                 0.10
                           
                                                 texture { DLmetal2 }
                                                }
                                    
                                       superellipsoid {          
                                                       <1, 0.2>                                           
                                                  
                                                       scale <0.16, 0.16, 0.16>
                                                       rotate <0, 90, 0>
                                                       translate <0.15, 0, 0>
                                                       
                                                       texture { DLmetal2 }              
                                                      }                                                      
                                      }    
                                           
                                
                                #declare loop = 0;           
                                #while(loop<10)
                                
                                box {
                                     <-1, -0.01, 0.14>,
                                     <1, 0.01, 0.2>
                                     
                                     texture { DLweapon }
                                     
                                     rotate <loop * 36, 0, 0>
                                    } 
                                                                
                                #declare loop = loop + 1;
                                #end                                                                     
                               }
                  
#declare DLcommand = union {
                            cylinder {
                                      <0, 0, 0>,
                                      <-0.8, 0, 0>,
                                      0.14                            
                            
                            
                                      scale <1, 0.6, 1>                                      
                                      
                                      texture { DLmetal1 }
                                     }
                                     
                            cone {
                                  <-1.4, 0, 0>, 0.4,
                                  <-0.6, 0, 0>, 0.14
                                                                    
                                  scale <1, 0.6, 1>                                                                  
                                  
                                  texture { DLmetal1 }
                                 }
                                 
                            difference {
                                        sphere {
                                                <-1.4, 0, 0>,
                                                0.4                                                
                                                
                                                scale <1, 0.6, 1>                                                
                                               }
                                               
                                        // Landing bay
                                        
                                        cylinder {                      
                                                  <-1.6, 0, 0>,
                                                  <-2, 0, 0>,
                                                  0.15                                            
                                                                                                        
                                                  scale <1, 0.6, 1>
                                                 } 
                                        
                                        texture { 
                                                 DLmetal1
                                                 scale <1, 0.6, 1>
                                                }                                                          
                                       }                                      
                                                                                       
                            
                            object { 
                                    DLbubble
                                    scale <1.1, 1.1, 1.1>                                               
                                   }
                            
                            union {
                                   #declare loop = 0;
                                   #while(loop<4)
                                   object {
                                           Bay_door_seg
                                                                        
                                           rotate <loop * 90, 0, 0>
                                          }
                                   
                                   #declare loop = loop + 1;
                                   #end
                                   
                                   scale <1, 0.6, 1>
                                   translate <-1.7, 0, 0>
                                  } 
                            
                            /* Bay Forcefield */       
    /*                        disc {
                                  <-1.75, 0, 0>,
                                  <-1, 0, 0>,
                                  0.0,
                                  1.5
                                  
                                  scale <1, 0.6, 1>
                                 
                                  texture { DLdockbay }                                   
                                 } */
                           }


#declare DLengine = union {
                           difference {                           
                                       cylinder {
                                                 <-0.75, 0, 0>,
                                                 <0.75, 0, 0>,    
                                                 0.3
                                            
                                                 scale <1, 1, 0.6>
                                                }
                                                
                                       sphere {
                                               <-0.95, 0, 0>,    
                                               0.5
                                            
                                               scale <1, 1, 1>
                                              }
                                              
                                       sphere {
                                               <0.95, 0, 0>,    
                                               0.5
                                            
                                               scale <1, 1, 1>
                                              }
                                              
                                       texture { DLmetal1 }
                                      } 
                                      
                           sphere {
                                   <0.0, 0, 0>,
                                   0.5                                   

                                   scale <0.25, 1, 0.5>
                                   
                                   texture { DLmetal2 }                                   
                                  }
                                  
                           sphere {
                                   <0, 0, 0>,
                                   0.25
                                                                    
                                   scale <1, 1, 0.6>
                                   translate <-0.45, 0, 0>
                                  
                                   texture { DLenginetext }
                                  }             
                                  
                           sphere {
                                   <0, 0, 0>,
                                   0.25
                                   
                                   scale <1, 1, 0.6>
                                   translate <0.45, 0, 0>
                                  
                                   texture { DLenginetext }
                                  }                                  
                          }

#declare DLmount = union {  
                          blob {
                                threshold 0.65
                                cylinder { <2.6, 0, 0>, <2.2, 0.866, 0>, 0.5, 1 }
                                cylinder { <2.2, 0.866, 0>, <1.234, 1.125, 0>, 0.4, 1 }
                                cylinder { <1.234, 1.125, 0>, <0.7, 1.125, 0>, 0.4, 1 }
                                sphere { 
                                        <2.6, 0, 0>, 0.7, 1 
                                        
                                        scale <1, 1.4, 1>
                                       }                               
                                       
                                rotate <60, 0, 0>       
                               }
                          
                          blob {
                                threshold 0.65
                                cylinder { <2.6, 0, 0>, <2.2, 0.866, 0>, 0.5, 1 }
                                cylinder { <2.2, 0.866, 0>, <1.234, 1.125, 0>, 0.4, 1 }
                                cylinder { <1.234, 1.125, 0>, <0.7, 1.125, 0>, 0.4, 1 }
                                sphere { 
                                        <2.6, 0, 0>, 0.7, 1 
                                        
                                        scale <1, 1.4, 1>
                                       } 
                                       
                                rotate <-60, 0, 0>                                      
                               }
                         
                          blob {
                                threshold 0.65
                                cylinder { <2.6, 0, 0>, <2.2, -0.866, 0>, 0.5, 1 }
                                cylinder { <2.2, -0.866, 0>, <1.234, -1.125, 0>, 0.4, 1 }
                                cylinder { <1.234, -1.125, 0>, <0.7, -1.125, 0>, 0.4, 1 }
                                sphere { 
                                        <2.6, 0, 0>, 0.7, 1 
                                        
                                        scale <1, 1.4, 1>
                                       }
                                       
                                rotate <60, 0, 0>       
                               }
                          
                          blob {
                                threshold 0.65
                                cylinder { <2.6, 0, 0>, <2.2, -0.866, 0>, 0.5, 1 }
                                cylinder { <2.2, -0.866, 0>, <1.234, -1.125, 0>, 0.4, 1 }
                                cylinder { <1.234, -1.125, 0>, <0.7, -1.125, 0>, 0.4, 1 }
                                sphere { 
                                        <2.6, 0, 0>, 0.7, 1 
                                        
                                        scale <1, 1.4, 1>
                                       }
                                       
                                rotate <-60, 0, 0>       
                               }
                                                     
                          texture { DLmetal1 }     
                         }

#declare DLarm =        blob {
                              threshold 0.65
                              cylinder { 
                                        <2.5, 0, 0>, <2.3, 0, -0.8>, 0.5, 1 
                                        
                                        scale <1, 0.5, 1>
                                       }
                                       
                              cylinder { 
                                        <2.3, 0, -0.8>, <1.8, 0, -1.2>, 0.4, 1 
                                        
                                        scale <1, 0.5, 1>
                                       }
                                       
                                       
                              cylinder { 
                                        <1.8, 0, -1.3>, <0.6, 0, -1.3>, 0.6, 1 
                                       
                                        scale <1, 0.5, 1>
                                       }
                                
                              cylinder { 
                                        <0.6, 0, -1.2>, <-0.9, 0, 0.0>, 0.5, 1 
                                       
                                        scale <1, 0.5, 1>
                                       }
                                       
                              sphere {
                                      <-0.9, 0, 0>, 0.5, 1
                                      
                                      scale <1, 0.5, 1>
                                     }  
  
                              texture { DLmetal1 }
                             }
                      
#declare DLeng_block = blob {
                             threshold 0.65
                             
                             sphere {                                     
                                     <0, 0, 0>, .4, 1
                                                                          
                                     scale <1.25, 1.0, 1.8>
                                     translate <0, 0, 0.3>
                                     
                                     texture { DLmetal1 }        
                                    } 
                                   
                             sphere {                                     
                                     <0, 0, 0>, .4, 1
                                     
                                     scale <1.25, 1.0, 1.8>
                                     translate <0, 0, -0.3>                                     
                                     
                                     texture { DLmetal1 }
                                    }
                                    
                             cylinder {                                       
                                       <-0.4, 0, 0>, <0.2, 0, 0>, 0.6, 1
                                       scale <1.0, 1.0, 2>
                                       
                                       texture { DLmetal1 }        
                                      } 
                             
                             sphere {                                     
                                     <0.4, 0, 0>, .4, -1
                                     
                                     scale <0.5, 0.5, 0.5>
                                     
                                     texture { DLenginetext }
                                    } 
                                                          
                            } 
                                                                                                              

// Object 

#declare Del_frigate = union {                  
                                object { 
                                        DLTS_drive
        
                                        scale <0.75, 1, 0.75>
                                        rotate <0, 0, -90> 
                                        //rotate <-(clock*360), 0, 0>
                                        translate <0.5, 0, 0>
                                       }  
                         
                                difference { 
                                            object { DLarm }
                                        
                                            cylinder {
                                                      <0.1, 0, -1.3>,
                                                      <0.9, 0, -1.3>,
                                                      0.1
                                                      
                                                      scale <1, 0.5, 1>
                                                      
                                                      texture { 
                                                               pigment { colour rgb <0, 0.1, 0> } 
                                                               finish { reflection <0, 1, 0> }
                                                              }
                                                     }
                                           }                                                
                                
                                difference { 
                                            object { DLarm }
                                            
                                            cylinder {
                                                      <0.1, 0, -1.3>,
                                                      <0.9, 0, -1.3>,
                                                      0.1
                                                      
                                                      scale <1, 0.5, 1>
                                                      
                                                      texture { 
                                                               pigment { colour rgb <0, 0.1, 0> } 
                                                               finish { reflection <0, 1, 0> }
                                                              }
                                                     } 
                                                                                                  
                                            rotate <180, 0, 0>
                                           } 
                                           
                                cylinder {
                                          <0.5, 0, -1.3>,
                                          <0.4, 0, -1.3>,           
                                          0.1
                                          
                                          scale <1, 0.5, 1>
                                          
                                          texture { DLweapon }                                                                                    
                                         } 
                                         
                                cylinder {
                                          <0.5, 0, 1.3>,
                                          <0.4, 0, 1.3>,           
                                          0.1
                                          
                                          scale <1, 0.5, 1>
                                          
                                          #if(damaged) texture { DLweapondrain } 
                                          #else texture { DLweapon }
                                          #end
                                         }          
                                       
                                object { 
                                        DLmount                                                                                                                       
                                       }       

                                object { DLcommand }

                                object { 
                                        DLengine
                                        scale <1, 0.7, 1>                                         
                                        translate <0.4, 1.125, 0.0>
                                        rotate <60, 0, 0>
                                       } 
                                
                                object { 
                                        DLengine
                                        scale <1, 0.7, 1>                                         
                                        translate <0.4, 1.125, 0.0>
                                        rotate <-60, 0, 0>
                                       } 
                                       
                                object { 
                                        DLengine
                                        scale <1, 0.7, 1>                                        
                                        translate <0.4, -1.125, 0.0>                                       
                                        rotate <60, 0, 0>
                                       }
                                
                                object { 
                                        DLengine
                                        scale <1, 0.7, 1>                                        
                                        translate <0.4, -1.125, 0.0>                                       
                                        rotate <-60, 0, 0>
                                       }

                                object { 
                                        DLeng_block 
                                
                                        translate <2.5, 0, 0>
                                       }
                               }