// Macros

#macro line_up(source, dest)
#local dir = dest - source;
#if(dir.y<0) #local mysign = -1.0;
#else #local mysign = 1.0;
#end

#if(dir.z!=0) #declare trphi = 57.29577*atan2(dir.z, dir.x);
#else #declare trphi = 0.0;
#end

#local myalpha = sqrt(dir.x*dir.x + dir.z*dir.z);
#if(myalpha!=0) #declare trtheta = 57.29577*atan2(myalpha, dir.y);
#else #declare trtheta = 90.0 - (mysign*90.0);
#end

#end

// interpolate values
//   T:  Middle value of time
//   T1: Initial time
//   T2: Final time
//   P1: Initial position (may be float, vector or color)
//   P2: Final position (may be float, vector or color)

#macro Interpolate(T,T1,T2,P1,P2)
   (P1+((T-T1)/(T2-T1))*(P2-P1))
#end

#if(clock>=dlweap_start & clock<=dlweap_stop)

#if(dlweap_mode=1)
sphere {        
        Interpolate(clock,dlweap_start,dlweap_stop, dlweap_src, dlweap_trg)
        (0.26 * DW_scale)
          
        hollow
          
        texture {
                 pigment {
                          color rgbt <1, 1, 1, 1>
                         }
                }
                           
        interior {
                  media {
                         emission (DW_bright*DW_colour)
                                                   
                         density {
                                  spherical
                                  color_map {
                                             [0.0 rgb <0, 0.1, 0>]
                                             [1.0 rgb <0.9, 1, 0.9>]
                                            }
                                                                                          
                                  scale <0.06, 0.12, 0.06> * DW_scale                                             
                                    
                                  line_up(dlweap_src, dlweap_trg)                                    
                                  rotate <0, 0, -trtheta>
                                  rotate <0, -trphi, 0>          
                                  translate Interpolate(clock,dlweap_start,dlweap_stop,dlweap_src, dlweap_trg)                                    
                                 } 
                         
                         density {
                                  spherical
                                  color_map {
                                             [0.0 rgb <0, 0, 0>]
                                             [1.0 rgb <1, 1, 1>]
                                            }
                                                                                          
                                  scale <0.06, 0.12, 0.06> * DW_scale                                             
                                    
                                  line_up(dlweap_src, dlweap_trg)                                    
                                  rotate <0, 0, -trtheta>
                                  rotate <0, -trphi, 0>          
                                  translate Interpolate(clock,dlweap_start,dlweap_stop,dlweap_src, dlweap_trg)                                    
                                 } 
                        }                                             
                   }                 
        
         }
#else
#if(dlweap_mode=0)
light_source {
              Interpolate(0.5,dlweap_start,dlweap_stop,dlweap_src, dlweap_trg)                                    
              DW_colour
              
              fade_power 1000
              fade_distance 3
             }


cylinder {
          // laser001

          dlweap_src
          dlweap_trg
          0.028
          
          hollow
          
          texture {
                   pigment {
                            color rgbt <1, 1, 1, 1>
                           }
                  }
                           
          interior {
                    media {
                           emission (DW_bright*DW_colour)
                                                   
                           density {
                                    cylindrical
                                    color_map {
                                               [0.0 rgb <0, 0, 0>]
                                               [1.0 rgb <1, 1, 1>]
                                              }
                                                                                          
                                    scale <0.02, 1, 0.02>*DW_scale
                                    
                                    line_up(dlweap_src, dlweap_trg)                                    
                                    rotate <0, 0, -trtheta>
                                    rotate <0, -trphi, 0>          
                                    translate dlweap_trg                                    
                                   } 
                          }                                             
                   }
         }   
#else
light_source {
              Interpolate(clock,dlweap_start,dlweap_stop,dlweap_src, dlweap_trg)                                    
              DW_colour
              
              fade_power 1000
              fade_distance 3
             }


sphere {        
        Interpolate(clock,dlweap_start,dlweap_stop, dlweap_src, dlweap_trg)
        (0.26 * DW_scale)
          
        hollow
          
        texture {
                 pigment {
                          color rgbt <1, 1, 1, 1>
                         }
                }
                           
        interior {
                  media {
                         emission (DW_bright*DW_colour)
                                                   
                         density {
                                  spherical
                                  color_map {
                                             [0.0 rgb <0, 0.1, 0>]
                                             [1.0 rgb <0.9, 1, 0.9>]
                                            }
                                                                                          
                                  scale <0.06, 0.12, 0.06> * DW_scale                                             
                                    
                                  line_up(dlweap_src, dlweap_trg)                                    
                                  rotate <0, 0, -trtheta>
                                  rotate <0, -trphi, 0>          
                                  translate Interpolate(clock,dlweap_start,dlweap_stop,dlweap_src, dlweap_trg)                                    
                                 } 
                         
                         density {
                                  spherical
                                  color_map {
                                             [0.0 rgb <0, 0, 0>]
                                             [1.0 rgb <1, 1, 1>]
                                            }
                                                                                          
                                  scale <0.06, 0.12, 0.06> * DW_scale                                             
                                    
                                  line_up(dlweap_src, dlweap_trg)                                    
                                  rotate <0, 0, -trtheta>
                                  rotate <0, -trphi, 0>          
                                  translate Interpolate(clock,dlweap_start,dlweap_stop,dlweap_src, dlweap_trg)                                    
                                 } 
                        }                                             
                   }                 
        
         }

#local camdir = camera_look_at - camera_location;
#local beta = 57.29577951*atan2(camdir.y, sqrt(camdir.x*camdir.x + camdir.z*camdir.z));
#local gamma = -57.29577951*atan2(camdir.z, camdir.x);

union {
#local loop = 0;

#while(loop<3)
disc {
      <0, 0, 0>,
      <1, 0, 0>,
      1.0
      
      texture {
        pigment {
                onion
                colour_map {
                        [0.0 colour rgb DW_colour filter 0.4]
                        [1.0 colour rgbf <1, 1, 1, 1> ]
                       }
                }
        
        finish { diffuse 0.0 ambient 1.0 + 0.1*loop*loop }
       }                  
      
      scale <0.025, 0.025, 0.25>      
      rotate <60 * loop + 30, 0, 0>
      translate <0.001, 0, 0>
     }

#local loop = loop + 1;
#end

rotate <720 * clock, 0, 0>
rotate <0, 0, beta>
rotate <0, gamma, 0>
translate Interpolate(clock,dlweap_start,dlweap_stop, dlweap_src, dlweap_trg)           

}

light_source {
              Interpolate(clock,dlweap_start,dlweap_stop,dlweap_src, dlweap_trg)                                    
              DW_colour
              
              fade_power 1000
              fade_distance 3
             }
  

disc {
      <0, 0, 0>,
      <1, 0, 0>,
      (0.15 * DW_scale)
      
      no_shadow
      hollow
      
      texture {
               pigment {
               hexagon    
               pigment { 
                        onion
                        colour_map {
                                [0.4 colour rgb DW_colour transmit 0.0]
                                [1.0 colour rgbt <1, 1, 1, 1>]
                               }
                       },
                       
               pigment { colour rgbt <1, 1, 1, 1> },
               pigment { colour rgbt <1, 1, 1, 1> },
               
               rotate <0, 0, 90>
               scale <0.08, 0.08, 0.08> * DW_scale
               }
                      
               finish { ambient 1.0 diffuse 0.0 }        
              } 
      
      rotate <720 * clock, 0, 0>
      rotate <0, 0, beta>
      rotate <0, gamma, 0>        
      translate Interpolate(clock,dlweap_start,dlweap_stop, dlweap_src, dlweap_trg)           
     }
      /*
disc {
      <0, 0, 0>,
      <1, 0, 0>,
      (0.25 * DW_scale)
      
      no_shadow
      hollow
      
      texture {
               pigment {
                        onion
                        colour_map {
                                [0.4 colour rgb DW_colour transmit 0.0]
                                [1.0 colour rgbt <1, 1, 1, 1>]
                               }
                       }
                      
               finish { ambient 1.0 diffuse 0.0 }        
               
                              
               rotate <0, 0, 90>
               scale <0.25, 0.25, 0.25> * DW_scale

              } 
      
      rotate <0, 0, beta>
      rotate <0, gamma, 0>        
      translate Interpolate(clock,dlweap_start,dlweap_stop, dlweap_src, dlweap_trg)           
     }
    */ 
#end
#end
#end