/*#declare camera_location = <0, 0, 3>;
#declare camera_look_at = <0, 0, 0>;

camera {
        location camera_location
        look_at camera_look_at
       }
       
light_source {
              (camera_location + <5,0,0>)
              <1, 1, 1>
             }
  */
#ifndef(PG_rotate) #declare PG_rotate = <0, 0, 0>; #end
#ifndef(PG_scale) #declare PG_scale = <1, 1, 1>; #end
#ifndef(PG_centre) #declare PG_centre = <0, 0, 0>; #end
#ifndef(PG_atmosdisc) #declare PG_atmosdisc = true; #end
#ifndef(PG_atmosthick) #declare PG_atmosthick = 0.1; #end
#ifndef(PG_atmosglow) #declare PG_atmosglow = 1.0; #end
#ifndef(PG_atmoscol1) #declare PG_atmoscol1 = <1, 1, 1>; #end
#ifndef(PG_atmoscol2) #declare PG_atmoscol2 = <1, 1, 1>; #end

#ifndef(PG_ocean) 
#declare PG_ocean = texture {
         pigment {
                  bozo
                                    
                  scale 0.5
                  warp { turbulence 0.5 lambda 2 }
                  
                  colour_map {
                        [0.0 rgb <0.1, 0.1, 0.6>]
                        [0.5 rgb <0.2, 0.2, 0.7>]
                        [1.0 rgb <0.1, 0.1, 0.5>]
                       }
                 }
                 
         finish {
                 diffuse 1.0
                }           
        }
#end
             
#ifndef(PG_land)         
#local land1 = pigment {
                  agate  
                  warp {
                  turbulence 1
                  lambda 1.5
                  omega 0.8
                  octaves 4  
                  }
                  scale 5
                  
                  colour_map {
                        [0.80 rgbt <0.200, 0.300, 0.200, 1.0>]
                        [0.90 rgbt <0.100, 0.200, 0.100, 0.0>]                                                
                        [0.95 rgbt <0.670, 0.486, 0.361, 0.0>]
                        [0.97 rgbt <0.150, 0.300, 0.150, 0.0>]
                        [1.00 rgbt <0.200, 0.400, 0.300, 0.0>]
                       }
                 }
                            
#local ice = pigment {
                crackle
                turbulence 0.4
                scale 0.1
                colour_map {                                                  
                         [0.40 pigment rgbt <2, 2, 2, 0>]
                         [0.500 pigment rgbt <1, 1, 1, 1>]                         
                         [0.70 pigment rgbt <1, 1, 1, 0>]
                        }
               }

#declare PG_land = texture {
        pigment {
         gradient y
         turbulence 0.15
         octaves 8
         omega 0.8                                    
         pigment_map {                  
                      [0.1 ice]
                      [0.11 land1]
                      [0.89 land1]
                      [0.9 ice]
                     } 
                
         translate <0, -0.5, 0>            
        }
        
        finish { diffuse 0.6 ambient 0.0 } 
      }        
#end        

#ifndef(PG_cloud)         

#local cloud1 = pigment {
                bozo
                turbulence <1, 0, 1>                  
                scale <0.125, 0.125, 0.125>                
                color_map {                                        
                      [0.40 rgbt <1, 1, 1, 1>]                      
                      [1.00 rgb <1, 1, 1>]
                     } 
                  
                 }
                 
#local cloud2 = pigment { colour rgbt <1, 1, 1, 1> }
         
#declare PG_cloud = texture {
        pigment {
            gradient y   
            turbulence 0.2
            pigment_map {                
                [0.2 cloud2]
                [0.21 cloud1]
                [0.79 cloud1]
                [0.8 cloud2]
               }     
               
            translate <0, 0.5, 0>   
           }     

         finish {
                 diffuse 1.0 ambient 0.0 
                }
        }        
#end             
       
#if(PG_atmosdisc = true)

#local camdir = camera_look_at - camera_location;
#local beta = 57.29577951*atan2(camdir.y, sqrt(camdir.x*camdir.x + camdir.z*camdir.z));
#local gamma = -57.29577951*atan2(camdir.z, camdir.x);

difference {
sphere {
        <0, 0, 0>,
        0.5
        
        texture { PG_ocean }
        texture { PG_land }
        texture { PG_cloud }
                              
        scale PG_scale
        rotate PG_rotate
        translate PG_centre
        
        light_group "planetary"
       }         


disc {
      <0, 0, 0>,
      <-1, 0, 0>,
      (0.5 * (1.0 + PG_atmosthick))
      
      hollow
      no_shadow
      
      texture {
               pigment {
                        onion
                        colour_map {
                                [0.0 rgb PG_atmoscol1 transmit 0.0]
                                [1.0 rgb PG_atmoscol2 transmit 1.0]
                               }
                               
                        scale (0.5 * (1.0 + PG_atmosthick))       
                       }
                       
               finish {
                       ambient PG_atmosglow
                       diffuse 0.0
                      }         
              }
              
                                
      scale PG_scale            
      rotate <0, 0, beta>
      rotate <0, gamma, 0>
      translate PG_centre
     }
     
}     

disc {
      <0, 0, 0>,
      <1, 0, 0>,
      (0.5 * (1.0 + PG_atmosthick))
      
      hollow
      no_shadow
      
      
      texture {
               pigment {
                        onion
                        colour_map {
                                [0.0 rgb PG_atmoscol1 transmit 0.0]
                                [1.0 rgb PG_atmoscol2 transmit 1.0]
                               }
                               
                        scale (0.5 * (1.0 + PG_atmosthick))       
                       }
                       
               finish {
                       ambient PG_atmosglow
                       diffuse 0.0
                      }         
              }
              
                                
      scale PG_scale            
      rotate <0, 0, beta>
      rotate <0, gamma, 0>
      translate PG_centre
     }
     
#else
sphere {
        <0, 0, 0>,
        0.5
        
        texture { PG_ocean }
        texture { PG_land }
        texture { PG_cloud }
                              
        scale PG_scale
        rotate PG_rotate
        translate PG_centre
        
        light_group "planetary"
       }         

#end

       