/* Experimental Particle system, for explosions only. TDY 2000 */

/* Check input settings */

#ifndef(TP_start) #declare TP_start = 0.0; #end
#ifndef(TP_end) #declare TP_end = 1.0; #end

#ifndef(TP_glowenable) #declare TP_glowenable = true; #end
#ifndef(TP_glownum) #declare TP_glownum = 16; #end
#ifndef(TP_glowscale) #declare TP_glowscale = 0.5; #end
#ifndef(TP_glowscatter) #declare TP_glowscatter = 0.5; #end

#ifndef(TP_particles) #declare TP_particles = 2000; #end
#ifndef(TP_speed) #declare TP_speed = 4; #end
#ifndef(TP_spdir) #declare TP_spdir = <0, 0, 0>; #end
#ifndef(TP_centre) #declare TP_centre = <0, 0, 0>; #end
#ifndef(TP_rotate) #declare TP_rotate = <0, 0, 0>; #end

#ifndef(TP_size) #declare TP_size = 0.3; #end
#ifndef(TP_aspect) #declare TP_aspect = 0.3; #end

#ifndef(TP_col_bright) #declare TP_col_bright = <2, 2, 2>; #end
#ifndef(TP_col_medium) #declare TP_col_medium = <1, 1, 0.6>; #end
#ifndef(TP_col_dark) #declare TP_col_dark = <1, 0.8, 0.5>; #end

#ifndef(TP_camera_location) #declare TP_camera_location = <0, 0, 0>; #end
#ifndef(TP_camera_look_at) #declare TP_camera_look_at = <0, 0, 1>; #end

#ifndef(TP_seed) #declare TP_seed = 100; #end
#ifndef(TP_mode) #declare TP_mode = 1; #end  // normal explosion

/* Check main clock */

#if(clock>=TP_start & clock<=TP_end)

/* Set up internal clock */

#declare TP_clock = (clock - TP_start) / (TP_end - TP_start);

/* Init vars */

#declare loop = 0;
#declare R1 = seed(TP_seed + 199);
#declare R2 = seed(TP_seed * 2.31);
#declare R3 = seed(TP_seed + 11);

/* Create big glow */
#if(!TP_glowenable)
disc {
      <0, 0, 0>,
      (TP_camera_location-TP_camera_look_at),  
      1.0
      
      hollow
      no_shadow
      
      pigment {
               onion               
               
               colour_map {
                           [0.0 color rgb TP_col_bright transmit (-1+(2*TP_clock))]
                           [1.0 color rgb TP_col_dark transmit 1.0]                                        
                          }                     
               
              } 
      
      finish {
              ambient 1.0
              diffuse 0.0
             } 
      
      scale (1 - TP_clock)
      translate TP_centre       
      //translate ((TP_centre - TP_camera_location) * 0.1 + TP_camera_location )
     }
#end

/* Create particle objects */

#declare loop = 0;
#while(loop<TP_particles)

#local alt = 360.0 * (rand(R2)-0.5) * TP_spdir.y;
#local azi = 360.0 * rand(R1) * TP_spdir.x;
#local fadefac = rand(R3);
#local radi = fadefac * TP_clock * TP_speed;
#local trmed = (0.4+(TP_clock*(0.6+fadefac)));
#if(trmed>1) #local trmed = 1; #end
#local trbrt = (-1+((2+fadefac)*TP_clock));  
#if(trbrt>1) #local trbrt = 1; #end

disc {
      <0, 0, 0>,      
      #if(TP_mode=1) (TP_camera_location-<radi, alt, azi>-TP_centre) #end
      #if(TP_mode=2) (TP_camera_location-TP_centre) #end
      0.9
      
      no_shadow
      hollow
      
      pigment { 
               onion
                              
               color_map {
                          #if(TP_mode=1) // normal
                          [0.05 color rgb TP_col_bright transmit trbrt ]
                          [0.5 color rgb TP_col_medium transmit trmed ]
                          [1.0 color rgb TP_col_dark transmit 1.0]                          
                          #end
                           
                          #if(TP_mode=2) // sparks
                          [0.1 color rgb TP_col_bright transmit trbrt ]
                          [1.0 color rgb TP_col_medium transmit trmed ]                          
                          #end
                                                    
                         }                         
              }

      finish {
              diffuse 0.0
              ambient 1.0
             } 

      scale <TP_size, TP_aspect * TP_size, TP_aspect * TP_size>*(1-TP_clock)
      #if(TP_mode=1)
      translate <radi, 0, 0>
      rotate <0, 0, alt>
      rotate <0, azi, 0>
      #end          
      
      #if(TP_mode=2)
      translate (<cos(azi)*cos(alt), sin(alt), cos(alt)*sin(azi)>*radi)
      #end
      
      rotate TP_rotate
            
      translate TP_centre
     }      

#declare loop = loop + 1;
#end

/* Init glow vars */   

#if(TP_glowenable) 
#declare loop = 0;
#declare R1 = seed(TP_seed*29.09);
#declare R2 = seed(TP_seed*20.31);
#declare R3 = seed(TP_seed*11.10);

/* Create glow objects */

#declare loop = 0;
#while(loop<TP_glownum)

#local myx = (rand(R1) - 0.5) * TP_glowscatter;
#local myy = (rand(R2) - 0.5) * TP_glowscatter;        
#local myz = (rand(R3) - 0.5) * TP_glowscatter; 

disc {
      <0, 0, 0>,
      (TP_camera_location-<myx, myy, myz>-TP_centre),
      0.9
      
      no_shadow
      hollow
      
      pigment { 
               onion
               color_map {
                          [0.65 color rgb TP_col_bright transmit (-1+(2*TP_clock))]
                          [1.0 color rgb TP_col_medium transmit 1.0]                        
                         }                         
              }

      finish {
              diffuse 0.0
              ambient 1.0
             } 

      scale (TP_glowscale*exp(-3*clock))
      
      translate <myx, myy, myz>*exp(-3*clock)      
      translate TP_centre
     }      

#declare loop = loop + 1;
#end
#end

#end